;**** MODULE02/ASM ****
;
;THE NEXT TWO ROUTINES, "SNGCS" AND "SNGCT", CALL
;THE SINGLE STEPPER WITH CALLS STEPPED THROUGH
;OR CALLS EXECUTED IN FULL.
;
SNGCS:CALL WL  ;DISPLAY AN "I" AND A SPACE
SNB:PUSH DE  ;GOTTA SAVE DE!
LD A,1  ;SET TO STEP THROUGH MODE
LD (SKCALL),A
JR SN1  ;CONTINUE ON
SNGCT:LD A,92  ;DISPLAY A DOWN ARROW AND A SPACE
CALL WL
SNA:PUSH DE  ;GOTTA SAVE DE AGAIN!
XOR A  ;SET MODE TO EXECUTE IN FULL
LD (SKCALL),A
SN1:CALL SSTEP  ;CALL THE SINGLE STEPPER
POP DE  ;CAN RESTORE DE NOW!
JP DSPRG  ;DISPLAY THE REGISTERS
;
;THIS ROUTINE IS THE FIND COMMAND
;
FIND:CALL WL  ;DISPLAY AN "F" AND A SPACE
FN0:CALL HXINP  ;GET A KEY
JR Z,FNA  ;JUMP IF HEX
CP 0DH  ;CARRIAGE RETURN?
JR Z,FN1  ;JUMP IF SO
JR FN0  ;GET ANOTHER KEY IF NOT
FNA:CALL GTA  ;GET THE ADDRESS
CALL SPC  ;DISPLAY A SPACE
LD (FHL),HL ;SAVE THE FIND ADDRESS
LD B,4  ;MAX NUMBER OF "KEYS"
LD DE,FBUF  ;SEARCH KEY BUFFER
FN2:CALL HXINP  ;GET A KEY
JR Z,FN7  ;GET ANOTHER IF NOT HEX
CP 0DH  ;CARRIAGE RETURN?
JR Z,FN3  ;JUMP IF SO
FN7:CALL WR  ;DISPLAY THE VALUE
CALL DISHEX  ;MAKE IT BINARY
SLA A  ;MAKE IT THE MSB
SLA A
SLA A
SLA A
LD C,A  ;SAVE IT IN C
FN4:CALL HXINP  ;GET THE LSB
JR NZ,FN4  ;GET ANOTHER IF NOT HEX
CALL WR  ;DISPLAY IT
CALL DISHEX  ;MAKE IT BINARY
ADD A,C  ;ADD MSB AND LSB
LD (DE),A  ;PLACE IN THE KEY BUFFER
INC DE  ;POINT TO NEXT ONE
CALL SPC  ;DISPLAY A SPACE
DJNZ FN2  ;REACHED 4 KEYS YET?
FN3:LD A,4  ;COMPUTE NUMBER OF BYTES IN
;THE SEARCH KEY
SUB B
LD (FNNUM),A ;SAVE IT
LD BC,0  ;SEARCH THROUGH 65536 BYTES
LD (FKNT),BC ;SAVE THE COUNT
FN1:LD HL,(FHL) ;GET THE START ADDRESS OF FIND
LD BC,(FKNT) ;GET THE COUNT
LD A,(FBUF) ;GET THE FIRST SEARCH VALUE
FN5:CPIR   ;FIND IT
LD (FHL),HL ;SAVE THE NEW START ADDRESS
DEC HL  ;POINT BACK ONE BYTE
LD (FKNT),BC ;SAVE THE COUNTER
RET PO  ;RETURN IF THROUGH 65536 BYTES
LD DE,FBUF  ;POINT TO KEY BUFFER
LD A,(FNNUM) ;NUMBER OF BYTES IN SEARCH KEY
LD B,A  ;SAVE IN B
FN6:LD A,(DE)  ;GET A KEY VALUE
INC DE  ;POINT TO NEXT ONE
CP (HL)  ;MATCH?
JR NZ,FN1  ;CONTINUE SEARCHING IF NOT
INC HL  ;POINT TO NEXT MEMORY VALUE
DJNZ FN6  ;CHECK ANOTHER?
LD HL,(FHL) ;GET THE STARTING ADDRESS
DEC HL  ;POINT TO FOUND ADDRESS
JP REGHEX  ;DISPLAY IT
;
;THE FOLLOWING TWO ROUTINES, "HDMP" AND "ADMP",
;DISPLAY MEMORY IN HEX AND ASCII RESPECTIVELY.
;
HDMP:CALL WL  ;DISPLAY AN "H" AND A SPACE
LD A,1  ;SET TO HEX MODE
LD (FLG1),A
JR DM1  ;GO DO THE DUMP
ADMP:CALL WL  ;DISPLAY AN "A" AND A SPACE
XOR A  ;SET TO ASCII MODE
LD (FLG1),A
DM1:CALL PCDEF  ;GET AN ADDRESS
PUSH HL  ;SAVE THE ADDRESS
CALL SCUR  ;SET TASMON'S CURSOR
POP HL  ;RESTORE THE ADDRESS
CALL CLS  ;CLEAR THE SCREEN
DM3:LD C,23  ;DO 23 LINES
DM2:CALL DMIT  ;GO DISPLAY THEM
DM2A:CALL KYINP  ;GET A KEY
CP 20H  ;SPACE BAR?
JR Z,DM3  ;JUMP IF SO
CP 10  ;DOWN ARROW?
JR Z,DM2Z  ;JUMP IF SO
CP '-'  ;"-" ?
JR NZ,DM2A  ;GET ANOTHER KEY IF NOT
LD DE,368  ;BACK UP 368 BYTES
XOR A  ;CLEAR THE CARRY FLAG
SBC HL,DE  ;BACK IT UP
JR DM3  ;GO DISPLAY 23 LINES
DM2Z:LD C,1  ;DO 1 LINE
JR DM2  ;GO DISPLAY IT
DMIT:LD B,8  ;NUMBER OF BYTES/LINE
CALL REGHEX  ;DISPLAY THE ADDRESS
CALL SPC  ;DISPLAY A SPACE
DM4:LD A,(HL)  ;GET A BYTE
INC HL  ;POINT TO NEXT ONE
PUSH AF  ;SAVE THE BYTE
LD A,(FLG1) ;ASCII/HEX?
OR A
JR Z,ASC1  ;JUMP IF ASCII MODE
POP AF  ;RESTORE THE BYTE
DM5:CALL SHEX2  ;DISPLAY IT IN HEX
JR DM6  ;GO CHECK IF LINE DONE
ASC1:POP AF  ;RESTORE THE BYTE
CP 20H  ;CONTROL CHARACTER?
JR C,DM5  ;DISPLAY IT IN HEX IF SO
CP 80H  ;GRAPHICS CHARACTER?
JR NC,DM5  ;DISPLAY IT IN HEX IF SO
PUSH AF  ;SAVE THE BYTE
CALL SPC  ;DISPLAY A SPACE
POP AF  ;RESTORE THE BYTE
CALL WR  ;DISPLAY THE CHARACTER
DM6:CALL SPC  ;DISPLAY A SPACE
DJNZ DM4  ;ANOTHER ON THIS LINE?
LD A,0DH  ;WRITE A CARRIAGE RETURN
CALL WR
DEC C  ;DO ANOTHER LINE?
JR NZ,DMIT  ;JUMP IF SO
RET
;
;THIS ROUTINE IS THE END COMMAND
;
EXIT:CALL WL  ;DISPLAY AN "E" AND A SPACE
EXA:CALL KYINP  ;GET A KEY
CP 0DH  ;CARRIAGE RETURN?
JR NZ,EXA  ;GET ANOTHER IF NOT
LD A,101  ;GET SYSTEM FLAGS
RST 28H  ;DO SVC
SET 1,(IY+3)  ;SET TYPE-AHEAD
CALL CLS  ;CLEAR THE SCREEN
LD A,22  ;EXIT SVC
RST 28H  ;DO SVC
;
;THIS ROUTINE IS THE TRACE COMMAND
;
TRACE:CALL WL  ;DISPLAY A "T" AND A SPACE
XOR A  ;CLEAR THE FLOATING BRKPNT
;ON "RET"/"RET CC" INSTRUCTIONS
LD (BRET),A
TR0:CALL KYINP  ;GET A KEY
CP 10  ;DOWN ARROW?
JR Z,TR0A  ;JUMP IF SO
CP 'I'  ;"I" KEY?
JR NZ,TR0  ;GET ANOTHER KEY IF NOT
CALL WR  ;DISPLAY THE "I"
LD (TTYP),A ;SET TO STEP THROUGH MODE
JR TR0B  ;CONTINUE ON
TR0A:LD A,92  ;DISPLAY A DOWN ARROW
CALL WR
XOR A  ;SET TO EXECUTE IN FULL MODE
LD (TTYP),A
TR0B:CALL CKSCR  ;SCROLL THE DISPLAY
LD A,3  ;SET STALL VALUE TO 1 SECOND
LD (STALL),A
TR1:LD A,(TTYP) ;GET MODE TYPE
OR A
JR Z,TR1A  ;JUMP IF EXECUTE IN FULL
CALL SNB  ;SINGLE STEP - STEPPED THROUGH
JR TR1B  ;CONTINUE ON
TR1A:CALL SNA  ;SINGLE STEP - IN FULL
TR1B:CALL CKSCR  ;SCROLL THE DISPLAY
LD A,(BRET) ;"RET" BREAKPOINT ON?
OR A
JR Z,TR1BZ  ;JUMP IF NOT
LD A,(JPFLAG) ;NEXT INSTRUCTION "RET"?
CP 9
JP Z,BREAK  ;HALT IF SO
CP 10  ;INSTRUCTION A "RET CC"?
JR NZ,TR1BZ ;JUMP IF NOT
LD HL,(RD+22) ;GET THE USER'S PC
LD B,(HL)  ;GET THE CONDITION CODES
LD A,(RD+12) ;GET USER'S F REGISTER
CALL CNDMET  ;CONDITION MET?
JP NZ,BREAK ;HALT IF SO
TR1BZ:LD HL,(RD+22) ;GET USER'S PC
CALL TBRK  ;EXECUTION NUMBER ZERO?
JR NZ,TRABY ;JUMP IF NO BREAK
TFXZ:CALL RSTCV  ;RESET THE EXECUTION NUMBERS
JP BREAK  ;HALT THE TRACE COMMAND
TRABY:CALL KYINP  ;GET A KEY
CP 20H  ;SPACE?
JR NZ,TR5  ;JUMP IF NOT
TR4:CALL KYINP  ;GET ANOTHER KEY
CP 20H  ;SPACE?
JR NZ,TR4  ;GET ANOTHER KEY IF NOT
TR5:CP '0'  ;LEGAL SPEED KEY?
JR C,TR7  ;CONTINUE IF NOT
CP '8'
JR NC,TR7
SUB 30H  ;MAKE IT BINARY
LD B,A
LD A,8
SUB B
LD (STALL),A ;SAVE IT
TR7:CP 'R'  ;BREAKPOINT ON "RET"?
JR NZ,TR7Z  ;JUMP IF NOT
LD (BRET),A ;SET BRKPNT ON "RET" FLAG
TR7Z:LD A,(STALL) ;GET THE STALL VALUE
RLCA   ;CONVERT TO 16 BIT STALL VALUE
LD B,A
TR8:LD A,(STALL) ;PUT STALL VALUE IN D AND E
LD E,A
DEC A
LD D,A
TR9:DEC DE  ;DECREMENT THE COUNTER
CALL BRCK  ;<BREAK> PRESSED?
JP NZ,BREAK  ;If <BREAK>, go to it
LD A,D  ;COUNTER TO ZERO?
OR E
JR NZ,TR9  ;DECREMENT IT AGAIN IF NOT
DJNZ TR8  ;DECREMENT SECONDARY COUNTER
JP TR1  ;GO DO ANOTHER INSTRUCTION
;
;THIS ROUTINE SUMS/SUBTRACTS TWO 4 DIGIT HEX VALUES
;
SUMHEX:CALL WL  ;DISPLAY AN "S" AND A SPACE
CALL GETHEX  ;GET THE FIRST VALUE
PUSH HL  ;SAVE IT
CALL SPC  ;DISPLAY A SPACE
CALL GETHEX  ;GET THE 2ND VALUE
CALL SPC  ;DISPLAY A SPACE
SM1:CALL KYINP  ;GET A KEY
CP '+'  ;"+" KEY?
JR Z,SM2  ;JUMP IF SO
CP '-'  ;"-" KEY?
JR NZ,SM1  ;GET ANOTHER IF NOT
CALL WR  ;DISPLAY THE "-"
CALL SPC  ;DISPLAY A SPACE
POP DE  ;RESTORE THE FIRST NUMBER
XOR A  ;CLEAR THE CARRY FLAG
EX DE,HL  ;SWITCH THE NUMBERS
SBC HL,DE  ;SUBTRACT THEM
SM3:JP REGHEX  ;DISPLAY THE NUMBER
SM2:POP DE  ;RESTORE THE 1ST NUMBER
CALL WR  ;DISPLAY THE "+"
CALL SPC  ;DISPLAY A SPACE
ADD HL,DE  ;ADD THE VALUES
JR SM3  ;GO DISPLAY IT
;
;THIS ROUTINE COMPARES TWO BLOCKS OF MEMORY
;
COMPAR:CALL WL  ;WRITE A "Q" AND A SPACE
COMPR2:CALL HXINP  ;GET A HEX CHARACTER
JR Z,HEXBYT ;IF CHARACTER WAS HEX
NOTHEX:CP 0DH  ;WAS CHARACTER A <CR>?
JR NZ,COMPR2 ;GO GET ANOTHER IF NOT
JR COMPR3  ;ELSE RESUME PREV COMPARE
HEXBYT:CALL GTA  ;GET REST OF HEX ADDRESS
LD (CMPAD1),HL ;STORE ADDRESS # 1
CALL SPC  ;WRITE A SPACE
CALL GETHEX  ;GET SECOND HEX ADDRESS
LD (CMPAD2),HL ;STORE ADDRESS # 2
LD A,' '  ;OUTPUT TWO SPACES TO
CALL WL  ;DISPLAY
COMPR3:LD HL,(CMPAD1) ;GET ADDRESS # 1
LD DE,(CMPAD2) ;GET ADDRESS # 2
XOR A  ;CLEAR CARRY FLAG
PUSH HL  ;SAVE ADDRESS # 1
SBC HL,DE  ;COMPARE #1 & # 2
POP HL  ;RESTORE ADDRESS # 1
RET Z  ;IF BOTH ADDRESSES SAME
CMPLP:LD A,(DE)  ;COMPARE BYTE STORED AT
CP (HL)  ;ADDR # 1 WITH ADDR # 2
INC HL  ;BUMP POINTERS FOR
INC DE  ;BOTH ADDRESSES
JR Z,CMPLP  ;IF COMPARE WAS GOOD
LD (CMPAD1),HL ;SAVE ADDRESSES FOLLOWING
LD (CMPAD2),DE ;BAD COMPARE
DEC HL  ;BUMP POINTERS TO POINT
DEC DE  ;TO ACTUAL BAD ADDRESS
CALL REGHEX  ;DISPLAY BAD ADDRESS #1
CALL SPC  ;WRITE A SPACE
EX DE,HL  ;GET BAD ADDRESS # 2
JR SM3  ;DISPLAY IT & FINISHED
;
;THIS ROUTINE SETS TASMON'S CURSOR TO ITS UPPER
;MOST POSITION
;
SCUR:LD HL,1840  ;GET THE ADDRESS
LD (MNCR),HL ;MAKE TASMON CURSOR ADDRESS
LD B,3  ;FUNCTION #3 OF
LD A,15  ;SVC #15
RST 28H  ;DO SVC
RET
WL:CALL WR  ;DISPLAY THE "A" REGISTER
JP SPC  ;DISPLAY A SPACE
;
;THIS IS THE HARDCOPY DISASSEMBLY ROUTINE
;
PDIS:CALL WL  ;DISPLAY A "P" AND A SPACE
CALL GETHEX  ;GET A STARTING ADDRESS
PUSH HL  ;SAVE IT
CALL SPC  ;DISPLAY A SPACE
CALL GETHEX  ;GET AN ENDING ADDRESS
POP DE  ;RESTORE STARTING ADDRESS
EX DE,HL  ;SWITCH START AND END
PUSH HL  ;Save for later
PUSH DE
LD E,'P'  ;Get *PR DCB
LD D,'R'
LD A,82  ;SVC #82
RST 28H  ;Do SVC
EX DE,HL  ;Get DCB to DE
LD C,0  ;Request status
LD A,5  ;SVC #5
RST 28H  ;Do SVC
POP DE  ;Restore start & end
POP HL
RET NZ  ;Return if not ready
PUSH HL  ;Save starting address
PUSH DE  ;SAVE ENDING ADDRESS
CALL SCUR  ;SET TASMON'S CURSOR
CALL CLS  ;CLEAR THE SCREEN
POP DE  ;RESTORE ENDING ADDRESS
POP HL  ;RESTORE STARTING ADDRESS
LD (STDIS),HL ;SAVE IT
PD1:LD A,1  ;SET FLAG TO ECHO TO PRINTER
LD (PFG),A
LD BC,1  ;DO ONE INSTRUCTION
PUSH DE  ;SAVE ENDING ADDRESS
LD HL,(STDIS) ;GET START ADDRESS
CALL DISASS  ;GO DISASSEMBLE IT
XOR A  ;CLEAR PRINT ECHO FLAG
LD (PFG),A
LD A,0DH  ;WRITE A CARRIAGE RETURN
CALL PNTIT
CALL KYINP  ;GET A KEY
LD HL,(STDIS) ;GET THE CURRENT ADDRESS
DEC HL  ;BACK UP ONE BYTE
POP DE  ;RESTORE ENDING ADDRESS
OR A  ;CLEAR CARRY FLAG
SBC HL,DE  ;DONE?
JP M,PD1  ;DO ANOTHER INSTRUCTION IF NOT
JP DSPRG  ;GO DISPLAY THE REGISTERS
;
;CLEAR SCREEN ROUTINE
;
CLS:PUSH HL  ;SAVE HL ACROSS CLS
LD HL,CLSS  ;CLEAR THE SCREEN
LD A,10  ;SVC #10
RST 28H  ;Do SVC
POP HL  ;RESTORE HL
RET
CLSS:DEFB 28,31,3
;
;THIS IS THE "KEEP SCREEN" ROUTINE
;
KPSCRN:CALL WL  ;DISPLAY A "K" AND A SPACE
KPS10:CALL HXINP  ;GET A KEY
JR Z,KPS20  ;JUMP IF HEX
CP 'N'  ;"N"?
JR Z,KPS30  ;JUMP IF SO
CP 'Y'  ;"Y"?
JR Z,KPS40  ;JUMP IF SO
CP 0DH  ;CARRIAGE RETURN?
JR NZ,KPS10 ;GET ANOTHER KEY IF NOT
CALL VKS  ;VEIW KEPT SCREEN
JP BREAK  ;RETURN TO COMMAND INPUT MODE
KPS20:CALL GTA  ;GET REST OF SCREEN ADDRESS
LD (KPADD),HL ;SAVE IT
LD BC,1920  ;NUMBER OF BYTES TO DO
KPS25:LD A,20H  ;BYTE TO PLACE
LD (HL),A  ;BLANK A CHARACTER
INC HL  ;POINT TO NEXT ONE
DEC BC  ;DONE CLEARING THE SAVED SCREEN?
LD A,B
OR C
JR NZ,KPS25 ;IF NOT, CLEAR ANOTHER
RET
KPS30:CALL WR  ;DISPLAY AN "N"
XOR A  ;TURN KEEP SCREEN OFF
LD (KPON),A
RET
KPS40:CALL WR  ;DISPLAY A "Y"
LD A,1  ;TURN KEEP SCREEN ON
LD (KPON),A
RET
;
;THIS ROUTINE GETS A FOUR DIGIT HEX VALUE AND RETURNS
;IT IN THE HL REGISTER PAIR.  IF THE ENTER KEY IS
;PRESSED AS THE RESPONCE, THE USER'S PC REGISTER IS
;RETURNED IN HL.
;
PCDEF:CALL HXINP  ;GET A KEY
JP Z,GTA  ;GO GET THE REST OF THE
;INPUT IF THIS ONE IS HEX
CP 0DH  ;CARRIAGE RETURN?
JR NZ,PCDEF ;GET ANOTHER KEY IF NOT
LD HL,(RD+22) ;GET USER'S PC REGISTER
JP REGHEX  ;GO DISPLAY IT
;
;THIS ROUTINE CHECKS IF THE BREAK KEY IS PRESSED.
;
BRCK:PUSH DE  ;SAVE DE ACROSS CALL
PUSH BC  ;AND BC TOO, MAYBE
LD A,8  ;GET BREAK KEY
RST 28H  ;Do SVC
CP 80H  ;Will go to zero on <BREAK>
JR Z,BRHIT  ;<BREAK> HIT, SO SWITCH FLAG
XOR A  ;SET FLAG
JR BEXIT
BRHIT:OR A  ;GO NON-ZERO
BEXIT:POP BC  ;RESTORE BC
POP DE  ;AND DE
RET
;
;THIS ROUTINE TESTS IF EXECUTION SHOULD HALT AFTER
;A BREAK.  HL ENTERS HOLDING THE ADDRESS IN QUESTION.
;ON EXIT, THE "Z" FLAG IS SET IF A BREAK SHOULD
;OCCUR.  THE CARRY FLAG IS SET ON EXIT IF THE ADDRESS
;IN QUESTION WAS THE SAME AS ONE OF THE BREAKPOINTS.
;
TBRK:LD IX,BRTBL ;POINT TO BREAKPOINT ADDRESSES
LD B,9  ;NUMBER TO CHECK
LD A,1
TB10:LD E,(IX+0) ;GET A BREAKPOINT ADDRESS
LD D,(IX+1)
INC IX  ;POINT TO NEXT ONE
INC IX
OR A  ;CLEAR CARRY FLAG
EX DE,HL  ;SWITCH ADDRESS IN QUESTION AND
;THE CURRENT BREAKPOINT ADDRESS
SBC HL,DE  ;SAME ADDRESS?
EX DE,HL
JR Z,TB20  ;JUMP IF SO
DJNZ TB10  ;NOT A MATCH, DO ANOTHER?
OR A  ;CLEAR THE "Z" AND "C" FLAGS
RET
TB20:LD A,9  ;FIND THE BREAKPOINT NUMBER
SUB B
LD C,A  ;PUT IN C
LD B,0
LD HL,CURN  ;POINT TO THE EXECUTION NUMBER
ADD HL,BC  ;POINT TO SPECIFIC ONE
DEC (HL)  ;DECREMENT IT
SCF   ;SET THE CARRY FLAG
RET
;
;NUMBER OF EXECUTIONS ROUTINE.  THESE ROUTINES SET
;THE NUMBER OF EXECUTIONS INDIVIDUALLY, SET THEM TO
;DEFAULT VALUES OR SET THEM ALL TO 01
;
NEBB:CALL WL  ;DISPLAY AN "N" AND A SPACE
NE10:CALL KYINP  ;GET A KEY
CP 0DH  ;CARRIAGE RETURN?
JR Z,RSTCV  ;JUMP IF SO
CP 'I'  ;"I"?
JR Z,NINITZ ;JUMP IF SO
CP '1'  ;LEGAL BREAKPOINT NUMBER?
JR C,NE10  ;GET ANOTHER KEY IF NOT
CP 3AH
JR NC,NE10  ;GET ANOTHER KEY IF NOT
JR SOVL  ;GO TO SET ROUTINE
NINITZ:CALL WL  ;DISPLAY AN "I"
NINIT:LD B,9  ;NUMBER TO DO
LD HL,ORGN  ;POINT TO ORIGINAL VALUES
LD A,1  ;BYTE TO PLACE
NI10:LD (HL),A  ;SET EXEC. NUMBER TO 1
INC HL  ;POINT TO NEXT ONE
DJNZ NI10  ;DO ANOTHER ONE?
RSTCV:LD B,9  ;NUMBER TO DO
LD HL,ORGN  ;POINT TO THE ORIGINAL VALUES
LD DE,CURN  ;POINT TO THE CURRENT VALUES
RS10:LD A,(HL)  ;GET AN ORIGINAL VALUE
INC HL  ;POINT TO NEXT ONE
LD (DE),A  ;SET CURRENT = ORIGINAL
INC DE  ;POINT TO NEXT CURRENT ONE
DJNZ RS10  ;ALL DONE?
RET
SOVL:PUSH AF  ;SAVE BREAKPOINT NUMBER
CALL WL  ;DISPLAY BREAKPOINT NUMBER
POP AF  ;RESTORE BREAKPOINT NUMBER
SUB 31H  ;MAKE IT BINARY
LD C,A
LD B,0
CALL GT2  ;GET TWO H