;**** MODULE01/ASM ****
;
 ORG 06000H ; START HERE
START:CALL CLS  ;Clear the screen
LD B,4  ;Function #4 (get cursor)
LD A,15  ;SVC #15
RST 28H  ;Do SVC
LD (USCR),HL ;SAVE AS THE USER'S CURSOR
LD SP,STACK ;SET THE STACK POINTER
LD A,101  ;GET SYSTEM FLAG POINTER IN IY
RST 28H  ;DO SVC
RES 1,(IY+3) ;TURN OFF TYPE-AHEAD
SET 5,(IY+10) ;SET CAPS LOCK
LD C,15  ;TURN CURSOR OFF
LD A,2  ;SVC #2
RST 28H  ;DO SVC
CALL CLALL  ;CLEAR ALL BREAKPOINTS
LD HL,MX  ;Display opening message
LD A,10  ;SVC #10
RST 28H  ;Do SVC
LD A,1
LD (PRINT),A ;SET THE DISPLAY FLAG ON
CALL NINIT  ;INITIALIZE EXECUTION NUMBERS
CALL DSPRG  ;DISPLAY THE REGISTERS
CALL SCUR  ;SET THE MONITOR'S CURSOR
CALL CKSCR  ;SCROLL THE SCREEN
KYLOOP:CALL INPUT  ;DO A COMMAND
CALL CKSCR  ;SCROLL THE SCREEN
KYP:LD SP,STACK ;SET THE STACK
JR KYLOOP  ;GO DO ANOTHER
;
;THIS IS THE SCREEN SCROLL COMMAND THAT WAS 
;ORIGINALLY IN SYS13/SYS.  IT WAS REMOVED TO
;ALLOW USAGE OF AN EXTEND COMMAND INTERPRETER.
;
CKSCR:PUSH DE  ;SAVE DE,BC, & HL
PUSH BC
PUSH HL
LD HL,(MNCR) ;GET TASMON'S CURSOR
INC H  ;POINT TO NEXT LINE
LD A,H  ;SEE IF LINE > 24
CP 24
CALL Z,SCROLL ;SCROLL IF NEEDED
LD (MNCR),HL ;SAVE NEW CURSOR POSITION
LD B,3  ;SAVE NEW CURSOR POSITION
LD A,15
RST 28H
POP HL  ;GET BC,DE, & HL
POP BC
POP DE
RET
SCROLL:DI   ;NO NASTY EXCURSIONS ELSEWHERE
LD A,86H  ;TOGGLE HIGH BANK IN
OUT (84H),A
LD A,15  ;SCROLL 15 LINES
LD HL,0FAB0H ;ADDRESS OF 1ST LINE TO MOVE
LD (SC1+1),HL
SC1:LD DE,0  ;HOLDS PREVIOUS LINE
LD H,D
LD L,E
LD BC,80  ;POINT TO PREVIOUS LINE
ADD HL,BC
LD (SC1+1),HL ;SAVE HL
LD BC,32  ;DO 32 CHARACTERS ON THE LINE
LDIR   ;SCROLL THE LINE
DEC A  ;DO ANOTHER LINE?
JR NZ,SC1  ;JUMP IF SO
LD A,87H  ;TOGGLE HIGH BANK OUT
OUT (84H),A
EI
LD HL,1730H ;POINT TO LAST LINE
PUSH HL
LD B,3  ;FUNCTION #3 OF
LD A,15  ;SVC #15
RST 28H  ;DO SVC
LD C,30  ;CLEAR TO END OF LINE
LD A,2  ;SVC #2
RST 28H  ;DO SVC
POP HL  ;RESTORE CURSOR POSITION
RET   ;EXIT SCROLL ROUTINE
;
;THIS COMMAND WAS ALSO IN SYS13/SYS. 
;IT DISPLAYS A KEPT SCREEN AND
;WAITS FOR <ENTER>.
;
VKS:LD B,5  ;FUNCTION #5 OF
LD A,15  ;SVC #15
LD HL,(KPADD) ;KEPT SCREEN ADDRESS
RST 28H  ;DO SVC
DI   ;NO NASTY EXCURSIONS ELSEWHERE
LD A,86H  ;TOGGLE SCREEN & KEYBOARD IN
OUT (84H),A
VKSLP:LD A,(0F440H) ;<ENTER> HELD DOWN?
AND 1  ;TEST FOR <ENTER>
JR NZ,VKSLP  ;GO IF SO
LD A,87H  ;TOGGLE SCREEN & KEYBOARD OUT
OUT (84H),A
EI   ;ALLOW EXCURSIONS
RET
;
;INTERPRET A TASMON COMMAND
;
INPUT:LD C,94  ;SET CURSOR CHARACTER
LD A,2  ;SVC #2
RST 28H  ;DO SVC
LD A,1  ;TURN THE PRINT FLAG ON
LD (PRINT),A
IN02:CALL KYINP  ;GET A KEYBOARD CHAR.
CP 1FH  ;CLEAR SCREEN?
JR NZ,IN01  ;JUMP IF NOT
CALL CLS  ;CLEAR THE SCREEN
CALL SCUR  ;SET THE CURSOR
JP DSPRG  ;DISPLAY THE REGISTERS
IN01:CP 'I'  ;SINGLE STEP?
JP Z,SNGCS  ;JUMP IF SO
CP 'G'  ;GO COMMAND?
JP Z,GCMD  ;JUMP IF SO
CP 'D'  ;DISASSEMBLE ?
JP Z,DSEM  ;JUMP IF SO
CP 'B'  ;BREAKPOINT COMMAND?
JP Z,BRPNT  ;JUMP IF SO
CP 'C'  ;CLEAR BREAKPOINTS?
JP Z,CBRPNT ;JUMP IF SO
CP 'M'  ;MODIFY MEMORY?
JP Z,MM01  ;JUMP IF SO
CP 'R'  ;REPLACE REGISTERS?
JP Z,MRG01  ;JUMP IF SO
CP 0AH  ;SINGLE STEP?
JP Z,SNGCT  ;JUMP IF SO
CP 'F'  ;FIND COMMAND?
JP Z,FIND  ;JUMP IF SO
CP 'A'  ;ASCII DUMP?
JP Z,ADMP  ;JUMP IF SO
CP 'H'  ;HEX DUMP?
JP Z,HDMP  ;JUMP IF SO
CP 'E'  ;END COMMAND?
JP Z,EXIT  ;JUMP IF SO
CP 'T'  ;TRACE COMMAND?
JP Z,TRACE  ;JUMP IF SO
CP 'S'  ;SUM/SUBTRACT?
JP Z,SUMHEX ;JUMP IF SO
CP 'P'  ;PRINT DISASSEMBLY?
JP Z,PDIS  ;JUMP IF SO
CP 'L'  ;LOAD COMMAND?
JP Z,LDSK  ;JUMP IF SO
CP 'W'  ;WRITE COMMAND?
JP Z,WFILE  ;JUMP IF SO
CP 9  ;SKIP FORWARD?
JP Z,SINS  ;JUMP IF SO
CP 8  ;BACK UP?
JP Z,BINS  ;JUMP IF SO
CP 'O'  ;OUTPUT DISASSEMBLY?
JP Z,DDSK  ;JUMP IF SO
CP 'X'  ;RELOCATE?
JP Z,RMEM  ;JUMP IF SO
CP 'Y'  ;BLOCK MOVE?
JP Z,MOVIT  ;JUMP IF SO
CP 'Z'  ;ZERO MEMORY?
JP Z,ZERO  ;JUMP IF SO
CP 'V'  ;VIEW A FILE?
JP Z,VIEW  ;JUMP IF SO
CP 'J'  ;TOGGLE RESTARTS?
JP Z,JPRST  ;JUMP IF SO
CP 'K'  ;KEEP SCREEN?
JP Z,KPSCRN ;JUMP IF SO
CP 'N'  ;NUMBER OF EXECUTIONS?
JP Z,NEBB  ;JUMP IF SO
CP 'Q'  ;COMPARE COMMAND?
JP Z,COMPAR ;JUMP IF SO
CP 'U'  ;USER COMMAND?
JP Z,BREAK  ;JUMP IF SO
JP IN02  ;NO LEGAL COMMANDS - GO GET
;ANOTHER CHARACTER
KYINP:CALL KYBORD  ;GET A KEYBOARD CHAR.
CP 80H  ;BREAK KEY?
RET NZ  ;RETURN IF NOT
BREAK:LD SP,STACK ;RESET THE STACK
CALL DSPRG  ;DISPLAY THE REGISTERS
CALL CKSCR  ;SCROLL THE SCREEN
JP KYP  ;GO DO A COMMAND
;
;THE FOLLOWING IS THE SINGLE STEP ROUTINE
;
;ALL PC MODIFYING INSTRUCTIONS (JP, CALL, ETC.) ARE
;DONE IN SOFTWARE.  ALL OTHER INSTRUCTIONS ARE COPIED
;TO A RAM BUFFER AND EXECUTED.  THIS ALLOWS ROM
;TO BE SINGLE STEPPED.
;
SSTEP:LD A,(BDCODE) ;CURRENT INSTR. BAD CODE?
OR A
JR NZ,BREAK ;JUMP IF SO
LD HL,(RD+22) ;USER'S PC REG IN HL
CALL REGHEX  ;DISPLAY USER PC CONTENTS
LD A,20H  ;SPACE CHARACTER
CALL WL  ;WRITE IT OUT
LD HL,0030H ;DISASSEM INSTR AREA
LD B,16H  ;# OF BYTES TO MOVE
ZFDADH:PUSH HL  ;SAVE HL
PUSH BC  ;SAVE BC
LD B,01H  ;Function #1 of
LD A,0FH  ;SVC # 15
RST 28H  ;DO SVC
CALL WR  ;DISPLAY & PRINT IT
POP BC  ;RESTORE BC
POP HL  ;RESTORE HL
INC HL  ;BUMP TO NEXT CHARACTER
DJNZ ZFDADH  ;DO NEXT CHARACTER
LD A,(JPFLAG) ;PC MODIFYING INSTR.?
OR A
LD HL,(RD+22) ;GET THE USER'S PC
JR NZ,JPSF  ;JUMP IF SO
SKP1:LD A,(NLONG) ;NUMBER OF BYTES IN INSTR.
LD B,A  ;PUT IN B
LD DE,ROMBF ;POINT TO ROM BUFFER
RS1:LD A,(HL)  ;GET A BYTE OF THE INSTR.
INC HL  ;POINT TO NEXT ONE
LD (DE),A  ;COPY TO EXECUTION BUFFER
INC DE  ;POINT TO NEXT BYTE
DJNZ RS1  ;DO ANOTHER?
LD (ADDRES),HL ;SAVE NEW PC
LD A,0CDH  ;PUT A BREAKPOINT AFTER THE
LD (DE),A  ;INSTRUCTION IN THE EXECUTION
PUSH DE  ;BUFFER
INC DE
LD HL,RTN01
LD A,L
LD (DE),A
INC DE
LD A,H
LD (DE),A
LD HL,(RD+20) ;GET THE USER'S STACK
DEC HL
PUSH HL  ;SAVE IT
LD HL,ROMBF ;POINT TO EXECUTION BUFFER
LD (RD+22),HL ;SAVE AS USER'S PC
CALL LBRP  ;LOAD THE BREAKPOINTS
CALL USRSTR  ;SINGLE STEP IT
CALL FBRP  ;FIX THE BREAKPOINTS
POP BC  ;GET USER'S STACK
POP DE  ;GET ADDRESS OF BREAKPOINT
LD HL,(RD+22) ;GET THE USER'S NEW PC
OR A  ;ARE THE TWO ADDRESSES THE
SBC HL,DE  ;SAME?
;
;IF THE ADDRESS WHERE THE BREAKPOINT WAS LOADED IS THE
;SAME AS THE USER'S NEW PC, THEN A BREAKPOINT WITHIN
;A CALL EXECUTED IN FULL WAS NOT ENCOUNTERED.  THIS
;CASE MUST BE DETERMINED SINCE THE RETURN ADDRESS OF
;A CALL IS PLACED ON THE USER'S STACK.  THE RETURN
;ADDRESS WILL BE IN THE EXECUTION BUFFER.  BUT THE
;PROPER RETURN ADDRESS SHOULD BE THE ADDRESS OF THE
;INSTRUCTION FOLLOWING THE ONE JUST SINGLE STEPPED.
;
LD HL,(ADDRES) ;GET THE CORRECT PC
JR Z,TFX05  ;NOT A BRKPNT WITHIN CALL
LD A,H  ;PUSH THE CORRECT RETURN
LD (BC),A  ;ADDRESS ON THE USER'S STACK
DEC BC
LD A,L
LD (BC),A
RET   ;RETURN TO THE CALLING ROUTINE
TFX05:LD (RD+22),HL ;SAVE USER'S PC
RET   ;RETURN TO CALLING ROUTINE
;
;THE FOLLOWING IS THE SOFTWARE ROUTINE TO HANDLE ALL
;PC MODIFYING INSTRUCTIONS.  THE DISASSEMBLER SETS THE
;MEMORY ADDRESS "JPFLAG" TO ZERO IF THE INSTRUCTIONS
;DOES NOT MODIFY THE PC.  IT SETS "JPFLAG" TO A CODE
;IF IT DOES MODIFY THE PC.
;
JPSF:CP 1  ;"JP" INSTRUCTION?
JR NZ,NTJP1 ;JUMP IF NOT
JP01:INC HL  ;POINT TO JUMP ADDRESS
LD E,(HL)  ;GET THE ADDRESS
INC HL  ;IN DE
LD D,(HL)
EX DE,HL  ;PUT IT IN HL
LD (RD+22),HL ;SAVE AS THE USER'S PC
RET   ;RETURN
NTJP1:CP 2  ;"JP CC" INSTRUCTION?
JR NZ,NTJP2 ;JUMP IF NOT
LD B,(HL)  ;GET THE CONDITION CODE
LD A,(RD+12) ;GET THE USER'S F REGISTER
CALL CNDMET  ;CONDITION MET?
JR NZ,JP01  ;JUMP IF MET
JP02:INC HL  ;SKIP THE INSTRUCTION
INC HL
INC HL
LD (RD+22),HL ;SAVE USER'S PC
RET   ;RETURN
NTJP2:CP 3  ;"JR" INSTRUCTION?
JR NZ,NTJP3 ;JUMP IF NOT
JR01:INC HL  ;POINT TO RELATIVE OFFSET
LD (STDIS),HL ;SET UP OFFSET ROUTINE
XOR A  ;DON'T PRINT ANYTHING
LD (PRINT),A
CALL JRADD  ;COMPUTE THE ADDRESS
LD A,1  ;TURN ON THE PRINT FLAG
LD (PRINT),A
LD (RD+22),HL ;SAVE THE USER'S PC
RET   ;RETURN
NTJP3:CP 4  ;"DJNZ E" INSTRUCTION?
JR NZ,NTJP4 ;JUMP IF NOT
LD A,(RD+15) ;GET THE USER'S B REGISTER
DEC A  ;DECREMENT IT
LD (RD+15),A ;SAVE IT AGAIN
JR NZ,JR01  ;JUMP IF NOT ZERO
JR02:INC HL  ;SKIP THE INSTRUCTION
INC HL
LD (RD+22),HL ;SAVE USER'S PC
RET   ;RETURN
NTJP4:CP 5  ;"JR CC" INSTRUCTION?
JR NZ,NTJP5 ;JUMP IF NOT
LD A,(HL)  ;GET THE CONDITION CODE
AND 24  ;MASK OUT THE CODE
LD B,A  ;PUT IN B
LD A,(RD+12) ;GET THE USER'S F REGISTER
CALL CNDMET  ;CONDITION MET?
JR NZ,JR01  ;JUMP IF MET
JR JR02  ;SKIP IT IF NOT MET
NTJP5:CP 6  ;"JP (RP)" INSTRUCTION?
JR NZ,NTJP6 ;JUMP IF NOT
LD A,(HL)  ;GET THE TYPE OF INSTRUCTION
CP 0E9H  ;JP (HL)?
JR NZ,NX01  ;JUMP IF NOT
LD HL,(RD+18) ;GET THE USER'S HL REGISTER
BTIT1:LD (RD+22),HL ;SAVE USER'S PC REGISTER
RET   ;RETURN
NX01:CP 0DDH  ;JP (IX) INSTRUCTION?
JR NZ,NX02  ;JUMP IF NOT
LD HL,(RD+0) ;GET USER'S IX REGISTER
JR BTIT1  ;GO MAKE IT THE PC
NX02:LD HL,(RD+2) ;GET USER'S IY REGISTER
JR BTIT1  ;GO MAKE IT THE PC
NTJP6:CP 7  ;"CALL" INSTRUCTION?
JR NZ,NTJP7 ;JUMP IF NOT
CL0A:LD A,(SKCALL) ;GET CALL STATUS (STEP
;THROUGH OR EXECUTE IN FULL)
OR A
JP Z,SKP1  ;JUMP IF EXECUTE IN FULL
INC HL  ;GET THE CALL ADDRESS
LD E,(HL)  ;AND PUT IN DE
INC HL
LD D,(HL)
INC HL
LD (RD+22),DE ;SAVE AS USER'S PC
LD (STK),SP ;SAVE TASMON'S STACK
LD SP,(RD+20) ;GET THE USER'S STACK
PUSH HL  ;PUT THE RETURN ADDRESS ON STACK
LD (RD+20),SP ;SAVE THE NEW STACK
LD SP,(STK) ;RESTORE TASMON'S STACK
RET   ;RETURN
NTJP7:CP 8  ;"CALL CC" INSTRUCTION?
JR NZ,NTJP8 ;JUMP IF NOT
LD B,(HL)  ;GET THE CONDITION CODE
LD A,(RD+12) ;GET THE F REGISTER
CALL CNDMET  ;CONDITION MET?
JR NZ,CL0A  ;JUMP IF MET
JP JP02  ;JUMP IF NOT MET
NTJP8:CP 9  ;"RET" INSTRUCTION?
JR NZ,NTJP9 ;JUMP IF NOT
RT01:LD (STK),SP ;SAVE TASMON'S STACK
LD SP,(RD+20) ;GET THE USER'S STACK
POP DE  ;GET THE RETURN ADDRESS
LD (RD+20),SP ;SAVE THE USER'S STACK
LD (RD+22),DE ;UPDATE THE USER'S PC
LD SP,(STK) ;RESTORE TASMON'S STACK
RET   ;RETURN
NTJP9:CP 11  ;"RST" INSTRUCTION?
JR NZ,NTJP10 ;JUMP IF NOT
LD A,(SKRST) ;GET STATUS OF "RST" (STEP
;THROUGH OR EXECUTE IN FULL)
OR A
JP Z,SKP1  ;JUMP IF EXECUTE IN FULL
LD A,(HL)  ;MASK OUT RST ADDRESS
AND 56
LD (STK),SP ;SAVE TASMON'S STACK
LD SP,(RD+20) ;GET THE USER'S STACK
INC HL  ;POINT TO INSTR. AFTER "RST"
PUSH HL  ;SAVE RETURN ADDRESS
LD (RD+20),SP ;SAVE USER'S STACK
LD SP,(STK) ;RESTORE TASMON'S STACK
LD L,A  ;PUT ADDRESS OF "RST" IN HL
LD H,0
LD (RD+22),HL ;SAVE USER'S PC
RET   ;RETURN
NTJP10:LD B,(HL)  ;"RET CC" INSTRUCTION
LD A,(RD+12) ;GET USER'S F REGISTER
CALL CNDMET  ;CONDITION MET?
JR NZ,RT01  ;JUMP IF MET
INC HL  ;FALL THROUGH INSTRUCTION IF NOT
LD (RD+22),HL ;SAVE USER'S PC
RET   ;RETURN
;
;THIS ROUTINE DETERMINES IF THE CONDITION OF A
;RET CC, JP CC OR CALL C IS MET.  IT IS SENT THE
;CONDITION BYTE IN THE B REGISTER AND THE F
;REGISTER IN THE A REGISTER.
;
;ON EXIT, THE "Z" FLAG IS SET IF THE CONDITION WAS
;NOT MET.
;
CNDMET:LD C,A  ;SAVE F REGISTER
LD A,B  ;MASK OUT CONDITION BITS
AND 56
CP 0  ;"NZ" CONDITION?
JR NZ,CN1  ;JUMP IF NOT
BIT 6,C  ;TEST FOR THE "Z" BIT
JR Z,TRU  ;JUMP IF MET
JR FAL  ;JUMP IF NOT MET
CN1:CP 8  ;"Z" CONDITION?
JR NZ,CN2  ;JUMP IF NOT
BIT 6,C  ;TEST THE "Z" BIT
JR NZ,TRU  ;JUMP IF TRUE
JR FAL  ;JUMP IF FALSE
CN2:CP 16  ;"NC" CONDITION?
JR NZ,CN3  ;JUMP IF NOT
BIT 0,C  ;TEST THE "C" FLAG
JR Z,TRU  ;JUMP IF TRUE
JR FAL  ;JUMP IF FALSE
CN3:CP 24  ;"C" CONDITION?
JR NZ,CN4  ;JUMP IF NOT
BIT 0,C  ;TEST THE "C" FLAG
JR NZ,TRU  ;JUMP IF TRUE
JR FAL  ;JUMP IF FALSE
CN4:CP 32  ;"PO" CONDITION?
JR NZ,CN5  ;JUMP IF NOT
BIT 2,C  ;TEST THE "P/V" FLAG
JR Z,TRU  ;JUMP IF TRUE
JR FAL  ;JUMP IF FALSE
CN5:CP 40  ;"PE" CONDITION?
JR NZ,CN6  ;JUMP IF NOT
BIT 2,C  ;TEST THE "P/V" FLAG
JR NZ,TRU  ;JUMP IF TRUE
JR FAL  ;JUMP IF FALSE
CN6:CP 48  ;"P" CONDITION?
JR NZ,CN7  ;JUMP IF NOT
BIT 7,C  ;TEST THE "S" BIT
JR Z,TRU  ;JUMP IF TRUE
JR FAL  ;JUMP IF FALSE
CN7:BIT 7,C  ;TEST THE "S" BIT
JR NZ,TRU  ;JUMP IF TRUE
FAL:XOR A  ;SET THE "Z" FLAG
RET
TRU:LD A,1  ;CLEAR THE "Z" FLAG
OR A
RET
;
;THE FOLLOWING ROUTINE WILL LOAD THE USER'S Z-80
;REGISTERS AND JUMP TO HIT PC REGISTER.  THE USER'S
;CURSOR AND CURSOR CHARACTER ARE RESTORED WHEN THE
;ROUTINE IS STARTED.
;
USRSTR:LD (STK),SP ;SAVE TASMON'S STACK
LD SP,RD  ;POINT TO THE USER'S REGISTERS
LD B,3  ;POSITION CURSOR FUNCTION OF
LD A,15  ;SVC #15
LD HL,(USCR) ;User screen location
RST 28H  ;DO SVC
LD A,(KPON) ;KEEP SCREEN ON?
OR A
JR Z,USR10  ;JUMP IF NOT
LD B,5  ;Function #5 of
LD A,15  ;SVC #15
LD HL,(KPADD) ;Copy from user defined buffer
RST 28H  ;DO SVC
USR10:POP IX  ;GET THE USER'S IX REGISTER
POP IY  ;GET IY
POP AF  ;GET AF'
POP BC  ;GET BC'
POP DE  ;GET DE'
POP HL  ;GET HL'
EXX   ;SWITCH PRIMARY AND SECONDARY REGS.
EX AF,AF
POP AF  ;GET AF
POP BC  ;GET BC
POP DE  ;GET DE
POP HL  ;GET HL
LD (STDIS),HL ;SAVE HL
POP HL  ;GET THE USER'S STACK
LD (S1),HL  ;SAVE IT
POP HL  ;GET USER'S PC
LD (NMDIS),HL ;SAVE IT
LD SP,(S1)  ;GET USER'S STACK
LD HL,(NMDIS)
PUSH HL  ;PUSH PC ON THE STACK
LD HL,(STDIS) ;GET HL
RET   ;JUMP TO THE USER'S PC
;
;THE FOLLOWING ROUTINE WILL SAVE THE USER'S REGISTERS
;AND THE CURSOR POSITION/CHARACTER.  THIS IS THE
;ROUTINE "CALL"ED AS A BREAKPOINT.  IT IS ASSUMED
;THAT THE USER'S PC REGISTER IS PUSHED ON THE USER'S
;STACK.
;
RTN01:LD (STK1),SP ;SAVE THE USER'S SP
LD SP,RD+20 ;POINT TO THE REGISTER SAVE
;AREA (USER'S REGISTER BUFFER)
PUSH HL  ;SAVE HL
PUSH DE  ;SAVE DE
PUSH BC  ;SAVE BC
PUSH AF  ;SAVE AF
LD B,4  ;Function 4 of
LD A,15  ;SVC #15
RST 28H  ;Do SVC
LD (USCR),HL ;SAVE IT
EX AF,AF
EXX   ;SWITCH PRIMARY AND SECONDARY REGS.
PUSH HL  ;SAVE HL'
PUSH DE  ;SAVE DE'
PUSH BC  ;SAVE BC'
PUSH AF  ;SAVE AF'
PUSH IY  ;SAVE IY
PUSH IX  ;SAVE IX
LD SP,(STK1) ;GET THE USER'S SP
POP HL  ;GET THE USER'S PC
DEC HL  ;SUBTRACT THREE
;FROM THE PC SINCE THIS
;VALUE IS THE ADDRESS JUST AFTER THE
;BREAKPOINT.  THE BREAKPOINT IS THREE
;BYTES LONG SO MVING BACK BY THREE MAKES
;IT POINT TO THE ADDRESS OF THE BREAK-
;POINT OR THE CORRECT PC.
DEC HL
DEC HL
LD (RD+22),HL ;SAVE THE USER'S PC
LD (RD+20),SP ;SAVE THE USER'S SP
LD SP,(STK) ;RESTORE TASMON'S STACK
LD B,3  ;Function #3 of
LD A,15  ;SVC #15
LD HL,(MNCR) ;Set TASMON cursor
RST 28H  ;DO SVC
LD A,(KPON) ;KEEP SCREEN ON?
OR A
RET Z  ;RETURN IF NOT
LD B,6  ;Function #6 of
LD A,15  ;SVC #15
LD HL,(KPADD) ;Move to user defined buffer
RST 28H  ;DO SVC
RET   ;RETURN
;
;DISPLAY THE USER'S REGISTERS.
;
DSPRG:PUSH DE  ;SAVE DE
LD HL,(MNCR) ;SAVE TASMON'S CURSOR
LD (HLBUF),HL
LD HL,48  ;COLUMN 48
PUSH HL  ;SAVE FOR LATER
LD B,3  ;Function #3 of
LD A,15  ;SVC #15
RST 28H  ;Do SVC
POP HL  ;GET ROW/COL BACK
LD (MNCR),HL ;SAVE AS TASMON'S CURSOR
LD C,30  ;Byte to display
LD A,2  ;SVC #2
RST 28H  ;Do SVC
;
;A TAB PRECEDES EACH DISASSEMBLED INSTRUCTION.  THE
;CURSOR IS SET SO A TAB WILL MOVE THE CURSOR TO
;COLUMN 48.
;
LD B,3  ;Function #3 of
LD A,15  ;SVC #15
LD HL,44  ;Set cursor to row 0, col 44
RST 28H  ;Do SVC
LD HL,(RD+22) ;GET THE USER'S PC
LD BC,1  ;DO ONE INSTRUCTION
LD A,1  ;TELL THE DISASSEMBLER
;TO DISPLAY THE RESULTS
LD (ADPR),A ;SET FLAG TO NOT DISPLAY
;THE HEX BYTES OF THE INSTRUCTION
CALL DISASS  ;DISASSEMBLE IT
LD (NLONG),A ;SAVE THE NUMBER OF BYTES
;IN THE INSTRUCTION
LD B,3  ;FUNCTION #3 OF
LD A,15  ;SVC #15
LD HL,48  ;COL #48
RST 28H  ;DO SVC
CALL CKSCR  ;SCROLL THE SCREEN
XOR A  ;TELL DISASSEMBLER TO DISPLAY
;THE HEX VALUES OF INSTRUCTIONS
LD (ADPR),A
LD HL,RTXT  ;POINT TO ASCII REGISTER
;NAMES (HL, HL', DE, ETC.)
LD DE,RD  ;POINT TO USER'S REGISTERS
LD (STDIS),DE ;SAVE IT
RGD1:LD B,4  ;DO 4 CHARACTERS
RGD2:LD A,(HL)  ;GET A REGISTER CHARACTER
INC HL  ;POINT TO NEXT ONE
CALL WR  ;DISPLAY IT
DJNZ RGD2  ;DO ANOTHER?
EX DE,HL  ;POINT TO REGISTER DATA
CALL THEX  ;DISPLAY (HL)
CALL INCHL  ;INCREMENT HL
EX DE,HL  ;SWITCH BACK TO REGISTER NAMES
CALL SPC  ;WRITE A SPACE
CALL WR  ;AGAIN
DEC HL  ;POINT TO LAST CHARACTER OF THE
;PREVIOUSLY DISPLAYED REGISTER NAME
LD A,(HL)  ;GET THE CHARACTER
INC HL
CP 128  ;END OF LINE?
JR NZ,RGD1  ;JUMP IF NOT
CALL CKSCR  ;SCROLL THE SCREEN
LD A,(HL)  ;GET THE CURRENT CHARACTER
CP 128  ;END OF REGISTER STUFF?
JR NZ,RGD1  ;JUMP IF NOT
LD B,8  ;DO EIGHT Z-80 FLAG BITS
LD A,(RD+12) ;GET THE USER'S Z-80 FLAGS
LD HL,ZTBL  ;POINT TO THE BIT TABLE
FZ1:PUSH HL  ;SAVE THE TABLE ADDRESS
RLA   ;ROLL LEFT TO CARRY
JR C,FZ2  ;JUMP IF BIT WAS SET
INC HL  ;IF NOT SET POINT TO NEXT
;BIT TABLE ENTRY
FZ2:LD E,A  ;SAVE THE Z-80 FLAGS
LD A,(HL)  ;GET THE BIT TABLE CHAR.
POP HL  ;RESTORE THE TABLE ADDRESS
INC HL  ;POINT TO NEXT BIT VALUE
INC HL
CALL WR  ;MOVE CHAR TO C
LD A,E  ;RESTORE THE Z-80 FLAGS
DJNZ FZ1  ;DO ANOTHER?
CALL SPC  ;WRITE A SPACE
CALL SPC  ;AND ANOTHER
LD HL,RHL  ;Display "(HL)"
LD A,10  ;Via SVC #10
RST 28H  ;Do SVC
CALL SPC  ;WRITE A SPACE
CALL SPC  ;AND ANOTHER
LD HL,(RD+18) ;GET THE USER'S HL
LD A,(HL)  ;GET THE BYTE AT HL
CALL SHEX2  ;DISPLAY THE BYTE
LD HL,(HLBUF) ;GET TASMON'S CURSOR POSITION
LD (MNCR),HL ;RESTORE IT
POP DE  ;RESTORE DE
RET   ;RETURN
;
;THIS ROUTINE ALLOWS THE USER'S Z-80 REGISTERS TO
;BE MODIFIED.
;
MRG01:CALL WL  ;WRITE COMMAND CHAR. AND A SPACE.
;COMMAND CHAR. WILL BE AN "R" FOR THIS
;COMMAND.
MRA:CALL KYINP  ;GET A KEY
CP 'P'  ;IS IT A "P"?
JR Z,PCC1  ;JUMP IF SO
CP 'S'  ;IS IT AN "S"?
JR Z,SPC1  ;JUMP IF SO
CP 'I'  ;IS IT AN "I"?
JR Z,IRC1  ;JUMP IF SO
CP 'A'  ;IS IT AN "A"?
JR Z,AFC1  ;JUMP IF SO
CP 'B'  ;IS IT A "B"?
JR Z,BCC1  ;JUMP IF SO
CP 'D'  ;IS IT A "D"?
JR Z,DECH1  ;JUMP IF SO
CP 'H'  ;IS IT AN "H"?
JR NZ,MRA  ;JUMP IF NOT
CALL WR  ;DISPLAY THE "H"
LD B,18  ;SET THE REGISTER DATA POINTER
LD A,'L'  ;GET AN "L"
JR APS1  ;GO DISPLAY IT
PCC1:CALL WR  ;DISPLAY THE "P"
LD B,22  ;SET REGISTER DATA POINTER
LD A,'C'  ;GET A "C"
JR MRG2  ;GO DISPLAY IT
SPC1:CALL WR  ;DISPLAY THE "S"
LD B,20  ;SET REGISTER DATA POINTER
LD A,'P'  ;GET A "P"
JR MRG2  ;GO DISPLAY IT
IRC1:CALL WR  ;DISPLAY THE "I"
IRC2:CALL KYINP  ;GET A KEY
CP 'X'  ;IS IT AN "X"?
JR Z,IRC3  ;JUMP IF SO
CP 'Y'  ;IS IT A "Y"?
JR NZ,IRC2  ;JUMP IF NOT
LD B,2  ;SET REGISTER DATA POINTER
JR MRG2  ;GO DISPLAY THE "Y"
IRC3:LD B,0  ;SET REGISTER DATA POINTER
JR MRG2  ;GO DISPLAY THE "X"
AFC1:CALL WR  ;DISPLAY THE "A"
LD B,12  ;SET REGISTER DATA POINTER
LD A,'F'  ;GET AN "F"
JR APS1  ;GO DISPLAY IT
BCC1:CALL WR  ;DISPLAY THE "B"
LD B,14  ;SET REGISTER DATA POINTER
LD A,'C'  ;GET A "C"
JR APS1  ;GO DISPLAY IT
DECH1:CALL WR  ;DISPLAY THE "D"
LD B,16  ;SET REGISTER DATA POINTER
LD A,'E'  ;GET AN "E"
APS1:CALL WR  ;DISPLAY THE CHARACTER
APS2:CALL HXINP  ;GET A KEY.
;THE "Z" FLAG WILL BE SET IF
;THE INPUTTED CHARACTER WAS A HEX
;DIGIT (0-9, A-F).
JR Z,AP3  ;JUMP IF HEX
CP 39  ;"'"?
JR NZ,APS2  ;JUMP IF NOT
CALL WR  ;DISPLAY THE "'"
LD A,B  ;GET REGISTER DATA POINTER
SUB 8  ;POINT TO SECONDARY REGISTER DATA
LD B,A  ;RESTORE IT
LD A,20H  ;GET A SPACE CHARACTER
JR MRG2A  ;GO DISPLAY IT
AP3:PUSH AF  ;SAVE A
CALL SPC  ;WRITE A SPACE
POP AF  ;RESTORE A
PUSH BC  ;SAVE REGISTER DATA POINTER
CALL GTA  ;GET 3 MORE HEX DATA VALUES
JR MRG3  ;CONTINUE ON
MRG2:CALL WR  ;WRITE THE 2ND CHARACTER
LD A,20H  ;SET TO WRITE A SPACE
MRG2A:CALL WR  ;DISPLAY THE CHARACTER
PUSH BC  ;SAVE REGISTER DATA POINTER
CALL GETHEX  ;GET A 4 DIGIT HEX VALUE
MRG3:PUSH HL  ;SAVE THE 4 DIGIT VALUE
POP DE  ;GET NEW REGISTER VALUE
POP BC  ;GET REGISTER DATA POINTER
LD C,B  ;SET UP FOR 16 BIT ADDRESS
LD B,0
LD HL,RD  ;POINT TO REGISTER DATA
ADD HL,BC  ;POINT TO SPECIFIC REGISTER
LD (HL),E  ;SAVE THE NEW REGISTER VALUE
INC HL
LD (HL),D
JP DSPRG  ;DISPLAY THE REGISTERS
;
;THIS ROUTINE ALLOWS MEMORY TO BE MODIFIED WITH
;ASCII OR HEX KEYBOARD INPUTS.
;
MM01:CALL WL  ;WRITE AN "M" AND A SPACE
MM0A:CALL KYINP  ;GET A KEY
CP 'A'  ;IS IT AN "A"?
JR Z,M0B  ;JUMP IF SO
CP 'H'  ;IS IT AN "H"?
JR NZ,MM0A  ;JUMP IF NOT
CALL WR  ;DISPLAY THE "H"
XOR A  ;SET FLAG TO HEX MODE
JR M0C  ;GO SET IT
M0B:CALL WR  ;DISPLAY THE "A"
LD A,1  ;SET FLAG TO ASCII MODE
M0C:LD (FLG1),A ;SAVE THE ASCII/HEX FLAG
CALL SPC  ;WRITE A SPACE
CALL PCDEF  ;GET THE MODIFICATION ADDRESS.
;THE DEFAULT VALUE IS THE USER'S PC
JR MM10  ;SKIP THE ADDRESS DISPLAY
MM02:CALL REGHEX  ;DISPLAY THE MODIFICATION ADDRESS.
MM10:CALL SPC  ;WRITE A SPACE
LD A,(HL)  ;GET THE CURRENT BYTE
CP 20H  ;IS IT A CONTROL CODE?
JR C,M0D  ;JUMP IF SO
CP 7FH  ;IS IT GRAPHICS?
JR NC,M0D  ;JUMP IF SO
CALL WR  ;DISPLAY THE CHARACTER
CALL SPC  ;DISPLAY A SPACE
JR M0D10  ;CONTINUE ON
M0D:LD A,20H  ;DISPLAY A SPACE
CALL WR
CALL WR
M0D10:LD A,(HL)  ;GET THE BYTE AGAIN
CALL SHEX2  ;DISPLAY THE VALUE IN HEX
CALL SPC  ;DISPLAY A SPACE
MM03:CALL KYINP  ;GET A KEY
OR A  
JR Z,MM03  ;GET ANOTHER IF NO INPUT
CP 0AH  ;DOWN ARROW?
JR NZ,MM04  ;JUMP IF NOT
MM07:INC HL  ;INCREMENT MODIFICATION ADDRESS
MM06:PUSH HL  ;SAVE MOD. ADDRESS
CALL CKSCR  ;SCROLL THE SCREEN
POP HL  ;RESTORE THE MOD. ADDRESS
JR MM02  ;DISPLAY THE ADDRESS AND THE BYTE
MM04:CP 0BH  ;UP ARROW?
JR NZ,MM05  ;JUMP IF NOT
DEC HL  ;DECREMENT THE MOD. ADDRESS
JR MM06  ;JUMP TO SCROLL SCREEN STUFF
MM05:PUSH AF  ;SAVE KEY
LD A,(FLG1) ;GET ASCII/HEX FLAG
OR A  ;HEX INPUT?
JR Z,M0E  ;JUMP IF SO
POP AF  ;RESTORE THE KEY
CP 0DH  ;CARRIAGE RETURN?
JR Z,M0F  ;JUMP IF SO
CP 20H  ;CONTROL CODE?
JR C,MM03  ;GET ANOTHER CHAR. IF SO
CALL WR  ;DISPLAY THE CHARACTER
JR M0F  ;CONTINUE
M0E:POP AF  ;RESTORE THE KEY
CP '0'  ;IS IT HEX?
JR C,MM03  ;IF NOT GET ANOTHER
CP 'G'
JR NC,MM03  ;IF NOT GET ANOTHER
CP 'A'
JR NC,MM08  ;JUMP IF HEX
CP 3AH
JR C,MM08  ;JUMP IF HEX
JR MM03  ;GO GET ANOTHER CHARACTER
;(THIS ONE IS NOT HEX)
MM08:CALL WR  ;DISPLAY THE CHARACTER
CALL DISHEX  ;MAKE IT THE MSB
SLA A
SLA A
SLA A
SLA A
LD C,A  ;SAVE IN C
MM09:CALL HXINP  ;GET A KEY
JR NZ,MM09  ;GET ANOTHER IF NOT HEX
CALL WR  ;DISPLAY THE CHARACTER
CALL DISHEX  ;BREAK IT UP (0-15, NOT 0-9, A-F)
ADD A,C  ;ADD IN THE LSB
M0F:LD (HL),A  ;STORE THE NEW BYTE
PUSH HL  ;SAVE THE MOD. ADDRESS
CALL DSPRG  ;DISPLAY THE REGISTERS
POP HL  ;RESTORE THE MOD. ADDRESS
JR MM07  ;GO DO THE NEXT BYTE
;
;THIS ROUTINE TAKES AN ASCII VALUE "0-9" OR "A-F"
;AND MAKES IT A BINARY 0-15.
;
DISHEX:SUB '0'  ;MAKE IT BINARY
CP 0AH  ;WAS IT AN "A-F"?
RET C  ;RETURN IF NOT
SUB 7  ;SUBTRACT 7 MORE
RET
;
;THIS ROUTINE WRITES A CARRIAGE RETURN WITHOUT
;DESTROYING THE LINE BY BRINGING THE CURSOR TO THE
;BEGINNING OF THE LINE AND MOVING THE CURSOR DOWN
;ONE LINE.
;
CRRET:LD A,26  ;MOVE CURSOR TO BEGINNING
;:OF LINE
CALL WR
LD A,29  ;MOVE DOWN ONE LINE
JP WR
;
;THIS ROUTINE WILL INPUT A FOUR DIGIT HEX VALUE AND
;ECHO EACH LEGAL HEX INPUT TO THE SCREEN.  THE VALUE
;IS RETURNED IN THE HL REGISTER PAIR.
;
GETHEX:CALL HXINP  ;GET A KEY
JR NZ,GETHEX ;GET ANOTHER IF NOT HEX
GTA:CALL WR  ;DISPLAY IT
CALL DISHEX  ;MAKE IT BINARY
SLA A  ;MAKE IT THE MSB
SLA A
SLA A
SLA A
LD H,A  ;STORE IT IN H
GT1:CALL HXINP  ;GET THE 2ND CHARACTER
JR NZ,GT1  ;GET ANOTHER IF NOT HEX
CALL WR  ;DISPLAY IT
CALL DISHEX  ;MAKE IT BINARY
ADD A,H  ;MAKE IT THE LSB
LD H,A  ;STORE IN H
GT2:CALL HXINP  ;GET THE 3RD CHARACTER
JR NZ,GT2  ;GET ANOTHER IF NOT HEX
CALL WR  ;DISPLAY IT
CALL DISHEX  ;MAKE IT BINARY
SLA A  ;MAKE IT THE MSB
SLA A
SLA A
SLA A
LD L,A  ;STORE IN L
GT3:CALL HXINP  ;GET THE 4TH CHARACTER
JR NZ,GT3  ;GET ANOTHER IF NOT HEX
CALL WR  ;DISPLAY IT
CALL DISHEX  ;MAKE IT BINARY
ADD A,L  ;ADD TO THE MSB
LD L,A  ;STORE IT IN L
RET
;
;THIS ROUTINE WILL GET A KEYBOARD CHARACTER AND SET
;THE "Z" FLAG IF THE INPUT WAS A HEX DIGIT.  THE
;CHARACTER INPUT IS RETURNED IN THE "A" REGISTER.
;
HXINP:CALL KYINP  ;GET A KEY
CP 0  ;NONE INPUT?
JR Z,HXINP  ;GET ANOTHER IF SO
CP '0'  ;LESS THAN 0?
JR C,HX01  ;JUMP IF SO
CP 'G'  ;GREATER THAN "F"?
JR NC,HX01  ;JUMP IF SO
CP 3AH  ;HEX?
JR C,HX02  ;JUMP IF SO
CP 'A'  ;HEX?
JR NC,HX02  ;JUMP IF SO
HX01:OR A  ;CLEAR THE "Z" FLAG
RET
HX02:CP A  ;SET THE "Z" FLAG
RET
;
;THIS ROUTINE SETS AND DISPLAYS BREAKPOINTS
;
BRPNT:CALL WL  ;DISPLAY "B" AND A SPACE
BRA:CALL KYINP  ;GET A KEY
CP 0DH  ;CARRIAGE RETURN?
JR Z,BRDSP  ;JUMP TO DISPLAY IF SO
CP '1'  ;LEGAL BREAKPOINT NUMBER?
JR C,BRA  ;GET ANOTHER IF NOT
CP 3AH
JR NC,BRA
CALL WR  ;DISPLAY THE NUMBER
SUB 31H  ;MAKE IT BINARY
SLA A  ;MULTIPLY BY TWO
LD C,A  ;SAVE IN C
LD B,0
LD HL,BRTBL ;POINT TO BREAKPOINT ADDRESSES
ADD HL,BC  ;POINT TO SPECIFIC ONE
CALL SPC  ;WRITE A SPACE
PUSH HL  ;SAVE THE ADDRESS
CALL GETHEX  ;GET A NEW BREAKPOINT VALUE
PUSH HL  ;SAVE IT
POP DE  ;BREAKPOINT VALUE -> DE
POP HL  ;GET BREAKPOINT ADDRESS
LD (HL),E  ;SAVE NEW BREAKPOINT
INC HL
LD (HL),D
RET
;
;THIS ROUTINE DISPLAYS THE BREAKPOINTS
;
BRDSP:LD B,3  ;DO 3 ROWS
PUSH BC  ;SAVE ROW COUNT
CALL CKSCR  ;SCROLL THE SCREEN
LD HL,BRTBL ;POINT TO BREAKPOINT ADDRESSES
LD DE,CURN  ;POINT TO EXECUTION NUMBERS
LD (STDIS),HL ;SAVE ADDRESS
BRDA:LD B,3  ;DO 3 PER LINE
JR BRD01  ;SKIP THE SPACE
BRD01Z:CALL SPC  ;DISPLAY A SPACE
BRD01:CALL THEX  ;DISPLAY THE VALUE
CALL INCHL  ;POINT TO NEXT ONE
CALL SPC  ;DISPLAY A SPACE
LD A,(DE)  ;GET THE EXECUTION NUMBER
INC DE  ;POINT TO NEXT ONE
CALL SHEX2  ;DISPLAY IT
DJNZ BRD01Z  ;DO ANOTHER ON THIS ROW?
POP BC  ;GET THE ROW COUNTER
DEC B  ;DONE?
PUSH BC  ;SAVE THE ROW COUNTER
JR Z,BRDB  ;JUMP IF DONE
CALL CKSCR  ;SCROLL THE SCREEN
JR BRDA  ;GO DO ANOTHER ROW
BRDB:POP BC  ;CLEAR THE STACK
JP DSPRG  ;DISPLAY THE REGISTERS
;
;THIS ROUTINE CLEARS THE BREAKPOINTS
;
CBRPNT:CALL WL  ;DISPLAY A "C" AND A SPACE
CBA:CALL KYINP  ;GET A KEY
CP 0DH  ;CARRIAGE RETURN?
JR Z,CLALL  ;JUMP IF SO
CP '1'  ;LEGAL BREAKPOINT NUMBER?
JR C,CBA  ;GET ANOTHER IF NOT
CP 3AH
JR NC,CBA  ;GET ANOTHER IF NOT
CALL WR  ;DISPLAY THE NUMBER
SUB 31H  ;MAKE IT BINARY
SLA A  ;MULTIPLY BY TWO
LD C,A
LD B,0
LD HL,BRTBL ;POINT TO BREAKPOINT ADDRESSES
ADD HL,BC  ;POINT TO SPECIFIC BREAKPOINT
LD (HL),0  ;CLEAR IT
INC HL
LD (HL),0
RET
CLALL:LD HL,BRTBL ;POINT TO BREAKPOINT ADDRESSES
XOR A  ;BYTE TO SET
LD B,18  ;CLEAR 18 BYTES
CL01:LD (HL),A  ;SET A BYTE TO ZERO
INC HL  ;POINT TO NEXT ONE
DJNZ CL01  ;DO ANOTHER
RET
;
;THIS ROUTINE IS THE "GO" COMMAND
;
GCMD:CALL WL  ;DISPLAY A "G" AND A SPACE
GC0:CALL PCDEF  ;GET A GO ADDRESS 
;(PROGRAM COUNTER IS THE DEFAULT)
LD (RD+22),HL ;SAVE AS THE USER'S PC
GC1:CALL LBRP  ;LOAD THE BREAKPOINTS
CALL USRSTR  ;GO DO IT
CALL FBRP  ;FIX THE BREAKPOINTS
LD HL,(RD+22) ;GET THE USER'S PC
CALL TBRK  ;IS EXECUTION NUMBER ZERO?
JP Z,TFXZ  ;JUMP IF SO
CALL DSPRG  ;DISPLAY REGISTERS
;
;THREE INSTRUCTIONS MUST BE SINGLE-STEPPED AFTER A
;BREAK WITH THE GO COMMAND SO EXECUTION DOES NOT
;RESUME IN THE MIDDLE OF A BREAKPOINT.  IF ONE OF
;THE THREE SINGLE-STEPPED INSTRUCTIONS IS A BREAKPOINT,
;THEN THREE MORE MUST BE SINGLE-STEPPED.
;
FBTY:LD B,3  ;DO 3 INSTRUCTIONS
FBTZ:PUSH BC  ;SAVE THE COUNT
CALL BRCK  ;BREAK KEY PRESSED?
JP NZ,BREAK ;JUMP IF SO
CALL SNB  ;DO A SINGLE STEP
LD HL,(RD+22) ;GET THE USER'S PC
CALL TBRK  ;EXECUTION NUMBER ZERO?
POP BC  ;RESTORE THE COUNT
JP Z,TFXZ  ;IF NEW PROGRAM COUNTER
;IS A BREAKPOINT ADDRESS AND
;EXECUTION NUMBER = ZERO, HALT EXECUTION
JR C,FBTY  ;IF NEW PROGRAM COUNTER
;WAS A BREAKPOINT, SINGLE
;STEP THREE MORE INSTRUCTIONS
DJNZ FBTZ  ;DO ANOTHER SINGLE STEP
JR GC1  ;CONTINUE GOING
;
;THIS ROUTINE SAVES THE MEMORY AT THE BREAKPOINT
;ADDRESSES AND LOADS THE BREAKPOINTS
;
LBRP:LD B,9  ;NUMBER OF BREAKPOINTS
LD HL,BRTBL ;BREAKPOINT ADDRESSES
LD IX,VALTBL ;STORAGE SPACE FOR MEMORY
;AT THE BREAKPOINT ADDRESSES
GC2:LD E,(HL)  ;GET A BREAKPOINT ADDRESS
INC HL
LD D,(HL)
INC HL
LD A,(DE)  ;GET A BYTE AT THE ADDRESS
LD (IX+0),A ;SAVE IT
INC IX  ;POINT TO NEXT SAVE LOCATION
LD A,0CDH  ;PUT IT A "CALL" INSTRUCTION
LD (DE),A
INC DE  ;POINT TO NEXT ONE
LD A,(DE)  ;GET THE VALUE
LD (IX+0),A ;SAVE IT
INC IX
PUSH HL  ;SAVE THE BREAKPOINT ADDRESS
LD HL,RTN01 ;GET THE BREAKPOINT ADDRESS
LD A,L  ;PLACE LSB OF BREAKPOINT
LD (DE),A
INC DE  ;POINT TO NEXT ONE
LD A,(DE)  ;GET THE VALUE
LD (IX+0),A ;SAVE IT
INC IX
LD A,H  ;PLACE MSB OF BREAKPOINT
LD (DE),A
POP HL  ;RESTORE TABLE ADDRESS
DJNZ GC2  ;DO ANOTHER?
RET
;
;THIS ROUTINE WILL REPLACE THE BREAKPOINTS WITH
;THE MEMORY ORIGINALLY LOCATED AT THOSE BREAKPOINTS
;
FBRP:LD B,9  ;NUMBER OF BREAKPOINTS
LD HL,BRTBL ;POINT TO BREAKPOINT ADDRESSES
LD IX,VALTBL ;POINT TO STORED VALUES
GC3:LD E,(HL)  ;GET A BREAKPOINT ADDRESS
INC HL  ;AND PLACE IT IN DE
LD D,(HL)
INC HL
LD A,(IX+0) ;GET A SAVE BYTE
INC IX  ;POINT TO NEXT ONE
LD (DE),A  ;RESTORE IT
INC DE
LD A,(IX+0) ;GET THE NEXT ONE
INC IX
LD (DE),A  ;RESTORE IT
INC DE
LD A,(IX+0) ;GET THE 3RD ONE
INC IX
LD (DE),A  ;RESTORE IT
DJNZ GC3  ;DO ANOTHER?
RET
;
;THIS ROUTINE CALLS THE DISASSEMBLER AND DISPLAYS
;OUTPUT TO THE SCREEN
;
DSEM:CALL WL  ;DISPLAY A "D" AND A SPACE
CALL PCDEF  ;GET AN ADDRESS
PUSH HL  ;SAVE IT
CALL SCUR  ;SET TASMON'S CURSOR
CALL CLS  ;CLEAR THE SCREEN
POP HL  ;RESTORE THE ADDRESS
DI3:LD BC,23  ;NUMBER OF INSTRUCTIONS
LD A,1  ;TURN DISPLAY ON
DI1:CALL DISASS  ;GO DISASSEMBLE IT
LD HL,(STDIS) ;GET LOCATION OF NEXT ADDRESS
DI2:CALL KYINP  ;GET A KEY
CP 20H  ;SPACE?
JR Z,DI3  ;JUMP IF SO
CP '-'  ;"-"?
JR Z,RDISAS ;JUMP IF SO
CP 0AH  ;DOWN ARROW?
JR NZ,DI2  ;GET ANOTHER KEY IF NOT
LD BC,1  ;DO 1 INSTRUCTION
JR DI1  ;GO DISASSEMBLE IT
RDISAS:LD B,46  ;BACK UP 46 INSTRUCTIONS
RDIS01:PUSH BC  ;SAVE THE NUMBER
CALL BINS10  ;BACK UP ONE
POP BC  ;RESTORE THE NUMBER
DJNZ RDIS01  ;BACK UP AGAIN?
JR DI3  ;GO DISPLAY 23 INSTRUCTIONS
;
;THIS ROUTINE TOGGLES THE RESTART ("RST") STEPPING MODE.
;
JPRST:CALL WL  ;DISPAY A "J" AND A SPACE
LD A,(SKRST) ;GET THE TOGGLE BYTE
CPL   ;COMPLIMENT IT
AND 1  ;MASK OUT BIT 0
LD (SKRST),A ;SAVE IT AGAIN
OR A  ;RESTARTS IN FULL?
JR Z,JPRST1 ;JUMP IF SO
LD A,'I'  ;DISPLAY AN I
JP WR
JPRST1:LD A,92  ;DISPLAY A DOWN ARROW
JP WR



                                                                                                  