SZAP80 ; 	 SZAP80/ASM - Model 4
 ;	  80x24 mods for Superzap
 ;   For Northern Bytes & the Public Domain
 ;	     by Tony Domigan
 ; P.O. Box 150, Thomastown, Victoria, 3074, AUSTRALIA.
 ;	     MCI-ID 254-5121
 ;
 ;Instructions to create a dual version (64x16 and 80x24)
 ;   1. From DOS 'LOAD SUPERZAP/CMD'
 ;   2. From DOS 'LOAD SZAP80/CMD'
 ;   3. From DOS 'DUMP SUPERZAP/CMD 5200H,6FFFH,5300H'
 ;           To execute -
 ;    Enter 'SUPERZAP' for normal SUPERZAP
 ;    Enter 'SUPERZAP 4' for 80x24 SUPERZAP
 ;
 ;This patch has been tested with VIDEO4 & VID80x24
 ;------------------------------------------------------
 ;Throw-away code - placed in SUPERZAP buffer
 ;Checks for '4' and   executes patch if so.
 ;------------------------------------------------------
 	ORG	5300H		;SUPERZAP buffer
 CHECK	LD	A,(HL)		;'SUPERZAP 4<cr>' ?
 	CP	'4'		;80x24 patch?
 	JP	Z,START		;Yes, Execute Patch
 	JP	54C5H		;Exec Superzap
 START	LD	A,0C3H		;Place Jumps
 	LD	(56D6H),A
 	LD	(5DDBH),A
 	LD	(6015H),A
 	LD	(601EH),A
 	LD	(620BH),A
 	LD	A,0CDH		;Place Calls
 	LD	(56DBH),A
 	LD	(5FF3H),A
 	LD	(6035H),A
 	LD	(603EH),A
 	LD	(6150H),A
 	LD	A,80		;80 Columns
 	LD	(60FEH),A
 	LD	(5E10H),A
 	ADD	A,A		;2x80 Column Lines
 	LD	(60F7H),A
 	LD	HL,RTNE1	;Place Addresses
 	LD	(601FH),HL
 	LD	HL,RTNE2
 	LD	(5FF4H),HL
 	LD	HL,RTNE3
 	LD	(620CH),HL
 	LD	HL,RTNE4
 	LD	(6016H),HL
 	LD	HL,RTNE5
 	LD	(6036H),HL
 	LD	HL,RTNE6
 	LD	(603FH),HL
 	LD	HL,RTNE7
 	LD	(5DDCH),HL
 	LD	HL,RTNE8
 	LD	(6151H),HL
 	LD	HL,RTNE9
 	LD	(56DCH),HL
 	LD	HL,RTNE0
 	LD	(56D7H),HL
 	LD	HL,3D40H
 	LD	(60B6H),HL
 	LD	HL,3E80H
 	LD	(60DBH),HL
 	LD	HL,3FC0H
 	LD	(60E8H),HL
 	LD	HL,40B1H
 	LD	(60F1H),HL
 EXEC	JP	54C5H		;Start SUPERZAP
 ;--------------------------------------------------
 	ORG	6F20H		;Patch Area
 RTNE1	POP	HL
 	PUSH	DE
 	LD	DE,16		;+64=80 Columns
 	ADD	HL,DE		;New Pointer
 	EX	AF,AF'
 	POP	DE
 	DEC	A
 	JP	6021H
 RTNE2	PUSH	DE
 	LD	DE,0028H	;Offset to Ascii Side
 	ADD	HL,DE
 	POP	DE
 	RET
 RTNE3	CALL	LDHLA		;LD (HL),A
 	INC	HL
 	RET
 RTNE4	CALL	RTNE3		;LD (HL),A
 	EX	(SP),HL
 	JP	6018H
 RTNE5	PUSH	AF
 	LD	A,E
 	CALL	RTNE3		;LD (HL),A
 	LD	A,D
 	CALL	LDHLA		;LD (HL),A
 	POP	AF
 	RET
 RTNE6	LD	A,14H		;Page 1 of Video
 	OUT	(84H),A		;Select Page 1
 	LD	DE,3C00H	;Top of page
 	RET
 RTNE7	PUSH	DE
 	PUSH	BC
 	LD	DE,3C08H
 	ADD	HL,DE		;Mod/Find Posn
 	PUSH	HL
 	LD	DE,3C00H	;Start of Screen
 	SBC	HL,DE		;Displacement
 	LD	A,64		;Normal Columns
 	CALL	4C59H		;Calc Number of rows
 	PUSH	AF		;save remainder
 	LD	A,80		;New Columns
 	CALL	4C37H		;New Displacement
 	POP	AF		;Restore Old Rows
 	LD	E,A		;DE=Start+Remainder
 	LD	D,3CH
 	ADD	HL,DE		;80x24 Screen Pos
 	CALL	LDAHL		;LD A,(HL)
 	LD	C,A		;Save screen char
 PLACIT	LD	A,(5DE1H)	;Store Mod/Find Char
 	CALL	LDHLA		;LD (HL),A
 	XOR	A
 	CALL	5DECH		;KBSCAN
 	PUSH	AF
 	LD	A,C		;Restore screen char
 	CALL	LDHLA		;LD (HL),A
 	POP	AF
 	CALL	Z,5DECH
 	JR	Z,PLACIT	;No Key
 	POP	HL
 	POP	BC
 	POP	DE
 	JP	5DEBH
 RTNE8	CALL	LDAHL		;LD A,(HL)
 	CP	20H
 	RET
 RTNE9	LD	A,14H		;Select vid page 1
 	OUT	(84H),A
 	CALL	6214H
 	RET
 RTNE0	CALL	5DBCH		;Mod/Find Rtne
 	PUSH	AF
 	LD	A,14H		;Select vid page 1
 	OUT	(84H),A
 	POP	AF
 	JP	56DEH
 ;-----------------------------------------------------
 ; 	The following Routine was taken from 
 ;	VIDEO4 by Jack Decker (avail from TAS)
 ;-----------------------------------------------------
 ;
 LDAHL	PUSH	HL		;LD A,(HL) rtne
 	CALL	CONV
 	LD	A,(HL)
 	POP	HL
 	RET
 LDHLA	PUSH	HL		;LD (HL),A rtne
 	PUSH	AF
 	CALL	CONV
 	POP	AF
 	LD	(HL),A
 	POP	HL
 	RET
 CONV	LD	A,H		;Screen Ptr Conversion
 	AND	03H
 	OR	3CH
 	BIT	6,H		;Page 1
 	LD	H,A
 	LD	A,(FLAG)
 	SET	7,A		;Page 2
 	JR	NZ,LOWER
 	AND	7FH
 LOWER	LD	(FLAG),A	;Select Page
 	OUT	(84H),A
 	RET
 FLAG	DEFB	05H		;Video Mask
 	END
