	TITLE	'<SuperScripsit SR2000>'
	OPTION	+NE,+NM
	SPACE	1
;-------------------------------------------------------
; Printer Driver for SuperScripsit to support extended
; features of Sears SR2000 daisy wheel printer. (Diablo
; 630 compatible.) Supports all standard enhancement
; features of SuperScripsit, at 10, 12, or 15 pitch.
; Does not support proportional printing, and if the
; latter is selected, will instead use 10 pitch.
; However, proportional justification IS supported
; by incremental space characters.
;-------------------------------------------------------
; Scripsit Pro users please note: in theory, this
; driver will work with Scripsit Pro if you delete the
; semicolon at the beginning of the next line:
;SCRPRO	EQU	0FFH
; Please note, however, that this has not been tested.
;-------------------------------------------------------
; 	Gary Lee Phillips, [72425,354]
;	January 10, 1987  (Assembled with PRO-MRAS)
;-------------------------------------------------------
	SPACE	1
; First let's define some useful SVC codes:
@CTL	EQU	5	;@CTL SVC
@PRT	EQU	6	;@PRT SVC
@PRINT	EQU	14	;@PRINT SVC
@GTDCB	EQU	82	;@GTDCB SVC
	SPACE	1
; Now some handy self-documenting values:
ETX	EQU	03H	;ASCII End of TeXt
CR	EQU	0DH	;ASCII Carriage Return
BS	EQU	08H	;ASCII Back Space
ESC	EQU	1BH	;ASCII ESCape
	SPACE	1
SVC	MACRO	#CODE
	LD	A,#CODE
	RST	28H
	ENDM
;-------------------------------------------------------
	IFDEF	SCRPRO	;USE SCRIPSIT PRO VALUES
PRSTOP	EQU	5F96H	;TEST BREAK, PAUSE IF PRESSED
PRPAUS	EQU	5F93H	;PAUSE FOR Y/N KEY PRESS
PRTERR	EQU	5F90H	;PRINTER NOT READY HANDLER
	ASEG		;NOT REQUIRED BY SOME ASSEMBLERS
	ORG	5F9EH	;START OF DRIVER CODE
	ELSE		;USE SUPERSCRIPSIT VALUES
PRSTOP	EQU	0BABBH	;TEST BREAK, PAUSE IF PRESSED
PRPAUS	EQU	0BAB8H	;PAUSE FOR Y/N KEY PRESS
PRTERR	EQU	0BAB5H	;PRINTER NOT READY HANDLER
	ASEG		;NOT REQUIRED BY SOME ASSEMBLERS
	ORG	0BAD3H	;STANDARD START OF DRIVER CODE
	ENDIF
	SUBTTL	'Printer Driver'
SR2000	EQU	$	;BEGIN HERE
;-------------------------------------------------------
;Table of justification values for use by mainline
INCSIZ	DB	120	;UNITS PER INCH
PITCHO	DB	10	;AVG CHARS PER INCH
WIDTBL	EQU	$	;BEGIN TBL OF CHAR WIDTHS
	DC	96,12	;ALL CHARS SAME WIDTH
SENDLF	DB	0	;NULL FOR SUPPRESS LF AFTER CR
NULLCR	DB	0	;NUMBER OF NULLS AFTER CR
;-------------------------------------------------------
;Table of addresses (entry points) used by SuperScripsit
	JP	PRINIT	;INITIALIZE PRINTER
	JP	SETPCH	;SET PITCH
	JP	PRTCHR	;SEND CHAR TO PRINTER
	JP	PRTSPC	;INCREMENTAL SPACE
	JP	BACKSP	;BACKSPACE FOR PS
	JP	TOGFEA	;TOGGLE SPECIAL FEATURE
	JP	EXFEA	;EXECUTE FEATURE IF ON
	JP	HAFFOR	;FWD HALF LINEFEED
	JP	HAFREV	;BWD HALF LINEFEED
	JP	RDYTST	;TEST FOR PRINTER READY
	JP	SETTBL	;INIT CHAR WIDTH TBL
	DC	25,0	;RESERVE FUTURE VECTORS
	XOR	A	;BY TREATING AS NO-OP
	RET		;WITH SUCCESSFUL RETURN
ENDPTR	DW	DVREND	;PTR TO LAST BYTE OF CODE
PRDCB	DW	0	;SAVE DCB PTR HERE
FEFLGS	DB	0	;FLAGS FOR SPECIAL FUNCTIONS
FEFUL	EQU	40H	;VALUE FOR UNDERLINE ON
FEFST	EQU	20H	;VALUE FOR STRIKE-THRU ON
FEFDU	EQU	10H	;VALUE FOR DOUBLE UL ON
FEFBF	EQU	08H	;VALUE FOR BOLDFACE ON
FEFPS	EQU	80H	;PROPORTIONAL MODE SET
;-------------------------------------------------------
PRINIT	EQU	$	;INITIALIZE PRINTER HARDWARE
	PUSH	DE	;SAVE REGS
	PUSH	BC
	PUSH	HL
	XOR	A	;INIT FLAG BYTE
	LD	(FEFLGS),A
	LD	DE,5250H	;LITERAL 'PR'
	SVC	@GTDCB		;FIND DCB ADDRESS
	JR	NZ,PRINER	;ERROR
	LD	(PRDCB),HL	;SAVE PTR
	LD	HL,PRINCD	;POINT TO CODES
	SVC	@PRINT
	JR	Z,PRINEX
PRINER	SCF			;INDICATE ERROR
PRINEX	POP	HL
	POP	BC
	POP	DE
	RET		;AND RETURN TO SCRIPSIT
PRINCD	DB	ESC,8DH,'P',ETX	;RESET PRINTER
;-------------------------------------------------------
SETPCH	EQU	$	;SET PRINTER PITCH
	PUSH	AF
	CALL	SETTBL	;INIT CHAR WIDTHS
	POP	AF
	PUSH	DE	;SAVE ALL REGS
	PUSH	BC
	PUSH	HL
	PUSH	AF
	CP	0	;PROPORTIONAL MODE?
	LD	A,(FEFLGS)	;GET FLAG BYTE
	JR	NZ,SETNPS	;NOT PS
	OR	FEFPS		;SET PS BIT
	LD	(FEFLGS),A	;AND SAVE IT
	POP	AF	;BALANCE STACK
	LD	A,10
	JR	SET10	;TREAT AS PICA
SETNPS 	AND	255-FEFPS	;SET NON-PS
	LD	(FEFLGS),A
	POP	AF
	CP	15	;COMPRESSED MODE?
	JR	NZ,SET12
	LD	A,9
	JR	SETEXT
SET12	CP	12	;ELITE MODE?
	JR	NZ,SET10
	LD	A,11
	JR	SETEXT
SET10	CP	10	;PICA MODE?
	JR	NZ,SETPER
	LD	A,13
SETEXT	LD	(SETPCT),A
	LD	HL,SETPCM
	SVC	@PRINT
	JR	Z,SETEXT1 ;NO ERROR
SETPER	SCF		;INDICATE ERROR
SETEXT1	POP	HL
	POP	BC
	POP	DE	;REGS RESTORED
	RET		;AND RETURN TO SCRIPSIT
SETPCM	DB	ESC,1FH	;COMMAND TO SET PITCH
SETPCT	DB	13,ETX
;-------------------------------------------------------
BACKSP	EQU	$	;BACKSPACE PRINTER
	LD	A,BS	;FALL THROUGH TO PRTCHR
;-------------------------------------------------------
PRTCHR	EQU	$	;OUTPUT ONE CHAR TO PRINTER
	PUSH	DE	;SAVE REGS
	PUSH	BC
	PUSH	HL
	CALL	PRSTOP	;OK TO CONTINUE?
	JR	C,PRTCEX ;NO, ABORT REQUESTED
	LD	C,A	;BYTE TO BE OUTPUT
	SVC	@PRT	;@PRT IT
	JR	Z,PRTCEX
	SCF		;INDICATE ERROR
PRTCEX	POP	HL
	POP	BC
	POP	DE	;ALL REGS RESTORED
	RET		;BACK TO SCRIPSIT
;-------------------------------------------------------
PRTSPC	EQU	$	;OUTPUT SPACES TO PRINTER
	PUSH	DE	;SAVE REGS
	PUSH	BC
	PUSH	HL
	LD	A,C	;CHECK FOR NUMBER OF UNITS
	OR	A	;IS IT ZERO?
	JR	NZ,SPCIT
	LD	A,B
	OR	A
	JR	Z,SPNOP
SPCIT	LD	A,(WIDTBL+0)	;WIDTH OF SPACE
	LD	E,A
	LD	D,00H		;NOW IN DE
	LD	H,B	;MOVE COUNT TO HL
	LD	L,C
SPCLP	SBC	HL,DE	;SUBTRACT ONE SPACE
	JR	C,SPCPS	;DO ODD-SIZE SPACE
	PUSH	AF	;SAVE FLAGS
	LD	A,' '	;PRINT A SPACE
	CALL	PRTCHR
	POP	AF	;RESTORE FLAGS
	JR	NZ,SPCLP ;STILL POSITIVE, DO AGAIN
	JR	SPNOP	;DONE
SPCPS	ADD	HL,DE	;RESTORE EXCESS (PS)
	LD	A,L	;NBR OF UNITS TO MOVE
	INC	A
	OR	80H	;SET BIT (MASK CR,ETX)
	LD	(SPCCNT),A
	LD	HL,SPCCMD
	SVC	@PRINT	;DO ODD-LENGTH SPACE
	JR	NZ,SPERR
	LD	A,(WIDTBL+0)
	INC	A	;RESTORE NORMAL PITCH
	OR	80H	;SET BIT (MASK CR,ETX)
	LD	(SETPCT),A
	LD	HL,SETPCM
	SVC	@PRINT	;RESET PITCH
	JR	Z,SPNOP
SPERR	SCF		;INDICATE ERROR
SPNOP	POP	HL
	POP	BC
	POP	DE	;ALL REGS RESTORED
	RET		;BACK TO SCRIPSIT
SPCCMD	DB	ESC,1FH ;CMD FOR PS SPACE
SPCCNT	DB	8DH,20H,ETX
;-------------------------------------------------------
TOGFEA	EQU	$	;TOGGLE SPECIAL FEATURE
	PUSH	DE	;SAVE REGS
	PUSH	BC
	PUSH	HL
	LD	HL,TOGNOP
	CP	'='	;DBL UNDERSCORE?
	JR	NZ,TOGST
	LD	D,FEFDU
	JR	TOGTST
TOGST	CP	'/'	;STRIKE-THROUGH?
	JR	NZ,TOGUL
	LD	D,FEFST
	JR	TOGTST
TOGUL	CP	'-'	;SGL UNDERSCORE?
	JR	NZ,TOGBF
	LD	D,FEFUL
	LD	HL,TOGULY
	JR	TOGTST
TOGBF	CP	'+'	;BOLD FACE?
	JR	NZ,TOGST
	LD	D,FEFBF
	LD	HL,TOGBFY
TOGTST	LD	A,(FEFLGS)	;GET FLAGS
	LD	E,A		;AND SAVE
	AND	D		;TEST BIT
	JR	Z,TOGEXT	;OFF SO FLIP ON
	LD	A,0FFH		;WAS ON SO
	SUB	D		;FLIP OFF
	AND	E
	LD	E,A		;SAVE VALUE
	LD	D,0		;AND ZERO MASK
	INC	HL		;BUMP TO CODE
	INC	HL		;FOR SWITCH OFF
	INC	HL
TOGEXT	PUSH	DE
	SVC	@PRINT	;SEND CODE IF ANY
	POP	DE
	LD	A,E		;GET FLAG BYTE
	OR	D		;AND MASK IT
	LD	(FEFLGS),A
	POP	HL
	POP	BC
	POP	DE
	XOR	A	;SET ZERO FLAG
	RET		;BACK TO SCRIPSIT
TOGNOP	DB	ETX,0,0		;DO NOTHING CODE
	DB	ETX,0,0		;DITTO
TOGULY	DB	ESC,'E',ETX	;SET UNDERSCORE ON
	DB	ESC,'R',ETX	;SET UNDERSCORE OFF
TOGBFY	DB	ESC,'W',ETX	;SET BOLDFACE ON
	DB	ESC,'&',ETX	;SET BOLDFACE OFF
;-------------------------------------------------------
EXFEA	EQU	$	;EXECUTE SPECIAL FEATURE
	PUSH	HL
	PUSH	BC
	PUSH	DE
	CP	'/'	;STRIKE-THRU?
	JR	NZ,EXFEDU
	LD	HL,STCODE
	JR	EXFEXT
STCODE	DB	ESC,'D',BS,'_',ESC,'U',ETX
EXFEXT	SVC	@PRINT
	JR	Z,EXFEOK
	SCF		;INDICATE ERROR
EXFEOK	POP	DE
	POP	BC
	POP	HL
	RET		;BACK TO SCRIPSIT
EXFEDU	EQU	$
	CP	'='	;DBL UNDERSCORE?
	JR	Z,EXFEDU1
	XOR	A
	JR	EXFEOK
EXFEDU1	LD	HL,DUCODE
	JR	EXFEXT
DUCODE	DB	ESC,'U',BS,'=',ESC,'D',ETX
;-------------------------------------------------------
HAFFOR	EQU	$	;FORWARD HALF LF
	PUSH	BC
	PUSH	HL
	PUSH	DE
	LD	HL,HAFLF
HAFEXT	SVC	@PRINT
	JR	Z,HAFEOK
	SCF		;INDICATE ERROR
HAFEOK	POP	DE
	POP	HL
	POP	BC
	RET		;BACK TO SCRIPSIT
HAFLF	DB	ESC,'U',ETX	;HALF LF FWD
;-------------------------------------------------------
HAFREV	EQU	$	;BACK HALF LF
	PUSH	BC	;SAVE REGS
	PUSH	HL
	PUSH	DE
	LD	HL,HAFRF
	JR	HAFEXT
HAFRF	DB	ESC,'D',ETX	;HALF LF FWD
;-------------------------------------------------------
RDYTST	EQU	$	;TEST FOR PRINTER READY
	PUSH	DE	;SAVE REGS
	PUSH	BC
	PUSH	HL
	LD	DE,(PRDCB)	;GET *PR PTR
	LD	C,0	;STATUS OPTION
	SVC	@CTL	;DO @CTL
	JR	Z,RDYEXT
	SCF		;INDICATE ERROR
RDYEXT	POP	HL
	POP	BC
	POP	DE	;ALL REGS RESTORED
	RET		;BACK TO SCRIPSIT
;-------------------------------------------------------
SETTBL	EQU	$	;INIT CHARACTER WIDTH TABLE
	PUSH	DE	;SAVE REGS
	PUSH	BC
	PUSH	HL
	CP	0	;PS REQUEST?
	JR	NZ,SETFIX
	LD	A,10	;TREAT PS AS 10
SETFIX	EQU	$	;SET FIXED SPACING MODE
	LD	(PITCHO),A	;SET PITCH
	CP	15
	JR	NZ,SETF12
	LD	A,8
	JR	SETLP1
SETF12	CP	12
	JR	NZ,SETF10
	LD	A,10
	JR	SETLP1
SETF10	CP	10
	LD	A,12
	JR	Z,SETLP1
	SCF		;INVALID PITCH
	JR	SETTEX	;RETURN WITH ERROR
SETLP1	LD	B,96	;NO OF BYTES TO INIT
	LD	HL,WIDTBL	;DESTINATION
SETLP2	LD	(HL),A	;FILL IN TABLE
	INC	HL	;BUMP PTR
	DJNZ	SETLP2	;REPEAT TILL DONE
SETTEX	POP	HL
	POP	BC
	POP	DE
	RET		;BACK TO SCRIPSIT
;-------------------------------------------------------
DVREND	EQU	$	;END OF PRINT DRIVER
	END	SR2000

