10 OPTION BASE 1
20 CLS:PRINT CHR$(15);
30 REM Starfinder ON DISPLAY, Version 2.0
40 REM By:  Melvin O. Duke.  Last Updated 18 July 1985.
50 REM Dimension statements go here
60 DIM SN$(246),CN$(246),MA(246),OP(246,4),RP(1,4),TF(4,4),T1(4,4),T2(4,4)
70 DIM CON$(246),RA(2),DE(2)
80 TITLE$="Starfinder ON DISPLAY"
90 TITLE.POS=40-INT(LEN(TITLE$)/2)
100 CLS
110 REM draw the title display
120 R1=3:C1=TITLE.POS-2:R2=6:C2=TITLE.POS+LEN(TITLE$)+1:GOSUB 190
130 PRINT@(3,(TITLE.POS)-1),TITLE$;
140 PRINT@(4,34),"Version 2.0";
150 R1=13:C1=28:R2=16:C2=52:GOSUB 190
160 PRINT@(13,32),"      by      ";
170 PRINT@(14,32),"Melvin O. Duke";
180 GOTO 330
190 REM subroutine to print a single box
200 FOR I=R1+1 TO R2-1
210 PRINT@((I)-1,(C1)-1),CHR$(149);
220 PRINT@((I)-1,(C2)-1),CHR$(170);
230 NEXT I
240 FOR J=C1+1 TO C2-1
250 PRINT@((R1)-1,(J)-1),CHR$(131);
260 PRINT@((R2)-1,(J)-1),CHR$(176);
270 NEXT J
280 PRINT@((R1)-1,(C1)-1),CHR$(151);
290 PRINT@((R1)-1,(C2)-1),CHR$(171);
300 PRINT@((R2)-1,(C1)-1),CHR$(181);
310 PRINT@((R2)-1,(C2)-1),CHR$(186);
320 RETURN
330 REM ask user to press a key to continue
340 PRINT@(23,0),"";
350 PRINT "Press any key to continue";
360 K$=INKEY$:IF K$="" THEN 360
370 CLS
380 REM General Description
390 CLS:PRINT@(9,0),"";
400 PRINT "This program permits you to view the stars in any portion of"
410 PRINT "the sky, and to change that view according to your commands."
420 PRINT
430 PRINT "The program contains all of the stars whose visual magnitude"
440 PRINT "is 3.50 or brighter.  They are plotted according to the"
450 PRINT "following:"
460 PRINT
470 PRINT "          "+CHR$(64);
480 :PRINT "  Visual Magnitude of 0.99 or brighter."
490 PRINT "          "+CHR$(42);
500 :PRINT "  Visual Magnitude of 1.99 or brighter."
510 PRINT "          ";:PRINT CHR$(43);
520 :PRINT "  Visual Magnitude of 2.99 or brighter."
530 PRINT "          ";:PRINT CHR$(46);
540 :PRINT "  All other stars."
550 PRINT
560 PRINT@(23,0),"Press any key to continue";
570 A$=INKEY$:IF A$="" THEN 570
580 UM=10
590 REM Read the data, convert it, and plot it.
600 OPEN"I",1,"STARFIND/DAT":CLS:R=0
610 PI=3.141592653589796#
620 R=R+1:I=R
630 INPUT #1, MA(I),CON$(I),SN$(I),CN$(I),RA(1),RA(2),DE(1),DE(2)
640 IF MA(I)>UM THEN 830
650 IF SN$(I)="eof" THEN CLOSE #1:GOTO 830
660 REM Compute the x, y, and z coordinates on a unit sphere
670 OP(I,1)=1
680 D=DE(2)/60
690 IF DE(1)<0 THEN D1=DE(1)-D ELSE D1=DE(1)+D
700 D2=(D1*2*PI)/360
710 OP(I,4)=SIN(D2) 'z coordinate
720 XY=COS(D2)
730 R1=RA(1)+(RA(2)/60)
740 R2=(R1*2*PI)/24 'convert to radians
750 OP(I,2)=XY*COS(R2) 'x coordinate
760 OP(I,3)=XY*SIN(R2) 'y coordinate
770 XTOPLOT=OP(I,2)
780 YTOPLOT=OP(I,3)
790 ZTOPLOT=OP(I,4)
800 GOSUB 3320 'plotting subprogram
810 REM Now obtain the next data item
820 GOTO 620
830 REM End of data
840 R=R-1
850 PRINT@(23,0),"";
860 PRINT "Press any key to continue";
870 A$=INKEY$:IF A$="" THEN 870
880 REM Determine the next user action
890 CLS
900 PRINT "The following actions are available:"
910 PRINT
920 :PRINT "   1.  Find a Star by its Common Name."
930 PRINT "   2.  Find a Star by its Scientific Name."
940 PRINT "   3.  Find a Constellation by its Name."
950 :PRINT "   4.  Print the Common Names of the Stars."
960 PRINT "   5.  Print the Scientific Names of the Stars."
970 :PRINT "   6.  Move the stars farther apart."
980 PRINT "   7.  Move the stars closer together."
990 :PRINT "   8.  Move the stars to the left."
1000 PRINT "   9.  Move the stars to the right."
1010 PRINT "  10.  Move the stars up."
1020 PRINT "  11.  Move the stars down."
1030 PRINT "  12.  Rotate the stars clockwise."
1040 PRINT "  13.  Rotate the stars counter-clockwise."
1050 PRINT "  14.  Quit."
1060 PRINT
1070 PRINT "What action would you like to take?"
1080 INPUT "Enter a number between 1 and 14.";AC
1090 AC=INT(AC)
1100 IF AC=8 THEN 1260 'Shift the stars to the left
1110 IF AC=9 THEN 1400 'Shift the stars to the right
1120 IF AC=10 THEN 1540 'Move the stars up
1130 IF AC=11 THEN 1680 'Move the stars down
1140 IF AC=12 THEN 1820 'Move the stars clockwise
1150 IF AC=13 THEN 1960 'Move the stars counter-clockwise
1160 IF AC=6 THEN 2100 'Expand the stars
1170 IF AC=7 THEN 2210 'Shrink the stars
1180 IF AC=4 THEN REPLY=1:GOTO 2320
1190 IF AC=5 THEN REPLY=2:GOTO 2320
1200 IF AC=1 THEN 3030 'To locate a star by its common name
1210 IF AC=3 THEN 2440 'To locate a constellation
1220 IF AC=2 THEN 3210 'To locate a star by its scientific name
1230 IF AC=14 THEN 2400 'To quit
1240 PRINT "The number must be between 1 and 14."
1250 GOTO 1070
1260 REM Routine to shift the stars to the left
1270 CLS
1280 PRINT@(22,0),"";
1290 INPUT "How many degrees to the left"; REPLY
1300 IF REPLY<0 OR REPLY>360 THEN PRINT "Number must be 0 to 360":GOTO 1290
1310 REM Convert the input-reply to radian measure
1320 THETA=(REPLY*2*PI)/360
1330 GOSUB 3490 ' for the identity array
1340 REM Construct the transform array
1350 TF(2,2)=COS(THETA)
1360 TF(3,3)=TF(2,2)
1370 TF(2,3)=SIN(THETA)
1380 TF(3,2)=-TF(2,3)
1390 GOTO 3560 'for matrix multiply
1400 REM Routine to shift the stars to the right
1410 CLS
1420 PRINT@(22,0),"";
1430 INPUT "How many degrees to the right"; REPLY
1440 IF REPLY<0 OR REPLY>360 THEN PRINT "Number must be 0 to 360":GOTO 1430
1450 REM Convert the input-reply to radian measure
1460 THETA=(REPLY*2*PI)/360
1470 GOSUB 3490 ' for the identity array
1480 REM Construct the transform array
1490 TF(2,2)=COS(THETA)
1500 TF(3,3)=TF(2,2)
1510 TF(2,3)=-SIN(THETA)
1520 TF(3,2)=-TF(2,3)
1530 GOTO 3560 'for matrix multiply
1540 REM Routine to move the stars up
1550 CLS
1560 PRINT@(22,0),"";
1570 INPUT "How many degrees up"; REPLY
1580 IF REPLY<0 OR REPLY>360 THEN PRINT "Number must be 0 to 360":GOTO 1570
1590 REM Convert the input-reply to radian measure
1600 THETA=(REPLY*2*PI)/360
1610 GOSUB 3490 ' for the identity array
1620 REM Construct the transform array
1630 TF(3,3)=COS(THETA)
1640 TF(4,4)=TF(3,3)
1650 TF(3,4)=SIN(THETA)
1660 TF(4,3)=-TF(3,4)
1670 GOTO 3560 'for matrix multiply
1680 REM Routine to move the stars down
1690 CLS
1700 PRINT@(22,0),"";
1710 INPUT "How many degrees down"; REPLY
1720 IF REPLY<0 OR REPLY>360 THEN PRINT "Number must be 0 to 360":GOTO 1710
1730 REM Convert the input-reply to radian measure
1740 THETA=(REPLY*2*PI)/360
1750 GOSUB 3490 ' for the identity array
1760 REM Construct the transform array
1770 TF(3,3)=COS(THETA)
1780 TF(4,4)=TF(3,3)
1790 TF(3,4)=-SIN(THETA)
1800 TF(4,3)=-TF(3,4)
1810 GOTO 3560 'for matrix multiply
1820 REM Routine to move the stars clockwise
1830 CLS
1840 PRINT@(22,0),"";
1850 INPUT "How many degrees clockwise"; REPLY
1860 IF REPLY<0 OR REPLY>360 THEN PRINT "Number must be 0 to 360":GOTO 1850
1870 REM Convert the input-reply to radian measure
1880 THETA=(REPLY*2*PI)/360
1890 GOSUB 3490 ' for the identity array
1900 REM Construct the transform array
1910 TF(2,2)=COS(THETA)
1920 TF(4,4)=TF(2,2)
1930 TF(2,4)=-SIN(THETA)
1940 TF(4,2)=-TF(2,4)
1950 GOTO 3560 'for matrix multiply
1960 REM Routine to move the stars counter-clockwise
1970 CLS
1980 PRINT@(22,0),"";
1990 INPUT "How many degrees counter-clockwise"; REPLY
2000 IF REPLY<0 OR REPLY>360 THEN PRINT "Number must be 0 to 360":GOTO 1990
2010 REM Convert the input-reply to radian measure
2020 THETA=(REPLY*2*PI)/360
2030 GOSUB 3490 ' for the identity array
2040 REM Construct the transform array
2050 TF(2,2)=COS(THETA)
2060 TF(4,4)=TF(2,2)
2070 TF(2,4)=SIN(THETA)
2080 TF(4,2)=-TF(2,4)
2090 GOTO 3560 'for matrix multiply
2100 REM Routine to move the stars farther apart.
2110 CLS
2120 PRINT@(22,0),"";
2130 INPUT "Enter a factor between 1 and 10"; REPLY
2140 IF REPLY<1 OR REPLY>10 THEN PRINT "Number must be 1 to 10":GOTO 2130
2150 GOSUB 3490 ' for the identity array
2160 REM Construct the transform array
2170 TF(2,2)=REPLY
2180 TF(3,3)=REPLY
2190 TF(4,4)=REPLY
2200 GOTO 3560 'for matrix multiply
2210 REM Routine to move the stars closer together.
2220 CLS
2230 PRINT@(22,0),"";
2240 INPUT "Enter a factor between .1 and 1"; REPLY
2250 IF REPLY<.1 OR REPLY>1! THEN PRINT "Number must be .1 to 1":GOTO 2240
2260 GOSUB 3490 ' for the identity array
2270 REM Construct the transform array
2280 TF(2,2)=REPLY
2290 TF(3,3)=REPLY
2300 TF(4,4)=REPLY
2310 GOTO 3560 'for matrix multiply
2320 REM Routine to name the stars.
2330 CLS
2340 GOSUB 3490 ' for the identity array
2350 REM Construct the transform array
2360 TF(2,2)=1
2370 TF(3,3)=1
2380 TF(4,4)=1
2390 GOTO 3560 'for matrix multiply
2400 REM Routine to quit
2410 CLS:PRINT@(17,0),"";
2420 PRINT "Program finished."
2430 GOTO 3990
2440 REM Routine to locate a Constellation
2450 CLS:RC=1
2460 PRINT@(22,0),SPACE$(79);
2470 PRINT@(22,0),"";:INPUT "Enter the name of a Constellation"; FIND.CONS$
2480 GOSUB 3140 'To make sure that the first letter is capitalized
2490 REM search for the constellation
2500 FOR K=1 TO R
2510 IF LEFT$(SN$(K),5)="Alpha" AND LEFT$(CON$(K),LEN(FIND.CONS$))=FIND.CONS$ THEN GOSUB 2550
2520 NEXT K
2530 IF RC=1 THEN PRINT@(21,0),"Unable to locate the constellation as named.":GOTO 2460
2540 GOTO 3560 'For matrix multiply
2550 REM found the star or constellation
2560 REM construct the first transform
2570 GOSUB 3490 'For the identity matrix
2580 IF OP(K,2)>0 AND OP(K,3)=0 THEN ALPHA=PI/2:GOTO 2640
2590 IF OP(K,2)<0 AND OP(K,3)=0 THEN ALPHA=(3*PI)/2:GOTO 2640
2600 ALPHA=ATN(ABS(OP(K,2)/OP(K,3)))
2610 IF OP(K,2)<0 AND OP(K,3)<0 THEN ALPHA=ALPHA+PI
2620 IF OP(K,2)<0 AND OP(K,3)>0 THEN ALPHA=2*PI-ALPHA
2630 IF OP(K,2)>0 AND OP(K,3)<0 THEN ALPHA=PI-ALPHA
2640 TF(2,2)=COS(ALPHA)
2650 TF(3,3)=TF(2,2)
2660 TF(2,3)=SIN(ALPHA)
2670 TF(3,2)=-TF(2,3)
2680 REM move to first transform
2690 FOR I=1 TO 4
2700 FOR J=1 TO 4
2710 T1(I,J)=TF(I,J)
2720 NEXT J
2730 NEXT I
2740 REM now construct the second transform
2750 GOSUB 3490 'for the identity matrix
2760 IF OP(K,4)>0 AND OP(K,3)=0 THEN BETA=PI/2:GOTO 2800
2770 IF OP(K,4)<0 AND OP(K,3)=0 THEN BETA=(3*PI)/2:GOTO 2800
2780 BETA=ATN(ABS(OP(K,4)/(SQR((OP(K,2)^2)+OP(K,3)^2))))
2790 IF OP(K,4)<0 THEN BETA=2*PI-BETA
2800 TF(3,3)=COS(BETA)
2810 TF(4,4)=TF(3,3)
2820 TF(3,4)=-SIN(BETA)
2830 TF(4,3)=-TF(3,4)
2840 REM move to second transform
2850 FOR I=1 TO 4
2860 FOR J=1 TO 4
2870 T2(I,J)=TF(I,J)
2880 NEXT J
2890 NEXT I
2900 REM now construct the real transform
2910 FOR I=1 TO 4
2920 FOR J=1 TO 4
2930 T=0
2940 FOR L=1 TO 4
2950 T=T+T1(I,L)*T2(L,J)
2960 NEXT L
2970 TF(I,J)=T
2980 NEXT J
2990 NEXT I
3000 REM now ready to plot the located star or constellation.
3010 RC=0:K=R
3020 RETURN
3030 REM Routine to locate a Star by its common name
3040 CLS:RC=1
3050 PRINT@(22,0),SPACE$(79);
3060 PRINT@(22,0),"";:INPUT "Enter the name of a Star"; FIND.STAR$
3070 GOSUB 3140 'To make sure that the first letter is capitalized
3080 REM search for the star
3090 FOR K=1 TO R
3100 IF LEFT$(CN$(K),LEN(FIND.STAR$))=FIND.STAR$ THEN GOSUB 2550
3110 NEXT K
3120 IF RC=1 THEN PRINT@(21,0),"Unable to locate the star as named.":GOTO 3050
3130 GOTO 3560 'For matrix multiply
3140 REM Routine to capitalize the first letter of the star or constellation
3150 IF AC=3 THEN 3190 'For a Constellation
3160 IF MID$(FIND.STAR$,2,1)=" " THEN 3180
3170 IF ASC(MID$(FIND.STAR$,1,1))>96 AND ASC(MID$(FIND.STAR$,1,1))<123 THEN MID$(FIND.STAR$,1,1)=RIGHT$(CHR$(ASC(MID$(FIND.STAR$,1,1))-32),1)
3180 GOTO 3200
3190 IF ASC(MID$(FIND.CONS$,1,1))>96 AND ASC(MID$(FIND.CONS$,1,1))<123 THEN MID$(FIND.CONS$,1,1)=RIGHT$(CHR$(ASC(MID$(FIND.CONS$,1,1))-32),1)
3200 RETURN
3210 REM Routine to locate a Star by its Scientific name
3220 CLS:RC=1
3230 PRINT@(22,0),SPACE$(79);
3240 PRINT@(22,0),"";:INPUT "Enter the name of a Star"; FIND.STAR$
3250 GOSUB 3140 'To make sure that the first letter is capitalized
3260 REM search for the star
3270 FOR K=1 TO R
3280 IF LEFT$(SN$(K),LEN(FIND.STAR$))=FIND.STAR$ THEN GOSUB 2550
3290 NEXT K
3300 IF RC=1 THEN PRINT@(21,0),"Unable to locate the star as named.":GOTO 3230
3310 GOTO 3560 'For matrix multiply
3320 REM Plotting subprogram
3330 IF XTOPLOT>.32 OR XTOPLOT<-.32 THEN 3480
3340 IF YTOPLOT<0 THEN 3480
3350 IF ZTOPLOT>.2 OR ZTOPLOT<-.2 THEN 3480
3360 REM Calculate the position
3370 XP=40+INT(39*(XTOPLOT/.32))
3380 ZP=24-(12+INT(11*(ZTOPLOT/.2)))
3390 PRINT @(23,0),CHR$(30);CHR$(16);:IF AC=3 THEN PRINT "Constellation: ";CN$(I); ELSE IF AC=2 THEN PRINT "Star: ";SN$(I); ELSE PRINT "Star: ";SN$(I);CHR$(17);
3400 PRINT@((ZP)-1,(XP)-1),"";
3410 REM Determine the character to plot
3420 STAR$=CHR$(64) ' @
3430 IF MA(I)>.9899999# THEN STAR$=CHR$(42) ' *
3440 IF MA(I)>1.99 THEN STAR$=CHR$(43) '+
3450 IF MA(I)>2.99 THEN STAR$=CHR$(46)' . (blinking)
3460 'Z1%=(ZP)-1:Z2%=(XP)-1:Z3%=0:IF Z3%<> 32 THEN GOTO 4090
3470 PRINT STAR$;
3480 RETURN
3490 REM Routine to produce an identity matrix
3500 FOR I=1 TO 4
3510 FOR J=1 TO 4
3520 IF I=J THEN TF(I,J)=1 ELSE TF(I,J)=0
3530 NEXT J
3540 NEXT I
3550 RETURN
3560 REM Routine to transform the array
3570 CLS
3580 FOR I=1 TO R
3590 FOR J=2 TO 4
3600 T=0
3610 FOR K=1 TO 4
3620 T=T+OP(I,K)*TF(K,J)
3630 NEXT K
3640 RP(1,J)=T
3650 NEXT J
3660 REM Now plot the new point
3670 XTOPLOT=RP(1,2)
3680 YTOPLOT=RP(1,3)
3690 ZTOPLOT=RP(1,4)
3700 GOSUB 3320 'plotting subprogram
3710 REM See if the name is wanted
3720 IF AC<4 OR AC>5 THEN 3910
3730 IF XTOPLOT>.32 OR XTOPLOT<-.32 THEN 3910
3740 IF YTOPLOT<0 THEN 3910
3750 IF ZTOPLOT>.2 OR ZTOPLOT<-.2 THEN 3910
3760 IF MA(I)>UM THEN 3910
3770 IF REPLY=1 THEN PART.NAME$=CN$(I)
3780 IF REPLY=2 THEN PART.NAME$=SN$(I)
3790 XP=XP+1 'star just plotted
3800 IF XP>79 THEN 3910
3810 REM print a character at a time
3820 FOR PPP=1 TO LEN(PART.NAME$)
3830 REM test for something there
3840 Z1%=(ZP)-1:Z2%=(XP)-1:Z3%=0:SCREEN!=FNPTS!(VARPTR(SCREEN$)):CALL SCREEN!(Z1%,Z2%,Z3%):IF Z3%<> 32 THEN 3880 'skip if present
3850 :
3860 PRINT@((ZP)-1,(XP)-1),MID$(PART.NAME$,PPP,1);
3870 :PRINT CHR$(17);
3880 XP=XP+1
3890 IF XP>79 THEN PPP=LEN(PART.NAME$)
3900 NEXT PPP
3910 REM Copy the transformed point back to the original point
3920 FOR J=2 TO 4
3930 OP(I,J)=RP(1,J)
3940 NEXT J
3950 NEXT I
3960 REM Back to next user action
3970 GOTO 850
3980 '
3990 END
