; VDCTL/OBJ -- @VDCTL interface for Model 4 BASIC -- 02/26/84
;
@VDCTL		EQU	15
		ORG	0F400H
SET		CALL	CALCADDR	; Get video pos & bit addresses
		LD	A,@VDCTL	; Get video character
		PUSH	BC		; BC altered by @VDCTL
		LD	B,1
		RST	40		; Video character now in A
		POP	BC		; Restore C
		PUSH	HL		; Save row,column
		CP	128		; If A<128 or >191, make it 128
		JR	C,FORCE128
		CP	192
		JR	NC,FORCE128
		JR	VALID
FORCE128	LD	A,128
VALID		LD	HL,SETMASK	; Point to start of table
		ADD	HL,BC		; Index to desired mask
		OR	(HL)		; Set pixel
		LD	C,A		; Put the character back
		LD	A,@VDCTL
		LD	B,2
		POP	HL		; Restore row,column
		RST	40
		RET			; Back to BASIC
;******************************************************************************
RESET		CALL	CALCADDR	; Get byte and bit addresses
		LD	A,@VDCTL	; Get video character
		PUSH	BC		; BC is altered by @VDCTL
		LD	B,1
		RST	40
		POP	BC		; Restore C
		PUSH	HL		; Save row,column
		CP	128		; If A<128 or >191, make it 128
		JR	C,PUT128	;  and skip the reset
		CP	192
		JR	NC,PUT128
		LD	HL,RESETMASK	; Point to start of table
		ADD	HL,BC		; Index to desired mask
		AND	(HL)		; Reset pixel
PUTBYTE		LD	C,A		; Put the character back
		LD	A,@VDCTL
		LD	B,2
		POP	HL		; Restore row,column
		RST	40
		RET			; Back to BASIC
PUT128		LD	A,128
		JR	PUTBYTE
;******************************************************************************
POINT		PUSH	BC		; Save pointer to T/F variable
		CALL	CALCADDR	; Get byte and bit addresses
		LD	A,@VDCTL	; Get video character
		PUSH	BC		; BC altered by @VDCTL
		LD	B,1
		RST	40
		POP	BC		; Restore C
		CP	128		; If char <128 or >191, return false
		JR	C,PIXELOFF
		CP	192
		JR	NC,PIXELOFF
		LD	HL,POINTMASK	; Point to start of table
		ADD	HL,BC		; Index to desired mask
		AND	(HL)		; A=0 if pixel off, <>0 if on
LOADVAR		POP	HL		; Point HL to BASIC T/F variable
		LD	(HL),A		; Load the BASIC T/F variable
		INC	HL
		LD	A,0
		LD	(HL),A
		RET			; Back to BASIC
PIXELOFF	LD	A,0
		JR	LOADVAR
;******************************************************************************
VPEEK		PUSH	BC		; Save 3rd argument
		LD	B,(HL)		; B = Row
		EX	DE,HL
		LD	C,(HL)		; C = Column
		PUSH	BC		; Move BC to HL
		POP	HL
		LD	B,1		; Setup for SVC
		LD	A,@VDCTL
		RST	40		; Take a peek
		JR	LOADVAR		; Now return result & back to BASIC
;******************************************************************************
CURSOR		LD	C,(HL)		; C = new cursor character
		PUSH	DE		; Save return variable
		LD	B,8		; Set up for SVC
		LD	A,@VDCTL
		RST	40		; Old cursor character now in A
		JR	LOADVAR		; Return old cursor & back to BASIC
;******************************************************************************
VPOKE		PUSH	BC		; Save pointer to value to be poked
		LD	B,(HL)		; B = Row
		EX	DE,HL
		LD	C,(HL)		; C = Column
		PUSH	BC		; Save Row & Column in AF
		POP	AF
		POP	HL		; Point to value to poke
		LD	C,(HL)		; Put poke value into C
		PUSH	AF		; Get row, column into HL
		POP	HL
		LD	B,2		; Set up for SVC
		LD	A,@VDCTL
		RST	40		; Poke it
		RET			; Back to BASIC
;******************************************************************************
PROTECT		LD	C,(HL)		; C = number of lines to protect
		LD	B,7		; Set up for SVC
		LD	A,@VDCTL
		RST	40		; Do it to it
		RET			; Back to BASIC
;******************************************************************************
VLINE		LD	A,(HL)		; Get length of target string
		CP	80		; Make sure length is >= 80
		RET	C		; Do nothing if < 80
		PUSH	DE		; Save 2nd argument
		INC	HL		; Get actual string address into DE
		LD	E,(HL)
		INC	HL
		LD	D,(HL)
		POP	HL		; HL points to 2nd argument
		LD	H,(HL)		; H has video line to get
		LD	B,9		; Set up for SVC
		LD	A,@VDCTL
		LD	C,1
POKEADDR1	EQU	$-1		; Poke 0 here to copy string to video
		RST	40		; Get the line
		RET			; Back to BASIC
;******************************************************************************
RAMTOVID	LD	E,(HL)		; Get pointer to RAM buffer into HL
		INC	HL
		LD	D,(HL)
		EX	DE,HL
		LD	A,@VDCTL	; Set up for SVC
		LD	B,5
POKEADDR2	EQU	$-1		; Poke 6 here to make this VIDTORAM
		RST	40
		RET			; Back to BASIC
;******************************************************************************
;	CALCADDR -- Translate X,Y coordinates to absolute character position
;		    and bit position within the character
;		ENTRY:	HL Points to the X coordinate, DE points to Y coord.
;		EXIT:	H=video row, L=video column, C=bit position
;******************************************************************************
CALCADDR	LD	C,(HL)		; Get the X coordinate into C
		EX	DE,HL
		LD	A,(HL)		; and the Y coordinate into A
		LD	L,C		; Now L has X coordinate
		SRL	L		; L/2=Video column now in L
		LD	C,0		; Set bit column to 0
		JR	NC,BITCOL0	; Go if bit column=0
		INC	C		; Else bit column=1
BITCOL0		LD	B,-1		; Initialize counter
VIDROW		INC	B		; Bump quotient (B= video row #)
		SUB	3		; Successive subract for /3
		JP	P,VIDROW	; Loop until negative
		ADD	A,3		; A=Bit row (Y MOD 3)
		RLCA			; bit row * 2
		ADD	A,C		; (bit row * 2)+bit column
		LD	C,A		; C = bit position (0 thru 5)
		LD	H,B		; H=Video row
		LD	B,0		; Zap B for later ADD BC,HL instruction
DOSENTRY	RET
SETMASK		DB	81H,82H,84H,88H,90H,0A0H	; Mask tables
RESETMASK	DB	0FEH,0FDH,0FBH,0F7H,0EFH,0DFH
POINTMASK	DB	1,2,4,8,16,32
		END	DOSENTRY	; Do nothing if executed from DOS ready
C