;***************************************************************
;
; ALLOC/CMD:	Freely donated to the public domain.
;		Permission is granted for personal but not
;		commercial use.
;
; Purpose:	Sets the default track allocation search.
;		Very useful for reorging a fragmented hard disk.
;		TRSDOS/LS-DOS 6.x only.
;
; Syntax:	ALLOC n (where n is desired starting track)
;
; Programmer:	R. A. Basham
; Date written:	December 1, 1991
;
; Set up for the Misosys MRAS assembler.  Minor modifications
; may be necessary if using some other assembler package.
;
;***************************************************************
;
;	SVC Equates
;
@ABORT	EQU	15H		;Abort execution and exit to DOS
@CMNDI	EQU	18H		;Execute command and exit to DOS
@DSPLY	EQU	0AH		;Display a message
;
CR	EQU	0DH		;Carriage return
SPC	EQU	20H		;Space char
;
SVC	MACRO	#ADDR		;Supervisor call
	LD	A,#ADDR
	RST	28H
	ENDM
;
;	Upon entry to this routine, the HL register pair
;	contains the address of the first nonblank char
;	following the command name.
;
	ORG	3000H		;User RAM starts here
;
;	Move the command line string to the TRACK buffer
;	for the MEMORY command.
;
BEGIN	LD	DE,TRACK	;Get TRACK buffer address
	LD	B,4		;Max 4 chars (999+CR)
GETCHAR	LD	A,(HL)		;Get next command line char
	INC	HL		;Bump HL past the char
	LD	(DE),A		;Move it to the TRACK buffer
	INC	DE		;Increment DE for next char
	CP	CR		;Was it a carriage return?
	JR	Z,EXEC		;Yes. Then execute command
	CP	30H		;Less than 0?
	JR	C,SYNTAX	;Yes. It's an error.
	CP	40H		;Greater than 9?
	JR	NC,SYNTAX	;Yes. Also an error.
	DJNZ	GETCHAR		;Else back for next char
;
;	Too many or too few chars in the the specified
;	command line or illegal chars found.
;
SYNTAX	LD	HL,USAGE	;Display the usage error
	SVC	@DSPLY
	SVC	@ABORT		; and exit to DOS
;
;	Execute the command to set track allocation
;	search for free space
;
EXEC	LD	A,4		;Do we have at least
	CP	B		; one char?
	JR	Z,SYNTAX	;No. Then it's an error.
	LD	HL,MEMORY	;Yes. Get MEMORY op address
	SVC	@CMNDI		;Execute it and exit to DOS
;
USAGE	DB	'Usage: ALLOC track (0-999)',CR
MEMORY	DB	'MEMORY (A="A",B='
TRACK	DC	4,0		;Max 4 bytes (999+CR)
	END	BEGIN
