;
;*******************
;
;	Macros
;
;*******************
;
; SVC macro is from "The Next Step" by Hardin Brothers
; from 80 MICRO, 11/84.
SVC	MACRO	?NUMBER
	LD	A,?NUMBER
	RST	28H
	ENDM
;
; This macro outputs a character to screen.
PRINT	MACRO	?CHAR
	LD	C,?CHAR
	SVC	@DSP
	ENDM
;
; This macro displays the prompt or menu by pointing the HL
; registers to it and calling the @DSPLY SVC.
DISPLAY MACRO	?MESSAGE
	LD	HL,?MESSAGE
	SVC	@DSPLY
	ENDM
;
;This macro moves the cursor.
K_POSN	MACRO	?ROW,?COLUMN
	LD	B,3
	LD	H,?ROW
	LD	L,?COLUMN
	SVC	@VDCTL
	ENDM
;
; This macro repeats the option if 'Y' is the reply to the
; 'Repeat?' prompt, to START (the menu) if 'N' is the
; reply, or exits to 'TRSDOS Ready' when BREAK is pressed.
REPEAT	MACRO
R?INDEX SVC	@KEY
	RES	5,A
	CP	'Y'
	JP	Z,OP?INDEX
	CP	'N'
	JP	Z,START
	CP	BRK
	JP	Z,QUIT
	JR	R?INDEX
	ENDM
;
;This macro inserts tabs into the menu.
TAB	MACRO	?SPACES
	DB	192+?SPACES
	ENDM
;
; This macro tests each bit in the B register and loads its
; ASCII equivalent into the buffer position pointed to by
; IX
BITB	MACRO	?BIT
	BIT	?BIT,B
	CALL	Z,ZERO
	CALL	NZ,ONE
	INC	IX
	ENDM
;
; This macro tests each bit in the C register and loads its
; ASCII equivalent into the buffer position pointed to by
; IX
BITC	MACRO	?BIT
	BIT	?BIT,C
	CALL	Z,ZERO
	CALL	NZ,ONE
	INC	IX
	ENDM
