;
;	Macros for TRSDOS 6.2.x SVC's
;
;	As taken from the Model 4
;	Technical Reference Manual.
;
;	Added SVC's taken from the TRSDOS 6.2
;	Tech. Ref. Manual update pages.
;
;	References in the macros are taken in the
;	order of registers given in the Manual.
;
@ABORT	MACRO		;abort program or jcl
	LD	A,21
	RST	28H
	ENDM
;
@ADTSK	MACRO	#TASKBLOCK,#TASKSLOT
	LD	DE,#TASKBLOCK	;point to task control block
	LD	C,#TASKSLOT	;task slot assignment #
	LD	A,29
	PUSH	HL
	RST	28H
	POP	HL
	ENDM
;
@BANK	MACRO	#FUNCTION,#BANKNUM,#ADDRESS
	LD	B,#FUNCTION
	LD	C,#BANKNUM
	IFEQ	#FUNCTION,0
	LD	HL,#ADDRESS
	ENDIF
	LD	A,102
	RST	28H
	ENDM
;
@BKSP	MACRO	#FCB
	LD	DE,#FCB
	LD	A,61
	RST	28H
	ENDM
;
@BREAK	MACRO	#VECTOR=0
	LD	HL,#VECTOR
	LD	A,103
	RST	28H
	ENDM
;
@CHNIO	MACRO	#DCB,#DIRECTION,#CHAR
	LD	IX,#DCB
	LD	B,#DIRECTION
	IFEQ	#DIRECTION,2
	LD	C,#CHAR
	ENDIF
	LD	A,20
	RST	28H
	ENDM
;
@CKDRV	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,33
	RST	28H
	ENDM
;
@CKEOF	MACRO	#FCB
	LD	DE,#FCB
	LD	A,62
	RST	28H
	ENDM
;
@CKTSK	MACRO	#SLOT
	LD	C,#SLOT
	LD	A,28
	RST	28H
	ENDM
;
@CLOSE	MACRO	#FCB
	LD	DE,#FCB
	LD	A,60
	RST	28H
	ENDM
;
@CMNDI	MACRO	#CMDBUF
	LD	HL,#CMDBUF
	LD	A,24
	RST	28H
	ENDM
;
@CMNDR	MACRO	#CMDBUF
	LD	HL,#CMDBUF
	LD	A,25
	RST	28H
	ENDM
;
@CTL	MACRO	#DCB,#FUNCTION,#VECTOR
	LD	DE,#DCB
	LD	C,#FUNCTION
	IFEQ	#FUNCTION,4
	LD	IY,#VECTOR
	ENDIF
	LD	A,5
	RST	28H
	ENDM
;
@DATE	MACRO	#BUFFER
	LD	HL,#BUFFER
	LD	A,18
	PUSH	BC
	RST	28H
	POP	BC
	ENDM
;
@DCINIT	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,42
	RST	28H
	ENDM
;
@DCRES	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,43
	RST	28H
	ENDM
;
@DCSTAT	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,40
	RST	28H
	ENDM
;
@DEBUG	MACRO
	LD	A,27
	RST	28H
	ENDM
;
@DECHEX	MACRO	#STRING
	LD	HL,#STRING
	LD	A,96
	RST	28H
	ENDM
;
@DIRRD	MACRO	#DEC,#DRIVE
	LD	B,#DEC
	LD	C,#DRIVE
	LD	A,87
	RST	28H
	ENDM
;
@DIRWR	MACRO	#DEC,#DRIVE
	LD	B,#DEC
	LD	C,#DRIVE
	LD	A,88
	RST	28H
	ENDM
;
@DIV8	MACRO	#DIVIDEND,#DIVISOR
	LD	E,#DIVIDEND
	LD	C,#DIVISOR
	LD	A,93
	RST	28H
	ENDM
;
@DIV16	MACRO	#DIVIDEND16,#DIVISOR8
	LD	HL,#DIVIDEND16
	LD	C,#DIVISOR8
	LD	A,94
	RST	28H
	ENDM
;
@DODIR	MACRO	#DRIVE,#FUNCTION,#HLVAL
	LD	C,#DRIVE
	LD	B,#FUNCTION
	IFNE	#FUNCTION,0
	LD	HL,#HLVAL
	ENDIF
	LD	A,34
	RST	28H
	ENDM
;
@DSP	MACRO	#CHAR
	LD	C,#CHAR
	LD	A,2
	PUSH	DE
	RST	28H
	POP	DE
	ENDM
;
@DSPLY	MACRO	#BUFFER
	LD	HL,#BUFFER
	LD	A,10
	PUSH	DE
	RST	28H
	POP	DE
	ENDM
;
@ERROR	MACRO	#ERRNUM
	LD	C,#ERRNUM
	LD	A,26
	RST	28H
	ENDM
;
@EXIT	MACRO	#RETCODE=0
	LD	HL,#RETCODE
	LD	A,22
	RST	28H
	ENDM
;
@FEXT	MACRO	#FCB,#DEFEXT
	LD	DE,#FCB
	LD	HL,#DEFEXT
	LD	A,79
	PUSH	BC
	RST	28H
	POP	BC
	ENDM
;
@FLAGS	MACRO
	LD	A,101
	RST	28H
	ENDM
;
@FNAME	MACRO	#BUFFER,#DEC,#DRIVE
	LD	DE,#BUFFER
	LD	B,#DEC
	LD	C,#DRIVE
	LD	A,80
	PUSH	BC
	RST	28H
	POP	BC
	ENDM
;
@FSPEC	MACRO	#BUFFER,#FCB
	LD	HL,#BUFFER
	LD	DE,#FCB
	LD	A,78
	PUSH	BC
	RST	28H
	POP	BC
	ENDM
;
@GET	MACRO	#FCB
	LD	DE,#FCB
	LD	A,3
	RST	28H
	ENDM
;
@GTDCB	MACRO	#DEVNAME
	LD	DE,#DEVNAME
	LD	A,82
	RST	28H
	ENDM
;
@GTDCT	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,81
	RST	28H
	ENDM
;
@GTMOD	MACRO	#MODNAME
	LD	DE,#MODNAME
	LD	A,83
	RST	28H
	ENDM
;
@HDFMT	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,52
	RST	28H
	ENDM
;
@HEXDEC	MACRO	#NUMBER,#BUFFER
	LD	HL,#NUMBER
	LD	DE,#BUFFER
	LD	A,97
	RST	28H
	ENDM
;
@HEX8	MACRO	#NUMBER,#BUFFER
	LD	C,#NUMBER
	LD	HL,#BUFFER
	LD	A,98
	RST	28H
	ENDM
;
@HEX16	MACRO	#NUMBER,#BUFFER
	LD	DE,#NUMBER
	LD	HL,#BUFFER
	LD	A,99
	RST	28H
	ENDM
;
@HIGH$	MACRO	#HIGHLOW=0,#SETADDR=0
	LD	B,#HIGHLOW
	LD	HL,#SETADDR
	LD	A,100
	RST	28H
	ENDM
;
@INIT	MACRO	#BUFFER,#FCB,#LRL
	LD	HL,#BUFFER
	LD	DE,#FCB
	LD	B,#LRL
	LD	A,58
	RST	28H
	ENDM
;
@IPL	MACRO
	XOR	A
	RST	28H
	ENDM
;
@KBD	MACRO
	LD	A,8
	PUSH	DE
	RST	28H
	POP	DE
	ENDM
;
@KEY	MACRO
	LD	A,1
	PUSH	DE
	RST	28H
	POP	DE
	ENDM
;
@KEYIN	MACRO	#BUFFER,#MAXLENGTH
	LD	C,0
	LD	B,#MAXLENGTH
	LD	HL,#BUFFER
	PUSH	DE
	LD	A,9
	RST	28H
	POP	DE
	ENDM
;
@KLTSK	MACRO
	LD	A,32
	RST	28H
	ENDM
;
@LOAD	MACRO	#FCB
	LD	DE,#FCB
	LD	A,76
	RST	28H
	ENDM
;
@LOC	MACRO	#FCB
	LD	DE,#FCB
	LD	A,63
	RST	28H
	ENDM
;
@LOF	MACRO	#FCB
	LD	DE,#FCB
	LD	A,64
	RST	28H
	ENDM
;
@LOGER	MACRO	#MESSAGE
	LD	HL,#MESSAGE
	LD	A,11
	RST	28H
	ENDM
;
@LOGOT	MACRO	#MESSAGE
	LD	HL,#MESSAGE
	LD	A,12
	RST	28H
	ENDM
;
@MSG	MACRO	#DCB,#MESSAGE
	LD	DE,#DCB
	LD	HL,#MESSAGE
	LD	A,13
	RST	28H
	ENDM
;
@MUL8	MACRO	#NUM1,#NUM2
	LD	C,#NUM1
	LD	E,#NUM2
	LD	A,90
	RST	28H
	ENDM
;
@MUL16	MACRO	#NUM16,#NUM8
	LD	HL,#NUM16
	LD	C,#NUM8
	LD	A,91
	PUSH	DE
	RST	28H
	POP	DE
	ENDM
;
@OPEN	MACRO	#BUFFER,#FCB,#LRL
	LD	HL,#BUFFER
	LD	DE,#FCB
	LD	B,#LRL
	LD	A,59
	RST	28H
	ENDM
;
@PARAM	MACRO	#PARMTBL,#CMDLINE=0
	IFNE	#CMDLINE,0
	LD	HL,#CMDLINE
	ENDIF
	LD	DE,#PARMTBL
	LD	A,17
	RST	28H
	ENDM
;
@PAUSE	MACRO	#TIME=0
	LD	BC,#TIME
	LD	A,16
	RST	28H
	ENDM
;
@PEOF	MACRO	#FCB
	LD	DE,#FCB
	LD	A,65
	RST	28H
	ENDM
;
@POSN	MACRO	#FCB,#RECNUM
	LD	DE,#FCB
	LD	BC,#RECNUM
	LD	A,66
	RST	28H
	ENDM
;
@PRINT	MACRO	#MESSAGE
	LD	HL,#MESSAGE
	LD	A,14
	PUSH	DE
	RST	28H
	POP	DE
	ENDM
;
@PRT	MACRO	#CHAR
	LD	C,#CHAR
	LD	A,6
	PUSH	DE
	RST	28H
	POP	DE
	ENDM
;
@PUT	MACRO	#DCB,#BYTE
	LD	DE,#DCB
	LD	C,#BYTE
	LD	A,4
	RST	28H
	ENDM
;
@RAMDIR	MACRO	#BUFFER,#DRIVE,#FUNCTION
	LD	HL,#BUFFER
	LD	B,#DRIVE
	LD	C,#FUNCTION
	LD	A,35
	RST	28H
	ENDM
;
@RDHDR	MACRO	#BUFFER,#CYLINDER,#DRIVE,#SECTOR
	LD	HL,#BUFFER
	LD	D,#CYLINDER
	LD	C,#DRIVE
	LD	E,#SECTOR
	LD	A,48
	RST	28H
	ENDM
;
@RDSEC	MACRO	#BUFFER,#CYLINDER,#DRIVE,#SECTOR
	LD	HL,#BUFFER
	LD	D,#CYLINDER
	LD	C,#DRIVE
	LD	E,#SECTOR
	LD	A,49
	RST	28H
	ENDM
;
@RDSSC	MACRO	#BUFFER,#CYLINDER,#DRIVE,#SECTOR
	LD	HL,#BUFFER
	LD	D,#CYLINDER
	LD	C,#DRIVE
	LD	E,#SECTOR
	LD	A,85
	RST	28H
	ENDM
;
@RDTRK	MACRO	#BUFFER,#CYLINDER,#DRIVE,#SECTOR
	LD	HL,#BUFFER
	LD	D,#CYLINDER
	LD	C,#DRIVE
	LD	E,#SECTOR
	LD	A,51
	RST	28H
	ENDM
;
@READ	MACRO	#FCB,#UREC=0
	LD	HL,#UREC
	LD	DE,#FCB
	LD	A,67
	RST	28H
	ENDM
;
@REMOV	MACRO	#FCB
	LD	DE,#FCB
	LD	A,57
	RST	28H
	ENDM
;
@RENAM	MACRO	#OLDFCB,#NEWNAME
	LD	DE,#OLDFCB
	LD	HL,#NEWNAME
	LD	A,56
	RST	28H
	ENDM
;
@REW	MACRO	#FCB
	LD	DE,#FCB
	LD	A,68
	RST	28H
	ENDM
;
@RMTSK	MACRO	#SLOTNUM
	LD	C,#SLOTNUM
	LD	A,30
	PUSH	HL
	PUSH	DE
	RST	28H
	POP	DE
	POP	HL
	ENDM
;
@RPTSK	MACRO	#NEWVECTOR
	LD	A,31
	RST	28H
	DEFW	#NEWVECTOR
	ENDM
;
@RREAD	MACRO	#FCB
	LD	DE,#FCB
	LD	A,69
	RST	28H
	ENDM
;
@RSLCT	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,47
	RST	28H
	ENDM
;
@RSTOR	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,44
	RST	28H
	ENDM
;
@RUN	MACRO	#FCB
	LD	DE,#FCB
	LD	A,77
	RST	28H
	ENDM
;
@RWRIT	MACRO	#FCB
	LD	DE,#FCB
	LD	A,70
	RST	28H
	ENDM
;
@SEEK	MACRO	#DRIVE,#CYLINDER,#SECTOR
	LD	C,#DRIVE
	LD	D,#CYLINDER
	LD	E,#SECTOR
	LD	A,46
	RST	28H
	ENDM
;
@SEEKSC	MACRO	#FCB
	LD	DE,#FCB
	LD	A,71
	RST	28H
	ENDM
;
@SKIP	MACRO	#FCB
	LD	DE,#FCB
	LD	A,72
	RST	28H
	ENDM
;
@SLCT	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,41
	RST	28H
	ENDM
;
@SOUND	MACRO	#FUNCTION
	LD	B,#FUNCTION
	LD	A,104
	RST	28H
	ENDM
;
@STEPI	MACRO	#DRIVE
	LD	C,#DRIVE
	LD	A,45
	RST	28H
	ENDM
;
@TIME	MACRO	#BUFFER
	LD	HL,#BUFFER
	LD	A,19
	PUSH	BC
	RST	28H
	POP	BC
	ENDM
;
@VDCTL	MACRO	#FUNCTION,#HLVAL,#CVAL,#DEVAL
	LD	B,#FUNCTION
	IFLT	#FUNCTION,7
	LD	HL,#HLVAL
	ENDIF
	IFEQ	#FUNCTION,2
	LD	C,#CVAL
	ENDIF
	IFGT	#FUNCTION,6
	LD	C,#CVAL
	ENDIF
	LD	A,15
	IFEQ	#FUNCTION,9
	LD	DE,#DEVAL
	ELSE
	PUSH	DE
	ENDIF
	RST	28H
	IFNE	#FUNCTION,9
	POP	DE
	ENDIF
	ENDM
;
@VER	MACRO	#FCB
	LD	DE,#FCB
	LD	A,73
	RST	28H
	ENDM
;
@VRSEC	MACRO	#CYLINDER,#SECTOR,#DRIVE
	LD	D,#CYLINDER
	LD	E,#SECTOR
	LD	C,#DRIVE
	LD	A,50
	RST	28H
	ENDM
;
@WEOF	MACRO	#FCB
	LD	DE,#FCB
	LD	A,74
	RST	28H
	ENDM
;
@WHERE	MACRO
	LD	A,7
	RST	28H
	ENDM
;
@WRITE	MACRO	#BUFFER,#FCB
	LD	DE,#FCB
	LD	HL,#BUFFER
	LD	A,75
	RST	28H
	ENDM
;
@WRSEC	MACRO	#BUFFER,#CYLINDER,#SECTOR,#DRIVE
	LD	HL,#BUFFER
	LD	D,#CYLINDER
	LD	E,#SECTOR
	LD	C,#DRIVE
	LD	A,53
	RST	28H
	ENDM
;
@WRSSC	MACRO	#BUFFER,#CYLINDER,#SECTOR,#DRIVE
	LD	HL,#BUFFER
	LD	D,#CYLINDER
	LD	E,#SECTOR
	LD	C,#DRIVE
	LD	A,54
	RST	28H
	ENDM
;
@WRTRK	MACRO	#BUFFER,#TRACK,#DRIVE
	LD	HL,#BUFFER
	LD	D,#TRACK
	LD	C,#DRIVE
	LD	A,55
	RST	28H
	ENDM
;
;
;	Additional SVC's.....
;
@CKBRKC	MACRO
	LD	A,106
	RST	28H
	ENDM
;
@CLS	MACRO
	LD	A,105
	RST	28H
	ENDM
;
;
