5 REM==========================================================================
10 REM Graphics Ports:
20 REM           128 - Write the X register address (0-127)
30 REM           129 - Write the Y register address (0-255)
40 REM           130 - Read/Write to the graphics memory specified by the X and
50 REM                 Y address register
60 REM           131 - Write to the options control register
70 REM           140 - Write to the X address OFFSET register
80 REM           141 - Write to the Y address OFFSET register
90 REM           142 - Write to the INTERMIX control register
95 REM=========================================================================
100 REM         131 - Options Control Register Description
110 REM                 Bit 0 ->        0 = Graphics Off        1 = On
120 REM                 Bit 1 ->        0 = Waits Off           1 = On
130 REM                 Bit 2 ->        0 = Increment X Reg     1 = Decrement
140 REM                 Bit 3 ->        0 = Increment Y Reg     1 = Decrement
150 REM                 Bit 4 ->        0 = Read RAM & Clock X  1 = Read & Hold
160 REM                 Bit 5 ->        0 = Read RAM & Clock Y  1 = Read & Hold
170 REM                 Bit 6 ->        0 = Write RAM- Clock X  1 = Write- Hold
180 REM                 Bit 7 ->        0 = Write RAM- Clock Y  1 = Write- Hold
190 REM         NOTE:
200 REM                 Bit 1 should be set high always. Otherwise correct
210 REM                 memory refresh is not guaranteed.
220 REM
230 REM         142 - Intermix Control Register Description
240 REM                 BIT 0 ->        0 = NO INTERMIX OF      1 = INTERMIX OF
250 REM                                     text and graphics       text and
260 REM                                     permitted               graphics
270 REM                 Bit 1 -> All other bits not connected
300 REM========================================================================
301 CLS:PRINT CHR$(23):FOR Z=0 TO 6:PRINT:NEXT Z:PRINT TAB(6),"======":PRINT TAB(6),"Coming":PRINT TAB(6),"Soon..":PRINT TAB(6),"======":PRINT CHR$(15)
350 OUT 14*16+12,64        :REM         4MHz Mode (Bit 6, Port EC)
354 OUT 131,192:REM GRAPHICS Off - NO INCREMENT OF X AND Y
355 FOR X=0 TO 127:FOR Y=239 TO 255:OUT 128,X:OUT 129,Y:OUT 130,0:NEXT Y:NEXT X
356 FOR Y=0 TO 238:FOR X= 80 TO 127:OUT 128,X:OUT 129,Y:OUT 130,0:NEXT X:NEXT Y
357 REM Find Faster Incremental-way to blank data area of Graphics Memory
390 OUT 128,0:OUT 129,0    :REM         Center Register Coordinates
395 OUT 140,0:OUT 141,0    :REM         Center Register Offsets
400 SYSTEM "run gload computer":REM         Load any Picture to Graphics Board
600 OUT 131,191               :REM         Display the Graphics Screen
1000 IF I=0 THEN I=1:OUT 142,1 ELSE I=0:OUT 142,0       :REM INTERMIX
1100 FOR X=127 TO 0 STEP -1:REM         X register limits
1300 OUT 140,X             :REM         X Offset register
1500 NEXT X                :REM         ReCycle Vertical Display
1700 FOR Y=255 TO 0 STEP -1:REM         Y register limits
1900 OUT 141,Y             :REM         Y Offset register
2100 NEXT Y                :REM         ReCycle Horizontal Display
2500 GOTO 1000
