 ;ROPEN/ASM
 ;
 ;ROUTE otput device to file
 ;
 ;Written by Jakub Szajman
 ;2 July 1987
 ;
 MODEL1	EQU	1		;0 = FALSE, 1 = TRUE
 DISPC	EQU	33H		;SHOW CHAR
 GETC	EQU	49H		;SCAN KEYBOARD
 GETL	EQU	05D9H		;GET LINE OF INPUT
 HOME	EQU	3C00H		;HOME POSITION
 DOS	EQU	402DH
 OVNO	DEFL	4288H		;MODEL III OVERLAY ADDR
 DRIVE	DEFL	427EH		;SELECTED DRIVE # STORAGE
 HIMEM	DEFL	4411H		;MODEL III HIMEM ADDR
 	COND	MODEL1
 HIMEM	DEFL	4049H		;MODEL I HIMEM ADDR
 DRIVE	DEFL	4308H		;SELECTED DRIVE STORAGE
 OVNO	DEFL	4317H		;CURRENT OVERLAY
 	ENDC
 ERROR	EQU	4409H		;ERROR EXIT
 DCALL	EQU	4419H		;DOS-CALL
 FNAME	EQU	441CH		;EXTRACT A FILESPEC
 OPEN	EQU	4420H		;OPEN NEW DCB
 CLOSE	EQU	4428H		;CLOSE FILE
 WRITE	EQU	4439H		;WRITE SECTOR
 DISPM	EQU	4467H		;DISPLAY MSG
 ;
 	ORG	0B000H
 START	CALL	01C9H		;CLEAR SCREEN
 	LD	DE,HOME
 	LD	HL,MSG		;"FILE NAME" MSG
 	CALL	DISPM		;SHOW
 	LD	HL,FCB		;FCB
 	LD	B,23		;MAX BUFFER SIZE
 	CALL	GETL		;GET LINE
 	CP	1		;BREAK PRESSED?
 	JP	Z,DOS		;EXIT
 	PUSH	HL
 	POP	DE		;PLACE IN SAME BUFFER
 	CALL	FNAME		;EXTRACT FILE NAME
 	LD	B,0		;LRECL=0
 	LD	HL,BUFFER
 	CALL	OPEN
 	JR	NZ,START
 	LD	HL,MSGM
 	CALL	DISPM
 LOOP	CALL	GETC		;GET CHAR
 	CP	1		;BREAK?
 	JR	NZ,JP1
 	LD	DE,DRIVES
 	CALL	CLOSE
 	JP	DOS
 JP1	CP	'0'
 	JR	C,LOOP		;NOT A DIGIT
 	CP	'7'
 	JR	NC,LOOP		;ILLEGAL VALUE
 	CALL	DISPC		;SHOW CHOICE
 	AND 	0FH		;ZAP ASCII PART
 	LD	B,A
 	LD	A,0DH
 	CALL	DISPC
 	CALL	DISPC		;2 BLANK LINES
 	LD	HL,3CC4H	;POINT TO MENUE (- LINE)
 	LD	DE,40H		;LINE LENGTH
 LOOP1	ADD	HL,DE		;FIND ROUTE PATTERN
 	DJNZ	LOOP1
 	LD	DE,MSGR1
 LOOP2	LD	A,(HL)
 	CP	' '		;END OF STRING?
 	JR	Z,JP2
 	LD	(DE),A		;LOAD IN BUFFER
 	INC	HL
 	INC	DE
 	JR	LOOP2
 JP2	LD	HL,DRIVEE	;LAST BYTE
 	PUSH	DE
 	LD	DE,(HIMEM)	;GET HIMEM
 	LD	BC,DRIVEE-DRIVES+1	;LENGTH
 	LDDR
 	EX	DE,HL		;NEW HIMEM
 	LD	(HIMEM),HL	;RESET HIMEM
 	LD	DE,MSGHA
 	CALL	ASCII		;STORE ADDRESS
 	LD	BC,5200H-4D00H+1
 	ADD	HL,BC
 	EX	DE,HL		;DE=FCB ADDRESS
 	PUSH	DE
 	LD	HL,32H+100H	;OFFSET TO STORE
 	ADD	HL,DE		;HL=STORE ADDRESS
 	PUSH	HL
 	LD	HL,32H
 	ADD	HL,DE		;HL=BUFFER
 	EX	DE,HL
 	POP	HL		;STORE ADDRESS
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D		;STORE BUFF ADDR
 	INC	HL		;STORE1
 	LD	(HL),E
 	INC	HL		;HL=DRIVER
 	EX	(SP),HL		;HL=FCB ADDRESS
 	INC	HL
 	INC	HL
 	INC	HL		;BUFFER ADDR IN FCB
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	POP	HL
 	LD	DE,MSGMMA
 	CALL	ASCII		;CONVERT TO ASCII
 	POP	DE
 	LD	HL,MSGMM
 	LD	BC,MSGMME-MSGMM	;LENGTH TO TRANSFER
 	LDIR			;SHIFT MSGMM TO BUFFER
 	LD	HL,MSGR
 	CALL	DISPM		;SHOW ON SCREEN
 	CALL	DCALL		;DOS-CALL, ROUTE
 	JP	NZ,ERROR
 	LD	HL,MSGH
 	JP	DISPM
 ;
 ;Convert HEX in HL to ASCII and store in DE
 ;
 ASCII	LD	A,H		;GET BYTE
 	CALL	HEX		;CONVERT TO ASCII
 	LD	A,L
 	CALL	HEX		;CONVERT
 	INC	DE
 	RET
 ;
 ;Hexadecimal to ASCII conversion
 ;
 HEX	PUSH	AF		;SAVE BYTE
 	RRCA			;SHIFT TO HIGHER NIBLE
 	RRCA
 	RRCA
 	RRCA
 	CALL	HEX1		;SHOW FIRST DIGIT
 	POP	AF
 HEX1	AND	0FH		;ZAP HIGHER NIBBLE
 	ADD	A,30H		;CONVERT TO ASCII
 	CP	3AH		;0 TO 9?
 	JR	C,HJMP1
 	ADD	A,7
 HJMP1	LD	(DE),A
 	INC	DE
 	RET
 ;
 MSG	DEFM	'Route DO or PR to disk'
 	DEFW	1D1AH
 	DEFB	1AH
 	DEFM	'BREAK to exit.  Run "RCLOSE" to terminateROUT'
 	DEFW	1A1AH
 	DEFB	1DH
 MSG1	DEFM	'1.  DO    - display to disk'
 	DEFW	1D1AH
 MSG3	DEFM	'2.  DO,DO - display to display to disk'
 	DEFW	1D1AH
 MSG4	DEFM	'3.  DO,PR - display to printer to disk'
 	DEFW	1D1AH
 MSG5	DEFM	'4.  PR    - printer to disk'
 	DEFW	1D1AH
 MSG6	DEFM	'5.  PR,DO - printer to display to disk'
 	DEFW	1D1AH
 	DEFB	1AH
 	DEFM	'Output file name? ... '
 	DEFB	3
 MSGM	DEFM	'Menu choice?........ '
 	DEFB	3
 MSGMM	DEFM	',MM='
 MSGMMA	DEFS	4
 	DEFB	'H'
 	DEFB	0DH
 MSGMME	EQU	$
 MSGH	DEFM	'HIMEM '
 MSGHA	DEFS	4
 	DEFB	'H'
 	DEFB	0DH
 MSGR	DEFM	'ROUTE '
 MSGR1	DEFS	MSGMME-MSGMM+5
 ;
 ;
 DRIVES	DEFS	5200H-4D00H	;DOS OVERLAY BUFFER
 FCB	DEFS	32H		;FCB BUFFER
 BUFFER	DEFS	100H
 STORE	DEFW	0		;STORE BUFFER POINTER
 STORE1	DEFB	0		;LSB OF BEG OF BUFFER
 	DEFS	10H		;USED BY DOS
 	PUSH	HL
 	PUSH	DE
 	LD	DE,11H
 	OR	A		;ZAP CARRY
 	SBC	HL,DE		;POINT TO STORE1
 	LD	E,(HL)
 	DEC	HL		;POINT TO STORE
 	LD	A,(HL)
 	DEC	HL
 	PUSH	HL
 	LD	L,(HL)
 	LD	H,A		;HL = BUFFER
 	LD	(HL),C		;STORE CHAR IN BUFFER
 	INC	HL
 	LD	A,E		;BEG OF BUFFER
 	CP	L		;END OF BUFFER?
 	JR	NZ,EXIT		;DO NOT WRITE SECTOR
 	PUSH	BC
 	DEC	H		;POINT TO BEG OF BUFFER
 	PUSH	HL
 	LD	A,(OVNO)	;GET CURRENT OVERLAY
 	PUSH	AF
 	LD	DE,5200H-4D00H+32H
 	OR	A
 	SBC	HL,DE		;BEG OF OVERLAY BUFFER
 	LD	DE,4D00H
 	EX	DE,HL
 	LD	BC,5200H-4D00H	;LENGTH OF OVERLAY
 	PUSH	BC
 	LDIR			;SAVE.  DE=FCB
 	LD	A,(DRIVE)	;GET CURRENT DRIVE
 	PUSH	AF
 	CALL	WRITE		;GET SECTOR
 	JP	NZ,ERROR
 	POP	AF
 	LD	(DRIVE),A
 	POP	BC		;LENGTH
 	DEC	DE		;BOTTOM OF SAVED OVL
 	EX	DE,HL
 	LD	DE,51FFH
 	LDDR			;RESTORE
 	POP	AF		;OVERLAY NO
 	POP	HL		;BUFFER ADDRESS
 	POP	BC		;RESTORE REGISTER
 	LD	(OVNO),A	;RESTORE OVELAY NO
 EXIT	POP	DE		;DE=STORE
 	EX	DE,HL		;DE=CURRENT BUFFER
 	LD	(HL),E
 	INC	HL
 	LD	(HL),D
 	POP	DE
 	POP	HL
 	RET
 ;
 ;BASIC may need last 2 bytes of memory!
 ;
 DRIVEE	EQU	$+2		;END OF DRIVER,+2 BYTES
 ;
 	END	START
                                                                                                                                         