	INTEGER*4 FUNCTION RIGHTS(IDENT,ATTRIB)
C
C	Test whether caller has rights ident specified (descriptor, r)
C
C	Returns SS$_NORMAL 	if OK
C		SS$_NOPRIV 	if identifier is valid but not held
C		SS$_NOSUCHID	if identifier is non-existent
C		Other status	as returned by system services used
C
C	If success, ATTRIB contains any attribute mask ($KGBDEF refers)
C
C	-----------------------------------------------------------------
C
C	Copyright (C) 	A C A Hopkins 	February 1987
C
C	-----------------------------------------------------------------
C	
	IMPLICIT INTEGER*4 (A-Z)
	CHARACTER IDENT*(*)
	INCLUDE '($JPIDEF)'
	INCLUDE '($SSDEF)'
	COMMON/GETUSR/WLEN,WCODE,LADDR,LLADDR
	INTEGER*2 WLEN,WCODE
	DATA WLEN,WCODE,LLADDR/4,JPI$_UIC,0/
	INTEGER*4 UIC(2)/0,0/
	ATTRIB=0
	RID_CTX=0
	LADDR=%LOC(UIC)
C
C	Obtain caller UIC
C
	STATUS=SYS$GETJPI(,,,WLEN,,,)
	IF(.NOT.STATUS)GO TO 98
C
C	Convert ident to longword format
C
	STATUS=SYS$ASCTOID(IDENT,RID,)
	IF(.NOT.STATUS)GO TO 97
C
C	Test for held right
C
5	STATUS=SYS$FIND_HELD(UIC,GOT_RID,ATTR,RID_CTX)
	IF(STATUS.EQ.SS$_NOSUCHID)GO TO 99
	IF(.NOT.STATUS)GO TO 98
	IF(GOT_RID.NE.RID)GO TO 5
C
C	Clear context and return completion status
C
	STATUS=SYS$FINISH_RDB(RID_CTX)
	IF(.NOT.STATUS)GO TO 98
	RIGHTS=SS$_NORMAL
	ATTRIB=ATTR
	RETURN
C
C	Error conditions
C
97	STATUS=SS$_IVIDENT
C
98	RIGHTS=STATUS
	RETURN
C
99	RIGHTS=SS$_NOPRIV
C
	END
