	TITLE	<ASSEMBLY LISTING FOR DEL/CMD>
;***********************************************************
;
;	DEL/CMD: Copyright 1987 by PFM Software from JBSoft.
;		 All rights reserved. Permission is granted
;		 for personal but not commercial use.
;
;	Purpose: Multiple file kill utility.
;		 TRSDOS/LS-DOS 6.x only.
;
;	Syntax is identical to the system REMOVE command.
;
;	Programmer: R. A. Basham
;	Date written: September 1, 1987
;
;	Set up for the Misosys MRAS assembler.
;	Minor modifications may be necessary if using some
;	other assembler package.
;
;************************************************************
;
;	SVC Equates
;
@CMNDR	EQU	19H		;Execute command and return
@DSP	EQU	02H		;Display a character
@DSPLY	EQU	0AH		;Display a message
@EXIT	EQU	16H		;Exit to DOS
;
SPC	EQU	20H		;space character
CR	EQU	0DH		;carriage return
ETX	EQU	03H		;end of text
MAXLEN	EQU	18H		;filename/ext.password:d
;
SVC	MACRO	#ADDR		;Supervisor call
	LD	A,#ADDR
	RST	28H
	ENDM
;
;	Upon entry to this routine, the HL register
;	pair contains the address of the first nonblank
;	following the command name.
;
	ORG	3000H		;User RAM starts here
;
BEGIN	LD	A,(HL)		;Is it a carriage return?
	CP	CR		;Then command line is empty
	JR	Z,SYNTAX	; and it's an error
;
	LD	DE,IOBUFF	;Get the IOBUFF address
	PUSH	DE		; and save it for later
	PAGE
GETCMD	LD	A,(HL)		;Get a command line char
	INC	HL		;Bump HL to next char
	LD	(DE),A		;Move char to the IOBUFF
	INC	DE		;Bump DE past the char
	CP	CR		;Was the character CR?
	JR	NZ,GETCMD	;No. Back for next char
;
	POP	DE		;Recover IOBUFF address
;
;	Load the next available filespec into the
;	FSPEC buffer.
;
AGAIN	LD	HL,FSPEC	;Get FSPEC buffer address
	LD	B,MAXLEN	;filename/ext.password:d
;
GETFILE	LD	A,(DE)		;Get the next char
	INC	DE		;Bump DE past it
	CP	CR		;End of the command line?
	CALL	Z,TESTLEN	;Then send the command
	JR	Z,EXIT		; and exit the program
	CP	SPC		;Space says we have a file
	CALL	Z,TESTLEN	;So send the command
	JR	Z,AGAIN		; and back for next file
	LD	(HL),A		;Else store the char
	INC	HL		;Bump HL past the char
	EXX			;Save the registers
	LD	C,A		; and display the char
	SVC	@DSP
	EXX			;Restore the registers
	DJNZ	GETFILE		; and back for next char
;
TESTLEN	LD	A,B		;Get the char count
	CP	MAXLEN		;If we moved anything
	JR	NZ,DELETE	; then delete the file
	RET			;Z is set so return
;
;	Save the current IOBUFF address for the
;	@CMNDR SVC and terminate the filespec with
;	a carriage return for the REMOVE command.
;
DELETE	PUSH	DE
	LD	(HL),CR
;
;	Make the execution results easy to read.
;
	LD	HL,RESULT	;Load RESULT pointer
	SVC	@DSPLY		; and display it
;
;	We don't check for errors on return from the
;	@CMNDR SVC because the system REMOVE command
;	is trapping and processing errors.
;
	LD	HL,REMOVE	;Get remove op address
	SVC	@CMNDR		; and execute it
;
	XOR	A		;Clear any error flags
	POP	DE		;Restore IOBUFF address
	RET			; and back for next file
;
;	Not enough arguments in the command line.
;
SYNTAX	LD	HL,USAGE	;Display the usage error
	SVC	@DSPLY
;
EXIT	LD	HL,0		;Set a good return code
	SVC	@EXIT		; and exit to DOS
;
USAGE	DB	'Usage: DEL filespec [filespec filespec...]'
	DB	CR
RESULT	DB	' => '		;Command result pointer
	DB	ETX
IOBUFF	DS	50H		;Max 80 chars from command
REMOVE	DB	'REMOVE '
FSPEC	DS	MAXLEN		;filespec/ext.password:d
	END	BEGIN
