       ; RAMDV362/ASM - Ram Disk Driver 
 ;	LNW Team - HD64180ROP CPU With 256K Ram
 ;	Model 4/4P  - Z80 CPU 128K Ram
 ;
 ;	UPDATED	9/15/86
 ; ADDED Support for 2048K Model 4
 ;
 	ORG	5200H
 ;*******************************************************
 ;		Type Flags
 LNW	EQU	0	; 1=LNW Computer
 ;			  0=Model 4 or 4P Computer
 MOD4	EQU	LNW-1
 ;
 HD64180	EQU	0	; 1=HD64180 Processor 256K Ram
 ;			   MMU will be Used
 ;			  0=Z80 Cpu With 128K Ram Banked
 ;			   for Low address 0-8000H
 ;			   Model 4 Supported only
 Z80	EQU	HD64180-1
 MUXMEM	EQU	0	; Added MUX Memory - Port 148
 ;			  1=Yes 0=No
 ;                         Memory Support to 2048k
 ;
 DISP	EQU	0	; Display Patch # when called
 ;                         Used for Debuging Program
 ;********************************************************
 ;		Ram Disk Driver
 ;	For NewDos/80 Version 2.0
 ;
 ;   This driver patches into the disk Sector Raed/Write &
 ;drive selects. An additional patch checks for SYS6/SYS
 ;to be present. If SYS6 is present and we are Formatting,
 ;Copying then a patch is added to SYS6/SYS to bypass the
 ;format routine and just write BOOT/SYS & DIR/SYS Sectors
 ;
 ;   The Ram disk can be installed in drive Slots 0-4. The
 ;pdrive for the Ram Disk will ALWAYS be #4. If we select
 ;Slot 0-3 then the physical drive will select when Slot 4
 ;is requested
 ;  THIS MEANS THAT WE WILL HAVE 5 DRIVES POSSIBLE ONLINE
 ;
 ;  This Version for the HD64180 moves 1 byte at a time.
 ;Next update will include a buffer area for moving 256
 ;bytes at a time as an option. The Model 4/4P  use Hi 
 ;memory and I HATE to loose memory unless the benifit
 ;is great. The HD64180 would be most efficent using the
 ;DMA controller however, I didn't want to loose possible
 ;compatability for "Ramdisk boards".
 ; Thus each sector is read to and from the buffer 1 byte
 ;at a time. That is for each byte read/written a memory
 ;map switch must take place. Ramdisk I/O speed can be
 ;dramatically increased at a cost of 256 bytes of himem
 ;on the model 4/4P ( A full Buffer option will be added 
 ;later as a option )
 ;
 ;  The Routine CALPAGE does the Page Calculating so any
 ;combination of port decoded ram & MMU ram controlled by
 ;the HD64180 can be used.
 ;
 ;   Several patch areas were nessary because of the way 
 ;SYS6/SYS operates. In all patches a test for the current
 ;drive is made. If it is the Ramdisk and SYS6 is resident
 ;and we have not patched SYS6 yet, then we patch in some
 ;bytes for FORMAT. Patch 1,2 are basically to detect if
 ;the Ramdisk is to be POWERED UP and or SELECTED. Patch
 ;3 is th actual Sector Read/Write. Patch 4 & 5 is for
 ;swaped drives. If we install the Ramdisk at drive 1 then
 ;the physical drive 1 becomes drive 4 so we don't have to
 ;give up a drive slot. Patch 6 is mainly for SYS6/SYS in
 ;case we got an error condition and exit Via 4409H. The
 ;purpose is to reset the Patch Flag (SYS6FLG). Once we 
 ;patch SYS6/SYS we don't want any drive selects to 
 ;repatch SYS6/SYS because SYS6/SYS calls other SYS 
 ;modules that overlay SYS6 in the normal overlay area.
 ;
 ;                  Operators Instructions
 ;
 ; Pdrive #4 will Always be the Defination for the Ramdisk
 ; There is a check for the Maximun # of sectors so you 
 ;cant write over the Rom image in the Model 4/4P
 ;
 ; To install type " RamDisk Dn " where dn = Drive #
 ; Once installed the Ramdisk will operate like the Floppy
 ;disk drives. You Must format it to use it.
 ; Format dn,,,,ndmw
 ; To remount the ramdisk as another drive at any time
 ;type Ramdisk dn
 ;
 ; Legal slots for the Ramdisk = 1to4
 ;
 ; When the Ramdisk is mounted over an existing drive the
 ;physical drive will become Drive #4
 ;
 ; If you want to change the Pdrive for Slot # 4 then
 ;you MUST reinstall the Ramdisk.
 ;
 ;*******************************************************
 ;		Equates for Each Type Machine
 ;
 	IF	LNW ; Team Model 1 Compatable
 ;********************************************************
 ;		LNW TEAM - With HD64180/Z80H
 ;********************************************************
 PATAD0	EQU	47EDH 	; Patch address for Patch 1
 ;
 PATAD1	EQU	4776H 	; Patch address for Patch 1
 PATAD1A	EQU	PATAD1+1
 ;
 PATAD2	EQU	47ADH	; Patch address for Patch 2
 PATAD2A	EQU	PATAD2+1
 ;
 PATAD3	EQU	465CH	; Patch address for Patch 3
 ;
 PATAD4	EQU	47A3H	; Patch address for Patch 4
 PATAD4A	EQU	PATAD4+1
 ;
 PATAD5	EQU 	4798H	; Patch address for Patch 5
 PATAD5A	EQU	PATAD5+1
 ;
 PATAD6	EQU	4409H	; patch address for Patch 6
 PATAD6A	EQU	PATAD6+1
 ;
 SYAL	EQU	477AH	; System AL Option - Max Drives
 SYAL1	EQU	439FH	; System - Max # Drive searched
 ;
 CURDRV	EQU	4308H	; Current drive selected
 CURDCMD	EQU	4309H	; Current FDC Select Bits 1-2-4-8
 ;
 CONFLG1	EQU	4369H	; Condition Flags - Debug/Overlay
 ;				Ect.
 SYS6ID	EQU	4D09H	; Byte ID to Check if SYS6 
 ;			  Overlayed its self.
 ;
 SY6BF	EQU	6886H	; System 6 Bypass format Patch 
 ;
 PAT0RCM	EQU	4776H	; Patch 0 End Replace command
 PAT1END	EQU	4779H	; Patch 1 Replaced Command
 PAT2END	EQU	47DDH	; Patch 2 End Jump address
 PAT3END	EQU	4773H	; Patch 3 End Jump address
 PAT3CON	EQU	471DH	; Patch 3 Continue address
 PAT6END	EQU	440CH	; Patch 6 End Jump address
 ;
 P6REPCM	EQU	4C1EH	; Patch 6 Replaced cmd Address
 DIRLMP	EQU	430AH	; Directory Starting Lump for
 ;			  Current Drive
 DIRGRN	EQU	430FH	; Grans/Lump Value for Current
 ;			  Drive
 PDRTBL	EQU	4371H	; Address of Pdrive Table Drive 1
 ;
 PDRADD	EQU	4399H	; Address of current Pdrive
 ;
 CURFDC	EQU	46C4H	; Current FDC cmd 
 LDRV0TK	EQU	4300H	; Last track Accessed by Drive 0
 LDRV4TK	EQU	4304H	; Last track Accessed by Drive 4
 ;
 ;******************************************************
 	ENIF
 ;
 	IF	MOD4
 ;********************************************************
 ;		Model 4 - 128K Ram
 ;********************************************************
 PATAD0	EQU	4792H 	; Patch address for Patch 1
 ;
 PATAD1	EQU	4723H 	; Patch address for Patch 1
 PATAD1A	EQU	PATAD1+1
 ;
 PATAD2	EQU	475EH	; Patch address for Patch 2
 PATAD2A	EQU	PATAD2+1
 ;
 PATAD3	EQU	4607H	; Patch address for Patch 3
 ;
 PATAD4	EQU	4754H	; Patch address for Patch 4
 PATAD4A	EQU	PATAD4+1
 ;
 PATAD5	EQU 	4749H	; Patch address for Patch 5
 PATAD5A	EQU	PATAD5+1
 ;
 PATAD6	EQU	4409H	; patch address for Patch 6
 PATAD6A	EQU	PATAD6+1
 ;
 SYAL	EQU	4727H	; System AL Option - Max Drives
 SYAL1	EQU	42BFH	; System - Max # Drive searched
 ;
 CURDRV	EQU	427EH	; Current drive selected
 CURDCMD	EQU	427FH	; Current FDC Select Bits 1-2-4-8
 ;
 CONFLG1	EQU	4289H	; Condition Flags - Debug/Overlay
 ;				Ect.
 SYS6ID	EQU	4D09H	; Byte ID to Check if SYS6 
 ;			  Overlayed its self.
 ;
 SY6BF	EQU	6888H	; System 6 Bypass format Patch 
 ;
 PAT0RCM	EQU	4723H	; Patch 0 End Replace command
 PAT1END	EQU	4726H	; Patch 1 Replaced Command
 PAT2END	EQU	4783H	; Patch 2 End Jump address
 PAT3END	EQU	4720H	; Patch 3 End Jump address
 PAT3CON	EQU	46CDH	; Patch 3 Continue address
 PAT6END	EQU	440CH	; Patch 6 End Jump address
 ;
 P6REPCM	EQU	4289H	; Patch 6 Replaced cmd Address
 ;
 DIRLMP	EQU	4280H	; Directory Starting Lump for
 ;			  Current Drive
 DIRGRN	EQU	4285H	; Grans/Lump Value for Current
 ;			  Drive
 PDRTBL	EQU	4291H	; Address of Pdrive Table Drive 1
 ;
 PDRADD	EQU	42B9H	; Address of current Pdrive
 ;
 CURFDC	EQU	4687H	; Current FDC cmd 
 LDRV0TK	EQU	4276H	; Last track Accessed by Drive 0
 LDRV4TK	EQU	4279H	; Last track Accessed by Drive 4
 ;
 LDDE	EQU 	5BEDH	; LD DE,(XX) - OPCODE
 LDIX	EQU	2ADDH	; LD IX,(XX) - OPCODE
 STHL	EQU 	22H	; LD (XX),HL - OPCODE
 ;
 HIMEM	EQU	4411H	; HIMEM FOR MODIII/IV
 PORTMSK	EQU	4CFFH	; PORT MASK of Port 84H
 ;
 ;******************************************************
 	ENIF
 ;******************************************************
 	IF	HD64180
 ;	Find Type of Processor We are Running
 ;		HD64180/Z80H Cpu
 ;
 ;
 HDSTART	DEFB	0EDH,38H,18H ; HD64180 INO (18H),A
 	DEFB	3H	     ; IF HD64180 THEN INC BC
 	JP	START 	; HD64180 SYSTEM
 ;
 	JP	Z80CPU	; Z80 SYSTEM
 ;
 ;
 ;
 Z80CPU	LD	HL,MTYPEER
 	CALL	4467H	; DISPLAY ERROR
 	JP	402DH
 ;
 MTYPEER	DEFM	'***** This MUST be a HD64180ROP Processor ****',0DH
 ;
 	ENIF
 ;
 ;********************************************************
 	DEFM	'Written By D. Huffman ',0DH
 ;********************************************************
 ;	Get Drive # for Ramdisk
 ;
 START 	LD	A,(HL)	; GET Command
 	CP	0DH
 	JR	Z,CMDER 	; ERROR
 GETCMD1	LD	A,(HL)
 	INC	HL
 	CP	' '
 	JR	Z,GETCMD1
 	CP	','
 	JR	Z,GETCMD1
 	CP	':'
 	JR	Z,GETCMD1
 ; Ah Finaly
 	SUB	30H	; CONV TO BIN
 	CP	5	; Drive 0-4
 	JR	C,GETCMD2	; GO IF OK
 CMDER	LD	HL,MESER 
 	CALL	MESOUT
 	JP	402DH
 ;
 NOMEMER	LD	HL,MESMER
 	CALL	MESOUT
 	JP	402DH
 ;
 ;
 GETCMD2	LD	(DRIVE),A	; SET IN DRIVE VALUES
 ; JUST for My Sanity We will Attempt to set 148
 	IN	A,(148)	; Get Port if exists
 	SET	0,A
 	OUT	(148),A
 ;
 ;
 	IF	MOD4
 	XOR	A		; Zero a
 	LD	(PORTMSK),A	; Setup Port Mask
 ;				  to zero
 ;
 	IF	MUXMEM
       	IN	A,(148)		; Check for more memory 
 ;				  Mux is Installed ?
 	CP	255		; Assume No Memory
 	JR	Z,NOMEMER; NOP
 	ENIF
 ; Setup and relocate to top of himem
 	LD	IX,(HIMEM)	; GET HIMEM
 ; BUT FIRST Check if we are already installed...
 	LD	A,(IX+4)
 	CP	0CDH		; Check for CALL 4723H
 	JR	NZ,GETLA	; NOP USE NEW ADDRESS
 	LD	A,(IX+5)
 	CP	23H		; ?
 	JR	NZ,GETLA
 	LD	A,(IX+6)
 	CP	47H		; ? 4723H
 	JR	NZ,GETLA
 ; OK IS US.....
 	LD	L,(IX+2)
 	LD	H,(IX+3)	; Old Himem value
 	JR	GETLB
 GETLA	LD	HL,(HIMEM)
 GETLB	LD	DE,PGMEN-PGM	; PROGRAM LENGTH
 	LD	(HIMEM1),HL	; Save for Next boot
 	AND	A
 	SBC	HL,DE		; HL=NEW START OF PGM
 	LD	(NEWLOC),HL	; SAVE IT
 	DEC	HL
 	DEC	HL		; SUB 2
 	LD	(HIMEM),HL	; SAVE HIMEM
 	INC	HL
 	INC	HL		; PUT IT BACK
 	LD	DE,PGM
 	AND	A
 	SBC	HL,DE		; HL = OFFSET
 	LD	(OFFSET),HL	; SAVE IT
 	LD	A,(RELNM)	; GET # IN TABLE
 	LD	B,A
       	LD	IX,RELTBL 	; GET TABLE
 GETLP1	PUSH	IX		; SAVE IT
 	LD	(IXBYTE),IX
 	DEFW	LDIX  		; LD IX,(XX) - OPCODE
 IXBYTE	DEFS	2
 	LD	(LOCBYTE),IX	; SAVE
 	LD	(LOCBYT1),IX
 	DEFW	LDDE		; LD DE,(LOCBYTE)
 LOCBYTE	DEFS	2
 	LD	HL,(OFFSET)
 	ADD	HL,DE		; ADD OFFSET
 	DEFB	STHL		; LD (LOCBYT1),HL
 LOCBYT1	DEFS	2
 	POP	IX		; GET IT BACK
 	INC	IX
 	INC	IX		; BUMP +2
 	DJNZ	GETLP1		; DO LOOP
 ;
 	JP	GETLPEN		; CONTINUE
 ;
 ;--------------------------------------------------------
 ;		Relocation Table
 ;
 	IF	MUXMEM
 RELNM	DEFB	36	; # OF ENTERYS IN TABLE
 	ENIF
 	IF	NOT,MUXMEM
 RELNM	DEFB	34
 	ENIF
 ;
 RELTBL	DEFW	ADDR1+1		; Relocation address
 	DEFW	ADDR2+1
 	DEFW	ADDR3+1
 	DEFW	ADDR4+1
 	DEFW	ADDR5+1
 	DEFW	ADDR6+1
 	DEFW	ADDR7+1
 	DEFW	ADDR8+1
 	DEFW	ADDR9+1
 	DEFW	ADDR10+1
 	DEFW	ADDR11+1
 	DEFW	ADDR12+1
 	DEFW	ADDR13+1
 	DEFW	ADDR14+1
 	DEFW	ADDR15+1
 	DEFW	ADDR16+1
 	DEFW	ADDR17+1
 	DEFW	ADDR18+1
 	DEFW	ADDR19+1
 	DEFW	ADDR20+1
 	DEFW	ADDR21+1
 	DEFW	ADDR22+1
 	DEFW	ADDR23+1
 	DEFW	ADDR24+1
 	DEFW	ADDR25+1
 	DEFW	ADDR26+1
 	DEFW	ADDR27+1
 	DEFW	ADDR28+1
 	DEFW	ADDR29+1
 	DEFW	ADDR30+1
 	DEFW	ADDR31+1
 	DEFW	ADDR32+1
 	IF	MUXMEM
 	DEFW	ADDR33+1
 	DEFW	ADDR34+1
 	ENIF
 ;
 	DEFW	SEC3+1
 	DEFW	PATCH2A+1
 ;
 ;
 GETLPEN	NOP			; CONTINUE HERE
 	ENIF
 ;
 ; Get Fourth Pdrive for New Drive #4
 ; This will be the prive for the Ram Driver no matter 
 ;where we install it.
 ;
 	LD	HL,BOOTSYS	; GET BOOT/SYS Sector
 	LD	DE,FCB
 	CALL	441CH		; Extract File spec
 	JP	NZ,BOOTER	; Got error
 	LD	DE,FCB
 	LD	HL,BUFFER
 	LD	B,0		; 256 Byte sectors
 	CALL	4424H		; Open Boot/sys
 	JP	NZ,BOOTER
 	CALL	4436H		; Sector 1
 	JP	NZ,BOOTER
 	CALL	4436H		;        2
 	JP	NZ,BOOTER
 	CALL	4436H		;        3
 	JP	NZ,BOOTER
 	CALL	4428H		; Close it
 	JP	NZ,BOOTER
 ; Now get Fourth Pdrive
 	DI		; For safety
 ;
 	IF	MOD4
 ;********************************************************
 ;***** Ok now Move New Copy of Ramdisk to Correct Loc **
 	LD	HL,PGM		; START
 	LD	DE,(NEWLOC)	; NEW ADDRESS LOCATION
 	LD	BC,PGMEN-PGM
 	LDIR			; MOVE IT
 	ENIF
 ;
 	LD	HL,BUFFER+40H 	; Start of buffer
 ADDR1	LD	DE,PDRIVE
 	LD	BC,16
 	LDIR			; MOVE IT
 ;
 	IF	Z80	; MODEL 4 WITH Z80
 	IF	MOD4
 	IF	MUXMEM	; MUX MEMORY ADDED
       	IN	A,(148)		; Check for more memory 
 ;				  Mux is Installed ?
 	CP	255		; Assume No Memory
 	JP	Z,NOMEMER; NOP
 ; AH We do have more memory
 	RES	7,A	; Enable Z80 Port Addressing
 	SET	0,A	; Enable First bank of Mux
 	OUT	(148),A
 	LD	HL,7936		; 2048K  2 MEG
 	LD	HL,MESS4M	; Message for disp
 	LD	(MESS44P),HL	; SAVE FOR DISPLAY
 ;                      		 Maximum # of sectors .
 ;				  For Safety in case the
 ;				  Pdrive is set wrong
 	JR	ADDR2
 	ENIF
 ; Now Check if Model 4 or 4P
 NOMORE 	LD	A,(0)
 	LD	B,A	; SAVE THE BYTE
      	LD	A,1
 	OUT	(84H),A
 	LD	(0),A
 	XOR	A
 	OUT	(84H),A
 	LD	A,(0)	; GET THE BYTE
 	CP	1
 	JR	Z,MODEL4P ; IS A 4P
 ;
 MODEL4	LD	HL,MESS4
 	LD	(MESS44P),HL	; SAVE FOR DISPLAY
 	LD	HL,320		; # OF SECTORS MAX 4 
 	JR	ADDR2 		; GO CHECK IF MORE MEM
 ;
 MODEL4P	LD	A,1
 	OUT	(84H),A	; BANK IN RAM
 	LD	A,B	; GET BYTE 
 	LD	(0),A	; PUT IT BACK
 	XOR	A
 	OUT	(84H),A	; BANK IN ROM/WRITE PROTECT
 ;
 	LD	HL,MESS4P
 	LD	(MESS44P),HL	; SAVE FOR DISPLAY
 	LD	HL,256		; MAX # OF SECTORS 4
 	ENIF
 	ENIF
 	IF	HD64180
 	LD	HL,768		; MAX # OF SECTORS
 	ENIF
 ;
 	IF	LNW
 	LD	HL,768		; MAX # OF SECTORS
 	ENIF
 ;
 ADDR2	LD	(SECTOR+1),HL	; SAVE IT
 ;
 	IF	HD64180
 ;*******************************************************
 ;		HD64180 MMU
 ;	Config MMU for 32K Boundrys 8000H-FFFFH
 ;
      	LD	A,128		; CBAR VALUE
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	3AH	; PORT 3AH CBAR OF MMU
 ;
 ;*******************************************************
 	ENIF
 ;patch Ramdrive into DOS
 PATCH	LD	A,(DRIVE)	; Get Drive # for Patch
 ADDR3  	LD	(PAT0+1),A	; SET IN DRIVE VALUES
 ADDR4  	LD	(PAT1+1),A
 ADDR5	LD	(PAT2+1),A
 ADDR6	LD	(PAT3+1),A
 ADDR7	LD	(PAT4+1),A
 ;
 ADDR8	LD	HL,PATCH0
 	LD	(PATAD0),HL
 ;
 ADDR9  	LD	HL,PATCH1	; FIRST PATCH
 	LD	A,0C3H		; JP
 	LD	(PATAD1),A
 	LD	(PATAD1A),HL
 ;
 ADDR10 	LD	HL,PATCH2
 	LD	A,0CDH		; CALL BYTE
 	LD	(PATAD2),A
 	LD	(PATAD2A),HL
 ;
 ADDR11	LD	HL,PATCH3
 	LD	(PATAD3),HL
 ;
 ; Is Drive 4 - Now Patch Pdrive Check routine
 ;
 	LD	A,0CDH		; CALL
 	LD	(PATAD4),A
 ADDR12	LD	HL,PATCH4
 	LD	(PATAD4A),HL	; CALL PATCH4
 ;
 	LD	A,0CDH
 	LD	(PATAD5),A
 ADDR13	LD	HL,PATCH5
 	LD	(PATAD5A),HL
 ;
 	LD	A,0C3H		; Patch 6 for SYS6TES
   	LD	(PATAD6),A
 ADDR31	LD	HL,PATCH6
   	LD	(PATAD6A),HL
 ;
 	LD	A,5		; 4 DRIVES
 	LD	(SYAL),A
 	LD	(SYAL1),A
 ;
 	EI
 ;
 ; Check if Ramdisk will be drive 0 ?
 	LD	A,(DRIVE)	; get current drive
 	CP	0		; Are we setting up Dr 0
 	JR	NZ,PATCHDN	; Nop
 ; Yes it is .. So we need to copy the Pdrive for 
 ; the Physical drive 0 to the Ram Disk
 ;
 ; BUFFER Still has Physical Drive 0 Rel Sector 3
 ;
 ; Open Boot/sys on Ramdisk
 	LD	HL,BOOTSYS 	; GET BOOT/SYS Sector
 	LD	DE,FCB 
 	CALL	441CH		; Extract File spec
 	JP	NZ,BOOTER	; Got error
 	LD	DE,FCB 
 	LD	HL,BUFFER0	; NEW BUFFER
 	LD	B,0		; 256 Byte sectors
 	CALL	4424H		; Open Boot/sys
 	JR	NZ,BOOTER
 	CALL	4436H		; Sector 1
 	JR	NZ,BOOTER
 	CALL	4436H		;        2
 	JR	NZ,BOOTER
 	CALL	4436H		;        3
 	JR	NZ,BOOTER
 ; Ok now copy over old Pdrive to Ramdisk
 	LD	HL,BUFFER	; Source
 	LD	DE,BUFFER0	; Dest
 	LD	BC,16		; 16 Bytes
 	LDIR			; Move them
 ;
 	LD	DE,FCB
 	CALL	4445H		; Backup 1
 	JR	NZ,BOOTER	; Error recovery
 ;
 	LD	HL,BUFFER0
 	CALL	4439H		; Write the Sector
 	JR	NZ,BOOTER
 ;
 	CALL	4428H		; Close it
 	JR	NZ,BOOTER
 ;
 PATCHDN	LD	A,(LDRV0TK)	; Get Last Track Accessed
 	LD	(LDRV4TK),A	; Move to Drive # 4 Slot
 ;				  This is so Dos can find
 ;				  the correct track the
 ;				   first time
 ;
 	LD	HL,MESS1	; MESSAGE INIT
 	CALL	MESOUT
 	IF	Z80
 	LD	HL,(MESS44P)	; GET CORRECT MESSAGE
 	CALL	MESOUT
 	ENIF
 	IF	HD64180
 	LD	HL,MESSHD
 	CALL	MESOUT
 	ENIF
 	LD	HL,MESS2
 	CALL	MESOUT
 	JP	402DH		; Done
 ;
 BOOTER	JP	4409H		; ERROR EXIT
 ;
 NEWLOC	DEFS	2		; NEW ADDRESS FOR RAMDRV
 OFFSET	DEFS	2		; OFFSET STORAGE
 DRIVE	DEFS	2		; Patch Drive #
 FCB	DEFS	50		; FCB BUFFER
 BUFFER	DEFS	256		; DOS BUFFER - PDRIVE 
 BOOTSYS	DEFM	'BOOT/SYS',0DH
 ;
 BUFFER0 DEFS	256		; DOS BUFFER - PDRIVE 
 ;
 MESS44P	DEFS	2		; Model 4/4P Display Mess
 ;
 MESS1	DEFM	'***********************************************',0DH
      	DEFM	'*        Ramdisk Version 3.62 Installed       *',0DH
 	DEFM	'*            Written By D. Huffman            *',0DH
 	IF	MOD4
 	DEFM	'*  Bit Mask for Port 84H is at Address 4CFFH  *',0DH
 	ENIF
 	DEFB	0	; END OF MESSAGE SEGMENT
 ;
 MESS4	DEFM	'*        Model 4 - 320 Sectors Maximum        *',0DH,0
 ;
 MESS4P	DEFM	'*        Model 4P - 256 Sectors Maximum       *',0DH,0
 MESS4M	DEFM	'* Model4/4P-Mux Memory Added-7936 Sectors Max *',0DH,0
 MESSHD	DEFM	'*             768 Sectors Maximum             *',0DH,0
 MESS2	DEFM	'***********************************************',0DH
 	DEFB	0DH,0
 ;
 MESER	DEFM	'*************************************************************',0DH
      	DEFM	'*                  Illegal Drive Specifyied                 *',0DH
 	DEFM	'*  Parameters  --->  RAMDISK <Dn>                           *',0DH
 	DEFM	'*  Example     --->  RAMDISK 4                              *',0Dh
 	DEFM	'*     The RamDisk uses Pdrive #4 in the Pdrive table        *',0DH
 	DEFM	'*************************************************************'
 	DEFB	0DH,0
 ;
 MESMER	DEFM	'*************PORT 148 (94H) RETURNS 255 (FFH)  **************',0DH
 	DEFM	' I Must Assume that the Memory Expansion Doesnt exist   ',0DH
 	DEFM	'              I Cannot Proceed ',0DH,0
 MESOUT	LD	A,(HL)	; GET BYTE
 	CP	0
 	RET	Z	; DONE
 	CALL	033H
 	INC	HL
 	JR	MESOUT
 ;
 ;*******************************************************
 	IF	LNW	; Lnw has Ram from 3000H-37DFH
 ;			; But the Illegal Emulator code
 ;			; Starts at 3500H
 	ORG	3000H
 	ENIF
 	IF	MOD4
 	ORG	8000H
 	ENIF
 ;
 PGM	EQU	$	;****** START OF RAMDISK
 ;*******************************************************
 ;************* Do Not Change the next 6 Bytes ***********
 HIMEM1	DEFS	2	; OLD HIMEM LOCATION
 ;********************************************************
 ;		47ECH		4792H
 ; * Bypass Drive Select & Test routine IF Ram Disk
 ;  This Routine is called by SYS6/SYS Directly
 PATCH0	CALL	PAT0RCM
 	RET	NZ
 	IF	DISP
 	LD	A,'0'
 	LD	(3FF7H),A	; Display Patch #
 	ENIF
 	LD	A,(CURDRV)	; GET CURRENT DRIVE
 PAT0	DEFB	0FEH		; CHECK FOR MEMDRIVE
 	DEFS	1  		; CP DN#
 	JR	NZ,RET0 	;jmp if not Ramdrive
 ; Now check if system 6 is active - We may be Formatting
 ADDR14	CALL	SYS6TES		; If system 6 then patch
 ;
 	POP	AF		;pop call off of stack
 RET0 	XOR	A
 	RET
 ;********************************************************
 ;		4776H		4723H
 ; * Bypass Drive Select If Ram Disk - Normal Call
 PATCH1	PUSH	AF		; SAVE IT
 	LD	A,(CURDRV)	; GET CURRENT DRIVE
 PAT1	DEFB	0FEH		; CHECK FOR MEMDRIVE
 	DEFS	1  		; CP DN#
 	JR	NZ,RET1 	;jmp if not Ramdrive
 	IF	DISP
 	LD	A,'1'
 	LD	(3FF8H),A	; Display Patch #
 	ENIF
 ; Now check if system 6 is active
 ADDR15	CALL	SYS6TES		; If system 6 then patch
 ;
 RET1	POP	AF		;pop AF back ...
      	PUSH	HL		; Replace cmd
 	PUSH	DE
 	PUSH	BC
 	JP	PAT1END 	; GO we replaced the cmds
 ;********************************************************
 ;	47ADH		475EH
 ;* Bypass Controller Init for the Read/Write IF Ram Disk
 PATCH2	LD	A,(CURDRV)	; GET CURRENT DRIVE
 PAT2	DEFB	0FEH		; CHECK FOR MEMDRIVE
 	DEFS	1  		; CP DN#
 ;
 	IF	LNW
 	LD	HL,37ECH 	; Replaced Cmd
 	ENIF
 ;
 	IF	MOD4
 	LD	A,(4286H)	; Replaced Cmd 
 	ENIF
 ;
 	RET	NZ	;ret if no Ramdrive
 ;
 	IF	DISP
 	LD	A,'2'
 	LD	(3FF9H),A	; Display Patch #
 	ENIF
 	IF	MOD4
 	IN	A,(0F0H)	; Get current FDC state
 	BIT	7,A		; Is it active
 	JR	NZ,PATCH2A
 ; AH Drives are running - shut them off
 	OUT	(0F4H),A	; Reset drive latches
 	ENIF
 ;
 	IF	LNW
 	XOR	A
 ;	LD	(37E0H),A	; Reset drive latches
 	ENIF
 ;
 ; Is Ram Disk - now check if Drive 0  If so dont patch
 ;
 ;
 PATCH2A	CALL	SYS6TES	; If system 6 then patch
 ;
 RET20	POP	AF	;pop calls & pushes off stack
 	POP	AF
 	POP	AF
     	JP	PAT2END		;continue
 ;
 ;	SYS6/SYS - Format bypass
 ; Called if Current drive to be accessed to Ramdisk
 SYS6TES	LD	A,(CURDRV)	; Get current drive agn
 	CP	0
 	RET	Z 		; Dont patch if 0
         LD	A,(CONFLG1)	; Overlay Address Clt
 	BIT	3,A
 	JR	Z,SYS6A		; Not SYS6
 	LD	A,(SYS6ID)	; Check if sys is called
 ;				  another overlay
 	CP	68H
 	RET	NZ		; OOPS Don't patch
 	LD	A,(626CH)	; GET Secondary Check PT
 	CP	20H		; Has SYS6 Bin Reloaded ?
 	JR	NZ,SYS6T1	; Yes Repatch
 ADDR16	LD	A,(SYS6FLG)	; PATCH SYS6 FLAG
 	CP	10
 	RET	Z       	; RET IF PATCHED
 ; Ah is active so patch it for Ramdrive
 SYS6T1	LD	A,0C9H	; By pass Source Dest Check
 	LD	(4E6FH),A
 ;
 	LD	A,94H	; Change Check Flag
 	LD	(4EB6H),A
 	LD	A,20H	; Patch Bypass Secondary Check
 	LD	(626CH),A
 ;
 	LD	A,18H	; By pass Prompts
 	LD	(55BFH),A
 ;
 ; 	LD	A,0A0H	; Force Option DDND
 ;   	LD	(5994H),A
 ;
 	XOR	A	; By Pass Format Verify
 	LD	(6655H),A
 	LD	(6656H),A
 	LD	(6657H),A
 ;
 	LD	A,0C9H	; By Pass Formatting
       	LD	(SY6BF),A
 ;
 	IF	DISP
 	LD	A,'P'
 	LD	(3FFEH),A
 	ENIF
 	LD	A,10
 ADDR17	LD	(SYS6FLG),A	; SET PATCH FLAG
 ;
 	RET
 SYS6A	XOR	A
 ADDR18	LD	(SYS6FLG),A	; Reset flag
 	IF	DISP
 	LD	A,'U'
 	LD	(3FFEH),A
 	ENIF
 	RET
 ;
 ;*******************************************************
 SYS6FLG	DEFS	2	; System 6 Patch flag
 ;*******************************************************
 ;	465CH		4607H
 ;* This The Actual Ramdisk Sector Read/Write Patch
 PATCH3	LD	A,(CURDRV)	; GET CURRENT DRIVE
 PAT3	DEFB	0FEH		; Check for Ramdisk 
 	DEFS	1  		; CP DN#
 	JP	NZ,PAT3END	;jmp if not ramdisk
 ;
 	IF	DISP
 	LD	A,'3'
 	LD	(3FFAH),A	; Display Patch #
 	ENIF
 	POP	AF		;pop call off of stack
 	PUSH	BC		;save registers
 	PUSH	DE	; Rel sector
 	PUSH	HL	; Buffer area
 	DI			;disable interrupt
 	EX	DE,HL	;HL=relative sector to read
 SECTOR	DEFB	11H		; LD DE,XXXXX
 	DEFS	2		; SECTOR MAX
 	PUSH	HL
 	AND	A
 	SBC	HL,DE
 	POP	HL
 ADDR22	JP	NC,BADREC;jmp if sector not in Ramdisk
 ; Check IF We are accessing  Directory Sectors
 	PUSH	HL		; Save it
 	POP	DE		; DE=HL
 	PUSH	DE
 	LD	A,(DIRLMP)	; Get Dir Lump
 	LD	C,A
 	XOR	A		; Zero a
 	SBC	HL,HL
 	LD	B,A
 	ADD	HL,BC		; Multiply Dir Lump * 5
 	ADD	HL,HL
 	ADD	HL,HL
 	ADD	HL,BC
 	LD	A,(DIRGRN)	; Grans per Lump
 	DEC	A
 	PUSH	HL
 	POP	BC
 SECLP1	ADD	HL,BC		; Multiply dir Lump/Sec
 	DEC	A
 	JR	NZ,SECLP1
 ; HL=Starting Sector of DIR ( DL * GRANS/LUMP * 5 )
 	RST	18H		; Compare HL TO DE
 	JR	Z,SECDIR	; IS DIR sector
 	JR	NC,SEC3A	; Before Dir
 ; Sector is beyond the start of the Directory
 	PUSH	HL
 	PUSH	DE
 	LD	DE,9		; Offset in Pdrive
 	LD	HL,(PDRADD)	; Address of current pdr
 	ADD	HL,DE		; Point to DDGA
 	LD	A,(HL)		; Get it
 	POP	DE
 	POP	HL
 	LD	B,A		; Multiply * 5
 	ADD	A,A
 	ADD	A,A
 	ADD	A,B
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	RST	18H		; Compare HL to DE
 	JR	Z,SEC3A		; Past end
 	JR	C,SEC3A		; Past end
 SECDIR	LD	A,32		; Read Protect
 	JR	SEC3
 SEC3A	LD	A,0
 SEC3 	LD	(STATUS+1),A	; Reset Read Protect Sec
 	POP	HL		; Get it back
 ; Cal bank value
 	LD	DE,128	; # Sectors/Bank
 	LD	C,1	; set first bank
 SEC1	AND	A
 	SBC	HL,DE	; Sub 128
 	JR	C,SEC2	; Go if less than
 	INC	C	; bump bank ptr
 	JR	SEC1
 SEC2	LD	A,C		; A = BANK # 1 to 14
 ADDR19	CALL	CALPAGE		; Find Byte for bank Cmd
 ADDR20	LD	(READ+1),A	; A = Command for MMU
 	IF	MOD4
 	LD	A,(PORTMSK)	; Get Bit Mask
 ADDR27	LD	(PORT84),A	; Save it
 	ENIF
 ; Now Cal Rel Sec in bank
 	AND	A
 	ADD	HL,DE		; Get Rel Sec
 ; HL=Rel Sector in Bank
 ; C=Bank #
 ; Now set HL=to address of Sector in Bank
 ; HL Cannot be > 128
 	XOR	A		; Zero a
 	CP	L		; is 0 ?
 	JR	Z,SEC5		; Is start of next bank
 	LD	B,L  		; # of Sectors
 	LD	DE,256		; # of Bytes/Sector
 	LD	HL,00H  	; Base Address
     	AND	A
 SEC4	ADD	HL,DE
 	DJNZ	SEC4		; HL=B*256
 ;
 	IF	HD64180		; Bank High by MMU
 SEC5 	LD	DE,8000H	; Offset to 8000H
 	AND	A
 	ADD	HL,DE
 	ENIF
 	IF	NOT,HD64180
 SEC5	NOP
 ;HL=Rel address from 0000H
 	ENIF
 ;HL=Address of Sector
 	POP	DE		;pop buffer address
 	PUSH	DE
 ;
 	LD	A,(CURFDC)	; BYTE FOR FDC CMD
 	AND	20H
 	JR	NZ,WRITE	;jmp if write sector
 ;
 ;********************************************************
 ;		READ A SECTOR
 	LD	B,0
 READ	LD	A,0	;A=bank to read/write from
 ;--------------------------------------------------------
 	IF	HD64180
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	38H	; PORT 38H CBR OF MMU
 ;			  Bank in Ram
 	ENIF
 	IF	Z80
 	OUT	(84H),A	; BANK IN RAM
 	ENIF
 ;--------------------------------------------------------
 	LD	C,(HL)		;get character
 	INC	HL	;add 1 to Ramdrive address
 	XOR	A 		; PAGE IN 0
 ;--------------------------------------------------------
 	IF	HD64180
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	38H	; PORT 38H CBR OF MMU
 ;			 Bank it out
 	ENIF
 	IF	Z80
 	IF	MOD4
 ADDR28	LD	A,(PORT84)	; Normal Mask
 	ENIF
 	OUT	(84H),A	; BANK OUT RAM
 	ENIF
 ;--------------------------------------------------------
 	LD	A,C
 	LD	(DE),A		;save byte to buffer
 	INC	DE		;add 1 to buffer address
 	DJNZ	READ	;continue  256 bytes read
 ;*******************************************************
 ;
 STATUS	LD	A,0	;read protect status if directory
 	JR	RET3 		;continue in DOS
 BADREC	LD	A,0C1H		;Error code 
 	JR	RET3		;continue in DOS
 ;
 ;********************************************************
 ;	WRITE A SECTOR
 WRITE	LD	B,0
 WRITE1	XOR	A
 ;--------------------------------------------------------
 	IF	HD64180
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	38H	; PORT 38H CBR OF MMU
 ;			  Bank it out
 	ENIF
 	IF	Z80
 	IF	MOD4
 ADDR29	LD	A,(PORT84)	; Normal Mask
 	ENIF
 	OUT	(84H),A	; BANK OUT RAM IF IN
 	ENIF
 ;-------------------------------------------------------
 	LD	A,(DE)		;get character to write
 	LD	C,A
 	INC	DE		;add 1 to buffer
 ADDR23 	LD	A,(READ+1)
 ;-------------------------------------------------------
 	IF	HD64180
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	38H	; PORT 38H CBR OF MMU
 ;			  Bank it in
 	ENIF
 	IF	Z80
 	OUT	(84H),A	; BANK IN RAM
 	ENIF
 ;--------------------------------------------------------
 	LD	(HL),C		;write character
 	INC	HL	;add 1 to Ramdrive address
 	DJNZ	WRITE1	;continue write 256 times
 	XOR	A
 ;--------------------------------------------------------
 	IF	HD64180
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	38H	; PORT 38H CBR OF MMU
 ;			   Bank it out
 	ENIF
 	IF	Z80
 	IF	MOD4
 ADDR30	LD	A,(PORT84)	; Normal Mask
 	ENIF
 	OUT	(84H),A	; BANK OUT RAM
 	ENIF
 ;
 ;--------------------------------------------------------
 ;
 ;
 RET3	NOP			; Patch Area for Debug
 	IF	Z80
 	IF	MUXMEM	; Added Memory
 	PUSH	AF	; SAVE READ STATUS FLAG
 ADDR34	LD	A,(PORT148)	; GET ORIG BITS
 	OUT	(148),A
 	POP	AF
 	ENIF
 	ENIF
     	JP	PAT3CON		;continue in DOS
 ;
 	IF	Z80
 	IF	MOD4
 	IF	NOT,MUXMEM	; ADDED MUX MEMORY
 ;********************************************************
 ;		CALPAGE - SETUP PAGE FOR MMU
 ;		   96K 1 to 3  Pages for Model 4
 ;		   64K 1 to 2  Pages for Model 4P
 ;	ENTER	A = PAGE # 1TO3 
 ;	EXIT	A = Command Byte for Port 84H
 ;
 ;
 CALPAGE	PUSH	HL
 	LD	L,63H	; Bank 1
 	CP	1
 	JR	Z,CALEN
 	LD	L,73H	; Bank 2
 	CP	2
 	JR	Z,CALEN
 	LD	L,3H	; Bank 3
 CALEN	LD	A,(PORTMSK)	; GET PORT  84 bit mask
 	OR	L
 	POP	HL
 	RET
 	ENIF
 	ENIF
 	ENIF
 ;********************************************************
 	IF	HD64180
 ;********************************************************
 ;		CALPAGE - SETUP PAGE FOR MMU
 ;		  256K =  1 TO 14 PAGES
 ;	ENTER	A = PAGE # 1TO14
 ;	EXIT	A = Command Byte for MMU
 ;
 ;
 CALPAGE	PUSH	HL
 	LD	L,A
        	LD	H,8		; FACTOR
 	DEFB	0EDH		; MLT - MULTIPLY
 	DEFB	6CH		; H X L
 ; HL HAS RESULTS
 	LD	A,L		; GET LSB
 ;
 	POP	HL
 	RET
 ;
 ;********************************************************
 	ENIF
 	IF	Z80
 	IF	MUXMEM	; ADDED Mux Memory Port 148
 ;********************************************************
 ;		CALPAGE - SETUP PAGE FOR MMU
 ;          1 TO 31 Pages 2,031,616 Bytes of Ramdisk
 ;
 ;
 ;	ENTER	A = PAGE # 1TO3 
 ;	EXIT	A = Command Byte for Port 84H
 ;
 ;
 CALPAGE	PUSH	HL
 	PUSH	BC
 	LD	L,A	; SAVE IT
 	IN	A,(148) ; GET BITS
 ADDR33	LD	(PORT148),A ; Save Bits for later
 	LD	H,A	; SAVE H
 	LD	A,L	; PUT A BACK
 ;
 	LD	L,63H	; Bank 1
 	CP	1
 	JR	Z,CALEN
 	LD	L,73H	; Bank 2
 	CP	2
 	JR	Z,CALEN
 ; OK Its more that 64K We will assume extra Memory
 ;
 	LD	L,73H	; Even page
 	BIT	0,A	; Is it an even # ?
 	JR	Z,CALEVEN
 ; IS AN ODD #
 	LD	L,63H	; Odd page
 	INC	A	; BUMP UP TO EVEN #
 CALEVEN	AND	31  	; Mask off upper bits
 			; Just incase we screwed up
 	AND	A	; Clear Carry if set
 	RR	A	; Divide / 2
 	LD	C,A	; Save bottom 5 Bits
 	LD	A,H
 	AND	224	; Mask off lower bits
 	OR	C	; Mix together
 ; Ah .... about time ....
 	OUT	(148),A	; Set Extra Memory Mux
 	IF	MOD4	; Is Z80 & MOD4
 CALEN	LD	A,(PORTMSK)	; GET PORT  84 bit mask
 	OR	L	; Mix A & L
 	POP	BC
 	POP	HL
 	RET
 	ENIF
 	IF	NOT,MOD4
 CALEN	LD	A,L
 	POP	BC
 	POP	HL
 	RET
 	ENIF
 ;
 ;********************************************************
 	ENIF
 	ENIF
 ;
 ;*******************************************************
 ;	47A3H		4754H
 ;* Patch in Pdrive Prammeters IF Ramdisk or Swaped Drive
 ;
 PATCH4	PUSH	AF	; Save AF
 	LD	A,(CURDRV)	; Check Current Drive
 PAT4	DEFB	0FEH		; Check if Ramdisk
 	DEFS	1		; Patch byte
 	JR	NZ,PATCH41	; Nop
 ;
 	IF	DISP
 	LD	A,'4'
 	LD	(3FFBH),A	; Display Patch #
 	ENIF
 ; Is us - Load in ower Pdrive for Mem Drive 
 ADDR21	LD	HL,PDRIVE	; SET HL=DRIVE 4 PDRIVE
 PATCH42	POP	AF
 	LD	(PDRADD),HL
 	RET			; CONTINUE
 ;
 PATCH41	CP	4		; IS DRIVE 4 ?
 	JR	NZ,PATCH42	; NOP
 ; Is Drive # 4 - AND This is not the Ramdisk
 ; - Now set Pdrive for Replaced drive
 	LD	HL,PDRTBL	; Pdrive Table
 ADDR24	LD	A,(PAT1+1)	; Get patched drive
 	CP	0		; Is it drive 0 ?
 	JR	Z,PATCH42	; HL=DRIVE 0 PDRIVE
 	PUSH	BC		; Save it
 	PUSH	DE
 	LD	DE,10		; # of enterys
 	LD	B,A		; Set up counter
 PAT4LP1	ADD	HL,DE		; BUMP 10
 	DJNZ	PAT4LP1
        	POP	DE
 	POP	BC
 	JR	PATCH42
 ;********************************************************
 ;	4798H			4749H
 ;* Patch in Physical Drive Latches IF Swaped Drive
 PATCH5	LD	L,A	; Save it
 ADDR25	LD	A,(PAT1+1)	; Get current Mem drive
 	CP	4		; Swap flag
 	JR	Z,PATCH51	; NOTHING TO DO
 ;
 	IF	DISP
 	LD	A,'5'
 	LD	(3FFCH),A	; Display Patch #
 	ENIF
 ; Now check current drive
 	LD	A,(CURDRV)	; Get current drive
 	CP	4
 	JR	NZ,PATCH51	; DO NOTHING
 	PUSH	BC
 	LD	A,(CURDCMD)	; Get Current bit setting
 	AND	0F0H		; Mask of low bits 0-3
 	LD	C,A		; save
 ADDR26 	LD	A,(PAT1+1)	; Get Swaped Drive
 	LD	B,A		; Save to B for loop
 	CP	0		; Is it dr0 ?
 	LD	A,1
 	JR	Z,PATCH54	; IS drive 0
 PATCH52	RL	A		; ROTATE 1 2 4 8
 	DJNZ	PATCH52
 PATCH54	OR	C		; OR in bits 4-7
        	POP	BC
 	JR	PATCH53
 PATCH51 LD	A,L
 PATCH53	LD	(CURDCMD),A	; DO INST
 	RET
 ;
 ;******************************************************
 ;	4C19H		4BBEH
 ; Patch for SYS6 incase we get an error and reload SYS6
 ;
 PATCH6	PUSH	AF
 	IF	DISP
 	LD	A,'6'
 	LD	(3FFDH),A
 	ENIF
 	XOR	A
 ADDR32	LD	(SYS6FLG),A
 ;
 	LD	A,26H
 ;
 	JP	PAT6END 
 ;
 ;******************************************************
 	IF	MOD4
 PORT84	DEFS	2	; Port Mask for Model 4
 	IF	MUXMEM
 PORT148	DEFS	2	; Port Mask for Extra Memory bank
 	ENIF
 	ENIF
 PDRIVE	DEFS	17	; Pdrive Table for Drive 4
 	DEFS	3
 PGMEN	NOP		; END OF PROGRAM FOR RELOCATION
 ;********************************************************
 	IF	HD64180
 ;			MMU CHART
 ;********************************************************
 ; 			CBAR = 128
 ;		0 TO 32K = BASE AREA
 ;		32 TO 64K = COMMON AREA 1
 ;			BBR = 0
 ;		BANK AREA - NOT USED
 ;
 ;			CBR
 ;
 ; 256 128 64K 32K
 ; 64  32  16  8  4  2  1    MEM RANGE    BYTE   BANK #
 ;  0   0   0  0  0  0  0    32 TO 64K    0      1
 ;  0   0   0  1  0  0  0    64 TO 96K    8      2
 ;  0   0   1  0  0  0  0    96 TO 128K   16     3
 ;  0   0   1  1  0  0  0    128 TO 160K  24     4
 ;  0   1   0  0  0  0  0    160 TO 192K  32     5
 ;  0   1   0  1  0  0  0    192 TO 224K  40     6
 ;  0   1   1  0  0  0  0    224 TO 256K  48     7
 ;
 	END	HDSTART
 	ENIF
 	IF	Z80
 	END	START
 	ENIF
