       ; RDEQV364/ASM - Equates for Ramdv364/asm
 ;
 ;********************************************************
 ;		Ram Disk Driver
 ;	For NewDos/80 Version 2.0
 ;
 ;   This driver patches into the disk Sector Read/Write &
 ;drive selects. An additional patch checks for SYS6/SYS
 ;to be present. If SYS6 is present and we are Formatting,
 ;Copying then a patch is added to SYS6/SYS to bypass the
 ;format routine and just write BOOT/SYS & DIR/SYS Sectors
 ;
 ;   The Ram disk can be installed in drive Slots 0-4. The
 ;pdrive for the Ram Disk will ALWAYS be #4. If we select
 ;Slot 0-3 then the physical drive will select when Slot 4
 ;is requested
 ;  THIS MEANS THAT WE WILL HAVE 5 DRIVES POSSIBLE ONLINE
 ;
 ;  This Version for the HD64180 moves 1 byte at a time.
 ;Next update will include a buffer area for moving 256
 ;bytes at a time as an option. The Model 4/4P  use Hi 
 ;memory and I HATE to loose memory unless the benifit
 ;is great. The HD64180 would be most efficent using the
 ;DMA controller however, I didn't want to loose possible
 ;compatability for "Ramdisk boards".
 ; Thus each sector is read to and from the buffer 1 byte
 ;at a time. That is for each byte read/written a memory
 ;map switch must take place. Ramdisk I/O speed can be
 ;dramatically increased at a cost of 256 bytes of himem
 ;on the model 4/4P ( A full Buffer option will be added 
 ;later as a option )
 ;
 ;  The Routine CALPAGE does the Page Calculating so any
 ;combination of port decoded ram & MMU ram controlled by
 ;the HD64180 can be used.
 ;
 ; Non Corvus:
 ;   Several patch areas were nessary because of the way 
 ;SYS6/SYS operates. In all patches a test for the current
 ;drive is made. If it is the Ramdisk and SYS6 is resident
 ;and we have not patched SYS6 yet, then we patch in some
 ;bytes for FORMAT. Patch 1,2 are basically to detect if
 ;the Ramdisk is to be POWERED UP and or SELECTED. Patch
 ;3 is th actual Sector Read/Write. Patch 4 & 5 is for
 ;swaped drives. If we install the Ramdisk at drive 1 then
 ;the physical drive 1 becomes drive 4 so we don't have to
 ;give up a drive slot. Patch 6 is mainly for SYS6/SYS in
 ;case we got an error condition and exit Via 4409H. The
 ;purpose is to reset the Patch Flag (SYS6FLG). Once we 
 ;patch SYS6/SYS we don't want any drive selects to 
 ;repatch SYS6/SYS because SYS6/SYS calls other SYS 
 ;modules that overlay SYS6 in the normal overlay area.
 ;
 ; Corvus:
 ; PDRIVE/DAT Contains the Pdrive Values for The Ramdisk
 ;
 ;                  Operators Instructions
 ;
 ; Pdrive #4 will Always be the Defination for the Ramdisk
 ; There is a check for the Maximun # of sectors so you 
 ;cant write over the Rom image in the Model 4/4P
 ;
 ; To install type " RamDisk Dn " where dn = Drive #
 ; Once installed the Ramdisk will operate like the Floppy
 ;disk drives. You Must format it to use it.
 ; Format dn,,,,ndmw
 ; To remount the ramdisk as another drive at any time
 ;type Ramdisk dn
 ;
 ; Legal slots for the Ramdisk = 1to4
 ;
 ; When the Ramdisk is mounted over an existing drive the
 ;physical drive will become Drive #4
 ;
 ; If you want to change the Pdrive for Slot # 4 then
 ;you MUST reinstall the Ramdisk.
 ;
 ;*******************************************************
 ;		Equates for Each Type Machine
 ;
 	IF	LNW ; Team Model 1 Compatable
 ;********************************************************
 ;		LNW TEAM - With HD64180/Z80H
 ;********************************************************
 PATAD0	EQU	47EDH 	; Patch address for Patch 1
 ;
 PATAD1	EQU	4776H 	; Patch address for Patch 1
 PATAD1A	EQU	PATAD1+1
 ;
 PATAD2	EQU	47ADH	; Patch address for Patch 2
 PATAD2A	EQU	PATAD2+1
 ;
 PATAD3	EQU	465CH	; Patch address for Patch 3
 ;
 PATAD4	EQU	47A3H	; Patch address for Patch 4
 PATAD4A	EQU	PATAD4+1
 ;
 PATAD5	EQU 	4798H	; Patch address for Patch 5
 PATAD5A	EQU	PATAD5+1
 ;
 PATAD6	EQU	4409H	; patch address for Patch 6
 PATAD6A	EQU	PATAD6+1
 ;
 SYAL	EQU	477AH	; System AL Option - Max Drives
 SYAL1	EQU	439FH	; System - Max # Drive searched
 ;
 CURDRV	EQU	4308H	; Current drive selected
 CURDCMD	EQU	4309H	; Current FDC Select Bits 1-2-4-8
 ;
 CONFLG1	EQU	4369H	; Condition Flags - Debug/Overlay
 ;				Ect.
 SYS6ID	EQU	4D09H	; Byte ID to Check if SYS6 
 ;			  Overlayed its self.
 ;
 SY6BF	EQU	6886H	; System 6 Bypass format Patch 
 ;
 PAT0RCM	EQU	4776H	; Patch 0 End Replace command
 PAT1END	EQU	4779H	; Patch 1 Replaced Command
 PAT2END	EQU	47DDH	; Patch 2 End Jump address
 PAT3END	EQU	4773H	; Patch 3 End Jump address
 PAT3CON	EQU	471DH	; Patch 3 Continue address
 PAT6END	EQU	440CH	; Patch 6 End Jump address
 ;
 P6REPCM	EQU	4C1EH	; Patch 6 Replaced cmd Address
 DIRLMP	EQU	430AH	; Directory Starting Lump for
 ;			  Current Drive
 DIRGRN	EQU	430FH	; Grans/Lump Value for Current
 ;			  Drive
 PDRTBL	EQU	4371H	; Address of Pdrive Table Drive 1
 ;
 PDRADD	EQU	4399H	; Address of current Pdrive
 ;
 CURFDC	EQU	46C4H	; Current FDC cmd 
 LDRV0TK	EQU	4300H	; Last track Accessed by Drive 0
 LDRV4TK	EQU	4304H	; Last track Accessed by Drive 4
 ;
 ;******************************************************
 	ENIF
 ;
 	IF	MOD4
 ;********************************************************
 ;		Model 4 - 128K Ram
 ;********************************************************
 PATAD0	EQU	4792H 	; Patch address for Patch 1
 ;
 PATAD1	EQU	4723H 	; Patch address for Patch 1
 PATAD1A	EQU	PATAD1+1
 ;
 PATAD2	EQU	475EH	; Patch address for Patch 2
 PATAD2A	EQU	PATAD2+1
 ;
 PATAD3	EQU	4607H	; Patch address for Patch 3
 ;
 PATAD4	EQU	4754H	; Patch address for Patch 4
 PATAD4A	EQU	PATAD4+1
 ;
 PATAD5	EQU 	4749H	; Patch address for Patch 5
 PATAD5A	EQU	PATAD5+1
 ;
 PATAD6	EQU	4409H	; patch address for Patch 6
 PATAD6A	EQU	PATAD6+1
 ;
 SYAL	EQU	4727H	; System AL Option - Max Drives
 SYAL1	EQU	42BFH	; System - Max # Drive searched
 ;
 CURDRV	EQU	427EH	; Current drive selected
 CURDCMD	EQU	427FH	; Current FDC Select Bits 1-2-4-8
 ;
 CONFLG1	EQU	4289H	; Condition Flags - Debug/Overlay
 ;				Ect.
 SYS6ID	EQU	4D09H	; Byte ID to Check if SYS6 
 ;			  Overlayed its self.
 ;
 SY6BF	EQU	6888H	; System 6 Bypass format Patch 
 ;
 PAT0RCM	EQU	4723H	; Patch 0 End Replace command
 PAT1END	EQU	4726H	; Patch 1 Replaced Command
 PAT2END	EQU	4783H	; Patch 2 End Jump address
 PAT3END	EQU	4720H	; Patch 3 End Jump address
 PAT3CON	EQU	46CDH	; Patch 3 Continue address
 PAT6END	EQU	440CH	; Patch 6 End Jump address
 ;
 P6REPCM	EQU	4289H	; Patch 6 Replaced cmd Address
 ;
 DIRLMP	EQU	4280H	; Directory Starting Lump for
 ;			  Current Drive
 DIRGRN	EQU	4285H	; Grans/Lump Value for Current
 ;			  Drive
 PDRTBL	EQU	4291H	; Address of Pdrive Table Drive 1
 ;
 PDRADD	EQU	42B9H	; Address of current Pdrive
 ;
 CURFDC	EQU	4687H	; Current FDC cmd 
 LDRV0TK	EQU	4276H	; Last track Accessed by Drive 0
 LDRV4TK	EQU	4279H	; Last track Accessed by Drive 4
 ;
 LDDE	EQU 	5BEDH	; LD DE,(XX) - OPCODE
 LDIX	EQU	2ADDH	; LD IX,(XX) - OPCODE
 STHL	EQU 	22H	; LD (XX),HL - OPCODE
 ;
 HIMEM	EQU	4411H	; HIMEM FOR MODIII/IV
 PORTMSK	EQU	4CFFH	; PORT MASK of Port 84H
 ;
 ;******************************************************
 	ENIF
 ;
