       ; MULT3V1/ASM - HD64180 256K RAM - MULTIPLE DOS PROGRAM
 ;               Model 4/4P Version - NewDos/80
 ;		CREATS 3 COMPLETELY SEPERATE DOS'S
 ;		CONTROLLED BY F2 KEY
 ;
 ;		UPDATED 12/17/86
 ;********************************************************
 ;
 	ORG	7000H
 ;********************************************************
 ;		Equates
 LDFHL	EQU	22H	; LD (ADDR),HL
 LDTHL	EQU	2AH	; LD HL,(ADDR)
 KBYDVR	EQU	4016H	; KEYBOARD DCB ADDRESS
 ;
 CPAGE0	EQU	0	; Bank Area 1 Dos Page 0
 ;			  0000H
 CPAGE1	EQU	0CH	; Bank Area 1 Dos Page 1
 ;			  C000H
 CPAGE2	EQU	18H	; Bank Area 1 Dos Page 2
 ;			  18000H
 CPAGE3	EQU	24H	; Bank Area 1 Dos Page 3
 ;			  24000H
 CSCRN	EQU	30H	; Bank Area 1 Screen Pages
 ;			  30000H
 ;		Memory Management Unit
 CBR	EQU	38H	; MMU Common base register
 BBR	EQU	39H	; MMU Bank Area registere
 CBAR	EQU	3AH	; MMU Common/Bank area register
 ;
 ;		Direct Memory Access Registers
 SAROL	EQU	20H	; DMA Source Address Reg. Ch OL
 SAROH	EQU	21H	; DMA Source Address Reg. Ch OH
 SAROB	EQU	22H	; DMA Source Address Reg. Ch OB
 ;
 DAROL	EQU	23H	; DMA Dest. Address Reg. Ch OL
 DAROH	EQU	24H	; DMA Dest. Address Reg. Ch OH
 DAROB	EQU	25H	; DMA Dest. Address Reg. Ch OB
 ;
 BCROL	EQU	26H	; DMA Byte Count Reg. Ch OL
 BCROH	EQU	27H	; DMA Byte Count Reg. Ch OH
 ;
 DSTAT	EQU	30H	; DMA Status Register
 DMODE	EQU	31H	; DMA Mode Control Register
 DMAWAIT	EQU	32H	; DMA/WAIT Control Register
 ;
 ;********************************************************
 ;		Check for HD64180
 ;
 START  	DEFB	0EDH,38H,18H ; HD64180 INO (18H),A
 	DEFB	3H	     ; IF HD64180 THEN INC BC
 	JP	HD64	; HD64180 SYSTEM
 ;
 	JP	Z80	; Z80 SYSTEM
 ;
 ;
 ;
 Z80	LD	HL,MTYPEER
 	CALL	4467H	; DISPLAY ERROR
 	JP	402DH
 MTYPEER	DEFM	'***** Sorry this MUST be a HD64180 Processor to run this PGM',0DH
 ;
 ;********************************************************
 PAGE	DEFB	0	; CURRENT DOS PAGE
 ;********************************************************
 ;		Init Routine
 HD64	LD	A,(HL)		; CHECK IF NO INIT CMD
 	CP	0DH		; EOL
 	JR	Z,HD64A		; GO IF EOL
     	LD	A,10		; DON'T INIT
      	LD	(INTFLG),A	; SET INIT FLAG FOR DMA
 	LD	HL,MESNOIN
 	CALL	4467H
 HD64A	LD	HL,(KBYDVR)	; GET KEY BOARD DRIVER
 	LD	(KBYDVR1),HL	; SAVE IT
 	LD	HL,KBYF1	; DRIVER FOR F1 KEY
 	LD	(KBYDVR),HL	; STORE IT
 ;
 ;		NOW SETUP MMU
 ;
 ; ;---------------;
 ; ; COMMON AREA 1 ;
 ; ; F000H-FFFFH   ;
 ; ;---------------;
 ; ;  BANK AREA    ;
 ; ; 4000H-EFFFH   ;
 ; ;---------------;
 ; ; COMMON AREA 0 ;
 ; ;    0-3FFFH    ;
 ; ;---------------;
      	LD	A,244		; CBAR VALUE 
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	CBAR	; PORT 3AH CBAR OF MMU
 ;
 ;	Enable Extra Memory in the Model 4/4P
 	IN	A,(148)
 	SET	7,A		; Setup MMU Access
 	OUT	(148),A
 ;
 ;	Setup Himem
 	LD	HL,HIMEM
 	CALL	4419H		; Let Dos do it...DOSCALL
 ;
 ;
 	LD	HL,MESINT	; DISPLAY MESSAGE
 	CALL	4467H
 	JP	402DH
 MESINT	DEFM	'***** Press F1 Key to start *****',0DH
 MESNOIN	DEFM	'***** No Memory Initalization *****',0DH
 HIMEM	DEFM	'HIMEM 0EFFFH',0DH
 ;
 ;
 ;*****************************************************
 ;	Get Dos Choice then Execute
 ;		Save Stack
 CHOICE	LD	A,(PAGE)	; WHAT IS THIS PAGE
 	LD	HL,STACK0	; IS 0 ?
 	CP	0
 	CALL	Z,SAVESTK
 	LD	HL,STACK1
 	CP	1
 	CALL	Z,SAVESTK
 	LD	HL,STACK2
 	CP	2
 	CALL	Z,SAVESTK
 	LD	HL,STACK3
 	CP	3
 	CALL	Z,SAVESTK
 ;
 ;********************************************************
 ;		SAVE SCREEN
 ;
 	LD	A,(PAGE)	; WHAT IS THIS PAGE
 	LD	DE,SCREEN0	; IS 0 ?
 	CP	0
 	CALL	Z,SAVESC
 	LD	DE,SCREEN1
 	CP	1
 	CALL	Z,SAVESC
 	LD	DE,SCREEN2  
 	CP	2
 	CALL	Z,SAVESC
 	LD	DE,SCREEN3  
 	CP	3
 	CALL	Z,SAVESC
 ;
 CHO1	CALL	01C9H		; CLS
 	LD	HL,MESCHO1
 	CALL	4467H		; DISPLAY IT
 ;
 	CALL	049H		; GET NEW PAGE #
 	SUB	48 		; CONVERT TO BIN
 	LD	(PAGE),A	; SAVE NEW PAGE #
 ;
 	LD	HL,STACK0	; PAGE 0
 	LD	DE,SCREEN0	; SCREEN ADDERSS
 	LD	B,CPAGE0	; OFFSET * 4K
 	CP	0
 	JP	Z,SETPAGE	; DO IT
 ;
 	LD	HL,STACK1	; PAGE 1
 	LD	DE,SCREEN1	; SCREEN ADDERSS
 	LD	B,CPAGE1	; OFFSET * 4K
 	CP	1
 	JP	Z,SETPAGE 	; DO IT
 ;
 	LD	HL,STACK2	; PAGE 2
 	LD	DE,SCREEN2  	; SCREEN ADDERSS
 	LD	B,CPAGE2		; OFFSET * 4K
 	CP	2
 	JP	Z,SETPAGE	; DO IT
 ;
 	LD	HL,STACK3	; PAGE 3
 	LD	DE,SCREEN3  	; SCREEN ADDERSS
 	LD	B,CPAGE3	; OFFSET * 4K
 	CP	3
 	JP	Z,SETPAGE	; DO IT
 	JP	CHO1		; WRONG KEY
 ;
 SETPAGE	CALL	RESTSTK		; RESTORE STACKx to STACK
 	EX	DE,HL		; MOVE DE TO HL
 	PUSH	BC
 	CALL	RESTSC		; RESTORE SCREEN
 	POP	BC
 	LD	A,B		; GET BBR VALUE
 	RET
 ;
 ;********************************************************
 ;		SAVE STACK TO STACKx
 ;	Enter	HL=Address of correct STACK
 SAVESTK	LD	(SAVC1),HL	; PUT LOC IN MEM
 	LD	HL,(STACK)
 	DEFB	LDFHL
 SAVC1	DEFS	2		; LD (SAVC1),HL
 	RET
 ;********************************************************
 ;		RESTORE STACKx to STACK
 ;	Enter	HL=Address of correct STACKx
 RESTSTK	LD	(SAVC2),HL
 	DEFB	LDTHL		; LD HL,(SAVC2)
 SAVC2	DEFS	2
 	LD	(STACK),HL
 	RET
 ;********************************************************
 ;		Save Screen Routine
 ;	Enter DE=Address of correct storage area
 SAVESC	LD	(SCRN1),DE	; PUT LOC IN MEM
 	PUSH	DE
 	LD	DE,(4020H)	; CURSER
 	DEFB	0EDH		; LD (SCRN1),DE
 	DEFB	53H		; SECOND BYTE OP-CODE
 SCRN1	DEFS	2		; LD (SCRN1),DE
 	POP	DE
 	INC	DE
 	INC	DE		; BUMP PAST CURSER
       	LD	HL,3C00H	; START OF VIDEO
 	LD	BC,1023
 	LDIR
 	LD	A,10		; NULL SCREENS
 	RET
 ;******************************************************
 ;		Restore Screen Routine
 ;	Enter	HL=Address of Correct Screen
 RESTSC 	LD	(SCRN2),HL
 	PUSH	HL
 	DEFB	LDTHL		; LD HL,(SCRN2)
 SCRN2	DEFS	2
 	LD	(4020H),HL	; CURSER
 	POP	HL
 	INC	HL
 	INC	HL		; BUMP PAST CURSER
       	LD	DE,3C00H	; START OF VIDEO
 	LD	BC,1023
 	LDIR
 	RET
 ;******************************************************
 ;
 ;
 ;********************************************************
 ;		DMA INIT ROUTINE
 ;
 ;
 DOSINT	LD	HL,DMATBL1	; START OF INIT TABLE
 	CALL	DMA
 	LD	HL,DMATBL2
 	CALL	DMA
 	LD	HL,DMATBL3
 	CALL	DMA
 	LD	HL,DMATBL4	; PROGRAM EXEC AREA
 	CALL	DMA
 	LD	A,10
 	LD	(INTFLG),A	; RESET INIT FLAG
 ; SETUP STACKS
 	LD	HL,STACK1
 	CALL	SAVESTK
 	LD	HL,STACK2
 	CALL	SAVESTK
 	LD	HL,STACK3
 	CALL	SAVESTK
 ; SETUP SCREENS
 	LD	A,CSCRN	; SCREEN SAVE AREA 34000H
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	BBR	; PORT 38H BBR OF MMU
 ;
 	LD	DE,SCREEN1
 	CALL	SAVESC
 	LD	DE,SCREEN2  
 	CALL	SAVESC
 	LD	DE,SCREEN3  
 	CALL	SAVESC
 ;
 	RET
 ;
 ;********************************************************
 DMA	LD	C,SAROL		; SOURCE LOW/HIGH  BYTE
 	LD	B,6		; 8 REGS TO LOAD
 OTIMR	DEFB	0EDH		; OTIMR I/O INSTRUCTION
 	DEFB	93H
 ;
 	LD	A,0 		; DE 0 BIT
 	DEFB	0EDH		; OUTO (m),g
 	DEFB	39H
 	DEFB	31H		; PORT 31H DMODE
 ; NOW SETUP BYTE COUNT
 	LD	HL,DMABCR 	; START OF BCR
 	LD	C,BCROL		; SOURCE LOW BYTE
 	LD	B,2		; 8 REGS TO LOAD
      	DEFB	0EDH		; OTIMR I/O INSTRUCTION
 	DEFB	93H
 ;
 ;
 ; OK NOW LET DO IT
 	LD	A,64		; DE 0 BIT
 	DEFB	0EDH		; OUTO (m),g
 	DEFB	39H
 	DEFB	30H		; PORT 30H
 ;
 ; NOW WAIT FOR COMPLETION OF DMA MOVE
 DMAWT	DEFB	0EDH		; INO g,(m)
 	DEFB	38H
 	DEFB	30H		; PORT 30H
 ;
 	BIT	6,A		; DONE ?
 	JR	NZ,DMAWT	; NOT YET
 ;
 	RET			; DONE
 ;********************************************************
 DMATBL1	DEFB	00	; 0E00H LSB MSB HSB SAROL
 	DEFB	40H
 	DEFB	0
 ;
 	DEFB	00	; DAROL
 	DEFB	00 
 	DEFB	1	; 10000H
 ;
 DMATBL2	DEFB	00	; 0E00H LSB MSB HSB SAROL
 	DEFB	40H
 	DEFB	0
 ;
 	DEFB	00	; DAROL
 	DEFB	0C0H
 	DEFB	1	; 1C000H
 ;
 DMATBL3	DEFB	00	; 0E00H LSB MSB HSB SAROL
 	DEFB	40H
 	DEFB	0
 ;
 	DEFB	00	; DAROL
 	DEFB	80H
 	DEFB	2	; 28000H
 ;
 DMATBL4	DEFB	00	; 0E00H LSB MSB HSB SAROL
 	DEFB	40H
 	DEFB	0
 ;
 	DEFB	00	; DAROL
 	DEFB	40H
 	DEFB	3	; 34000H
 ;
 DMABCR	DEFB	0FFH	; 45055 BYTES OR AFFFH
 	DEFB	0AFH
 ;
 ;
 ;*******************************************************
 ;		MESSAGES
 MESCHO1	DEFB	26,26,26,26,26,26
 	DEFM	'Enter Dos Page # 0-3 ',03H
 ;
 ;********************************************************
 ;		Screen Storage Area
 ;
 SCREEN0	DEFS	1030	; Save area 0
 SCREEN1	DEFS	1030	; Save area 1
 SCREEN2	DEFS	1030	; Save area 2
 SCREEN3	DEFS	1030	; Save area 3
 	NOP 
 ;
 ;
 ;
 ;********************************************************
 ;********************************************************
 	ORG	0F000H
 ;********************************************************
  	DEFS	10	; SAFETY
 INTFLG	DEFB	0	; INIT FLAG FOR STARTUP
 STACK	DEFS	2	; TEMP STACK POINTER
 STACK0	DEFS	2	; PAGE 0 STACK
 STACK1	DEFS	2	; PAGE 1 SATCK
 STACK2	DEFS	2	; PAGE 2 STACK
 STACK3	DEFS	2	; PAGE 3 SATCK
 ;		KEYBOARD DRIVER
 ;
 KBYF1 	DEFB	0CDH		; CALL
 KBYDVR1	DEFS	2		; 2 BYTE ADDRESS
 	CP	27		; F2 KEY
 	JR	NZ,KBYF1A		; GO IF NOT
 	CALL	PGMCTL	; CALL PROGRAM CONTROL 
 	LD	A,0	; NULL KEY
 KBYF1A	RET		; RETURN
 ;
 PGMCTL	DI
 ;**************** SAVE ALL REGS *********************
 	PUSH	AF
 	PUSH	BC
 	PUSH	HL
 	PUSH	DE
 	EXX
 	PUSH	AF
 	PUSH	BC
 	PUSH	HL
 	PUSH	DE
 	PUSH	IX
 	PUSH	IY
 ;
 	LD	(STACK),SP	; SAVE CURRENT STACK
 ;
      	LD	BC,5000H	; WAIT VALUE
 PGMWT	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,PGMWT
 ;
 PGMCTL1	LD	A,(14591)	; FAT FINGER TEST
 	CP	0
 	JR	NZ,PGMCTL1
 ;
 ;********************************************************
 	LD	A,(INTFLG)	; CHECK IF INIT IS NEEDED
 	CP	0
 	CALL	Z,DOSINT	; GO DO IT
 ;
 ;		  ADDRESS FOR COMMON BASE 1 OFFSET
 ;********************************************************
 	LD	A,CSCRN		; 30000H
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	BBR	; PORT 39H BBR OF MMU
 ;		  ADDRESS FOR BANK AREA 1 OFFSET
 	CALL	CHOICE		; GET DOS CHOICE
 ;		 A=CORRECT MMU BBR VALUE
 ;********************************************************
 	DEFB	0EDH	; OPCODE  OUTO (m),g
 	DEFB	39H
 	DEFB	BBR	; PORT 38H BBR OF MMU
 ;		  ADDRESS FOR COMMON BASE 1 OFFSET
      	LD	BC,5000H	; WAIT VALUE
 PGMWT1	DEC	BC
 	LD	A,B
 	OR	C
 	JR	NZ,PGMWT1
 ;
 PGMCTL2	LD	A,(14591)	; FAT FINGER TEST
 	CP	0
 	JR	NZ,PGMCTL2
 ;
 ;********************************************************
 	LD	SP,(STACK)	; RESTORE STACK
 	POP	IY
 	POP	IX
 	POP	DE
 	POP	HL
 	POP	BC
 	POP	AF
 	EXX
 	POP	DE
 	POP	HL
 	POP	BC
 	POP	AF
 ;
 	EI
 ;      	LD	HL,MESF1
 ;	CALL	4467H
 	RET
 ;
 MESF1	DEFM	'*** F2 PRESSED ***',0DH
 	END	START
