	TITLE	<ROMSAVE/ASM>
*GET	EQUATE51/ASM
BOOT	EQU	0		; start of ROM
LENGTH	EQU	3800H		; length of ROM
;


	ORG	5200H
START	PUSH	HL		; save command line
	LD	HL,HELLO$	; set up opening display
	LD	A,(0125H)	; check for Model III mode
	CP	'I'
	JR	Z,MODEL3
	LD	A,LF		; set up error message
	LD	(MODERR$),A
	RST	40
	POP	HL		; restore stack
	RET
;
MODEL3	CALL	@DSPLY		; greet world
	POP	HL		; rec command line
	LD	A,(HL)		; examine 1st char
	CP	':'		; possible drivespec?
	JR	Z,DSPEC
	CP	CR		; got ANYTHING?
	JR	Z,KEY		; go if not
FSPEC	LD	DE,FCB		; try for a filespec
	CALL	@FSPEC		; xfer to FCB
	JR	NZ,ERROR	; quit on error
	LD	HL,EXT$		; append default extension
	CALL	@FEXT		; if none specified
	JR	KEY		; go try it
;
DSPEC	CALL	SETDRV		; process drivespec into fcb
	LD	A,32		; ret "illegal drivespec"
	JR	C,ERROR		;  on error
KEY	LD	HL,PROMPT$	; dsply prompt
	CALL	@DSPLY
	LD	HL,ENTER$
	CALL	@DSPLY
	LD	B,0		; get keystroke
	CALL	@KEYIN
	JP	C,@ABORT
	LD	HL,WRITE$	; dsply "Writing..."
	CALL	@DSPLY
	LD	HL,BOOT		; point to start of memory
	LD	DE,FCB		; open data file
	LD	B,L
	CALL	@INIT
	JR	NZ,ERROR
;
;	write a sector for each page of ROM
	PUSH	DE		; index the DCB buffer
	POP	IY
	LD	C,.HIGH.LENGTH	; p/u record count
	DEC	C		; adj for zero offset
	CALL	@POSN		; position to ERN, ignore error
	CALL	@WRITE		; write dummy sector
	JR	NZ,ERROR
	CALL	@REW		; rewind file
	JR	NZ,ERROR
	LD	HL,0		; set ERN to zero
	LD	(FCB+12),HL
;
WRITE	CALL	@WRITE		; write a sector
	JR	NZ,ERROR
	INC	(IY+4)		; bump buffer msb
	LD	A,(IY+4)	; loop till done
	CP	.HIGH.LENGTH
	JR	NZ,WRITE
;
;	close file and exit
	CALL	@CLOSE		; close file
	JR	NZ,ERROR
	LD	HL,DONE$	; dsply exit message
	CALL	@DSPLY
	JP	@EXIT
;
ERROR	LD	L,A		; error into HL
	LD	H,0
	CP	27		; disk full error?
	JR	NZ,ERR
	CALL	@KILL		; remove what won't fit
	LD	A,L		; p/u error code
ERR	OR	40H		; set short error message
	JP	@ERROR
;
;	get drivespec from c/l, stuff FCB if valid
SETDRV	INC	HL		; bump c/l pointer
	LD	A,(HL)		; get drivespec
	CP	'0'		; range check
	RET	C
	CP	'8'
	CCF
	RET	C
	PUSH	AF		; save spec
	LD	HL,FCB		; p/u fcb
$SD1	LD	A,(HL)		; p/u fcb char
	INC	HL
	CP	'/'		; skip extension and
	JR	Z,$SD1		; password delimiters
	CP	'.'
	JR	Z,$SD1
	CP	':'		; got dspec delimiter?
	JR	Z,$SD2
	CP	' '		; got control char?
	JR	NC,$SD1
	DEC	HL		; b/u pointer
	LD	(HL),':'	; stuff delimiter
	INC	HL
$SD2	POP	AF		; recover dspec
	LD	(HL),A		; stuff dspec
	INC	HL
	LD	(HL),ETX	; stuff etx
	OR	A
	RET
;
HELLO$	DB	28,31,'ROMSAVE 1.1a - '
	DB	'Model III ROM Image Quick Save Utility for 4P',LF
	DB	'(c) 1989 Robert A. Haynes, Somerville, MA 02143',LF
MODERR$	DB	CR,'Please run ROMSAVE only from LDOS 5.x in Model III mode!'
	DB	CR
ENTER$	DB	' ...',LF,LF,'Press <ENTER> to continue, <BREAK> to abort. ',3
EXT$	DB	'DAT'
WRITE$	DB	LF,'Writing...  ',3
DONE$	DB	'Done.',CR
PROMPT$	DB	'Preparing to write '
FCB	DB	'ROM/DAT',3
	END	START
