	TITLE	<ROMLOAD/ASM>
*GET	EQUATE63/ASM		; standard 6.3 and ascii equates here
;				; plus definition of SVC macro
BOOT	EQU	0000H		; start of ROM image
LENGTH	EQU	3800H		; length of ROM image
@DSPLY3	EQU	4467H		; LDOS 5.x @dsply function
@ABORT3	EQU	4030H		; LDOS 5.x @abort function
TEST	EQU	0125H		; Model III ROM test location
;
	ORG	5200H
START	PUSH	HL		; save command line
	LD	HL,HELLO$	; set up opening display
	LD	A,(TEST)	; check for Model III mode
	CP	'I'
	JR	NZ,MODEL4
	LD	A,LF		; set up error message
	LD	(MODERR$),A
	CALL	@DSPLY3
	POP	HL		; restore stack
	JP	@ABORT3		; abort to LDOS Ready
;
MODEL4	SVC	@DSPLY
	LD	HL,0		; get high$
	LD	B,L
	SVC	@HIGH$
	LD	DE,BUFFER+LENGTH ; test high$ lower limit
	OR	A
	SBC	HL,DE
	POP	HL		; rec command line
	JP	C,NOMEM
	LD	A,(HL)		; examine 1st char
	CP	':'		; possible drivespec?
	JR	Z,DSPEC
	CP	CR		; got ANYTHING?
	JR	Z,OPEN		; go if not
FSPEC	LD	DE,FCB		; try for a filespec
	SVC	@FSPEC		; xfer to FCB
	JR	NZ,ERROR	; quit on error
	LD	HL,EXT$		; append default extension
	SVC	@FEXT		; if none specified
	JR	OPEN		; go try it
;
DSPEC	CALL	SETDRV		; process drivespec into fcb
	LD	A,32		; ret "illegal drivespec"
	JR	C,ERROR		;  on error
OPEN	SVC	@FLAGS		; force read-only
	SET	0,(IY+'S'-'A')
	LD	HL,LOAD1$	; display load message
	SVC	@DSPLY
	LD	HL,LOAD2$
	SVC	@DSPLY
	LD	HL,BUFFER	; find and open file
	LD	DE,FCB
	LD	B,0
	SVC	@OPEN
	JR	NZ,ERROR
	PUSH	DE		; IY => FCB
	POP	IY
READ	SVC	@READ		; read a sector
	JR	NZ,EOF		; exit on error
	INC	(IY+4)		; bump buffer msb
	JR	READ		; read whole file to buffer
;
EOF	CP	28		; eof found?
	JR	NZ,ERROR
	LD	HL,INSERT$	; dsply instructions
	SVC	@DSPLY
KEY	SVC	@KEY		; get response
	CP	80H		; got BREAK?
	JR	Z,BREAK
	CP	82H		; got F2?
	JR	NZ,KEY
	SVC	@CLS		; clear screen
	DI			; disable interrupts
	LD	A,1		; set Model III mode 1
	OUT	(84H),A
	LD	HL,BUFFER	; copy buffer to
	LD	DE,BOOT		; 0000-37FFH
	LD	BC,LENGTH
	LDIR
	XOR	A		; set Model III mode 0
	OUT	(84H),A
	JP	BOOT		; jump to ROM image
;
ERROR	CP	24		; file not found?
	JR	Z,NOFILE
	LD	L,A		; set error into HL
	LD	H,0
	OR	40H		; set short message
	LD	C,A		; dsply error
	SVC	@ERROR
;
NOFILE	LD	HL,FCB		; dsply filespec
	SVC	@DSPLY
	LD	HL,NOFILE$	; and "no file" error
	DB	0DDH
BREAK	LD	HL,BREAK$	; dsply BREAK error
	DB	0DDH
NOMEM	LD	HL,NOMEM$	; dsply no memory error
	SVC	@DSPLY
	SVC	@ABORT
;
;	get drivespec from c/l, stuff FCB if valid
SETDRV	INC	HL		; bump c/l pointer
	LD	A,(HL)		; get drivespec
	CP	'0'		; range check
	RET	C
	CP	'8'
	CCF
	RET	C
	PUSH	AF		; save spec
	LD	HL,FCB		; p/u fcb
$SD1	LD	A,(HL)		; p/u fcb char
	INC	HL
	CP	'/'		; skip extension and
	JR	Z,$SD1		; password delimiters
	CP	'.'
	JR	Z,$SD1
	CP	':'		; got dspec delimiter?
	JR	Z,$SD2
	CP	' '		; got control char?
	JR	NC,$SD1
	DEC	HL		; b/u pointer
	LD	(HL),':'	; stuff delimiter
	INC	HL
$SD2	POP	AF		; recover dspec
	LD	(HL),A		; stuff dspec
	INC	HL
	LD	(HL),ETX	; stuff etx
	OR	A
	RET
;
HELLO$	DB	28,31,'ROMLOAD 1.1a - '
	DB	'Model III ROM Image Quick Load Utility for 4P',LF
	DB	'(c) 1989 Robert A. Haynes, Somerville, MA 02143',LF
MODERR$	DB	CR,'Please run ROMLOAD only from LS-DOS 6.3!',CR
INSERT$	DB	'Insert a Model III Bootable Diskette into Drive :0,',LF
	DB	'press <F2> to reboot, or <BREAK> to abort.',LF,CR
BREAK$	DB	'<BREAK> pressed, program terminated.',CR
NOMEM$	DB	'Insufficient memory available.',CR
NOFILE$	DB	' file was NOT found.    (Incorrect filename?)',LF,LF
	DB	'First boot LDOS 5.x the usual way, and run ROMSAVE under',LF
	DB	'that DOS.  Copy the created image file (the default name is'
	DB	LF
	DB	'ROM/DAT) to a drive that will be available under your LSDOS'
	DB	LF,'configuration, preferably drive :0.  Then ROMLOAD again.'
	DB	CR
EXT$	DB	'DAT'
LOAD2$	DB	' Image File... ',LF,CR
LOAD1$	DB	'Loading '
FCB	DB	'ROM/DAT',3
	DS	24
BUFFER	EQU	.HIGH.$+1.SHL.8
	END	START
