;TYPER - a PROWAM application allowing direct access to the system printer
;
;	by Scott A. Loomer, 12 March 1985
;	with over-the-shoulder-assistance from Karl Hessinger
;
;	demos a very simple PROWAM application
;
;	Use: when invoked, type what you want (<80 chars) and upon
;	hitting RETURN, it is sent to the printer. Import is supported,
;	so you can mark a block of text and the entire block is	printed.
;
@WKEYIN	EQU	0
@WCREAT	EQU	7
@WCLOSE	EQU	8
@WDSP	EQU	9
@PRINT	EQU	14
@SOUND	EQU	104
@WINDOW	EQU	124
;*=*=*
;	Establish macro
;*=*=*
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	40
	ENDM
;
	OPTION	CI		;PRO-NTO applications are core image
;
;*=*=*
;	The following is the header protocol
;*=*=*
	ORG	2700H		;Forces START to 2800H
	DB	'PROWAM'
	DB	'Typewriter  ',3
	DC	13,0
	DW	IROW,ICOL
	DC	.HIGH.$.SHL.8-$+256-32,0
	DC	32,' '
;*=*=*
;	This is where the program starts
;*=*=*
	IFNE	$,2800H
	ERR	'Something is wrong in the header
	ENDIF
START	LD	B,@WCREAT	;Function to open a window
	LD	HL,16.SHL.8+0	;Origin NW corner at row 16, col 0
IROW	EQU	$-1
ICOL	EQU	$-2
	LD	DE,2.SHL.8+80	;Window to have 2 rows, 80 columns
	SVC	@WINDOW
	JR	Z,OK		;Go if we were able to open it
	LD	B,00.SHL.4+02	;No good, set up parms for beep
	SVC	@SOUND		;Beep the speaker and return
	RET
;*=*=*
;	Window opened, proceed to accept lines until BREAK
;*=*=*
OK	LD	HL,BUFFER	;Point to key buffer
	LD	BC,@WKEYIN.SHL.8+79
	SVC	@WINDOW		;Accept keyin of up to 79 chars
	JR	NC,OK2		;Go if not BREAK or EXPORT
	LD	B,@WCLOSE	;Close the window (reg C will
	SVC	@WINDOW		;  be set for BREAK or EXPORT code
	RET
;*=*=*
;	Print the line entered
;*=*=*
OK2	SVC	@PRINT		;HL still points to buffer
	LD	BC,@WDSP.SHL.8+13 ;Display a CR
	SVC	@WINDOW
	JR	OK		;Loop for next line
;*=*=*
;	This is the key buffer
;*=*=*
BUFFER	DS	80
;*=*=*
;	Standard memory overflow check
;*=*=*
	IF	$.GT.3000H		;Check on memory overflow
	ERR	'Memory overflow!!!'
	ENDIF
;*=*=*
;	Zero last sector of application file - patch space
;*=*=*
	IFLT	$,3000H
	DC	.HIGH.$.SHL.8-$+256,0	;Zero remainder of sector
	ENDIF
	END	START			;START must be 2800H
