;PHRASE/ASM - 08/17/87
;*=*=*
;	PHRASE application for accessing a text file of phrases
;	Copyright (c) 1987 MISOSYS, Inc., All rights reserved
;*=*=*
	TITLE	'<Phrase Export>
	OPTION	+CI
*LIST	OFF
ETX	EQU	3
ENTR	EQU	13
CR	EQU	13
UP_ARR	EQU	11
DN_ARR	EQU	10
LT_ARR	EQU	8
SUP_ARR	EQU	1BH
SDN_ARR	EQU	1AH
BUFFER	EQU	2600H
TEXT	EQU	2700H
@CLOSE	EQU	60
@ERROR	EQU	26
@FLAGS	EQU	101
@LOC	EQU	63
@OPEN	EQU	59
@POSN	EQU	66
@READ	EQU	67
@SOUND	EQU	104
@VDCTL	EQU	15
;*=*=*
;	Establish macro
;*=*=*
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	40
	ENDM
*GET	WINDOW/MAC
;*=*=*
;	The following is the header protocol
;*=*=*
	ORG	2700H		;Forces START to 2800H
	DB	'PROWAM'
	DB	'PhraseExport',3
	DC	13,0
	DW	IROW,ICOL
	DC	.HIGH.$.SHL.8-$-48+256,0
	DATE
	TIME
	DB	'Copyright (c) 1987 MISOSYS, Inc.'
*LIST	ON
;*=*=*
;	This is where the program starts
;*=*=*
	IFNE	$,2800H
	ERR	'Something is wrong in the header
	ENDIF
START	LD	(SPSAV),SP
	LD	HL,1.SHL.8+1	;Origin NW corner at row 1, col 1
IROW	EQU	$-1
ICOL	EQU	$-2
	LD	DE,2.SHL.8+78	;Window to have 2 rows, 78 columns
	@WCREAT			;Function to open a window
	JR	Z,OK		;Go if we were able to open it
	LD	B,00.SHL.4+02	;No good, set up parms for beep
	SVC	@SOUND			;Beep the speaker and return
	RET
;*=*=*
;	Window opened, open the data file
;*=*=*
OK	LD	A,3		;Init text area
	LD	(TEXT),A
	LD	HL,'  '
	LD	(MNEMON),HL
	LD	DE,FCB
	LD	HL,BUFFER
	LD	B,L
	SVC	@OPEN
	JR	Z,FIRST
	CP	41		;Accept File already open
	JP	NZ,IOERR
FIRST	CALL	GET1ST
NEXTREC	CALL	GETNEXT
DSPTEXT	LD	HL,0
	@WSCUR
	LD	HL,TEXT
	@WDSPLY
	LD	HL,1.SHL.8.OR.0
	@WSCUR
	LD	HL,$-$		;P/u & display the current mnemonic
MNEMON	EQU	$-2
	LD	C,L
	@WDSP
	LD	C,H
	@WDSP
KEYLP	LD	HL,1.SHL.8.OR.7
	@WSCUR
	LD	BC,0
	@WINDOW			;Get a keystroke
	JP	C,EXITAP	;Exit on BREAK/EXPORT
	PUSH	AF
	OR	0
CLRFLG	EQU	$-1
	JR	Z,KEYLP2
	LD	HL,STATPOS
KEYLP1	LD	C,' '
	@WPOKE
	INC	L
	LD	A,L
	SUB	77+1
	JR	NZ,KEYLP1
	LD	(CLRFLG),A
KEYLP2	POP	AF
	CP	DN_ARR		;Next phrase?
	JR	Z,NEXTREC
	CP	UP_ARR		;Previous phrase?
	JP	Z,PREVREC
	CP	SUP_ARR		;First phrase?
	JR	Z,FIRST
	CP	SDN_ARR		;Last phrase?
	JP	Z,RECEND
	CP	LT_ARR		;Backspace mnemonic?
	JP	Z,BKSPA
	CP	0DH		;Select phrase for export
	JR	Z,ENTER
	CP	' '		;Ignore all other controls
	JR	C,KEYLP
;*=*=*
;	Add a char to the mnemonic string
;*=*=*
	LD	HL,(ALPHA)	;P/u current entry
	INC	L
	DEC	L
	JR	NZ,ALPHA1	;Go if already a first char
	LD	L,A
	PUSH	HL
	LD	HL,1.SHL.8.OR.4
	@WSCUR
	POP	HL
	LD	(ALPHA),HL	;Update user entry
	LD	C,L		;  and display it
	@WDSP
	JR	KEYLP
ALPHA1	LD	H,A		;Find the phrase
	LD	(ALPHA),HL
	CALL	GET1ST
ALPHA2	CALL	GETNEXT
	JR	Z,NOTFND
	LD	HL,(MNEMON)
	LD	DE,$-$
ALPHA	EQU	$-2
	OR	A
	SBC	HL,DE		;Match mnemonic?
	JR	NZ,ALPHA2
ALPHA3	CALL	PUTSPA		;Blank out
	LD	HL,0
	LD	(ALPHA),HL
	JP	DSPTEXT
NOTFND	LD	DE,NOTFND$
	CALL	STATUS
	JR	ALPHA3
;*=*=*
;	Routine to backspace a mnemonic
;*=*=*
BKSPA	LD	HL,(ALPHA)	;P/u current user entry
	INC	L
	DEC	L
	JP	Z,KEYLP		;Ignore if none entered
	LD	L,0
	LD	(ALPHA),HL
	CALL	PUTSPA
	JP	KEYLP
;*=*=*
;	ENTER - Program the export
;*=*=*
ENTER	LD	HL,0.SHL.8+0
	@WSCUR			;Set cursor to 0,0
	LD	B,4		;Get absolute cursor loc'n
	SVC	@VDCTL
	PUSH	HL		;Save upper left
	LD	HL,0.SHL.8+77	;Point to LR
	@WSCUR
LOOP	@WPEEK			;Find last non-blank
	CP	' '
	JR	NZ,GOTCHAR
	DEC	L
	JR	NC,LOOP
	POP	HL
EXITAP0	LD	C,0		;Close and exit
	JR	EXITAP
GOTCHAR	@WSCUR
	LD	B,4
	SVC	@VDCTL		;Get cursor loc'n
	EX	DE,HL
	POP	HL
	LD	C,81H		;Program control export, NOCR
EXITAP	PUSH	DE
	PUSH	BC
	LD	DE,FCB
	SVC	@CLOSE
	POP	BC		;Recover exit condx
	POP	DE
	LD	SP,$-$		;P/u entry stack pointer
SPSAV	EQU	$-2
	@WCLOSE			;Close the window
	RET
;*=*=*
;	Routine to get next phrase
;*=*=*
GETNEXT	LD	HL,BUFFER	;P/u pointer to next buffer char
BUFPTR	EQU	$-2
	LD	A,(HL)		;Get menmonic
	CP	'.'		;End on '.'
	RET	Z
	LD	C,A
	INC	L
	CALL	Z,RDNEXT
	LD	B,(HL)
	LD	(MNEMON),BC
	INC	L
	CALL	Z,RDNEXT
	LD	DE,TEXT
	LD	B,78		;Maximum text length
GETTE1	LD	A,(HL)		;Port the char
	LD	(DE),A
	CP	CR		;End of phrase?
	JR	Z,GETTE3
	INC	L		;Bump to next
	CALL	Z,RDNEXT
	INC	E
	DJNZ	GETTE1		;Loop until max
GETTE2	LD	A,(HL)		;Skip until CR
	CP	CR
	JR	Z,GETTE3
	INC	L
	CALL	Z,RDNEXT
	JR	GETTE2
GETTE3	INC	L
	CALL	Z,RDNEXT
	INC	B
	DEC	B
	JR	Z,GETTE5
GETTE4	LD	A,' '
	LD	(DE),A
	INC	E
	DJNZ	$-2
GETTE5	LD	A,3
	LD	(DE),A
	LD	(BUFPTR),HL
	OR	A		;Set NZ for phrase
	RET
RDNEXT	PUSH	DE
	LD	DE,FCB
	CALL	READ
	POP	DE
	RET
;*=*=*
;	Routine to find previous phrase
;*=*=*
PREVREC	LD	HL,(BUFPTR)	;Get pointer
	LD	B,3
PREVR1	LD	A,L
	DEC	L		;Backup until past 0
	OR	A
	JR	NZ,PREVR2
	CALL	RDPREV		;Read previous sector
	JR	NZ,PREVR3	;Exit if back at start
PREVR2	LD	A,(HL)
	CP	CR		;Look for 3rd previous CR
	JR	NZ,PREVR1
	DJNZ	PREVR1
	INC	L		;Now bump to first mnemonic of
	CALL	Z,RDNEXT	;  desired phrase
	DB	0FEH
PREVR3	INC	L		;Set L=0
	LD	(BUFPTR),HL
	JP	NEXTREC		;Display it
RDPREV	LD	DE,FCB
	PUSH	BC
	SVC	@LOC
	DEC	BC		;If last read the first record
	LD	A,B		;  then don't physically backspace
	OR	C
	JR	Z,RDPREV1
	DEC	BC
	CALL	POSNRD
	POP	BC
	RET
RDPREV1	POP	BC
	INC	A		;Set NZ if already at first record
	RET
;*=*=*
;	Routine to find the last phrase
;*=*=*
RECEND	CALL	GETNEXT		;Get next phrase
	JR	NZ,RECEND
	JP	DSPTEXT
;*=*=*
;	Routine to blank the user entered mnemonic
;*=*=*
PUTSPA	LD	HL,1.SHL.8.OR.4
	@WSCUR
	LD	C,' '
	@WPOKE
	RET
;*=*=*
;	Routine to read a position
;*=*=*
GET1ST	XOR	A
	LD	(BUFPTR),A	;Set to 1st byte
	LD	B,A		;Set to 1st sector
	LD	C,A
POSNRD	LD	DE,FCB
	SVC	@POSN
READ	SVC	@READ
	RET	Z
	PUSH	HL
	LD	HL,BUFFER+254
	LD	(HL),CR
	INC	L
	LD	(HL),'.'
	POP	HL
	CP	29
	RET	Z
	CP	28
	RET	Z
IOERR	LD	HL,EXITAP0
IOERR0	PUSH	HL		;Set RET
	OR	0C0H
	LD	C,A
	SVC	@FLAGS
	SET	7,(IY+'C'-'A')	;Get error message
	LD	DE,IOERR$+1	;  into a buffer
	SVC	@ERROR		;  past the 1EH
	LD	H,D		;Replace the CR with ETX
	LD	L,E
	LD	A,CR
	LD	B,A		;Make BC large
	CPIR			;Has to find it!!!
	DEC	HL		;Point to the CR
	LD	(HL),3
	LD	DE,IOERR$
	CALL	STATUS
	LD	B,0		;Accept only <ENTER>
	@WKEYIN
	RET
;*=*=*
;	Routine to display status
;*=*=*
STATPOS	EQU	1.SHL.8.OR.10
STATUS	LD	HL,STATPOS
	PUSH	DE
	@WSCUR
	POP	HL
	@WDSPLY
	RET
;*=*=*
;	This is the text buffer
;*=*=*
FCB	DB	'PHRASE/TXT',CR
	DC	32-11,' '
IOERR$	DB	1EH
NOTFND$	DB	'Phrase not found!',ETX
;*=*=*
;	Standard memory overflow check
;*=*=*
	IF	$.GT.3000H		;Check on memory overflow
	ERR	'Memory overflow!!!'
	ENDIF
;*=*=*
;	Zero last sector of application file - patch space
;*=*=*
	IFLT	$,3000H
	DC	.HIGH.$.SHL.8-$+256,0	;Zero remainder of sector
	ENDIF
	END	START			;START must be 2800H
