;DOSAVE/ASM - 04/02/85
;*=*=*
;	Equates
;*=*=*
@PUT	EQU	4
@MSG	EQU	13
@VDCTL	EQU	15
@ERROR	EQU	26
@INIT	EQU	58
@CLOSE	EQU	60
@FSPEC	EQU	78
@FLAGS	EQU	101
@SOUND	EQU	104
@WINDOW	EQU	124
SROW	EQU	4
SCOL	EQU	10
NROW	EQU	3
NCOL	EQU	38
IOBUF	EQU	2600H
;*=*=*
;	Establish macro
;*=*=*
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	40
	ENDM
;*=*=*
	OPTION	CI			;Application must be core-image
;*=*=*
; Information sector
;*=*=*
	ORG	2700H			;Forces START to 2800H
	DB	'PRONTO'
	DB	'DO Save     ',3
	DC	13,0
	DW	IROW,ICOL
	DC	.HIGH.$.SHL.8-$-48+256,0
	DATE
	TIME
	DB	'Copyright 1985 MicroConsultants '
;*=*=*
;	Application starts here @ x'2800'
;*=*=*
START	LD	HL,SROW.SHL.8.OR.SCOL	;Define upper left corner
IROW	EQU	$-1
ICOL	EQU	$-2
	LD	DE,NROW.SHL.8.OR.NCOL	;Define number of rows & columns
	LD	B,7			;Set function 7 - WCREAT
	SVC	@WINDOW			;Attempt to open the window
	JR	Z,OK			;Jump if no error
;*=*=*
;	If error on window open the beep and return
;*=*=*
	LD	B,00<4+02		;Set tone & duration
	SVC	@SOUND			;Beep
	RET
;*=*=*
;	Prompt for filespec
;*=*=*
OK	LD	HL,PROMPT$		;Filespec prompt
	LD	B,10			;Set function 10 - WDSPLY
	SVC	@WINDOW			;Display filespec prompt
	LD	HL,LINBUF		;Input buffer
	LD	BC,00<8+23		;Set function 0 - WKEYIN
					;  allow up to 23 characters
	SVC	@WINDOW			;Get the filespec
	JR	C,BREAK			;Jump if <Break> depressed
;*=*=*
;	Close the window
;*=*=*
	PUSH	HL			;Save the buffer pointer
	LD	BC,8<8+00		;Set function 8 - WCLOSE
					;  without export
	SVC	@WINDOW			;Close the window
	POP	HL			;Restore the buffer pointer
;*=*=*
;	Check the filespec and open the file
;*=*=*
	LD	DE,FCB			;File control block
	SVC	@FSPEC			;Check the filespec
	LD	A,19			;Illegal filename error code
	JP	NZ,FILERR		;Jump if illegal filename
	LD	HL,IOBUF		;Disk I/O buffer
	LD	B,0			;Set LRL == 256
	SVC	@INIT			;Open/init the file
	JP	NZ,FILERR		;Jump if error
;*=*=*
;	Write the contents of the video to the file
;*=*=*
	LD	BC,24<8+0		;B contains number of lines (24)
					;C contains current line (0)
LOOP	PUSH	BC			;Save count & line
	LD	H,C			;Move line to H for VDCTL
	LD	DE,LINBUF		;Buffer for video line
	PUSH	DE			;Dave it for later
	LD	BC,9<8+01
	SVC	@VDCTL			;Move one video line into buffer
	POP	HL			;Restore buffer start
	LD	DE,FCB
	SVC	@MSG			;Write buffer contents to file
	JR	NZ,FILERR		;Jump if error during write
	POP	BC			;Restore count & line
	INC	C			;Advance to next line
	DJNZ	LOOP			;Loop till done
;*=*=*
;	Close the file and return
;*=*=*
CLOSFIL	SVC	@CLOSE			;Close the file
	RET
;*=*=*
;	Error routines
;*=*=*
FILERR	PUSH	AF			;Save the error code
;*=*=*
; Open a window to display the error message
; Return may be ignored since we know that a window can be opened
;*=*=*
	LD	HL,IROW.SHL.8.OR.ICOL	;Define upper left corner
	LD	DE,NROW.SHL.8.OR.NCOL	;Define number of rows & columns
	LD	B,7			;Set function 7 - WCREAT
	SVC	@WINDOW			;Open the window
	POP	AF			;Restore the error code
	OR	0C0H			;Set short & return
	LD	C,A			;Save error code in C
	SVC	@FLAGS
	SET	7,(IY+'C'-'A')		;Get error message
	LD	DE,IOERR$+3		;  into a buffer
	SVC	@ERROR			;Get error message
	LD	H,D			;Replace the CR with ETX
	LD	L,E
	LD	A,13
	LD	B,A			;Make BC large
	CPIR				;Has to find it!!!
	DEC	HL			;Point to the CR
	LD	(HL),3
	LD	HL,IOERR$		;Get start of string
	LD	B,10			;Set function 10 - WDSPLY
	SVC	@WINDOW			;Display error message
	LD	BC,0.SHL.8+0		;Set function 0 - WKEYIN
					;  allow 1 char input &
					;  return immediately
	SVC	@WINDOW			;Wait for a keystroke
	CALL	CLOSFIL			;Attempt to close the file
BREAK	LD	BC,8<8+00		;Set function 8 - WCLOS
	SVC	@WINDOW			;Close the window
	RET
;*=*=*
PROMPT$	DB	10,'  Filespec ? ',3
IOERR$	DB	10,'  '
LINBUF	DS	80
	DB	13
FCB	DS	32
;*=*=*
	IF	$.GT.3000H		;Check on memory overflow
	ERR	'Memory overflow!!!'
	ENDIF
	IFLT	$,3000H
	DC	.HIGH.$.SHL.8-$+256,0	;Zero remainder of sector
	ENDIF
;*=*=*
	END	START
