program pmat; { composed by Jay C. Ritterson, Minneapolis, MN
                version 2.2.0

                Formats documents, i.e. with 80 char. line lengths
                  (This may be changed by changing value of constant LL.)
                   using the following non-printed instructions:

             Command lines:                  (one command to a line only)
                ;p or ;P - Forces a new page
                ;+ - Turns on page numbering (default)
                ;- - Turns off page numbering

                ;r or ;R - Causes next line of text to be right justified, but
                          control characters, though not printed, are counted,
                          and will move visible text to the left of the right
                          margin.
                ;c or ;C - Causes next line of text to be centered

                Lines not preceded by a command line will be left justified.

                ;d or ;D - Causes double spacing to begin
                ;s or ;S - Causes single spacing to begin

                ;i# or ;I# - Causes subsequent text to be indented # spaces
                ;i0, ;i, ;I0 or ;I - returns format to 0 indentation.
                Beware of exceeding page width; blanks are simply added at
                   left margin.

                ; followed by a space creates a comment line.

             Imbedded commands:       (imbedded into text)
                @ $ - underline on (constant UON)
                @ & - underline off (constant UOFF)
                @ ( - bold type on (constant BON)
                @ ) - bold type off (constant BOFF)
                @ / - italics on (constant ION)
                @ \ - italics off (constant IOFF)
                       (no space following @)

             -----------------------------------------------------------------

                Page width set at 80 characters.
                Lines per page set at 56.

                Form feed set as 0Ch
                Underline on/off set as 0Fh/0Eh
                Bold type on/off set as 1B1Fh/1B20h
                Italics on/off set as 1B42h1d/1B42h0d

                See list of constants.

                --------------------------------------------------------------

              }

{$NO INOUT}       { Supresses I/O prompts }

const
    B     = '#5F';     { page marker character }
    CLS   = '#1C#1F';  { clear screen character }
    FF    = '#0C';     { form feed character }
    CR    = '#0D';     { carriage return (automatic line feed) }
    LF    = '#0A';     { line feed (automatic carriage return) }
    LL    =  80;       { line length in total columns }
    PL    =  56;       { page length in lines to be printed per page }
    UON   =  '#0F';    { underline on }
    UOFF  =  '#0E';    { underline off }
    BON   =  '#1B#1F'; { bold type on (double stroke) }
    BOFF  =  '#1B#20'; { bold type off }
    ION   =  '#1B#421';{ italics on }
    IOFF  =  '#1B#420';{ italics off }

var
    ch               : char;    { generic }
    str,pstr         : string;  { generic }
    source           : text;
    input, output    : text;
    ok               : boolean;
    ln               : packed array [1..LL] of char;

function cpystr (s : string) : string; external;

procedure readkey (var ch : char); external;

procedure setacnm (var f : text; s : string); external;

procedure read_parm (var s : string); external;

function getint(s : string) : integer;

  var
    good         :         boolean;
    numerals     :         set of char;

  function decodei (s : string) : integer; external;
  function conc (s1,s2 : string) : string; external;
  function mid$ (s : string; position, length : integer) : string; external;
  function character (s : string; position : integer) : char; external;

  begin
    good := false;
    numerals := ['0'..'9'];

    if character(s,3) in numerals then
      good := true
    else
      getint := 0;

    if good and character(s,4) in numerals then
        getint := decodei(conc(mid$(s,3,1),mid$(s,4,1)))
    else
      getint := decodei(mid$(s,3,1));

  end;   { of getint function }

function character (s : string; p : integer) : char; external;

function len (s : string) : integer; external;

function delete (s : string; pos, len : integer) : string; external;

function insert (subs, s : string; pos : integer) : string; external;


procedure centerln (var inf : text; var str : string);

  var
     strln,
     ln     : packed array [1..LL] of char;
     index  : integer;   { array pointer index }
     lnlen  : integer;   { length of text }
     inset  : integer;   { pointer to inset first character }
     ptr    : integer;   { pointer to first character }
     toe    : integer;   { pointer to last character }

  begin
    for index := 1 to LL do          { clear line to all blanks }
      strln[index] := ' ';

    readln (inf,ln);

    index := 1;
    while ln[index] =  ' '
      and index <= LL do             { skip leading blanks }
      index := index + 1;
    if index > LL then
      index := LL;
    ptr := index;

    lnlen := 0;
    while index <= LL and            { count characters in line }
      ln[index] <> CR do             { count }
      begin
        lnlen := lnlen + 1;          { inc line length counter }
        index := index + 1;          { inc array index pointer }
      end;                           { counting characters in line }

    index := ptr + lnlen - 1;
    while ln[index] = ' ' and
      index > 0 do
      begin
        index := index - 1;
        lnlen := lnlen - 1;
      end;

    inset := trunc((LL - lnlen)/2) + 1;

    for index := ptr to (ptr + lnlen) do      { add text of line }
      begin
        strln[inset] := ln[index];
        inset := inset + 1;
      end;

    str := bldstr(strln);

  end;                               { of centerln procedure }


procedure rightln (var inf : text; var str : string);

  var
     strln,
     ln     : packed array [1..LL] of char;
     index  : integer;   { array pointer index }
     lnlen  : integer;   { line length counter }
     ptr    : integer;   { pointer to first character }

  begin
    for index := 1 to LL do
      strln[index] := ' ';

    index := 1;

    readln (inf,ln);

    while ln[index] =  ' '
      and index <= LL do          { skip leading blanks }
      index := index + 1;
    if index > LL then
      index := LL;

    ptr := index;
    lnlen := 0;

    while index <= LL and        { count characters in line }
      ln[index] > ' ' do         { begin counting }
        begin
          lnlen := lnlen +1;
          index := index + 1;
        end;

    while ln[index] = ' ' and
      index > 0 do               { remove trailing blanks }
      begin
        index := index - 1;
        lnlen := lnlen - 1;
      end;

    for index := LL - lnlen to LL do
      begin
        strln[index] := ln[ptr];
        ptr := ptr + 1;
      end;

    str := bldstr(strln);

  end;                           { of rightln procedure }


procedure view_scan (var str : string);

  var
      x  :  integer;

  begin
    for x := 1 to len(str) do
      begin
        if (character(str,x) = '@') and
           (character(str,x+1) = '$' or
            character(str,x+1) = '%' or
            character(str,x+1) = '(' or
            character(str,x+1) = ')' or
            character(str,x+1) = '/' or
            character(str,x+1) = '\') then { control character }
          begin
            str := delete(str,x,1);        { delete control character }
            if character(str,x) = '$' or
               character(str,x) = '(' or
               character(str,x) = '/' then { command on }
              begin
                str := delete(str,x,1);
                str := insert(bldstr('#10'),str,x); { inverse on }
              end;
            if character(str,x) = '%' or
               character(str,x) = ')' or
               character(str,x) = '\' then { command on }
              begin
                str := delete(str,x,1);
                str := insert(bldstr('#11'),str,x); { inverse off }
              end;
          end;
        end;
  end;                  { of view_scan }


procedure print_scan (var str : string);

  var
      x   :   integer;

  begin
    for x := 1 to len(str) do            { check for control words }
      begin
        if (character(str,x) = '@') and
           (character(str,x+1) = '$' or
            character(str,x+1) = '%' or
            character(str,x+1) = '(' or
            character(str,x+1) = ')' or
            character(str,x+1) = '/' or
            character(str,x+1) = '\') then { control character }
          begin
            str := delete(str,x,1);        { delete control character }
            if character(str,x) = '$' then { underline on }
               begin
                 str := delete(str,x,1);
                 str := insert(bldstr(UON),str,x);
               end;
            if character(str,x) = '%' then { underline off }
              begin
                str := delete(str,x,1);
                str := insert(bldstr(UOFF),str,x);
              end;
            if character(str,x) = '(' then { bold type on }
              begin
                str := delete(str,x,1);
                str := insert(bldstr(BON),str,x);
              end;
            if character(str,x) = ')' then { bold type off }
              begin
                str := delete(str,x,1);
                str := insert(bldstr(BOFF),str,x);
              end;
            if character(str,x) = '/' then { italics on }
              begin
                str := delete(str,x,1);
                str := insert(bldstr(ION),str,x);
              end;
            if character(str,x) = '\' then { italics off }
              begin
                str := delete(str,x,1);
                str := insert(bldstr(IOFF),str,x);
              end;
          end;
        end;
  end;                     { print_scan }


procedure previewfile (var source : text);

  var
    line, page, x    : integer;
    str              : string;
    dent             : integer;
    indent           : boolean;
    new_page         : boolean;
    double           : boolean;

  begin
    line := 0;
    page := 1;
    indent := false;
    dent := 0;
    new_page := false;
    double := false;

    reset (source);

    write (output,CLS);
    writeln (output);

    while not eof(source) do
      begin                                  { reading file lines }
        readln (source,str);                 { read to first eoln }
        while new_page and len(str) = 0 do   { kill blanks at top of page }
          readln (source,str);
        view_scan (str);                     { convert control characters }
        new_page := false;                   { switch off new page flag }

        if character(str,1) <> ';' then      { check for non-command line }
          begin
            if indent then
              for x := 1 to dent do
                write (output,' ');
            writeln (output,str);
            line := line + 1;                { increment line counter }
            if double then
              begin
                writeln (output);
                line := line + 1;            { increment line counter }
              end;
          end;

        if (character (str,1) = ';'          { check for time for new page }
           and (character (str,2) = 'p' or character (str,2) = 'P'))
           or (line >= PL) then
          begin   { new page }
            for x := 1 to 300 do x := x;     { pause }
            line := 1;                       { reset line counter }
            page := page + 1;                { increment page counter }
            writeln (output,CR,'                           ',
            B,B,B,B,B,B,B,B,B,B,'page: ', page:1,' ',B,B,B,B,B,B,B,B,B,B,CR);
            new_page := true;
          end;   { of new page }

        if (character (str,1) =';'           { check for center line }
           and (character (str,2) ='c' or character (str,2) = 'C')) then
          begin
            dispose (str);
            centerln (source,str);
            view_scan (str);
            writeln (output,str);
            line := line + 1;
            if double then
              begin
                writeln (output);
                line := line + 1;
              end;
          end;

        if (character (str,1) =';'           { check for right justify }
           and (character (str,2) ='r' or character (str,2) = 'R')) then
         begin
            dispose (str);
            rightln (source,str);
            view_scan (str);
            writeln (output,str);
            line := line + 1;
            if double then
              begin
                writeln (output);
                line := line + 1;
              end;
          end;

        if (character (str,1) =';'           { check for indent line }
           and (character (str,2) ='i' or character (str,2) = 'I')) then
          begin
            dent := getint(str);
            if dent > 0 then
              indent := true
            else
              indent := false;
          end;

        if (character (str,1) =';'           { check for double space }
           and (character (str,2) ='d' or character (str,2) = 'D')) then
          double := true;

        if (character (str,1) =';'           { check for single space }
           and (character (str,2) ='s' or character (str,2) = 'S')) then
          double := false;

        dispose (str);                       { collect garbage }
      end;                                   { reading file lines }

    for x := 1 to 9000 do x := x;            { long pause }
    write (output,CLS);                      { clear screen }
  end;   { of preview procedure }


procedure printfile (var source : text);

  var
    print            : text;
    str              : string;
    line,page,x,dent : integer;
    indent           : boolean;
    page_number      : boolean;
    new_page         : boolean;
    double           : boolean;

  begin
    line := 0;
    page := 1;
    indent := false;
    dent := 0;
    page_number := true;
    new_page := false;
    double := false;

    reset (source);
    setacnm (print,bldstr(':L'));
    rewrite (print);
    writeln (output);

    while not eof(source) do
      begin                            { reading lines from file }
        readln (source,str);           { read to first eoln }

        while new_page and len(str) = 0 do   { kill blanks at top of page }
          readln (source,str);
        print_scan (str);                    { convert control characters }
        new_page := false;                   { switch off new page flag }

        if character(str,1) <> ';' then      { check for non-command line }
          begin
            if indent then
              for x := 1 to dent do
                write (print,' ');
            writeln (print,str);
            line := line + 1;                { increment line counter }
            if double then
              begin
                writeln (print);
                line := line + 1;            { increment line counter }
              end;
          end;

        if character (str,1) =';' and       { check for page number on }
           character (str,2) ='+'  then
          page_number := true;

        if character (str,1) =';' and       { check for page number off }
           character (str,2) ='-'  then
          page_number := false;

        if (character (str,1) = ';'    { check for time for new page }
           and (character (str,2) = 'p' or character (str,2) = 'P'))
           or (line >= PL) then
          begin                        { a new page }
            line := 1;                 { reset line counter }
            page := page + 1;          { increment page counter }
            write (print, FF);         { form feed }
            if page_number then
              writeln (print, '                                        ',
                              '                                   ',page:1)
            else
              writeln(print);
            writeln (output,'    page ',page:1); { display page number }
            new_page := true;
            writeln (print);                { add line after page number }
          end;                         { of new page }

        if (character (str,1) =';'           { check for center line }
           and (character (str,2) ='c' or character (str,2) = 'C')) then
          begin
            dispose (str);
            centerln (source,str);
            print_scan (str);
            writeln (print,str);
            line := line + 1;
            if double then
              begin
                writeln (print);
                line := line + 1;
              end;
          end;

        if (character (str,1) =';'           { check for right justify }
           and (character (str,2) ='r' or character (str,2) = 'R')) then
         begin
            dispose (str);
            rightln (source,str);
            print_scan (str);
            writeln (print,str);
            line := line + 1;
            if double then
              begin
                writeln (print);
                line := line + 1;
              end;
          end;

        if (character (str,1) =';'           { check for indent line }
           and (character (str,2) ='i' or character (str,2) = 'I')) then
          begin
            dent := getint(str);
            if dent > 0 then
              indent := true
            else
              indent := false;
          end;

        if (character (str,1) =';'           { check for double space }
           and (character (str,2) ='d' or character (str,2) = 'D')) then
          double := true;

        if (character (str,1) =';'           { check for single space }
           and (character (str,2) ='s' or character (str,2) = 'S')) then
          double := false;

        dispose (str);                 { collect garbage }
      end;                             { reading lines from file }

    write (print,FF);                  { form feed }
    message ('    ** printing complete');

  end;             { of printfile procedure }


                                    { main }
begin
  ok :=  true;

  setacnm (input,bldstr(':K'));
  reset (input);

  setacnm (output,bldstr(':C'));
  rewrite (output);

  read_parm (str);
  pstr := cpystr(str);
  setacnm (source,str);

  while ok do
    begin
      write (output,CLS);                      { clear screen }
      writeln (output,LF,LF,LF,LF,LF);         { down 4 lines }
      writeln (output,'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~',
                      '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
      writeln (output,'TRS-80 Model 4                                  ',
               '           #10 p_mat #11 version 2.2.0');
      write (output,' Print formatter composed by Jay C. Ritterson,',
                    ' Minneapolis, MN, 1986-89');
      writeln (output);
      writeln (output,'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~',
                      '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~');
      writeln (output);
      writeln (output,'              [1>  Preview ',pstr);
      writeln (output,'              [2>  Print ',pstr);
      writeln (output,'              [*>  Anything else will quit program');
      readkey (ch);
        case ch of
        '1' : previewfile (source);
        '2' : printfile (source);
        otherwise
              ok := false;
        end;   { of case }
    end;   { while ok loop }

end.                           { p_mat program }
version 2.2.0 (constants set for DMP 132)
April 1989
