*TITLE 'NUMBERS/ASM - A number conversion utility by Bill Evans - 12/85'
; This conversion program will convert numbers from one
; form to another, as per menu selection. This program will
; work *ONLY* on TRSDOS 6.2
;
; This program was written by Bill Evans [70160,436] and
; placed in public domain in 1985.
*INCL	MACROS
;
	ORG	5500H		;Start here
;
;*******************
;
;	Buffers
;
;*******************
;
DATA	DS	16		;Input data buffer
COUNTER DS	1		;Counter buffer
SWITCH	DS	1		;Switch buffer
KPOSN	DS	1		;Cursor position buffer
MAX	DS	1		;Maximum number of digits
				; buffer
HEXBUF	DS	5		;HEX Buffer
PRTANS	DS	2		;Partial answer buffer
MSB	DS	9		;MSB buffer
LSB	DS	9		;LSB buffer
;
;*******************
;
;	Equates
;
;*******************
;
;		ASCII Control codes
ETX	EQU	3		;End of text
BS	EQU	8		;Backspace
HT	EQU	9		;Horizontal Tab
LF	EQU	10		;Line feed
CR	EQU	13		;Carriage return
;
;		Keyboard control keys/characters
KON	EQU	14		;Cursor on
KOFF	EQU	15		;Cursor off
WIDE	EQU	23		;40 character screen
CLL	EQU	30		;Clear to end of line
CLS	EQU	31		;Clesr to end of screen
BRK	EQU	80H		;BREAK key
F1	EQU	81H		;F1 key
F2	EQU	82H		;F2 key
;
;		Supervisor Calls
@KEY	EQU	1		;Input from keyboard w/wait
@DSP	EQU	2		;Output to display
@DSPLY	EQU	10		;Display line handler
@VDCTL	EQU	15		;Display control routine
@EXIT	EQU	22		;Normal program exit
@DECHEX EQU	96		;DEC==>BIN conversion
@HEXDEC EQU	97		;BIN==>DEC conversion
@HEX16	EQU	99		;BIN==>HEX cnversion - 16 bit
@CLS	EQU	105		;Clear video screen
;
;*******************
;
;	Start of program
;
;*******************
;
START	SVC	@CLS		;Clear screen
	PRINT	KOFF		;Turn cursor off
	LD	B,8		;Change cursor to
	LD	C,94		; carat when it is
	SVC	@VDCTL		; visible
	DISPLAY MENU
LOOP	SVC	@KEY		;Input from keyboard
	CP	BRK		;Was BREAK pressed?
	JR	Z,QUIT		;Yes - then quit
	RES	5,A		;Convert to upper case
	CP	'A'		;Was A pressed?
	JP	Z,OP0019	;Yes - go to Option A
	CP	'B'		;Was B pressed?
	JP	Z,OP0030	;Yes - go to Option B
	CP	'C'		;Was C pressed?
	JP	Z,OP0042	;Yes - go to Option C
	CP	'D'		;Was D pressed?
	JP	Z,OP0053	;Yes - go to Option D
	CP	'E'		;Was E pressed?
	JP	Z,OP0064	;Yes - go to Option E
	CP	'F'		;Was F pressed?
	JP	Z,OP0075	;Yes - go to Option F
	CP	'G'		;Was G pressed?
	JP	Z,OP0086	;Yes - go to Option G
	CP	'H'		;Was H pressed?
	JP	Z,OP0108	;Yes - go to Option H
	CP	'I'		;Was I pressed?
	JP	Z,OP0097	;Yes - go to Option I
	CP	'J'		;Was J pressed?
	JP	Z,OP0119	;Yes - go to Option J
	CP	'P'		;Was P pressed?
	JP	Z,PAGE1 	;Yes - go to page 1 of
				; Program Information
	JR	LOOP		;Keep looking
QUIT	LD	B,8		;Change cursor back to
	LD	C,95		; underscore
	SVC	@VDCTL
	SVC	@CLS		;Clear screen
	SVC	@EXIT		;Exit to TRSDOS Ready
;
;*******************
;
;	Option A
;
;*******************
;
OP0019	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,6		;Move cursor, Row 0, Col 6
	DISPLAY DEC_BIN 	;Displsy option title
	CALL	DECIN		;Display decimal input
	CALL	KEYIN		;Input data
	LD	(IX),ETX	;Terminate DATA buffer
	PRINT	KOFF		;Turn cursor off
	LD	A,(COUNTER)	;Get the number of digits
	CP	5		;Are there 5 digits?
	JR	NZ,OPA		;If not then skip TEST
	CALL	TEST		;Make sure input does not
				; exceed 65535
	JR	Z,OP0019	;Test failed, start over
OPA	CALL	DECBIN		;DEC==>BIN subroutine
	CALL	BIN_ASC 	;Move binary results in BC
				; registers to MSB and LSB
				; buffers
	CALL	BINOUT		;Display binary results
	REPEAT
;
;*******************
;
;	Option B
;
;*******************
;
OP0030	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,6		;Move cursor, Row 0, Col 6
	DISPLAY BIN_DEC 	;Display option title
	CALL	BININ		;Display binary input
	CALL	KEYIN		;Input data
	PRINT	KOFF		;Turn cursor off
	CALL	ASC_BIN 	;Move binary from DATA buf-
				; fer to HL registers
	CALL	BINDEC		;BIN==>DEC subroutine
	CALL	DECOUT		;Display decimal output
	REPEAT
;
;*******************
;
;	Option C
;
;*******************
;
OP0042	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,6		;Move cursor, Row 0, Col 6
	DISPLAY DEC_HEX 	;Display option title
	SVC	@DSPLY		;Display it
	CALL	DECIN		;Display decimal input
	CALL	KEYIN		;Input data
	LD	(IX),ETX	;Terminate DATA buffer
	PRINT	KOFF		;Turn cursor off
	LD	A,(COUNTER)	;Get the number of digits
	CP	5		;Are there 5 digits?
	JR	NZ,OPC		;If not then skip TEST
	CALL	TEST		;Make sure input does not
				; exceed 65535
	JR	Z,OP0042	;Test failed, start over
OPC	CALL	DECBIN		;DEC==>BIN subroutine
; The input is now in binary in BC.
	PUSH	BC		;Move binary to
	POP	DE		; DE registers
	CALL	BINHEX		;BIN==>HEX subroutine
	CALL	HEXOUT		;Display hex output
	REPEAT
;
;*******************
;
;	Option D
;
;*******************
;
OP0053	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,6		;Move cursor, Row 0, Col 6
	DISPLAY HEX_DEC 	;Display option title
	CALL	HEXIN		;Display hex input
	CALL	KEYIN		;Input data
	PRINT	KOFF		;Turn cursor off
	CALL	HEXBIN		;HEX==>BIN subroutine
	CALL	BINDEC		;BIN==>DEC subroutine
	CALL	DECOUT		;Display decimal output
	REPEAT
;
;*******************
;
;	Option E
;
;*******************
;
OP0064	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,6		;Move cursor, Row 0, Col 6
	DISPLAY BIN_HEX 	;Display option title
	CALL	BININ		;Display binary input
	CALL	KEYIN		;Input data
	PRINT	KOFF		;Turn cursor off
	CALL	ASC_BIN 	;Move binary from DATA buf-
				; fer to HL registers
	EX	DE,HL		;Move binary to DE regs.
	CALL	BINHEX		;In DEC==>HEX subroutine
	CALL	HEXOUT		;Display hex output
	REPEAT
;
;*******************
;
;	Option F
;
;*******************
;
OP0075	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,6		;Move cursor, Row 0, Col 6
	DISPLAY HEX_BIN 	;Display option title
	CALL	HEXIN		;Display hex input
	CALL	KEYIN		;Input data
	PRINT	KOFF		;Turn cursor off
	CALL	HEXBIN		;HEX==>BIN subroutine
	PUSH	HL		;Move binary to
	POP	BC		; BC registers
	CALL	BIN_ASC 	;Move binary results in BC
				; registers to MSB and LSB
				; buffers
	CALL	BINOUT		;Display binary results
	REPEAT
;
;*******************
;
;	Option G
;
;*******************
;
OP0086	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,0		;Move cursor, Row 0, Col 0
	DISPLAY DECSHEX 	;Display option title
	CALL	DECIN		;Display decimal input
	CALL	KEYIN		;Input data
	LD	(IX),ETX	;Terminate DATA buffer
	PRINT	KOFF		;Turn cursor off
	LD	A,(COUNTER)	;Get the number of digits
	CP	5		;Are there 5 digits?
	JR	NZ,OPG		;If not then skip TEST
	CALL	TEST		;Make sure input does not
				; exceed 65535
	JR	Z,OP0086	;Test failed, start over
OPG	CALL	DECBIN		;DEC==>BIN subroutine
; The input is now in binary in BC.
	LD	D,C		;Reverse MSB and LSB, and
	LD	E,B		; put it in DE registers
	CALL	BINHEX		;BIN==>HEX subroutine
	CALL	SHEXOUT 	;Display split hex output
	REPEAT
;
;*******************
;
;	Option H
;
;*******************
;
OP0108	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,0		;Move cursor, Row 0, Col 0
	DISPLAY SHEXDEC 	;Display option title
	CALL	SHEXIN		;Display split hex input
	CALL	KEYIN		;Input data
	PRINT	KOFF		;Turn cursor off
	CALL	HEXBIN		;SHEX==>BIN subroutine
	LD	E,H		;These 3 steps exchange
	LD	D,L		; the LSB and MSB in
	EX	DE,HL		; register pair HL
	CALL	BINDEC		;BIN==>DEC subroutine
	CALL	DECOUT		;Display decimal output
	REPEAT
;
;*******************
;
;	Option I
;
;*******************
;
OP0097	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,0		;Move cursor, Row 0, Col 0
	DISPLAY DECSDEC 	;Display option title
	CALL	DECIN		;Display decimal input
	CALL	KEYIN		;Input data
	LD	(IX),ETX	;Terminate DATA buffer
	PRINT	KOFF		;Turn cursor off
	LD	A,(COUNTER)	;Get the number of digits
	CP	5		;Are there 5 digits?
	JR	NZ,OPI		;If not then skip TEST
	CALL	TEST		;Make sure input does not
				; exceed 65535
	JR	Z,OP0097	;Test failed, start over
OPI	CALL	DECBIN		;DEC==>BIN subroutine
; The input is now in binary in BC registers. After the H
; register is zeroed the L register will be loaded with the
; LSB of the input and converted into decimal. This same
; process will be repeated for the MSB.
	PUSH	BC		;Store the binary input
	LD	H,0		;Zero the MSB of the output
	LD	L,C		;Transfer the LSB of the
				; input to the LSB of the
				; output
	CALL	BINDEC		;BIN==>DEC subroutine -
				; convert to LSB of split
				; decimal
	CALL	LSBOUT		;Display it
	POP	BC		;Restore the binary input
	LD	H,0		;Zero the MSB of the output
	LD	L,B		;Transfer the MSB of the
				; input to the LSB of the
				; output
	CALL	BINDEC		;BIN==>DEC subroutine -
				; convert to MSB of split
				; decimal
	CALL	MSBOUT		;Display it
	REPEAT
;
;*******************
;
;	Option J
;
;*******************
;
; The LSB of the decimal input is converted to binary and
; stored in the PRTANS buffer.	The MSB of the decimal
; input is converted to binary. This MSB conversion is
; combined with the previous LSB conversion, and the result
; is converted to decimal.
OP0119	SVC	@CLS		;Clear screen
	PRINT	WIDE		;Turn on double width
	K_POSN	0,0		;Move cursor, Row 0, Col 0
	DISPLAY SDECDEC 	;Display option title
	CALL	LSBIN		;Display input for LSB
				; of split decimal
	CALL	KEYIN		;Input data
	LD	(IX),ETX	;Terminate DATA buffer
	LD	A,(COUNTER)	;Get the number of digits
	CP	3		;Are there 3 digits?
	JR	NZ,OPJ		;If not then skip TEST
	CALL	STEST		;Make sure input does not
				; exceed 255
	JR	Z,OP0119	;Test failed, start over
OPJ	CALL	DECBIN		;DEC==>BIN subroutine
; The input is now in binary in BC.
	PUSH	BC		;Move binary to
	POP	HL		; HL registers
	LD	(PRTANS),HL	;Save partial binary
	CALL	MSBIN		;Display input for MSB
				; of split decimal
	CALL	KEYIN		;Input data
	LD	(IX),ETX	;Terminate DATA buffer
	PRINT	KOFF		;Turn cursor off
	LD	A,(COUNTER)	;Get the number of digits
	CP	3		;Are there 3 digits?
	JR	NZ,OPJ1 	;If not then skip TEST
	CALL	STEST		;Make sure input does not
				; exceed 255
	JR	Z,OP0119	;Test failed, start over
OPJ1	CALL	DECBIN		;DEC==>BIN subroutine
	LD	HL,(PRTANS)	;Restore partial binary
	LD	H,C		;Load MSB of the psrtial
				; binary result with the
				; just converted MSB input
	CALL	BINDEC		;BIN==>DEC subroutine
	CALL	DECOUT		;Display decimal output
	REPEAT
;
;*******************
;
;	Program Information
;
;*******************
;
PAGE1	SVC	@CLS		;Clear Screen
	K_POSN	0,0		;Move cursor, Row 0, Col 0
	DISPLAY PG1		;Display page 1 of text
LOOK1	SVC	@KEY		;Input from keyboard w/wait
	CP	F1		;Was F1 pressed?
	JP	Z,PAGE2 	;Yes - go to page 2 of
				; Program Information
	CP	BRK		;Was BREAK pressed?
	JP	Z,START 	;Yes - return to main menu
	JR	LOOK1		;Keep looking
PAGE2	SVC	@CLS		;Clear Screen
	K_POSN	0,0		;Move cursor, Row 0, Col 0
	DISPLAY PG2		;Display page 2 of text
LOOK2	SVC	@KEY		;Input from keyboard w/wait
	CP	F1		;Was F1 pressed?
	JP	Z,PAGE3 	;Yes - go to page 3 of
				; Program Information
	CP	F2		;Was F2 pressed?
	JP	Z,PAGE1 	;Yes - go to page 1 of
				; Program Information
	CP	BRK		;Was BREAK pressed?
	JP	Z,START 	;Yes - return to main menu
	JR	LOOK2		;Keep looking
PAGE3	SVC	@CLS		;Clear Screen
	K_POSN	0,0		;Move cursor, Row 0, Col 0
	DISPLAY PG3		;Display page 3 of text
LOOK3	SVC	@KEY		;Input from keyboard w/wait
	CP	F2		;Was F2 pressed?
	JP	Z,PAGE2 	;Yes - go to page 2 of
				; Program Information
	CP	BRK		;Was BREAK pressed?
	JP	Z,START 	;Yes - return to main menu
	JR	LOOK3		;Keep looking
;
;*******************
;
;	Text
;
;*******************
;
PG1	TAB	15
	DEFM	'N U M B E R   C O N V E R S I O N   U T I L I T Y'
	DB	LF		;Next line
	TAB	30
	DEFM	'Program Information'
	DW	0A0AH		;Next line, skip a line
	DEFM	'The BREAK key is active at all times.  If the BREAK key is pressed while the'
	DB	LF		;Next line
	DEFM	'menu is displayed or while the ''Repeat?'' prompt is displayed the program'
	DB	LF		;Next line
	DEFM	'will exit to ''TRSDOS Ready,'' any other time it will return to the Menu.'
	DW	0A0AH		;Next line, skip a line
	DEFM	'The left and right arrow keys are active whenever a numerical input is re-'
	DB	LF		;Next line
	DEFM	'quested.  Pressing these keys will move the arrow shaped cursor back and'
	DB	LF		;Next line
	DEFM	'forth beneath the input line.  To correct an erroneously entered digit posi-'
	DB	LF		;Next line
	DEFM	'tion the cursor below it and type in the correct digit.'
	DW	0A0AH		;Next line, skip a line
	DW	0A0AH		;Skip 2 lines
	TAB	23
	DEFM	'* * *     C A U T I O N     * * *'
	DB	LF		;Next line
	DEFM	'IF WHEN USING THE ARROW KEYS A BLANK SPACE IS INSERTED ANY WHERE BEFORE THE'
	DB	LF		;Next line
	DEFM	'LAST DIGIT THE RESULT WILL BE UNPREDICTABLE!'
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DEFM	'<F1> Next Page                                                    <BREAK> Menu'
	DB	ETX		;End of PG1
PG2	TAB	37
	DEFM	'Page 2'
	DW	0A0AH		;Next line, skip a line
	DEFM	'In Binary inputs only the ''0'' and ''1'' keys are active.  Any time you wish'
	DB	LF		;Next line
	DEFM	'to enter a number with fewer than 4, 8, or 16 bits use leading 0''s.'
	DW	0A0AH		;Next line, skip a line
	DEFM	'In Decimal inputs keys 0-9 are active, as are <SPACE BAR> and <ENTER>.'
	DB	LF		;Next line
	DEFM	'  a. <ENTER> may be pressed when you wish to enter less than the maximum num-'
	DB	LF		;Next line
	DEFM	'     ber of digits allowed.'
	DB	LF		;Next line
	DEFM	'  b. If <ENTER> is pressed when there is no input the <ENTER> key will appear'
	DB	LF		;Next line
	DEFM	'     to be a dead key.  (Use a ''0'' to represent no input.)'
	DB	LF		;Next line
	DEFM	'  c. When the fifth digit is pressed (third digit in the case of a Split Deci-'
	DB	LF		;Next line
	DEFM	'     mal input) <ENTER> is automatically pressed.'
	DB	LF		;Next line
	DEFM	'  d. When the input exceeds 65535 (255 in the case of a Split Decimal input)'
	DB	LF		;Next line
	DEFM	'     the input is ignored and the request for data repeated.'
	DB	LF		;Next line
	DEFM	'  e. Since there should be no spaces preceeding the last digit the <SPACE BAR>'
	DB	LF		;Next line
	DEFM	'     functions as a DELETE key.  Each time this key is pressed the last digit'
	DB	LF		;Next line
	DEFM	'     is deleted.  (It does not matter where the cursor is when this key is'
	DB	LF		;Next line
	DEFM	'     pressed.  The cursor will be repositioned below where the last digit'
	DB	LF		;Next line
	DEFM	'     was.)'
	DW	0A0AH		;Next line, skip a line
	DW	0A0AH		;Skip 2 lines
	DEFM	'<F1> Next Page                <F2> Previous Page                   <BREAK> Menu'
	DB	ETX		;End of PG2
PG3	TAB	37
	DEFM	'Page 3'
	DW	0A0AH		;Next line, skip a line
	DEFM	'In Hexadecimal inputs keys 0-9 and A-F are active.  Lower case inputs are au-'
	DB	LF		;Next line
	DEFM	'tomatically converted to upper case.'
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DW	0A0AH		;Skip 2 lines
	DEFM	'                              <F2> Previous Page                   <BREAK> Menu'
	DB	ETX		;End of PG3
;
;*******************
;
;	Menu
;
;*******************
;
MENU	DW	0A0AH		;Two blank lines
	DW	0A0AH		;Two blank lines
	TAB	10
	DEFM	'N U M B E R   C O N V E R S I O N   U T I L I T Y'
	DW	0A0AH		;Next line, skip a line
	TAB	20
	DEFM	'A) Decimal to Binary'
	DB	LF		;Next line
	TAB	20
	DEFM	'B) Binary to Decimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'C) Decimal to Hexadecimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'D) Hexadecimal to Decimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'E) Binary to Hexadecimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'F) Hexadecimal to Binary'
	DB	LF		;Next line
	TAB	20
	DEFM	'G) Decimal to Split Hexadecimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'H) Split Hexadecimal to Decimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'I) Decimal to Split Decimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'J) Split Decimal to Decimal'
	DB	LF		;Next line
	TAB	20
	DEFM	'P) Program Information'
	DW	0A0AH		;Next line, skip a line
	TAB	30
	DEFM	'Press letter corresponding to choice'
	DB	CR		;End of MENU
;
;*******************
;
;	Messages
;
;*******************
;
DEC_BIN DEFM	'Decimal to Binary conversion'
	DB	CR		;End of DEC_BIN
BIN_DEC DEFM	'Binary to Decimal conversion'
	DB	CR		;End of DEC_BIN
DEC_HEX DEFM	'Decimal to Hexadecimal conversion'
	DB	CR		;End of DEC_HEX
HEX_DEC DEFM	'Hexadecimal to Decimal conversion'
	DB	CR		;End of HEX_DEC
BIN_HEX DEFM	'Binary to Hexadecimal conversion'
	DB	CR		;End of DEC_HEX
HEX_BIN DEFM	'Hexadecimal to Binary conversion'
	DB	CR		;End of HEX_BIN
DECSHEX DEFM	'Decimal to Split Hexadecimal conversion'
	DB	CR		;End of DECSHEX
SHEXDEC DEFM	'Split Hexadecimal to Decimal conversion'
	DB	CR		;End of SHEXDEC
DECSDEC DEFM	'Decimal to Split Decimal conversion'
	DB	CR		;End of DECSDEC
SDECDEC DEFM	'Split Decimal to Decimal conversion'
	DB	CR		;End of SDECDEC
NUMBER	DEFM	'Enter number (do NOT exceed 65535)'
	DB	LF		;Next line
	DEFM	'_____'
	DB	CR		;End of NUMBER
SIZE	DEFM	'Will this be a 4 digit input, an 8'
	DB	LF		;Next line
	DEFM	'digit input, or a 16 digit input?'
	DB	CR		;End of SIZE
NYBBLE	DEFM	'Enter a 4 bit number: ____'
	DB	CLS		;Clear screen from here on
	DB	CR		;End of NYBBLE
BYTE	DEFM	'Enter an 8 bit number: ________'
	DB	CLS		;Clear screen from here on
	DB	CR		;End of BYTE
WORD	DEFM	'Enter a 16 bit number:                '
	DB	LF		;Next line
	DEFM	'________ ________'
	DB	CLS		;Clear screen from here on
	DB	CR		;End of WORD
HEXNO	DEFM	'Enter a 4 digit HEX number: ____'
	DB	CR		;End of HEXNO
SHEXNO	DEFM	'Enter a 4 digit SPLIT-HEX number: ____'
	DB	CR		;End of SHEXNO
LPROMPT DEFM	'Enter LSB (do NOT exceed 255)'
	DB	LF		;Next line
	DEFM	'___'
	DB	CR		;End of LPROMPT
MPROMPT DEFM	'Enter MSB (do NOT exceed 255)'
	DB	LF		;Next line
	DEFM	'___'
	DB	CR		;End of MPROMPT
NOINPUT DEFM	'If there is no input it MUST be'
	DB	LF		;Next line
	DEFM	'entered as 0'
	DB	CR		;End of NOINPUT
BIN1	DEFM	'Binary: MSB  '
	DB	ETX		;End of BIN1
BIN2	DEFM	'        LSB  '
	DB	ETX		;End of BIN2
DECDSP	DEFM	'Decimal: '
	DB	ETX		;End of DECDSP
HEXDSP	DEFM	'Hexadecimal: '
	DB	ETX		;End of HEXDSP
SHEXDSP DEFM	'Split Hexadecimal: '
	DB	ETX		;End of SHEXDSP
LSBDSP	DEFM	'Least Significant Byte: '
	DB	ETX		;End of LSBDSP
MSBDSP	DEFM	'Most  Significant Byte: '
	DB	ETX		;End of MSBDSP
RPT	TAB	18
	DEFM	'Repeat?'
	DB	CR		;End of RPT
;
;*******************
;
;	Decimal input subroutine
;
;*******************
;
DECIN	K_POSN	3,0		;Move cursor, Row 3, Col 0
	DISPLAY NUMBER		;Display prompt
	LD	A,'D'		;Set switch to decimal
	LD	(SWITCH),A	;Store it
	LD	A,5		;Maximum number of digits
	LD	(MAX),A 	;Store it
	LD	H,5		;Position cursor to row 5,
	LD	L,0		; column 0
	LD	A,0		;Zero the
	LD	(COUNTER),A	; loop counter
	LD	(KPOSN),A	; and the cursor position
	RET			;Return to caller
;
;*******************
;
;	Decimal output subroutine
;
;*******************
;
DECOUT	K_POSN	7,0		;Move cursor, Row 7, Col 0
	DISPLAY DECDSP		;Display decimal display
	DISPLAY DATA		;Display decimal answer
	K_POSN	10,0		;Move cursor, Row 10, Col 0
	DISPLAY RPT		;Display 'Repeat?'
	RET			;Return to caller
;
;*******************
;
;	Binary input subroutine
;
;*******************
;
BININ	K_POSN	3,0		;Move curcor Row 3, Col 0
	DISPLAY SIZE		;Display prompt
BININ1	SVC	@KEY		;Look for input
	CP	'4'		;Was '4' pressed?
	JP	Z,BIN_4 	;Yes - go to 4 bit input
	CP	'8'		;Was '8' pressed?
	JP	Z,BIN_8 	;Yes - go to 8 bit input
	CP	'1'		;Was '1' pressed?
	JP	Z,BIN_16	;Yes - go to 16 bit input
	CP	BRK		;Was BREAK pressed?
	JP	Z,START 	;Yes - return to menu
	JR	BININ1		;Loop until we get 4, 8, 1
;				; or BREAK
BIN_4	K_POSN	3,0		;Move curcor Row 3, Col 0
	DISPLAY NYBBLE		;Display prompt
	LD	H,4		;Position cursor to row 4,
	LD	L,44		; column 44
	LD	A,4		;Maximum number of bits
	LD	(MAX),A 	;Store it
	JP	BININ2		;Continue
BIN_8	K_POSN	3,0		;Move curcor Row 3, Col 0
	DISPLAY BYTE		;Display prompt
	LD	H,4		;Position cursor to row 4,
	LD	L,46		; column 46
	LD	A,8		;Maximum number of bits
	LD	(MAX),A 	;Store it
	JP	BININ2		;Continue
BIN_16	K_POSN	3,0		;Move curcor Row 3, Col 0
	DISPLAY WORD		;Display prompt
	LD	H,5		;Position cursor to row 5,
	LD	L,0		; column 0
	LD	A,16		;Maximum number of bits
	LD	(MAX),A 	;Store it
BININ2	LD	A,'B'		;Set switch
	LD	(SWITCH),A	; to BINARY
	LD	A,0		;Zero the
	LD	(COUNTER),A	; loop counter
	LD	(KPOSN),A	; and the cursor position
	LD	IX,DATA 	;Point to DATA buffer where
				; input will be stored
	RET			;Return to caller
;
;*******************
;
;	Binary output subroutine
;
;*******************
;
BINOUT	K_POSN	7,0		;Move curcor Row 7, Col 0
	DISPLAY BIN1		;Display MSB message
	DISPLAY MSB		;Display MSB
	DISPLAY BIN2		;Display LSB message
	DISPLAY LSB		;Display LSB
	K_POSN	10,0		;Move cursor, Row 10, Col 0
	DISPLAY RPT		;Display 'Repeat?'
	RET			;Return to caller
;
;*******************
;
;	HEXADECIMAL input subroutine
;
;*******************
;
HEXIN	K_POSN	3,0		;Move curcor Row 3, Col 0
	DISPLAY HEXNO		;Display prompt
	LD	A,'H'		;Set switch
	LD	(SWITCH),A	; to HEX
	LD	A,4		;Maximum number of digits
	LD	(MAX),A 	;Store it
	LD	H,4		;Position cursor to row 4,
	LD	L,56		; column 56
	LD	A,0		;Zero the
	LD	(COUNTER),A	; loop counter
	LD	(KPOSN),A	; and the cursor position
	LD	IX,DATA 	;Point to DATA buffer where
				; input will be stored
	RET			;Return to caller
;
;*******************
;
;	HEXADECIMAL output subroutine
;
;*******************
;
HEXOUT	K_POSN	7,0		;Move curcor Row 7, Col 0
	DISPLAY HEXDSP		;Display HEX message
	DISPLAY HEXBUF		;Display HEX
	K_POSN	10,0		;Move cursor, Row 10, Col 0
	DISPLAY RPT		;Display 'Repeat?'
	RET			;Return to caller
;
;*******************
;
;	SPLIT HEXADECIMAL input subroutine
;
;*******************
;
SHEXIN	K_POSN	3,0		;Move curcor Row 3, Col 0
	DISPLAY SHEXNO		;Display prompt
	LD	A,'H'		;Set switch
	LD	(SWITCH),A	; to HEX
	LD	A,4		;Maximum number of digits
	LD	(MAX),A 	;Store it
	LD	H,4		;Position cursor to row 4,
	LD	L,68		; column 68
	LD	A,0		;Zero the
	LD	(COUNTER),A	; loop counter
	LD	(KPOSN),A	; and the cursor position
	LD	IX,DATA 	;Point to DATA buffer where
				; input will be stored
	RET			;Return to caller
;
;*******************
;
;	SPLIT HEXADECIMAL output subroutine
;
;*******************
;
SHEXOUT K_POSN	7,0		;Move curcor Row 7, Col 0
	DISPLAY SHEXDSP 	;Display Split HEX message
	DISPLAY HEXBUF		;Display HEX
	K_POSN	10,0		;Move cursor, Row 10, Col 0
	DISPLAY RPT		;Display 'Repeat?'
	RET			;Return to caller
;
;*******************
;
;	Split Decimal input subroutine
;
;*******************
;
LSBIN	K_POSN	3,0		;Move curcor Row 3, Col 0
	DISPLAY LPROMPT 	;Display prompt
	LD	A,'D'		;Set switch
	LD	(SWITCH),A	; to Decimal
	LD	A,3		;Maximum number of digits
	LD	(MAX),A 	;Store it
	LD	H,5		;Position cursor to row 5,
	LD	L,0		; column 0
	LD	A,0		;Zero the
	LD	(COUNTER),A	; loop counter
	LD	(KPOSN),A	; and the cursor position
	RET			;Return to caller
MSBIN	K_POSN	5,0		;Move curcor Row 5, Col 0
	DISPLAY MPROMPT 	;Display prompt
	LD	A,'D'		;Set switch
	LD	(SWITCH),A	; to Decimal
	LD	A,3		;Maximum number of digits
	LD	(MAX),A 	;Store it
	LD	H,7		;Position cursor to row 7,
	LD	L,0		; column 0
	LD	A,0		;Zero the
	LD	(COUNTER),A	; loop counter
	LD	(KPOSN),A	; and the cursor position
	RET			;Return to caller
;
;*******************
;
;	SPLIT DECIMAL output subroutine
;
;*******************
;
LSBOUT	K_POSN	7,0		;Move curcor Row 7, Col 0
	DISPLAY LSBDSP		;Display Split Decimal LSB
				; message
	DISPLAY DATA		;Display Split Decimal LSB
				; answer
MSBOUT	K_POSN	8,0		;Move curcor Row 8, Col 0
	DISPLAY MSBDSP		;Display Split Decimal MSB
				; message
	DISPLAY DATA		;Display Split Decimal MSB
				; answer
	K_POSN	10,0		;Move cursor, Row 10, Col 0
	DISPLAY RPT		;Display 'Repeat?'
	RET			;Return to caller
;
;*******************
;
;	Subroutines
;
;*******************
;
;	KEYIN subroutine
; This subroutine displays keyed in characters one row
; above the cursor. By useing a carat as the cursor symbol
; it appears to be an arrowhead pointing to where the
; keyed in character will be displayed.
;
; This subroutine is actually a series of subroutines.
; The main subroutine is KEYIN. It will then branch to
; either of 3 routines depending on what is in the SWITCH
; buffer, and then finish with the DSP (display) routine,
; where the input will be displayed on screen and stored
; in a DATA buffer.
;
; When entering this subroutine first store the maximum
; number of digits to be input in the MAX buffer; 0 in
; COUNTER buffer to reset the loop counter and in the
; KPOSN buffer to reset the cursor position counter; and
; store <H>ex, <B>inary, or <D>ecimal in the SWITCH buffer.
; Also load HL with the cursor row and column.
KEYIN	LD	IX,DATA 	;Point to DATA buffer
KEYIN1	LD	A,(MAX) 	;Get maximum digits
	LD	B,A		;Put it in B register
	LD	A,(COUNTER)	;Get current loop counter
	CP	B		;Did we loop MAX times?
	RET	Z		;Yes - return to caller
	PRINT	KON		;Turn on cursor
	LD	B,3		;Make sure cursor is
	SVC	@VDCTL		; displayed in position
	SVC	@KEY		;Look for input
	CP	BRK		;Was BREAK pressed?
	JP	Z,START 	;Yes - return to menu
	CP	BS		;Was left arrow pressed?
	JR	NZ,KEYIN2	;No - continue
;
; Backspace the cursor 1 column each time the left arrow
; is pressed.
	LD	A,(KPOSN)	;Get the cursor position
	CP	0		;Did we move all the way
				; to the left?
	JP	Z,KEYIN1	;Yes - keep looking
	DEC	IX		;No - decrement position in
				; DATA buffer and the
	DEC	A		; arrows counter and return
	LD	(KPOSN),A	; it to memory
	DEC	L		;Move back
        DEC     L               ;Do it twice because we're
				; in wide character mode
	LD	A,L		;Get the cursor column
	CP	16		;Is this column 9?
	JR	Z,BUMP		;Yes - bump back 1 column
	JP	KEYIN1		;Keep looking
;
; This routine will move the cursor backward one column,
; skipping column 9. This makes the reading of a 16 bit
; BINARY easier by separating it into 2 bytes.
BUMP	DEC	L		;Move backward 1 column
        DEC     L               ;Do it twice because we're
				; in wide character mode
	JP	KEYIN1		;Keep looking
KEYIN2	CP	HT		;Was right arrow pressed?
	JR	NZ,KEYIN3	;No - continue
;
; Move the cursor forward 1 colomn each time the right
; arrow is pressed.
	LD	A,(MAX) 	;Get maximum digits
	DEC	A		;Adjust
	LD	B,A		;Put it in B register
	LD	A,(KPOSN)	;Get the cursor position
	CP	B		;Move fwd MAX-1 times?
	JP	Z,KEYIN1	;Yes - keep looking
	INC	IX		;No - increment position in
				; DATA buffer and the
	INC	A		; arrows counter and return
	LD	(KPOSN),A	; it to memory
	INC	L		;Move forward
        INC     L               ;Do it twice because we're
				; in wide character mode
	LD	A,L		;Get the cursor column
	CP	16		;Is this column 9?
	JR	Z,JUMP		;Yes - jump fwd 1 column
	JP	KEYIN1		;Keep looking
;
; This routine will move the cursor forward one column,
; skipping column 9. This makes the reading of a 16 bit
; BINARY easier by separating it into 2 bytes.
JUMP	INC	L		;Move forward 1 column
        INC     L               ;Do it twice because we're
				; in wide character mode
	JP	KEYIN1		;Keep looking
;
; We will now test the SWITCH to see if this a <B>inary,
; <D>ecimal, <S>plit Decimal or <H>exadecimal input and
; take the appropriate routines. We will use the alternate
; redister set so we don't lose the the keyed character in
; register A, then switch back to the original register set
; when we enter the appropriate routine.
KEYIN3  EX      AF,AF'		;Use alternate registers
	LD	A,(SWITCH)	;Load SWITCH for testing
	CP	'B'		;Is it <B>inary
	JP	Z,B_KEYIN	;Yes
	CP	'D'		;Is it <D>ecimal
	JP	Z,D_KEYIN	;Yes
	CP	'H'		;Is it <H>exadecimal
	JP	Z,H_KEYIN	;Yes
B_KEYIN EX      AF,AF'		;Use original registers
	CP	'0'		;Less than 0?
	JP	C,KEYIN1	;Yes - ignore
	CP	'2'		;Greater than 1?
	JP	NC,KEYIN1	;Yes - ignore
	JP	DSP		;Display
D_KEYIN EX      AF,AF'		;Use original registers
	CP	20H		;Was SPACE BAR pressed?
	JR	NZ,D1		;No - then continue
	LD	A,(COUNTER)	;Get the number of digits
	LD	B,A		;Number of digits is the
				; count for DJNZ
	CP	0		;Are there any digits?
	JP	Z,KEYIN1	;No - ignore 'SPACE'
	DEC	A		;Decrement it by 1
	LD	(COUNTER),A	; and store it back in Mem
        LD      (KPOSN),A       ;Also, return cursor pos'n
				; to Mem
	LD	L,0FEH		;The first two increments of
				; L will put the cursor in
				; column 0
	DEC	H		;Input row
CPOSN	INC	L		;Next screen location
        INC     L               ;Do it twice because we're
				; in wide character mode
	DJNZ	CPOSN		;Keep moving the cursor
				; till we get in the right
				; position
	LD	B,3		;Move cursor
	SVC	@VDCTL
	LD	C,'_'		;Underscore represents no
				; input (space)
	SVC	@DSP
	INC	H		;Back to original row
	JP	KEYIN1		;Keep looking
D1	CP	CR		;Was ENTER pressed?
	JR	NZ,D2		;No - continue
;
; We will first position the cursor to one column beyond
; the last digit.
	LD	A,(COUNTER)	;Get the number of digits
	CP	0		;Are there any digits?
	JP	Z,KEYIN1	;If not then ignore the CR
	LD	B,A		;Number of digits is the
				; count for DJNZ
	INC	B		;We want to stop 1 column
				; beyond the last digit
	LD	L,0FEH		;The first two increments of
				; L will put the cursor in
				; column 0
	DEC	H		;Input row
POS	INC	L		;Next screen location
        INC     L               ;Do it twice because we're
				; in wide character mode
	DJNZ	POS		;Keep moving the cursor
				; till we get in the right
				; position
	LD	B,3		;Move cursor
	SVC	@VDCTL
;
; We will erase underscore characters that are remaining on
; the input line when less than 5 digits are entered.
	PRINT	CLL		;Erase from cursor to end
				; of line
; These next steps will make sure the index register (IX)
; is correctly pointing to the position following the last
; digit.
	LD	IX,DATA 	;Point to beginning of DATA
				; buffer
	LD	A,(COUNTER)	;Get the number of digits
	LD	B,A		;This is the count for DJNZ
POINT	INC	IX		;Point to next position in
				; DATA buffer
	DJNZ	POINT
	RET			;Return to caller
D2	CP	'0'		;Less than 0?
	JP	C,KEYIN1	;Yes - ignore
	CP	':'		;Greater than 9?
	JP	NC,KEYIN1	;Yes - ignore
	JP	DSP		;Display
H_KEYIN EX      AF,AF'		;Use original registers
	CP	'0'		;Less than 0?
	JP	C,KEYIN1	;Yes - ignore
	CP	':'		;Greater that 9?
	JP	C,DSP		;No - display
	RES	5,A		;Convert to upper case
	CP	'A'		;Less than A?
	JP	C,KEYIN1	;Yes - ignore
	CP	'G'		;Greater than F?
	JP	NC,KEYIN1	;Yes - ignore
;
DSP	LD	(IX),A		;Store the input in
				; DATA buffer
	LD	C,A		;The character to 'POKE'
				; is now in the C register
	DEC	H		;Go to the input row
	LD	B,3		;Move cursor
	SVC	@VDCTL
	LD	B,2		;'POKE' the input
	SVC	@VDCTL
	INC	H		;Go back to the original
	INC	L		; row, then Frwd. 1 column
        INC     L               ;Do it twice because we're
				; in wide character mode
	LD	A,(KPOSN)	;Get cursor position
	INC	A		;Increment the current
				; cursor position
	LD	(KPOSN),A	;Update cursor position
	LD	A,L		;Get the cursor column
	CP	16		;Is this column 9?
	JR	NZ,DSP1 	;No - continue
;
; This routine will move the cursor forward one column,
; skipping column 9. This makes the reading of a 16 bit
; BINARY easier by separating it into 2 bytes.
	INC	L		;Move forward 1 column
        INC     L               ;Do it twice because we're
				; in wide character mode
DSP1	INC	IX		;Next byte in DATA buffer
	LD	A,(KPOSN)	;Get cursor position
	LD	B,A		;Move it to B register
	LD	A,(COUNTER)	;Get loop counter
	CP	B		;Is the current cursor
; position greater than the loop counter (No. of digits
; entered)? If not then update the COUNTER before we go
; back to the KEYIN routine.
        JP      NC,KEYIN1       ;Keep looking don't update
				; the counter
	INC	A		;Increment the COUNTER
	LD	(COUNTER),A	; and save it
	JP	KEYIN1		;Keep looking
;
;	TEST subroutine
; The @DECHEX SVC will not abort if the DECIMAL input ex-
; ceeds 65535, nor are there any flags set or reset. There-
; fore we must test the input ourselves. Each digit is
; tested individually, starting with the most significanxt
; digit. If the tested digit exceeds a given value then the
; entire input is too large. If that digit equals a given
; value the next digit is tested. If the digit is below the
; given value then it does not matter how high the follow-
; ing digits are; the input is below 65535 so we return to
; the caller for processing. This process is repeated until
; all digits have been tested if necessary.
TEST	LD	IX,DATA 	;Point IX to input
	LD	A,(IX)		;Get the first digit
	CP	'7'		;Greater than 6?
	JR	NC,ABORT	;Yes - digit too large
	CP	'6'		;Equal to 6?
	JR	Z,TEST1 	;Test the next digit
	RET			;Digit is less than 6 so no
; further testing is necessary
TEST1	INC	IX		;Point to next input byte
	LD	A,(IX)		;Get the second digit
	CP	'6'		;Greater than 5?
	JR	NC,ABORT	;Yes - digit too large
	CP	'5'		;Equal to 5?
	JR	Z,TEST2 	;Test the next digit
	RET			;Digit is less than 5 so no
; further testing is necessary
TEST2	INC	IX		;Point to next input byte
	LD	A,(IX)		;Get the third digit
	CP	'6'		;Greater than 5?
	JR	NC,ABORT	;Yes - digit too large
	CP	'5'		;Equal to 5?
	JR	Z,TEST3 	;Test the next digit
	RET			;Digit is less than 5 so no
; further testing is necessary
TEST3	INC	IX		;Point to next input byte
	LD	A,(IX)		;Get the forth digit
	CP	'4'		;Greater than 3?
	JR	NC,ABORT	;Yes - digit too large
	CP	'3'		;Equal to 3?
	JR	Z,TEST4 	;Test the next digit
	RET			;Digit is less than 3 so no
; further testing is necessary
TEST4	INC	IX		;Point to next input byte
	LD	A,(IX)		;Get the last digit
	CP	'6'		;Greater than 5?
	JR	NC,ABORT	;Yes - digit too large
	RET			;The test is completed
ABORT	CP	A		;Set the Zero flag
	RET
;
;
;	TEST subroutine for Split Decimal input
; The input must not exceed 255 (FF in HEX) so we will test
; each digit in the same manner as above. Each digit is
; tested individually, starting with the most significanxt
; digit. If the tested digit exceeds a given value then the
; entire input is too large. If that digit equals the given
; value the next digit is tested. If the digit is below the
; given value then it does not matter how high the follow-
; ing digits are; the input is below 255 so we return to
; the caller for processing. This process is repeated until
; all digits have been tested if necessary.
STEST	LD	IX,DATA 	;Point IX to input
	LD	A,(IX)		;Get the first digit
	CP	'3'		;Greater than 2?
	JR	NC,ABORT	;Yes - digit too large
	CP	'2'		;Equal to 2?
	JR	Z,STEST2	;Test the next digit
	RET			;Digit is less than 6 so no
; further testing is necessary
STEST2	INC	IX		;Point to next input byte
	LD	A,(IX)		;Get the third digit
	CP	'6'		;Greater than 5?
	JR	NC,ABORT	;Yes - digit too large
	CP	'5'		;Equal to 5?
	JR	Z,STEST3	;Test the next digit
	RET			;Digit is less than 5 so no
; further testing is necessary
STEST3	INC	IX		;Point to next input byte
	LD	A,(IX)		;Get the last digit
	CP	'6'		;Greater than 5?
	JR	NC,ABORT	;Yes - digit too large
	RET			;The test is completed
;
;	ASCII to Binary subroutine
; The Binary that is on screen is also in the DATA buffer.
; Each byte of the DATA buffer will contain an ASCII '1' or
; an ASCII '0.' We will set or reset the appropriate bit in
; register H or register L. In the case of a 4 or 8 bit
; Binaey number leading bits are already reset.
ASC_BIN LD	IX,DATA 	;Point to DATA buffer
	LD	HL,0		;Reset all the bits in
				;HL register pair
	LD	A,(MAX) 	;Get the Max. No. of bits
	CP	4		;Is it 4?
	JR	Z,BIN4		;Yes-set up for 4 bit move
	CP	8		;Is it 8?
	JR	Z,BIN8		;Yes-set up for 8 bit move
	CP	16		;Is it 16?
	JP	Z,BIN16 	;Yes-set up for 16 bit move
BIN4	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET4_3	;Yes
	RES	3,L		;Reset bit 3
	JR	CONT4_1 	;Continue
SET4_3	SET	3,L		;Set bit 3
CONT4_1 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET4_2	;Yes
	RES	2,L		;Reset bit 2
	JR	CONT4_2 	;Continue
SET4_2	SET	2,L		;Set bit 2
CONT4_2 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET4_1	;Yes
	RES	1,L		;Reset bit 1
	JR	CONT4_3 	;Continue
SET4_1	SET	1,L		;Set bit 1
CONT4_3 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET4_0	;Yes
	RES	0,L		;Reset bit 0
	RET			;Return to caller
SET4_0	SET	0,L		;Set bit 0
	RET			;Return to caller
BIN8	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_7	;Yes
	RES	7,L		;Reset bit 7
	JR	CONT8_1 	;Continue
SET8_7	SET	7,L		;Set bit 7
CONT8_1 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_6	;Yes
	RES	6,L		;Reset bit 6
	JR	CONT8_2 	;Continue
SET8_6	SET	6,L		;Set bit 6
CONT8_2 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_5	;Yes
	RES	5,L		;Reset bit 5
	JR	CONT8_3 	;Continue
SET8_5	SET	5,L		;Set bit 5
CONT8_3 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_4	;Yes
	RES	4,L		;Reset bit 4
	JR	CONT8_4 	;Continue
SET8_4	SET	4,L		;Set bit 4
CONT8_4 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_3	;Yes
	RES	3,L		;Reset bit 3
	JR	CONT8_5 	;Continue
SET8_3	SET	3,L		;Set bit 3
CONT8_5 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_2	;Yes
	RES	2,L		;Reset bit 2
	JR	CONT8_6 	;Continue
SET8_2	SET	2,L		;Set bit 2
CONT8_6 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_1	;Yes
	RES	1,L		;Reset bit 1
	JR	CONT8_7 	;Continue
SET8_1	SET	1,L		;Set bit 1
CONT8_7 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SET8_0	;Yes
	RES	0,L		;Reset bit 0
	RET			;Return to caller
SET8_0	SET	0,L		;Set bit 0
	RET			;Return to caller
BIN16	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_7	;Yes
	RES	7,H		;Reset bit 7
	JR	CONTH_1 	;Continue
SETH_7	SET	7,H		;Set bit 7
CONTH_1 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_6	;Yes
	RES	6,H		;Reset bit 6
	JR	CONTH_2 	;Continue
SETH_6	SET	6,H		;Set bit 6
CONTH_2 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_5	;Yes
	RES	5,H		;Reset bit 5
	JR	CONTH_3 	;Continue
SETH_5	SET	5,H		;Set bit 5
CONTH_3 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_4	;Yes
	RES	4,H		;Reset bit 4
	JR	CONTH_4 	;Continue
SETH_4	SET	4,H		;Set bit 4
CONTH_4 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_3	;Yes
	RES	3,H		;Reset bit 3
	JR	CONTH_5 	;Continue
SETH_3	SET	3,H		;Set bit 3
CONTH_5 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_2	;Yes
	RES	2,H		;Reset bit 2
	JR	CONTH_6 	;Continue
SETH_2	SET	2,H		;Set bit 2
CONTH_6 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_1	;Yes
	RES	1,H		;Reset bit 1
	JR	CONTH_7 	;Continue
SETH_1	SET	1,H		;Set bit 1
CONTH_7 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETH_0	;Yes
	RES	0,H		;Reset bit 0
	JR	CONTL		;Continue
SETH_0	SET	0,H		;Set bit 0
CONTL	INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_7	;Yes
	RES	7,L		;Reset bit 7
	JR	CONTL_1 	;Continue
SETL_7	SET	7,L		;Set bit 7
CONTL_1 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_6	;Yes
	RES	6,L		;Reset bit 6
	JR	CONTL_2 	;Continue
SETL_6	SET	6,L		;Set bit 6
CONTL_2 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_5	;Yes
	RES	5,L		;Reset bit 5
	JR	CONTL_3 	;Continue
SETL_5	SET	5,L		;Set bit 5
CONTL_3 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_4	;Yes
	RES	4,L		;Reset bit 4
	JR	CONTL_4 	;Continue
SETL_4	SET	4,L		;Set bit 4
CONTL_4 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_3	;Yes
	RES	3,L		;Reset bit 3
	JR	CONTL_5 	;Continue
SETL_3	SET	3,L		;Set bit 3
CONTL_5 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_2	;Yes
	RES	2,L		;Reset bit 2
	JR	CONTL_6 	;Continue
SETL_2	SET	2,L		;Set bit 2
CONTL_6 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_1	;Yes
	RES	1,L		;Reset bit 1
	JR	CONTL_7 	;Continue
SETL_1	SET	1,L		;Set bit 1
CONTL_7 INC	IX		;Point to next byte
	LD	A,(IX)		;Get ASCII bit
	CP	'1'		;Is it a 1?
	JR	Z,SETL_0	;Yes
	RES	0,L		;Reset bit 0
	RET			;Return to caller
SETL_0	SET	0,L		;Set bit 0
;
; We now have the BINARY in the HL register pair.
;
	RET			;Return to caller
;
;
;	Binary to ASCII subroutine
; The BC register pair holds the BINARY results of the
; @DECHEX SVC. We will now test each bit and load a '1' or
; a '0' into the appropriate locations in the MSB and LSB
; buffers.
BIN_ASC LD	IX,MSB		;Point to MSB buffer
	BITB	7
	BITB	6
	BITB	5
	BITB	4
	BITB	3
	BITB	2
	BITB	1
	BITB	0
	LD	(IX),CR 	;End of MSB buffer
;
	LD	IX,LSB		;Point to LSB buffer
	BITC	7
	BITC	6
	BITC	5
	BITC	4
	BITC	3
	BITC	2
	BITC	1
	BITC	0
	LD	(IX),CR 	;End of LSB buffer
	RET
;
ONE	LD	(IX),'1'
	RET
;
ZERO	LD	(IX),'0'
	RET
;
*TITLE 'Conversion Subroutines'
*EJECT
*INCL	CONVRT
	END	START
