20 '
30 'Design assumptions are:
40 '  1. Driven element length in inches is 5600/frequency in MHZ.
50 '  2. The reflector is 5% longer than the driven element.
60 '  3. Reflector and first director spacing is 0.2 wavelengths from driven.
70 '  4. The first director is 5% shorter than the driven element.
80 '     Subsequent director lengths are calculated by adding 1% to
90 '     the shortening factor of the previous director. For example,
100 '     the 2nd director is 6% shorter than the driven element,
110 '     the 3rd is 7% shorter, the 4th, 8% shorter, etc.
120 '  5. Director spacing is 110% of previous spacing. Spacing starts
130 '     at 0.2 wavelengths.
140 '
150 ' The program is well documented via remarks, so any of the above
160 ' assumptions may be easily changed.
170 '
180 '-------------------- PROGRAM BEGINS --------------------------------------
190 '
200 CLS
210 DEFINT I
212 PRINT "This program calculates the demensions of a VHF Yagi antenna."
213 PRINT
220 PRINT "THE OUTPUT OF THIS PROGRAM IS TO A PRINTER."
230 PRINT "TURN PRINTER ON AND ALIGN PAPER BEFORE PROCEEDING."
240 PRINT
250 INPUT"WHAT FREQUENCY (MHZ) ";FREQ
260 INPUT"HOW MANY ELEMENTS (3 MINIMUM) ";ELNO
270 WL = 11808/FREQ 'wavelength in free space (inches)
280 DR = 5600/FREQ 'driven element length (inches)
290 RF = DR * 1.05 'reflector length
300 SPR = WL * .2 'reflector spacing
310 PL(1) = DR * .95'first director length
320 SPP(1) = WL * .2 'first director spacing
330 FOR I = 2 TO (ELNO -2)
340 PRINT
350 SPP(I) = SPP(I-1) * 1.1 'each director spacing 10% greater than previous
360 PL(I) = DR * (100 - (4 + I))*.01 'director length
370 LN1 = LN1 + SPP(I) 'keep track of overall length
380 NEXT
390 DEF FNX(X) = INT(X*100+.5)*.01 'function to round off printing to 2 dec.
400 LNT = SPR + SPP(1) + LN1 'total beam length
410 LPRINT"DESIGN DATA FOR VHF YAGI BEAM ANTENNA: "
420 LPRINT
430 LPRINT"---- DESIGN FREQUENCY IS";FREQ;" MHZ"
440 LPRINT"---- TOTAL NUMBER OF ELEMENTS IS";ELNO
450 LPRINT
460 LPRINT
470 LPRINT TAB(35);"LENGTH IN INCHES"
480 LPRINT "REFLECTOR";TAB(40);FNX(RF)
490 LPRINT "REFLECTOR TO DRIVEN";TAB(41);FNX(SPR)
500 LPRINT "DRIVEN";TAB(40);FNX(DR)
510 LPRINT "DRIVEN TO 1st DIRECTOR";TAB(41);FNX(SPP(1))
520 LPRINT "1st DIRECTOR LENGTH";TAB(40);FNX(PL(1))
530 LPRINT
540 FOR I = 2 TO (ELNO -2)
550 LPRINT"DIRECTOR No.";I;" LENGTH IS";FNX(PL(I));" INCHES"
560 LPRINT "SPACED";FNX(SPP(I));" INCHES FROM DIRECTOR No.";I-1
570 LPRINT
580 NEXT
590 LPRINT "------ OVERALL BEAM LENGTH IS";FNX(LNT);" INCHES ------"
