	TITLE	<ASSEMBLY LISTING FOR MOVE/CMD>
;************************************************************
;
;	MOVE/CMD: Copyright 1987 by PFM Software from JBSoft.
;		  All rights reserved.  Permission is granted
;		  for personal but not commercial use.
;
;	Purpose: Copies a source file to a destination file
;		 and removes the source file if the copy was
;		 successful.  TRSDOS/LS-DOS 6.x only.
;
;	Syntax is the same as the system COPY command.
;
;	Programmer: R. A. Basham
;	Date written: September 1, 1987
;
;	Set up for the Misosys MRAS assembler.
;	Minor modifications may be necessary if
;	using some other assembler package.
;
;*************************************************************
;
;	SVC Equates
;
@ABORT	EQU	15H		;Abort execution and exit to DOS
@CMNDR	EQU	19H		;Execute command and return
@CMNDI	EQU	18H		;Execute command and exit to DOS
@DSPLY	EQU	0AH		;Display a message
@EXIT	EQU	16H		;Exit to DOS
;
CR	EQU	0DH		;Carriage return
SPC	EQU	20H		;Space char
MAXLEN	EQU	18H		;filename/ext.password:d
;
SVC	MACRO	#ADDR		;Supervisor call
	LD	A,#ADDR
	RST	28H
	ENDM
;
;	Upon entry to this routine, the HL register pair
;	contains the address of the first nonblank char
;	following the command name.
;
	ORG	3000H		;User RAM starts here
;
;	Move the command line string to the IOBUFF for
;	the COPY operation.
;
BEGIN	LD	DE,IOBUFF	;Get IOBUFF address
	PUSH	DE		; and save it for later
	PAGE
GETCMD	LD	A,(HL)		;Get next command line char
	INC	HL		;Bump HL past the char
	LD	(DE),A		;Move it to the IOBUFF
	INC	DE		;Increment DE for next char
	CP	CR		;Was it a carriage return?
	JR	NZ,GETCMD	;No. Back for the next char
;
;	Copy the source filespec from the IOBUFF to the
;	SOURCE buffer for the REMOVE operation.
;
	LD	HL,SOURCE	;Get SOURCE buffer address
	LD	B,MAXLEN	;filename/ext.password:d
	POP	DE		;Get IOBUFF address
;
GETSRCE	LD	A,(DE)		;Get the next char
	INC	DE		;Bump DE past it
	CP	CR		;CR is an error because
	JR	Z,SYNTAX	; there's no destination
	CP	SPC		;A space says we're done
	JR	Z,EXEC		; so execute the COPY
	LD	(HL),A		;Else store the char
	INC	HL		;Bump HL past it and
	DJNZ	GETSRCE		; back for the next char
;
;	Too few arguments in the the specified command
;	line or the source filespec is too long.
;
SYNTAX	LD	HL,USAGE	;Display the usage error
	SVC	@DSPLY
	LD	HL,0		;Set a good return code
	SVC	@EXIT		; and exit to DOS
;
;	If we get here, there is something in the SOURCE
;	buffer and the supplied command line is in the
;	IOBUFF.
;
;	We don't have to check for errors because the
;	system COPY command traps and processes errors.
;
EXEC	LD	(HL),CR		;CR for the REMOVE op
	LD	HL,COPY		;Get COPY op address
	SVC	@CMNDR		; and execute the COPY
	LD	A,L		;If we get a zero return
	OR	H		; code from the COPY,
	JR	Z,KILL		; we can kill the source
	SVC	@ABORT		;Else COPY failed so abort
;
;	If we get here, the COPY operation was successful.
;	We can now safely REMOVE the source file.
;
KILL	LD	HL,REMOVE	;Get REMOVE op address
	SVC	@CMNDI		;Execute it and exit to DOS
	PAGE
USAGE	DB	'Usage: MOVE source destination'
	DB	CR
REMOVE	DB	'REMOVE '
SOURCE	DS	MAXLEN		;filespec/ext.password:d
COPY	DB	'COPY '
IOBUFF	DS	50H		;Max 80 chars from command
	END	BEGIN
