;	MORESET -- Set up and editing program for MORE/APP
;
;	VERSION 1 --will open MORE/APP
;		    then display the current programs & library settings
;		    will allow user to mover cursor to one to edit
;		    will allow editing of description & library settings
;		    will prompt for saving on break key
;		    will be able to use with /JCL
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
@CKBRKC	EQU	6AH
@CLOSE	EQU	3CH
@CLS	EQU	69H
@DSP	EQU	02H
@DSPLY	EQU	0AH
@ERROR	EQU	1AH
@EXIT	EQU	16H
@FLAGS	EQU	65H
@KEY	EQU	01H
@KEYIN	EQU	09H
@MUL16	EQU	5BH
@OPEN	EQU	3BH
@POSN	EQU	42H
@READ	EQU	43H
@VDCTL	EQU	0FH
@WRITE	EQU	4BH
;
CR	EQU	0DH
ETX	EQU	03H
LF	EQU	0AH
UP_ARR	EQU	0BH
DN_ARR	EQU	0AH
LF_ARR	EQU	08H
MEN_PTR	EQU	2
LIB_PTR	EQU	4
MENU_LEN EQU	18
LIB_LEN	EQU	12
;
	ORG	3000H
;
START:	LD	(OLD_STK),SP
	SVC	@CKBRKC
	JR	NZ,ABORT
;
	SVC	@FLAGS		;CK FOR JCL OPERATION
	BIT	5,(IY+'S'-'A')
	JR	Z,START2
	LD	A,1		;SET FLAG FOR JCL OPERATION
	LD	(JCL_FLG),A
	JR	START3
;
START2:	CALL	BLK_CUR
	JP	NZ,DOS_ERR
	LD	(OLD_CUR),A
	SVC	@CLS
START3:	LD	HL,SIGNON$
	SVC	@DSPLY
	JP	NZ,DOS_ERR
	LD	DE,FCB		;OPEN MORE/APP
	LD	HL,F_BUF
	LD	B,0		;SET LRL=256
	SVC	@OPEN
	JR	Z,START1
	LD	HL,NO_MORE$
	SVC	@DSPLY
ABORT:	LD	HL,-1
EXIT:	CALL	CK_JCL
	JR	NZ,EXIT1
	LD	C,'_'		;RESTORE CURSOR
OLD_CUR: EQU	$-1
	CALL	SET_CUR
	SVC	@CLS
EXIT1:	LD	SP,$-$
OLD_STK: EQU	$-2
	SVC	@EXIT
;
START1:	LD	BC,MEN_PTR	;OPENED MORE/APP, NOW
	SVC	@POSN		;POSITION TO THE TEXT OF APPS TABLE
	JP	NZ,DOS_ERR
	SVC	@READ
	JP	NZ,DOS_ERR
	LD	HL,F_BUF	;COPY SECTOR TO WORK BUFFER
	LD	DE,MENU_TBL
	LD	BC,256
	LDIR
	PUSH	DE		;SAVE END OF BUFFER
	LD	DE,FCB
	LD	BC,MEN_PTR+1
	SVC	@POSN
	JP	NZ,DOS_ERR
	SVC	@READ
	LD	HL,F_BUF
	POP	DE
	LD	BC,256
	LDIR
	CALL	DSP_TXT		;DISPLAY WORK BUFFER
	LD	DE,FCB
	LD	BC,LIB_PTR
	SVC	@POSN
	JP	NZ,DOS_ERR
	SVC	@READ
	JP	NZ,DOS_ERR
	LD	HL,F_BUF	;COPY SECTOR TO WORK BUFFER
	LD	DE,LIB_TBL
	LD	BC,256
	LDIR
	CALL	DSP_LIB		;DISPLAY THE LIBRARY SETTINGS
;
OK:	CALL	POS_CUR		;SHOW CURSOR
	CALL	CK_JCL
	JR	Z,OK_1
	LD	HL,LET$
	SVC	@DSPLY
OK_1:	CALL	GET_KEY		;GET KEY STROKE
	JP	NZ,DOS_ERR
	CALL	DO_KEY		;PARSE KEY STROKE
	JR	OK		;AND LOOP FOR NEXT IF NEEDED
;
;	DO_KEY -- ROUTINE TO PARSE A KEY INPUT.
;		  INPUT IS IN A
;
DO_KEY:	CP	80H		;BREAK KEY?
	JR	NZ,DK1		;NO, CONTINUE PARSE
	POP	HL		;CLEAR RETURN FROM STACK
JCL_DONE:
	LD	A,0		;ANY CHANGES?
CHG_FLG	EQU	$-1
	OR	A
	JR	Z,CHG_1		;NO, QUIT
	CALL	CK_JCL
	JR	NZ,CHG_2
	LD	HL,23<8+0	;SET CURSOR POS
	LD	B,3		;FUNCTION: SET CURSOR
	SVC	@VDCTL
	JP	NZ,DOS_ERR
CHG_2:	LD	HL,CHG_MSG$	;ELSE PROMPT FOR SAVE CHANGES?
	SVC	@DSPLY
	JP	NZ,DOS_ERR
	CALL	CK_JCL
	JR	NZ,CHG_3
	LD	C,'_'
	CALL	SET_CUR
	JP	NZ,DOS_ERR
CHG_3:	CALL	GET_KEY
	JP	NZ,DOS_ERR
	AND	0DFH		;MAKE UPPER CASE
	CP	'Y'
	JR	NZ,CHG_1	;IF NOT Y THEN QUIT
	CALL	SAVE_CHG	;ELSE SAVE CHANGES & QUIT
CHG_1:	LD	HL,0
	CALL	CLOSE		;CLOSE MORE/APP FILE
	JP	EXIT
;
DK1	CP	DN_ARR		;DOWN ARROW?
	JR	NZ,DK2		;NO, GO, ELSE
	LD	A,(POS)
	INC	A
	CP	22		;BOTTOM OF DATA?
	JR	C,DK1_1		;NO SKIP AHEAD
	LD	A,2		;MOVE TO TOP OF WINDOW
DK1_1	LD	(POS),A
	RET
;
DK2	CP	UP_ARR		;UP ARROW?
	JR	NZ,DK3		;NO, GO
	LD	A,(POS)		;P/U CURRENT POS
	CP	2		;TEST TOP OF DATA
	JR	NZ,DK2_1	;NOT AT TOPS, SKIP
	LD	A,22		;SET TO BOTTOM OF WINDOW
DK2_1	DEC	A		;MOVE UP A ROW
	LD	(POS),A		;SAVE NEW POS
	RET
;
DK3	CP	CR		;SELECTED CURRENT?
	JR	NZ,DK4
	LD	A,(POS)		;P/U CURRENT ROW NUMBER
	DEC	A		;SET OFFSET (CURSOR ROW 2-21,
	DEC	A		; TABLE 0-19)
	JR	EDIT
;
DK4	AND	0DFH		;MAKE UPPERCASE
	CP	'A'
	RET	C		;BELOW A ENTERED, LOOP
	CP	'T'+1		;BEYOND T ENTERED, LOOP
	RET	NC
	SUB	'A'		;GET OFFSET IN A
;
EDIT:				;EDIT THE WINDOW APPLICATION IN MENU
	LD	(LIB_NUM),A	;SAVE NUMBER TO EDIT
	LD	C,A		;MOVE OFFSET IN TABLE TO C
	LD	A,1
	LD	(CHG_FLG),A	;SET CHANGE FLAG ON
	PUSH	BC		;SAVE NUMBER IN C
	CALL	CK_JCL
	JR	NZ,ED_7
	LD	C,'_'
	CALL	SET_CUR
	JP	NZ,DOS_ERR
ED_7:	POP	BC		;P/U NUMBER IN C
	LD	HL,MENU_LEN	;NUM OF CHARS IN MENU TABLE ENTRY
	SVC	@MUL16
	LD	H,L		;HL==OFFSET INTO MENU TABLE
	LD	L,A
	LD	DE,MENU_TBL+5
	ADD	HL,DE		;HL==>TEXT TO EDIT
ED_3:	PUSH	HL		;SAVE PTR TO TEXT
	PUSH	HL		;SAVE IT AGAIN
	LD	B,MENU_LEN-5	;BLANK MENU DATA
	LD	A,' '
ED_6:	LD	(HL),A
	INC	HL
	DJNZ	ED_6
	POP	HL		;P/U PTR TO MENU DATA
	LD	BC,MENU_LEN-5<8+5 ;NUMBER OF CHARACTERS IN DESCRIPTION
				;PLUS OFFSET IN FIELD
	CALL	BLANK		;BLANK FIELD
	LD	B,MENU_LEN-5	;GET NEW LINE FOR MENU
	POP	HL		;P/U PTR TO TEXT
	CALL	GET_LINE	;GET NEW TEXT
	JP	NZ,DOS_ERR
	JR	C,ED_3		;ENDED WITH BREAK, SO LOOP
ED_1:	LD	A,(HL)		;SEARCH FOR CR
	CP	CR
	JR	Z,ED_2		;SKIP IF FOUND
	INC	HL		;ELSE BUMP PTR
	JR	ED_1
ED_2:	LD	(HL),' '	;REPLACE CR WITH SPACE
	LD	A,0		;P/U NUMBER OF LIB TO EDIT
LIB_NUM	EQU	$-1
	LD	C,A
	LD	HL,LIB_LEN
	SVC	@MUL16
	LD	H,L
	LD	L,A		;OFFSET TO HL
	LD	DE,LIB_TBL
	ADD	HL,DE		;HL==>ENTRY
ED_4:	PUSH	HL		;SAVE PTR TO DATA
	PUSH	HL		;SAVE IT AGAIN
	LD	B,LIB_LEN-1	;BLANK ENTIRE LIBRARY ENTRY
	LD	A,CR
	LD	(HL),CR		;MARK END OF ENTRY
	LD	A,0
	INC	HL
ED_5:	LD	(HL),A
	INC	HL
	DJNZ	ED_5
	POP	HL		;P/U PTR TO DATA
	LD	BC,LIB_LEN<8+20	;FIELD LEN + SCREEN OFFSET
	CALL	BLANK		;BLANK FIELD
	POP	HL		;P/U PTR TO ENTRY TEXT
	LD	B,LIB_LEN-1	;GET NEW LIBRARY SPEC
	CALL	GET_LINE
	JP	NZ,DOS_ERR
	JR	C,ED_4		;ENDED WITH BREAK
;
	CALL	CK_JCL
	JP	NZ,JCL_DONE	;DONE EDITING, RETURN FOR MORE
	CALL	BLK_CUR
	RET
;
POS_CUR:			;ROUTINE TO MOVE CURSOR
	CALL	CK_JCL		;NO NEED TO MOVE CURSOR
	RET	NZ		;IN JCL MODE
	LD	HL,(POS-1)
	LD	B,3		;FUNCTION: SET CURSOR
	SVC	@VDCTL
	JP	NZ,DOS_ERR
	RET
;
DSP_TXT:
	CALL	CK_JCL		;DO NOT DISPLAY MENU IN JCL MODE
	RET	NZ
	LD	B,20		;NUMBER OF ENTRIES IN MENU TABLE
	LD	HL,MENU_TBL	;SET TXT_PTR
	LD	(TXT_PTR),HL
	LD	HL,02<8+0	;START THIRD ROW DOWN, COL 0
DT_1:	PUSH	BC		;SAVE COUNT OF ENTRIES
	PUSH	HL		;SAVE PTR TO SCREEN LINE
	LD	B,3		;FUNCTION: MOVE CURSOR
	SVC	@VDCTL
	JP	NZ,DOS_ERR
	LD	B,MENU_LEN	;NUMBER OF CHARACTERS
	LD	HL,(TXT_PTR)
DT_2:	LD	A,(HL)
	INC	HL
	LD	C,A
	PUSH	BC
	SVC	@DSP
	JP	NZ,DOS_ERR
	POP	BC
	DJNZ	DT_2
	LD	(TXT_PTR),HL	;SAVE PTR TO NEXT LINE
	POP	HL		;HL==CURRENT LINE START
	INC	H		;HL==NEXT LINE START
	POP	BC		;P/U COUNT OF ENTRIES
	DJNZ	DT_1		;LOOP FOR ALL ENTRIES
	RET
;
DSP_LIB:
	CALL	CK_JCL
	RET	NZ		;DO NOT DISPLAY IN JCL MODE
	LD	B,20		;NUMBER OF ENTRIES IN LIB TABLE
	LD	HL,LIB_TBL	;SET TXT_PTR
	LD	(TXT_PTR),HL
	LD	HL,02<8+MENU_LEN+2 ;START THIRD ROW DOWN, PAST MENU DATA
DL_1:	PUSH	BC		;SAVE COUNT OF ENTRIES
	PUSH	HL		;SAVE PTR TO SCREEN LINE
	LD	B,3		;FUNCTION: MOVE CURSOR
	SVC	@VDCTL
	JP	NZ,DOS_ERR
	LD	B,LIB_LEN	;NUMBER OF CHARACTERS
	LD	HL,(TXT_PTR)	;P/U START OF LINE
DL_2:	LD	A,(HL)
	INC	HL
	CP	CR		;END OF ENTRY?
	JR	Z,DL_3
	OR	A
	JR	Z,DL_3
	LD	C,A
	PUSH	BC
	SVC	@DSP
	JP	NZ,DOS_ERR
	POP	BC
DL_3:	DJNZ	DL_2
	LD	(TXT_PTR),HL	;SAVE PTR TO NEXT LINE
	POP	HL		;HL==CURRENT LINE START
	INC	H		;HL==NEXT LINE START
	POP	BC		;P/U COUNT OF ENTRIES
	DJNZ	DL_1		;LOOP FOR ALL ENTRIES
	RET
;
SAVE_CHG:
	LD	DE,F_BUF	;TRANSFER MENU DATA TO FILE BUFFER
	LD	HL,MENU_TBL
	LD	BC,256
	LDIR
	PUSH	HL		;SAVE POSITION STOPPED
	LD	DE,FCB		;POSITION FILE
	LD	BC,MEN_PTR
	SVC	@POSN
	JP	NZ,DOS_ERR
	SVC	@WRITE		;SAVE DATA
	JP	NZ,DOS_ERR
	LD	DE,F_BUF
	POP	HL		;P/U END POSITION
	LD	BC,256
	LDIR
	LD	DE,FCB
	LD	BC,MEN_PTR+1
	SVC	@POSN
	JP	NZ,DOS_ERR
	SVC	@WRITE
	JP	NZ,DOS_ERR
;
	LD	DE,F_BUF	;TRANS LIBRARY DATA TO BUFFER
	LD	HL,LIB_TBL
	LD	BC,256
	LDIR
	LD	DE,FCB		;POSITION FILE
	LD	BC,LIB_PTR
	SVC	@POSN
	JP	NZ,DOS_ERR
	SVC	@WRITE		;SAVE DATA
	JP	NZ,DOS_ERR
	RET
;
CLOSE:
	LD	DE,FCB
	SVC	@CLOSE
	RET
;
BLANK:	;ENTRY: B = NUMBER OF SPACES TO DISPLAY
	;       C = OFFSET OF CURSOR TO FIELD
	CALL	CK_JCL
	RET	NZ
;
	PUSH	BC
	LD	A,(POS)		;P/U ROW
	LD	H,A
	LD	L,C
	LD	B,3
	SVC	@VDCTL
	JP	NZ,DOS_ERR
	POP	BC
	PUSH	HL		;SAVE CURSOR POS
	LD	C,' '
BLNK_1	PUSH	BC		;SAVE COUNT & CHAR
	SVC	@DSP
	JP	NZ,DOS_ERR
	POP	BC
	DJNZ	BLNK_1
	POP	HL
	LD	B,3
	SVC	@VDCTL
	JP	NZ,DOS_ERR
	RET
;
DOS_ERR:
	LD	L,A	;SET ABORT ERROR CODE
	LD	H,0
	OR	0C0H	;SET SHORT & RETURN BIT
	LD	C,A
	SVC	@ERROR
	CALL	CLOSE	;CLOSE OPEN FILE
	JP	EXIT	;AND QUIT PROGRAM
;
BLK_CUR:
	LD	C,8CH		;SET SMALL BLOCK CURSOR
;
SET_CUR:
	LD	B,8
	SVC	@VDCTL
	JP	NZ,DOS_ERR
	RET
;
GET_LINE:
	PUSH	HL		;RETURN PTR TO START SO SAVE START
	CALL	CK_JCL
	JR	Z,GL_4		;USE KEY BOARD INPUT
	LD	A,MENU_LEN-5
	CP	B
	JR	NZ,GL_6
	LD	HL,DES$
	SVC	@DSPLY
	JR	GL_7
;
GL_6:	LD	HL,M_SPEC$
	SVC	@DSPLY
GL_7:	JP	NZ,DOS_ERR
	LD	HL,LINE_BUF
	LD	C,0
	SVC	@KEYIN		;RETURNS HL==>LINE_BUF
	JP	NZ,DOS_ERR	;AND B=COUNT
	POP	DE		;P/U PTR TO START
	PUSH	DE		;SAVE START POINTER
	LD	C,B
	LD	B,0
	LDIR
	DEC	HL		;POINT TO FINAL CHARACTER
	LD	A,(HL)		;P/U TERMINATING CHARACTER
	POP	HL		;P/U POINTER TO START OF LINE
	CP	A		;SET Z FLAG
	RET
;
GL_4:	SVC	@KEY		;GET KEY STROKE
	JR	NZ,GL_5		;RETURN WITH ERROR
	CP	' '		;CONTROL CHARACTER?
	JR	C,GL_3		;YES, GO PROCESS
	LD	(HL),A		;SAVE IN BUFFER
	INC	HL		;BUMP BUFFER PTR
	LD	C,A		;MOVE CHAR TO C
	SVC	@DSP		;SHOW IT
	JR	NZ,GL_5		;RETURN WITH ERROR
	DJNZ	GL_4		;AND LOOP FOR MAX
	LD	A,CR
	LD	(HL),A		;END LINE WITH AUTOMATIC CR
GL_3:	CP	CR		;WAS IT END OF LINE?
	JR	Z,GL_2		;YES, BACK WITH CR
	CP	80H		;WAS IT BREAK?
	JR	Z,GL_1		;YES, RETURN CARRY FLAG
	CP	LF_ARR		;BACKSPACE?
	JR	NZ,GL_4		;IGNORE ALL OTHER CONTROL CHAR
	POP	DE		;P/U PTR TO START OF BUFFER
	PUSH	DE		;SAVE IT AGAIN
	PUSH	HL		;SAVE PTR TO BUFFER
	XOR	A		;CLEAR CARRY
	SBC	HL,DE		;CK FOR START OF BUFFER
	POP	HL		;P/U PTR TO BUFFER
	JR	Z,GL_4		;AT BEGINNING OF BUFFER, DO NOTHING
	DEC	HL		;BACKSPACE POINTER
	PUSH	BC		;SAVE COUNT IN B
	LD	C,LF_ARR	;BACKSPACE CURSOR
	SVC	@DSP
	POP	BC
	JR	NZ,GL_5		;RETURN WITH ERROR
	PUSH	BC
	LD	C,' '		;BLANK POSITION
	SVC	@DSP
	POP	BC
	JR	NZ,GL_5		;RETURN WITH ERROR
	PUSH	BC
	LD	C,LF_ARR	;REPOSITION CURSOR
	SVC	@DSP
	POP	BC
	JR	NZ,GL_5		;RETURN WITH ERROR
	JR	GL_4		;LOOP FOR NEXT CHAR
;
GL_2:	POP	HL		;P/U PTR TO START
	CP	A		;SET Z FLAG
	RET
;
GL_1:	CP	A		;SET Z FLAG
	SCF			;SET CARRY FLAG
GL_5:	POP	HL		;P/U PTR TO START OF BUFFER
	RET
;
GET_KEY:		;READ INPUT FROM KEYBOARD OR JCL FILE
	CALL	CK_JCL
	JR	NZ,GK_1
	SVC	@KEY
	RET
;
GK_1:	LD	BC,80<8+0	;SET UP TO READ ENTIRE LINE
	LD	HL,LINE_BUF	;BUT ONLY WANT ONE KEY
	SVC	@KEYIN
	RET	NZ
	LD	A,(HL)
	RET
;
CK_JCL:		;RET Z IF NO JCL ELSE Z
	LD	A,0
JCL_FLG	EQU	$-1
	OR	A
	RET
;
SIGNON$: DB	'MORESET -- set the applications MORE can call by Aaron O''Neill, July, 1992',LF
	DB	'     Description    Memberspec',CR

;
NO_MORE$: DB	'Could not open MORE/APP.  Program aborted!',CR
;
CHG_MSG$: DB	'      Save changes (Y/N)? ',ETX
;
LET$:	DB	'        Letter to change? ',ETX
DES$:	DB	'         New description? ',ETX
M_SPEC$: DB	'New member specification? ',ETX
;
LINE_BUF: DS	81
;
FCB:	DB	'MORE/APP',CR
	DS	23
;
F_BUF:	DS	256
;
	DB	0
POS	DB	2
;
TXT_PTR: DW	$-$
;
	DC	.HIGH.$.SHL.8-$+256,0
;
MENU_TBL: DC	20*MENU_LEN,0
;
	DC	.HIGH.$.SHL.8-$+256,0
LIB_TBL: DC	20*LIB_LEN,0
	DC	.HIGH.$.SHL.8-$+256,0
;
	END	START
