;*=*=*
;	MORE application for accessing a /APP files from a window
;*=*=*
	OPTION	+CI
CR	EQU	13
UP_ARR	EQU	11
DN_ARR	EQU	10
@SOUND	EQU	104
@KEY	EQU	1
;*=*=*
;	Establish macro
;*=*=*
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	40
	ENDM
*GET	WINDOW/MAC
;*=*=*
;	The following is the header protocol
;*=*=*
	ORG	2700H		;Forces START to 2800H
	DB	'PROWAM'
	DB	'MorePrograms',3
	DC	13,0
	DC	.HIGH.$.SHL.8-$+256,0
;*=*=*
;	This is where the program starts
;*=*=*
	IFNE	$,2800H
	ERR	'Something is wrong in the header
	ENDIF
;
START:	LD	HL,2.SHL.8+31	;ORIGIN NW CORNER AT ROW 2, COL 31
	LD	DE,20.SHL.8+18	;WINDOW TO HAVE 20 ROWS, 18 COLUMNS
	@WCREAT			;FUNCTION TO OPEN A WINDOW
	JR	Z,OK		;GO IF WE WERE ABLE TO OPEN IT
	LD	B,00.SHL.4+02	;NO GOOD, SET UP PARMS FOR BEEP
	SVC	@SOUND		;BEEP THE SPEAKER AND RETURN
	RET
;*=*=*
;	Window opened, display menu and get response
;*=*=*
OK	@WB2W	BUFFER		;DISPLAY MENU
	LD	C,08CH		;SMALL BLOCK
	CALL	DSP_POS
	SVC	@KEY		;WAIT FOR KEY STROKE
	CALL	DO_KEY		;DO KEY STROKE
	JR	OK		;AND LOOP FOR NEXT IF NEEDED
;
;	DO_KEY -- ROUTINE TO PARSE A KEY INPUT.
;		  INPUT IS IN A
;
DO_KEY:	CP	80H		;BREAK KEY?
	JR	NZ,DK1		;NO, CONTINUE PARSE
	POP	HL		;CLEAR RETURN FROM STACK
	@WCLOSE			;C SET FOR EXPORT OR CLOSE
	RET
;
DK1	CP	DN_ARR		;DOWN ARROW?
	JR	NZ,DK2		;NO, GO, ELSE
	CALL	DSP_SPC
	LD	A,(POS)
	INC	A
	CP	20		;BOTTOM OF WINDOW?
	JR	C,DK1_1
	LD	A,0		;MOVE TO TOP OF WINDOW
DK1_1	LD	(POS),A
	RET
;
DK2	CP	UP_ARR		;UP ARROW?
	JR	NZ,DK3		;NO, GO
	CALL	DSP_SPC
	LD	A,(POS)		;P/U CURRENT POS
	OR	A		;TEST FOR ZERO, TOP OF WINDOW
	JR	NZ,DK2_1	;NOT AT TOPS, SKIP
	LD	A,20		;SET TO BOTTOM OF WINDOW
DK2_1	DEC	A		;MOVE UP A ROW
	LD	(POS),A		;SAVE NEW POS
	RET
;
DK3	CP	CR		;SELECTED CURRENT?
	JR	NZ,DK4
	LD	A,(POS)		;P/U CURRENT ROW NUMBER
	JR	EXECUTE
;
DK4	AND	0DFH		;MAKE UPPERCASE
	CP	'A'
	RET	C		;BELOW A ENTERED, LOOP
	CP	'T'+1		;BEYOND T ENTERED, LOOP
	RET	NC
	SUB	'A'		;GET OFFSET IN A
;
EXECUTE:			;EXECUTE A WINDOW APPLICATION FROM MENU
	ADD	A,A		;DOUBLE OFFSET IN A
	LD	HL,LOOK_UP	;HL==>LOOK UP TABLE
	ADD	A,L		;HL==>PTR TO PROGRAM TO EXECUTE
	LD	L,A
	JR	NC,EX1
	INC	H
EX1	LD	E,(HL)		;DE==>STRING TO EXECUTE
	INC	HL
	LD	D,(HL)
	EX	DE,HL		;HL==>STRING TO EXECUTE
	LD	C,0		;NO EXPORT ON CLOSE
	PUSH	HL
	@WCLOSE			;CLOSE WINDOW
	POP	HL		;P/U PTR TO STRING TO EXECUTE
	POP	DE		;CLEAR STACK OF RETURN
	@WEXEC			;EXECUTE PROGRAM
	RET			;RET TO CALLER OF APP
;
DSP_SPC:
	LD	C,' '
DSP_POS:			;ROUTINE TO DISPLAY CHAR AT POS
	LD	HL,(POS-1)
	PUSH	HL		;SAVE POS
	PUSH	BC		;SAVE CHAR IN C
	@WSCUR
	POP	BC		;P/U CHAR
	@WDSP			;DISPLAY IT
	POP	HL		;P/U POS AGAIN
	@WSCUR			;BACK UP CURSOR
	RET
;
	DB	0
POS	DB	0
;
	IF	$.LT.2850H	;Check on memory buffer conflict
	ERR	'Memory conflict, move video buffer!!!'
	ENDIF
;
	DC	.HIGH.$.SHL.8-$+256,0	;PUT BUFFER ON PAGE BOUNDRY
;
BUFFER:
	DB	'  A. Address file '
	DB	'  B. Bring Up     '
	DB	'  C. Cardx File   '
	DB	'  D. Disk EDitor  '
	DB	'  E. BringUpPrint '
	DB	'  F. File EDitor  '
	DB	'  G. Cardx Format '
	DB	'  H. Address HEAD '
	DB	'  I. CharacterSet '
	DB	'  J. Card Format  '
	DB	'  K. Things To Do '
	DB	'  L. Typewriter   '
	DB	'  M. MemoryEDitor '
	DB	'  N. Card Filer   '
	DB	'  O. Video Editor '
	DB	'  P. PhraseExport '
	DB	'  Q. MiniTerminal '
	DB	'  R. RPN Calc     '
	DB	'  S. *DO Save     '
	DB	'  T. Text Editor  '
;
	DC	.HIGH.$.SHL.8-$+256,0
;
PRG_A	DB	'0ADDRESS:0',CR
	DB	0			;SPACE TO MAKE MAX NAME LEN
PRG_B	DB	'0BRINGUP:0',CR
	DB	0
PRG_C	DB	'0CARDX:0',CR
	DC	3,0
PRG_D	DB	'0DED:0',CR
	DC	5,0
PRG_E	DB	'0BUP:0',CR
	DC	5,0
PRG_F	DB	'0FED:0',CR
	DC	5,0
PRG_G	DB	'0CARDXF:0',CR
	DC	2,0
PRG_H	DB	'0HEAD:0',CR
	DC	4,0
PRG_I	DB	'0CHARSET:0',CR
	DB	0
PRG_J	DB	'0CARDFORM:0',CR
PRG_K	DB	'0TODO:0',CR
	DC	4,0
PRG_L	DB	'0TYPER:0',CR
	DC	3,0
PRG_M	DB	'0MED:0',CR
	DC	5,0
PRG_N	DB	'0CARD:0',CR
	DC	4,0
PRG_O	DB	'0VED:0',CR
	DC	5,0
PRG_P	DB	'0PHRASE:0',CR
	DC	2,0
PRG_Q	DB	'0TERM:0',CR
	DC	4,0
PRG_R	DB	'0RPNCALC:0',CR
	DB	0
PRG_S	DB	'0DOSAVE:0',CR
	DC	2,0
PRG_T	DB	'0TED:0',CR
	DC	5,0
;
LOOK_UP:
	DW	PRG_A,PRG_B,PRG_C,PRG_D,PRG_E
	DW	PRG_F,PRG_G,PRG_H,PRG_I,PRG_J
	DW	PRG_K,PRG_L,PRG_M,PRG_N,PRG_O
	DW	PRG_P,PRG_Q,PRG_R,PRG_S,PRG_T
;
;*=*=*
;	Standard memory overflow check
;*=*=*
	IF	$.GT.3000H		;Check on memory overflow
	ERR	'Memory overflow!!!'
	ENDIF
;*=*=*
;	Zero last sector of application file - patch space
;*=*=*
	IFLT	$,3000H
	DC	.HIGH.$.SHL.8-$+256,0	;Zero remainder of sector
	ENDIF
;
	END	START			;START must be 2800H
