SVC	MACRO	#N
	LD	A,#N
	RST	28H
	ENDM
;-----------------------------------------------
@CKDRV	EQU	33
@DIRRD	EQU	87
@DIRWR	EQU	88
@DSPLY	EQU	10
@ERROR	EQU	26
@EXIT	EQU	22
;-----------------------------------------------
LF	EQU	10
CR	EQU	13
ETX	EQU	3
;-----------------------------------------------
	ORG	3000H
;-----------------------------------------------
DEC	DB	0	; current DEC
DRIVE	DB	0	; current drive
COUNT	DB	0	; changes this sector
;-----------------------------------------------
WRONG	DB	'Syntax is MOD :d'
	DB	LF
	DB	' where :d is the logical drive'
	DB	LF,CR
;-----------------------------------------------
SYNTAX	LD	HL,WRONG
	SVC	@DSPLY
	LD	HL,0
	SVC	@EXIT
;-----------------------------------------------
OOPS	OR	0C0H
	LD	C,A
	SVC	@ERROR
QUIT	LD	HL,0
	SVC	@EXIT
;-----------------------------------------------
START	LD	IX,DEC
;...............................................
CMDLINE	LD	A,(HL)	; command line
	INC	HL
	CP	' '
	JR	Z,CMDLINE
;...............................................
	CP	':'
	JR	Z,CMDLINE
;...............................................
	CP	CR
	JR	Z,SYNTAX
;...............................................
	CP	'0'
	JR	C,SYNTAX
;...............................................
	CP	'8'
	JR	NC,SYNTAX
;...............................................
	AND	7
	LD	(DRIVE),A
;
	LD	C,A
	SVC	@CKDRV
	LD	A,15		; write protected
	JR	C,OOPS
	LD	A,8		; not available
	JR	NZ,OOPS
;...............................................
READ	LD	B,(IX+0)	; dec
	LD	C,(IX+1)	; drive
	SVC	@DIRRD
	JR	Z,READOK
;...............................................
	LD	A,(DEC)
	CP	10H		; single side ?
	JR	NZ,OOPS
;...............................................
	JR	QUIT
;-----------------------------------------------
READOK	XOR	A
	LD	(COUNT),A
	CALL	TEST
	LD	A,(COUNT)
	OR	A
	JR	Z,NOPUT
;...............................................
	LD	B,(IX+0)	; dec
	LD	C,(IX+1)	; drive
	SVC	@DIRWR
	JR	NZ,OOPS
NOPUT	LD	A,(DEC)
	INC	A
	LD	(DEC),A
	CP	20H
	JR	C,READ
;...............................................
	JR	QUIT
;-----------------------------------------------
TEST	PUSH	HL
	POP	IY
	LD	B,8
LOOP1	BIT	7,(IY+0)	; FPDE ?
	JR	NZ,NOPE		; go if not
;...............................................
	BIT	4,(IY+0)	; in use ?
	JR	Z,NOPE		; go if not
;...............................................
	BIT	6,(IY+1)	; Mod flag ?
	JR	Z,NOPE		; go if not
;...............................................
	RES	6,(IY+1)	; clear flag
	LD	A,(COUNT)
	INC	A
	LD	(COUNT),A
NOPE	LD	DE,20H
	ADD	IY,DE
	DJNZ	LOOP1
	OR	A	; reset carry
	RET
;-----------------------------------------------
	END	START
