	TITLE	<MOVE/CMD>
;program to install the memdisk as drive 0, moving
;the other drives up one number, without disturbing
;their order.
SVCTABLE	EQU	0
V60	EQU	0
MOD1	EQU	0
MOD3	EQU	.NOT.MOD1
;the above set up the use of SVCMAC/MAC, by telling
;if the SVC table is resident, and if this program
;is for Version 6.x LDOS (TRSDOS)
*GET	SVCMAC/MAC
;this equate is for the JCL file's FCB
	IF	MOD1
JFCB$	EQU	4358H
	ELSE
JFCB$	EQU	4265H
	ENDIF
;actual program starts here
	IF	.NOT.V60
	ORG	5200H
	ELSE
	ORG	3000H
	ENDIF
BEGIN	PUSH	HL	;save command line pointer
	LD	HL,SIGNON	;let's announce ourselves
	@DSPLY
	POP	HL	;retrieve pointer
	DEC	HL	;start with command line pointer-1
SKIPSPA	INC	HL	;move pointer up one
	LD	A,(HL)	;put next character in A
	CP	' '	;and check against space
	JR	Z,SKIPSPA	;if so, skip
	CP	0DH	;look for <cr>
	JR	Z,ERROR	;no drive number
	CP	':'	;if ':', ignore, treat as space
	JR	Z,SKIPSPA
	CP	'8'	;check range
	JP	NC,ERROR	;not '7' or less
	CP	'0'
	JP	C,ERROR	;less than '0'
;if we made it this far, A contains a valid LDOS drive number
	AND	7	;convert to binary
	IF	.NOT.V60
	LD	(CMPR),A	;save for later use
	ENDIF
	LD	B,A	;and move the result to B
	XOR	A	;clear the accumulator
MULT	ADD	A,0AH	;# of bytes per DCT block
	DJNZ	MULT	;times # of drives-1
	PUSH	AF	;save offset against the unknown
	LD	C,0	;let's get the address of DCT for :0
	GETDCT		;with the system call
	POP	AF	;get offset back
	PUSH	IY	;save DCT address from IY....
	POP	HL	;so we can put it in HL
	PUSH	AF	;save our offset again
	ADD	A,L	;add the offset to HL
	JR	NC,NCRY	;if a carry is generated, we must
	INC	H	;increase H by 1
NCRY	LD	L,A	;and put new lsb in L
	PUSH	HL	;save this for later
	LD	DE,END	;we'll save this DCT entry for later
	LD	BC,0AH	;at the end of this program
	LDIR
;At this point, HL points to the address just past the end of the
;entry we are moving. On top of the stack is our offset, and under
;that is the address of the beginning of the entry we are moving.
;We'll get both off the stack, decrement both the address pointers,
;switch them to the right places, and do a LDDR.
	POP	DE	;get old DCT+offset, because we'll move
	DEC	DE	;other drives up into it, starting with
			;drive to move - 1
	DEC	HL	;pointed to end-of-DCT-entry + 1 before
	EX	DE,HL	;get numbers into right registers
	POP	AF	;get offset value back to use in next move
	LD	B,0	;to make room for the new :0
	LD	C,A	;here we use the # calculated in MULT
	LDDR
;Now, HL points to DCT-1, DE at DCT+10. Let's increment HL to
;point it at DCT, then exchange DE and HL, load HL with END
;(which is where we stored the entry for our drive-to-move),
;and move it into the new slot
	INC	HL	;now points to DCT address
	EX	DE,HL	;move it to DE (destination)
	LD	HL,END	;now we can move new :0's DCT
	LD	BC,0AH	;how much to move
	LDIR
;If this was done from a JCL, we must increment the drive
;number in the JCL file's FCB, found at JFCB$+6 <435E> [426B],
;unless it was the drive that we move, then it must be
;made to point at :0
	IF	.NOT.V60	;not for Ver. 6.x yet
	LD	HL,JFCB$+6	;point HL to drive # byte
	LD	A,(HL)	;put current drive number into A
	CP	00H	;we put logical drive being moved here
CMPR	EQU	$-1
	JR	NZ,OTHER	;wasn't drive being moved
	XOR	A	;was drive we moved, so make it 0
	JR	RSTORE	;jump to where we restore it
OTHER	ADD	A,1	;add 1 to it
RSTORE	LD	(HL),A	;put it back
	ENDIF
	LD	HL,DONE	;tell everyone that we're finished
	@DSPLY
	LD	HL,0	;clear HL for version 6.0
	@EXIT
ERROR	LD	HL,ERRMESS	;let's tell them they messed up
	@LOGOT	;send it to *JL and *DO
	@ABORT	;take the ABORTivt way out to LDOS
SIGNON	DB	'MOVE/CMD - Logical drive mover for LDOS (tm)',0AH
	DB	'(c) 1983 by Jeffrey R Brenton',0DH
DONE	DB	'New SYSTEM drive installed',0DH
ERRMESS	DB	'Parameter error - Recheck command line',0AH
	DB	'Syntax is "MOVE {:}d" where d is logical '
	DB	'drive 0 through 7',0DH
END	EQU	$
	END	BEGIN

