;**********  mneta2/asm **********
SNDPT1:	LD	DE,8000H
SNDPT2:	CALL	GETIMM		;wait for ctrl-q...
	JR	Z,SNDPT3
	CP	XON		;a ctrl-q???
	JR	Z,SNDPT4	;if so, let's go.
SNDPT3:	DEC	E
	JR	NZ,SNDPT2
	DEC	D
	JR	NZ,SNDPT2
	DJNZ	SNDPT1		;if it takes too long, go ahead anyhow.
SNDPT4:	POP	BC
	POP	DE
SNDPT5:	POP	AF
	CALL	RSPUT		;xmit the data byte
	RET
;
; error messages
;
DERROR:	OR	0C0H		;get short error msg
	CALL	@ERROR		;from dos
ABORT:	LD	A,(SIFLAG)
	OR	A		;in protocol mode?
	JR	Z,ABORT1	;no, just waiting for something
	LD	HL,ABLOAD	;general abort message
	CALL	VIDLIN
	LD	DE,DCB
	LD	A,(DE)
	BIT	7,A		;was file open?
	CALL	NZ,@CLOSE	;close if so
	LD	A,KNAK
	CALL	RSPUT		;send aborting <nak>
ABORT1:	LD	SP,(STKPTR)	;reset stack pointer
	XOR	A
	LD	(SIFLAG),A	;disable a protocol
	JP	DTERM		;return to mainline
;
;
GETCKS:	CALL	GETWAT		;get a char
	CP	ETX		;check for <etx> not preceded by <dle>
	RET	Z		;return if so - done with block
	PUSH	AF		;else save flags
	CP	EOT		;are we done??  end of transmission!
	JR	NZ,GETCK1
	LD	(APEOT),A	;say "eot seen"
GETCK1:	CP	DLE
	JR	NZ,GETCK2	;if dle, then get next one
	CALL	GETWAT		;<dle> masks a control character
	AND	1FH		;so get another & unmask it.
GETCK2:	CALL	DOCKS		;update cksum
	POP	AF		;flag set by cp etx
	LD	A,D		;restore byte
	RET	
;
DOCKS:	LD	D,A		;save the byte
	LD	A,E		;get old checksum
	RLCA			;rotate thru carry
	ADD	A,D		;add in the new byte
	ADC	A,0		;include any carry bit
	LD	E,A		;save new checksum
	LD	A,D		;restore the byte
	RET
;
GETIMM:	LD	A,(3840H)
	BIT	1,A		;<clear>?
	JP	NZ,ABORT
	AND	4		;break key?
	JP	NZ,EXIT	
	CALL	INPUT		;get a byte from rs-232
	RET	Z		;don't wait if no input.
	AND	7FH		;strip top bit away
	RET
;
GETWAT:	LD	A,(3840H)	;check for <break> press here
	BIT	1,A		;is <clear> down?
	JP	NZ,ABORT	;then get out of download 
	AND	4		;or back to dos if <break>
	JP	NZ,EXIT		;so it can't hang the machine
	CALL	INPUT		;get an unstripped byte
	JR	Z,GETWAT	;wait if nothing there
	CP	KNAK		;is it a <nak>??? (unmasked)
	JP	Z,ABORT		;abort if so.
	RET
;
RSPUT:	PUSH	AF
	CALL	OUTPUT		;send character out
	POP	AF
	RET
;
VDCHRK:	CALL	VIDCHK		;header info and "/" or "." 
	JP	NZ,VDCHAR	;only if <not> showing data..
	RET
;
VIDCHK:	PUSH	BC
	LD	C,A		;save current char
	LD	A,(DMODE)	;are we displaying data?
	OR	A		;set flag
	LD	A,C		;restore byte
	POP	BC
	RET			;Z=show it 
;
VIOMRK:	CALL	VIDCHK		;displaying data?
	RET	Z		;then don't show this part
	PUSH	AF		;else...
	LD	A,CR		;do funny things..
	CALL	VDCHAR		;on display during file transfer
	LD	A,32		;using "their" method
	LD	(XFRCTR),A
	POP	AF
	CP	'.'
	CALL	Z,VDCHAR
	RET
;
CTXFR:	CALL	VIDCHK		;display data as received?
	JP	Z,VDCHAR	;yes, do it
	PUSH	AF		;else..
	PUSH	HL		;show "+" sometimes
	LD	HL,XFRCTR
	DEC	(HL)
	JR	NZ,CTXFR0
	LD	(HL),32
	LD	A,'+'
	CALL	VDCHAR
CTXFR0:	POP	HL
CTXFR2:	POP	AF
	RET
;
DTGL:	LD	HL,DMSG
	CALL	VIDLIN		;start msg
	LD	A,(DMODE1)	;reverse setting for 
	OR	A		;data display during
	LD	HL,DSPOFF	;file transfer
	LD	A,0FFH
	JR	Z,DTGL2		;was <on>,turn off
	LD	HL,DSPON	;else
	XOR	A		;if off,turn on
DTGL2:	LD	(DMODE1),A	
	CALL	VIDLIN		;announce it
	RET
;
DMODE:	DB	0		;display data in protocol mode?
DMODE1:	DB	0		;keep this one as set in term mode
CRFLG:	DB	0		;prev char to check for cr,lf
APEOT:	DB	0		;<eot> received.
XFRCTR:	DB	0		;counter for showing "+"
POINT:	DW	0		;pointer to "next" posn in xcvbuf
LAST1:	DW	0		;pointer to current end from file(+1)
COUNT:	DB	0		;bytes to send in current block
APNXT:	DB	'0'		;record number expected
APCUR:	DB	'0'		;record number received
XFRTYP:	DB	0		;<a>scii or <b>inary xfer
APFLG:	DB	0		;nonzero if eot to be sent unmasked
EOFFLG:	DB	0		;flag if all of file read
STKPTR:	DW	0		;save stack for abort return
MDM80:	DW	0		;screen bufr add if called fm modem80
CURSPS:	DW	9260H		;"saved" cursor posn for modem80
SIFLAG	DB	0		;non-zero if protocol enabled
KEYBUF	DC	2,0		;keyin buffer!
DNLOAD:	DB	LF,LF,'!! CSEXEC - Beginning DOWNload',LF,CR
UPLOAD:	DB	LF,LF,'!! CSEXEC - Beginning UPload',LF,CR
ABLOAD:	DB	LF,LF,'%% CSABRT - Aborting file transfer',LF,CR
DLBOMB:	DB	LF,LF,'That file already exists on your disk!'
	DB	LF,'Do you wish to replace it (Y or N) ? ',ETX
DMSG:	DB	LF,'!! Data display during file transfer <O',ETX
DSPON:	DB	'N> !',CR
DSPOFF:	DB	'FF> !',CR
;
SYSID:	DB	'#RS2LM,,,PL,PA,HC',0DH,00H
	DB	0,0,0,0,0,0,0	;in case someone wants to zap here
				;
DCB:	DB	0		;for file control blk
DBUFF	EQU	DCB+50		;disk buffer
XCVBUF	EQU	DBUFF+256	;xmit/rcv buffer
;the equ's don't generate extra space here like ds would
;
; meaning of the data in sysid:
; #rs222,cc,cw,pl,pa,hc
; #means can use protocol
; #rs222 means radio shack mod 1 w/trsdos 2.2
;
; cc= cursor control  (not implemented)
; implies the following cursor control:
; <esc><a>        cursor up
; <esc><b>        cursor down
; <esc><c>        cursor right
; <esc><d>        cursor left
; <esc><h>        cursor home
; <esc><j>        erase to end of screen
; <esc><k>        erase to end of line
; <esc><j>        erase screen and home cursor (also <ff>)
; <esc><y><l+31><c+31> position cursor to line l and column c
; cw= width control    (not implemented)
; <esc><m>        go to double size characters (32 per line)
; <esc><l>        switch to normal (64 per line) characters
; hc= hard copy   (not implemented)
; implies the following:
; <dc2> (ctrl-r, 022 octal, 12 hex) enable printer
; <dc4> (ctrl-t, 024 octal, 14 hex) disable printer
; pa= a protocol
; implies file transfer capability using the compuserve a protocol
; pl= load protocol
; implies ability to load code segments under the compuserve l protocol
;
INIT	EQU	$		;set things up, then we can overwrite
	LD	(STKPTR),SP	;in case needed
	PUSH	HL		;command line 
;
; check if mod i or iii
;
	LD	A,(54H)		;a rom location 
	DEC	A		;always 1 in mod i 
	JR	Z,MODI
	LD	HL,(4411H)	;MIII high$
	JR	CALC
;
MODI:	LD	HL,(4049H)	;get mem pointer 
CALC:	LD	(MEMPT1),HL	;save for later
	OR	A		;clear carry 
	LD	DE,12*256+XCVBUF;space needed for file trans.
	SBC	HL,DE		;check for room
	JP	C,NOMEM		;quit if not
; this part looks for device name passed (ldos only!)
; other doses will not open a device
	POP	HL		;cmd line
	DEC	HL
SC1:	INC	HL
	LD	A,(HL)
	CP	20H		;skip any spaces
	JR	Z,SC1
	CP	CR
	JP	Z,RESET	
	CP	'*'		;devicespec starts with *
	JP	NZ,RESET	;else use own driver
;
OPENCL:	LD	DE,CLDCB	;set up dcb
	CALL	@FSPEC
	JR	NZ,NODEV	
	LD	DE,CLDCB	;if no error
	CALL	@OPEN		;then open the device
	JR	LOGON		;and use it 
	OR	0C0H
	CALL	@ERROR		;get msg if error
;
NODEV:	LD	HL,DEVSPR	;tell user
	JR	NOM2
;
NOMEM:	POP	HL
	LD	HL,NOMEM1	;no free memory
NOM2:	CALL	VIDLIN		;show it
	JP	@ABORT		;and quit 
;
RESET:	LD	A,0FFH		;any value will work here
	OUT	(MR),A		;signal master reset
	LD	A,UART		;no parity, 8 bit words, 1 stop bit
	OUT	(CTRL),A	;set up paramaters
	LD	A,BAUD		;get baud
	OUT	(CONFIG),A	;output to baud rate gen.
;
LOGON:	LD	A,(402DH)	;check to see if
	CP	0C3H		;called from
	JR	NZ,LOGON1
	LD	DE,(402EH)	;modem80..
	LD	HL,9940H	;address at dos @exit if
	SBC	HL,DE		;"standard" version
	LD	HL,8680H	;address where screen stored
	JR	Z,GETSCR	;put it back now!
	LD	HL,9224H	;fix the "saved" cursor position
	LD	(CURSPS),HL	;for "ldos" version
	LD	HL,98E3H	;then check for "ldos" version
	SBC	HL,DE
	LD	HL,8780H	;screen is here if so
	JR	Z,GETSCR	;move it
;
LOGON1:	LD	HL,BANNER	;announce program
	CALL	VIDLIN
	JP	DTERM		;ready to go now
;
GETSCR:	LD	(MDM80),HL	;save dup screen address for exit
	LD	DE,VIDEO	;move last modem80 screen back
	LD	BC,LINE*LINES	;to video
	LDIR
	JR	LOGON1		;then log on program
;
NOMEM1:	DB	'>> Not enough memory for file transfers! ',CR
DEVSPR:	DB	'>> Device spec required!',CR
BANNER:	DB	LF,'CIS A protocol  -  Version 1.0   02/10/82',CURSON,LF,CR
;

