;**********  MNETA1/ASM ***********
;     This program uses parts of the:
; *** COMPUSERVE INFORMATION SERVICE EXECUTIVE
; Copyright (c) 1980, 1981 COMPUSERVE INCORPORATED
; by Russ Ranshaw and Harry Selfridge.
; This adaptation for TRS-80 MODEL I or III (any DOS)
; by Les Mikesell, with thanks to Ray Pelzer for some of
; the 8080 to Z-80 translation.
;
; ***************  NOTE  ****************
;This program handshakes with the 'XA' on SIGS, 'ACCESS', and
;the file transfer utility 'XFTRAN'. 'XFTRAN' works just like
;'FILTRN', i.e. the files are uploaded or downloaded to the
;user's personal filespace.  On 'XA' and 'ACCESS', this
;program allows use of the 'DOW' function.
;The SYSID string must be modified for use with SOFTEX.
;A later version may include this change.
;
; This version has none of the fancy cursor or printer 
; controls of vidtex included. It is just a dumb terminal
; with the error-free protocol for file transfers. It may be
; called as a dos command from modem-80 (or other smart
; terminal program), or used alone. If called from another
; terminal program, it must be loaded before typing the
; R XFTRAN or DOW filespec command so it will identify itself
; when the host checks.  Unlike the original, this program
; will display the data as it is being transmitted so that
; you can abort the transfer if the file is not one you
; wanted, especially useful for the things in access.
; In the terminal mode, pressing:
; <CLEAR> + 8   sends left square bracket
; <CLEAR> + 9   sends right square bracket
; these characters are needed to surround another users id # 
; to identify his files
; <CLEAR> + :   clears the screen locally
; <CLEAR> + -   toggles display mode during file transfer
; (default is to display the data)
; the mode can only be changed before the transfer starts,
; because..
; during the file transfer, pressing:
; <CLEAR> will abort the transfer and return to terminal mode
; pressing <break> at any time will exit from the program.
;
; The load to ram protocol for downloading object files
; created by the cross-assemblers on compuserve is also
; implememted. (use the system program LODHEX for those
; files which are stored in intel hex format).
;
; special equates for dos, etc.
@FSPEC	EQU	441CH		;move filename to fcb
@INIT	EQU	4420H		;dos init a new file
@OPEN	EQU	4424H		;dos open an existing file
@CLOSE	EQU	4428H		;dos close a file
@ERROR	EQU	4409H		;get error msg
@KEYIN	EQU	40H		;line from kb
@ABORT	EQU	4030H
@EXIT	EQU	402DH		;normal exit
; special characters for data transmission protocol
SOH	EQU	01H		;start of text
ETX	EQU	03H		;end of text
EOT	EQU	04H		;end of transmission
SI	EQU	0FH		;<si> = shift into protocol mode
SO	EQU	0EH		;<so> = shift out of protocol mode
; protocol mode implies that <esc> sequences
; are not sent to console but are used to control
; the up/down load protocol
XON	EQU	11H		;<dc1> control-q: resume transmission
XOFF	EQU	13H		;<dc3> control-s: stop transmission
KNAK	EQU	15H		;<nak>
DLE	EQU	10H		;<dle> (transparacy flag)
ESC	EQU	1BH		;escape
CR	EQU	0DH		;<ret>
LF	EQU	0AH		;<lf>
;
VIDEO	EQU	3C00H		;screen address
LINE	EQU	64		;chars/line
LINES	EQU	16		;lines/screen
CURSOR	EQU	4020H		;cursor storage
BKSP	EQU	08H
CARET	EQU	5EH
HOME	EQU	1CH		;home cursor
CLR	EQU	1FH		;to end of screen
CURSON	EQU	0EH		;turn cursor on 
;
; uart definitions
BAUD	EQU	55H		;baud setup (300 baud) use 77h for 1200
				;if 1200 baud is used, the data cannot be 
				;displayed during the file transfer.
UART	EQU	6CH		;8 bit words, no parity, 1 stop bit
MR	EQU	0E8H		;master reset
MODEM	EQU	0E8H		;input gives modem status
CONFIG	EQU	0E9H		;out sets baud rate
CTRL	EQU	0EAH		;out sets params, in gives status
DATA	EQU	0EBH		;data in, out
CARRIER	EQU	020H		;bit 5 of modem off if carrier
OUTRDY	EQU	040H		;bit 6 of ctl set if ready for char
INPBIT	EQU	80H		;bit 7 of ctl set if new input
;
@GET	EQU	013H		;char fm device/file
@PUT	EQU	01BH		;char to device/file
@DSP	EQU	033H		;char to display
@KBD	EQU	02BH		;char fm keyboard
;
;      aseg  ;(for macro-80) assemble to absolute addresses
	ORG	5200H		;as low as possible
;
ENTRY:	JP	INIT		;log on and initialize, etc....
;*****
; The RS-232 routines:
;*****
INPUT:	PUSH	DE
	LD	DE,CLDCB	
	CALL	@GET		;input char fm rs232 / no wait
	POP	DE	
	RET	
;
OUTPUT:	PUSH	DE
	LD	DE,CLDCB
	CALL	@PUT		;output char to rs232
	POP	DE
	RET	
;
;device control block
; if ldos device name is passed on command line when
; program is loaded, this will be routed to their driver
;
CLDCB:	DB	07H		;i/o device type 
DRVADD:	DW	CLDVR		;address of driver
	DC	5,0		;leave some space here
;
;use:   ld de,cldcb
;       call @ctrl  to see if uart is ready to send
;                   returns w/ Z set if ready
;       call @get   to input a character
;                   Z set on return means no input
;       call @put   to send character in a
;
;all of these calls maintain all of the register contents
;except af (and iy which is not used anyway).
;
; driver routine ************
; for non-standard rs232 configurations which will not be
; used with an ldos driver, replace this code and the uart
; intialization at reset:
; entering the driver with c set means the call was from @get
; and the driver should return with the character in the
; a register and Z reset, or with Z set if there is no input.
; entering with Z set means the call was from @put and the 
; character to be output will be in the c register.
; if neither c or Z is set, the call is from @ctl (not used
; in this program).
; the rom routines save/restore the hl,bc,de,and ix registers
; for the driver, and ix will be pointing to the dcb when the
; driver is entered.
;
CLDVR	EQU	$	
	JR	Z,CLOUT		;output request 
	JR	C,CLINT		;input request 
;
; status test (from call 23h)
; can uart accept output now?
;
CLSTAT:	IN	A,(CTRL)	;get uart status 
	AND	OUTRDY		;bit 6, 1=holding reg. empty
	XOR	OUTRDY		;reverse flag so Z set=ready
; remove semi-colons to wait for carrier detect also
;       ret nZ
;       in   a,(modem) ;chk carrier (0 if detected)
;       and  carrier   ;mask other bits 
	RET			;Z = ready 
;
; input request
CLINT:	IN	A,(CTRL)	;get status
	AND	INPBIT		;test for input
	RET	Z		;Z set if no input
	IN	A,(DATA)	;get data
	RET			;
;
; for output request
CLOUT:	CALL	CLSTAT		;check uart status
	JR	NZ,CLOUT	;wait till ready
	LD	A,C		;get character 
				;the @put call passes char in c
	OUT	(DATA),A	;output data 
	RET	
;
; end of rs232 driver
;
VIDLIN:	PUSH	HL		;line to display (for mod i/iii)
VID3:	LD	A,(HL)		;get char
	CP	ETX		;done?
	JR	Z,VID2
	PUSH	AF
	CALL	@DSP
	POP	AF
	INC	HL		;point to next
	CP	CR		;done?
	JR	NZ,VID3
VID2:	POP	HL
	RET
;
DSP:	PUSH	DE
	CALL	@DSP		;use system video
	POP	DE
	RET
;
; video filter -  add caret before ctl chars
VDCHAR:	PUSH	AF	
	CALL	VDSHOW		;fix up for display
	POP	AF
	RET	
;
VDSHOW:	AND	7FH		;no graphics or sp comp codes wanted
	CP	20H		;printable??
	JP	NC,DSP		;print char if not control
	CP	0AH
	JP	Z,DSP		;linefeeds
	CP	0DH
	JP	Z,DSP		;carriage return
	CP	BKSP
	JP	Z,DSP
	CP	07H		;bell
	JP	Z,DSP		;in case someone has hdw mod for bell
	CP	CLR		;clear ?
	JR	Z,CLRSCR	;or..
	CP	0CH		;formfeed?
	JR	NZ,CTLCHR
CLRSCR:	LD	A,HOME
	CALL	DSP		;then clear screen
	LD	A,CLR
	JP	DSP
CTLCHR:	PUSH	AF		;print caret, char
	LD	A,CARET
	CALL	DSP
	POP	AF
	OR	40H		;chg to upper case char
	JP	DSP	
;
EXIT:	CALL	@KBD		;<break> was detected by scanning 
				;kb memory, so get character
				;out of ldos type-ahead buffer
	LD	DE,(MDM80)	;called fm modem80?
	LD	A,D
	OR	E		;address is zero if not
	JR	Z,EXIT1		;so quit
	LD	HL,VIDEO	;else pass screen contents
	LD	BC,LINE*LINES	;back to modem80 screen buffer
	LDIR			;to make things less confusing
	LD	DE,(CURSPS)	;and pass current cursor position
	LD	HL,CURSOR	;also..
	LD	BC,2	
	LDIR
EXIT1:	JP	@EXIT		;and quit
;
CONTRL:	LD	HL,3820H	;chk number row of kb to use...
	BIT	0,(HL)		;<cear> + 8
	JR	NZ,LFTBRK	;for left square bracket
	BIT	1,(HL)		;<clear> +9
	JR	NZ,RTBRK	;for right sqr brk
	BIT	2,(HL)		;<clear> + :
	JR	NZ,CLR1		;for local screen clear 
	BIT	5,(HL)		;and <clear> + -
	JR	Z,OUTP	
	CALL	DTGL		;to toggle protocol display mode
	JR	INCK
CLR1:	CALL	CLRSCR
	JR	INCK	
LFTBRK:	LD	A,5BH		;send left square bracket
	JR	OUTP
RTBRK:	LD	A,5DH		;or right square bracket
	JR	OUTP		;needed for mnet id numbers
;
CTLZ:	LD	HL,3808H	;check kb memory
	BIT	2,(HL)		;is Z key pressed?
	JR	NZ,OUTP		;really is ctl-Z
	JR	INCK		;skip if just shift-dn-arrow
;
; dumb terminal mode
DTERM:	LD	A,(3840H)
	AND	4		;<break?>
	JP	NZ,EXIT		;exit if pressed
	CALL	@KBD		;check for input
	CP	CLR		;is it <clear?>
	JR	NZ,KEY2	
	LD	A,(3880H)	;then check for <shift>
	OR	A
	LD	A,CLR		;if <shift><clear>
	JR	Z,INCK		;else ignore <clear>
KEY2:	OR	A	
	JR	Z,INCK		;go on if no keypress
	LD	HL,3840H	;look for <clear> key
	BIT	1,(HL)		;so we can use....
	JR	NZ,CONTRL	;combinations for special purposes
	CP	1AH		;old roms generate this with shift-dn arrow
	JR	Z,CTLZ		;so skip unless Z key is down
;
OUTP:	CALL	OUTPUT		;send out rs232
;
INCK:	CALL	INPUT		;received character?
	JR	Z,DTERM		;if no input
	AND	7FH		;mask parity
	CP	DLE		;<dle> received
	JR	Z,ISDLE		;process if so
SHOW:	CP	SI		;start protocol?
	JR	Z,ISSI	
	CP	SO		;non-protocol
	JR	Z,ISSO
	CP	ESC		;is it <escape>?
	JR	Z,ISESC		;yes, see what to do next
	PUSH	AF		;save char
	CP	LF		;linefeed?
	JR	NZ,NOTLF	;no
	LD	A,(CRFLG)	;check last char
	CP	CR		;was it cr?
	JR	Z,SKPCHR	;then don't display lf
NOTLF:	LD	A,(CRFLG)	;check last chr
	CP	ESC		;was it escape?
	JR	Z,SKPCHR	;skip if so (cursor conrtol etc)
	POP	AF		;get flag set by cp esc
	PUSH	AF
	CALL	NZ,VDCHAR	;display
SKPCHR:	POP	AF
NOTSIM:	LD	(CRFLG),A	;and save last char
	JP	DTERM		;loop
;
ISDLE:	CALL	GETWAT		;if <dle>, then get next char
	AND	1FH		;make control char
	JR	SHOW		;and print it
;
ISSO:	XOR	A		;<so> disables protocol mode
ISSI:	LD	(SIFLAG),A	;<si> enables protocol mode
	JP	DTERM		;continue
;
ISESC:	LD	A,(SIFLAG)	;is protocol enabled?
	OR	A
	LD	A,ESC		;reload esc
	JR	Z,NOTSIM	;not using protocol
;
ISESCN:	CALL	GETWAT		;wait for next char
	AND	7FH		;mask it
	CP	'I'		;if <esc> <i>
	JP	NZ,ESC0		;else
	LD	HL,SYSID	;then send id
SNDID:	LD	A,(HL)
	INC	HL
	OR	A		;end?
	JP	Z,DTERM		;then back to terminal
	CALL	RSPUT		;send char
	JR	SNDID		;till done
;
ESC0:	CP	'L'		;if <esc><l>
	JP	NZ,ESC1		;else
	LD	E,0		;then system load function
	CALL	GETCKS		;get byte count
	LD	B,A
	CALL	GETCKS		;get low address byte
	LD	L,A
	CALL	GETCKS		;get high address byte
	LD	H,A
;
ESCL0:	CALL	GETCKS		;next data byte
	LD	(HL),A		;save it
	INC	HL		;point to next
	DEC	B		;count down
	JR	NZ,ESCL0	;load block
	LD	C,E		;save checksum
	CALL	GETCKS		;get checksum
	CP	C		;match?
	LD	A,'.'		;logical ack
	JR	Z,ESCL1		;if correct
	LD	A,'/'		;if no match, send "/"
ESCL1:	CALL	OUTPUT		;
	CALL	VDCHAR		;and display
	JP	DTERM		;and wait for next
;
ESC1:	CP	'A'		;<esc><a>?
	JP	NZ,NOTSIM	;if not
	LD	(STKPTR),SP	;save stack pointer for emergencies
;
; initialiZe for data transmission
; using the compuserve a-protocol
; the protocol begins with the following sent from the host:
; <esc><a><soh><recnum><u | d><a | b><filespec><etx><cksum>
; where the <recnum> is a single digit ascii record
; number of "1","2", ... "9", or "0"
; where the <u> or first <d> imply upload or download
; a=ascii (remove <lf> after a <cr>), b=binary
; the <filespec> is a standard trsdos file specification.
; cksum=checksum for the record
;
ABEGIN:	XOR	A
	LD	(APFLG),A	;clear flags
	LD	(EOFFLG),A
	LD	A,'0'		;start record number digit
	LD	(APNXT),A	;save it
	LD	(DMODE),A	;don't display cmd line
	LD	HL,XCVBUF	;point to start of buffer
	LD	(POINT),HL	;to put command
	PUSH	HL
	CALL	APRCMD		;get command line fm host
	POP	HL		;get buffer pointer
	LD	(POINT),HL	;and reset for transfer
	LD	HL,XCVBUF+2	;rcv'd filename fm host
	LD	DE,DCB		;move filespec to
	CALL	@FSPEC		;the dcb
	LD	A,(XCVBUF+1)	;get transfer type of
	LD	(XFRTYP),A	;<a>scii or <b>inary
	CP	'B'		;if binary
	JR	Z,NOTASC	;leave block mode display
	LD	A,(DMODE1)
	LD	(DMODE),A	;set display mode for data
NOTASC:	XOR	A
	LD	(CRFLG),A	;clear flag to start
	LD	B,0		;lrl = 256
	LD	DE,DCB		;set up to open file
	LD	HL,DBUFF	;point to disk buffer
	LD	A,(XCVBUF)	;get direction of xfer
	CP	'D'		;download??
	JP	NZ,CHECKU	;nope, check upload
	CALL	@INIT		;if download, start new file
	JP	NZ,DERROR	;abort if error occurred
	JR	C,INITOK	;not an existing file
	LD	HL,DLBOMB	;existing file
	CALL	VIDLIN		;announce it
	LD	B,1		;chars wanted
	LD	HL,KEYBUF	;buffer to receive
	CALL	@KEYIN		;wait for answer 
	LD	A,(KEYBUF)	;get answer
	AND	5FH		;make upper case
	CP	'Y'		;check answer
	JP	NZ,ABORT	;abort if good file
INITOK:	LD	HL,DNLOAD	;else announce download
	CALL	VIDLIN
;
DOWNLD:	CALL	APRCV		;receive a block 
	JR	NZ,DLLAST	;eot rcv'd if not zero
	CALL	WRITE		;check buffer, write if needed
	JR	DOWNLD		;and keep loading buffer
DLLAST:	DEC	HL		;back up past the <eot> char
	CALL	WRITE1		;write what we have now
	LD	DE,DCB
	CALL	@CLOSE		;then close file
	JP	NZ,DERROR	;abort on closing error
	LD	A,'.'
	CALL	RSPUT		;announce we got it.
	CALL	VIOMRK
	LD	SP,(STKPTR)
	JP	DTERM		;return to mainline
;
CHECKU:	CP	'U'		;upload??
	JP	NZ,ABORT	;abort if not
	CALL	@OPEN		;open existing file
	JP	NZ,DERROR	;abort on open error
	LD	HL,UPLOAD	;else announce upload
	CALL	VIDLIN
	LD	A,'.'		;logical <ack>
	CALL	RSPUT		;send to host
	CALL	VIOMRK
;
;start the upload!
	CALL	GETWAT		;see if host is
	CP	'.'		;ready to receive
	JP	NZ,ABORT	;abort if not
	CALL	READ		;read the disk 
UPL1:	CALL	GETBYT		;reset (count), read more if needed
	JR	C,UPL2		;carry set if we already finished
	CALL	APSND		;now do the transmission
	JR	UPL1		;and do the next block
UPL2:	CALL	APSND0		;transmit <eot> unmasked 
	LD	SP,(STKPTR)	;ready to go home now.
	JP	DTERM		;back to mainline
;
;*********  subroutines ***********
;
GETBYT:	LD	DE,(POINT)	;get next byte address
	LD	HL,(LAST1)	;one past end byte
	OR	A
	SBC	HL,DE		;how many left in buffer
	JR	Z,GTMORE	;none - if "next" is past end
	LD	A,H
	OR	A		;more than 256?
	LD	A,0		;then write 256
	JR	NZ,GETB2
	LD	A,L		;else write remaining
GETB2:	LD	(COUNT),A	;bytes to send in this block
	RET	
;
GTMORE:	LD	A,(EOFFLG)	;end of file read?
	OR	A	
	JR	Z,GTB3		;if not, read more
	LD	HL,XCVBUF
	LD	(POINT),HL	;else send eot
	LD	(HL),EOT
	LD	A,1
	SCF			;carry set means finished
	JR	GETB2		;set count and return
;
GTB3:	CALL	READ		;read in some more
	JR	GETBYT		;and then set pointers
;
;disk read routine
;
READ:	LD	HL,XCVBUF
	LD	(POINT),HL	;start at beginning
	LD	BC,10*256+XCVBUF;quit when we get here
	LD	DE,DCB		;point to file
READ0:	CALL	@GET		;load a byte
	JP	NZ,EOFCK	;test for end, else error
	LD	(HL),A		;store char
	PUSH	HL
	SBC	HL,BC		;test for 10 sectors
	POP	HL
	INC	HL		;bump pointer for next (doesn't affect flags)
	JR	NZ,READ0	;till buffer full or eof
;
READ1:	LD	(LAST1),HL	;save pointer to end byte (1 past)
	RET	
;
EOFCK:	CP	1CH		;is error code "eof"
	JP	NZ,DERROR	;abort if something else
	LD	(EOFFLG),A	;flag that file is done
	LD	A,(XFRTYP)	;if ascii transfer
	CP	'A'
	JR	NZ,EOF2		;go if <b>
	DEC	HL		;if <a>scii
	LD	A,CR		;then check if..
	CP	(HL)		;last char was cr...
	JR	Z,EOF1
	INC	HL		;if not, add one
	LD	(HL),A		;just to be sure
EOF1:	INC	HL		;that file will be accepted
	JR	READ1	
;
EOF2:	PUSH	HL		;if <b>inary file we must
	LD	DE,XCVBUF	;send multiples of 32 bytes
	OR	A		;for the .bin format
	SBC	HL,DE		;so...
	LD	A,L		;get low byte of count in bfr(mod256)
	POP	HL		;restore bfr pointer
	AND	32-1		;mask out even multiples
	JR	Z,READ1		;ok if even
	LD	B,A		;<32
	LD	A,32		;we want 32
	SUB	B		;how many more?
	LD	B,A		;into b
EOF3:	LD	(HL),0		;pad out with zero bytes
	INC	HL
	DJNZ	EOF3		;to multiple of 32
	JR	READ1		;and go back
;
; disk write routine
;
WRITE:	PUSH	HL		;save posn in buffer
	LD	DE,256*10+XCVBUF;got ten sectors yet?
	OR	A		;clear carry
	SBC	HL,DE		;test
	POP	HL		;restore current position
	RET	C		;not full yet, keep loading buffer
;
WRITE1:	LD	DE,XCVBUF	;starting point
	OR	A		;clear carry
	SBC	HL,DE		;get count of bytes to write
	PUSH	HL
	POP	BC		;into bc 
	EX	DE,HL		;start to hl
	LD	(POINT),HL	;fix pointer while we have it
;
	LD	DE,DCB		;point to file
WRITE2:	LD	A,C
	OR	B		;test for end
	RET	Z		;quit if done
	DEC	BC		;count down
	LD	A,(HL)		;get char
	INC	HL		;point to next 
	CALL	@PUT		;write it
	JP	Z,WRITE2	;do it all unless error
	JP	DERROR		;then quit
;
; receive a record from host and save in buffer
APRCV:	LD	A,'.'		;prompt host for data
	CALL	RSPUT		;send it
	CALL	VIOMRK		;init display
APRCMD:	LD	A,(APNXT)
	INC	A		;bump the desired record number
	CP	'9'+1
	JR	C,APRCM1	;past "9" yet??
	LD	A,'0'		;start at "0" again
APRCM1:	LD	(APNXT),A
	CALL	VDCHRK		;show record #
APRCV0:	CALL	GETWAT		;get a byte
	CP	SOH		;start of record??
	JR	Z,APRCV1	;then go!
	CP	ETX
	JR	NZ,APRCV0	;<etx> alone is questionable
	LD	A,'/'		;so we'd better ask
	CALL	RSPUT		;for a retransmission
	CALL	VDCHRK
	JR	APRCV0
;
APRCV1:	XOR	A
	LD	E,A		;for checksum
	LD	(APEOT),A	;clear <eot> flag & checksum
	LD	HL,(POINT)	;get current pointer
	CALL	GETCKS		;get sender's record number
	LD	(APCUR),A	;and hold it
APRCV2:	CALL	GETCKS		;get a byte and checksum
	JR	Z,APRCV3	;jump if <etx> received
	CP	LF		;was it a line feed?
	JR	NZ,APRC2A
	LD	A,(XFRTYP)	;if so, is this ascii transfer?
	CP	'A'
	JR	NZ,APRCLF	;jump if not
	LD	A,(CRFLG)	;does it follow a <cr>?
	CP	CR
	LD	A,0		;reset crflg
	LD	(CRFLG),A	;so only one lf is skipped
	JR	Z,APRCV2	;ignore <lf> if so.
APRCLF:	LD	A,LF		;else restore the line feed
APRC2A:	LD	(HL),A		;store the byte in buffer
	LD	(CRFLG),A	;and save to check for <cr,lf>.
	CALL	MEMPT		;bump pointer (unless up to high$)
	CALL	CTXFR		;give display some work.
	JR	APRCV2		;and loop for more
;
APRCV3:	LD	C,E		;save our checksum
	CALL	GETCKS		;get theirs
	CP	C		;checksums verify??
	JR	NZ,APRCV4	;nope
	LD	A,(APNXT)	;yep, get our record number
	LD	C,A
	LD	A,(APCUR)	;check with their rec #
	CP	C
	JR	NZ,APRCV5	;no match, check further
	LD	(POINT),HL	;all ok, store buffer position
	LD	A,(APEOT)	;put <eot> flag in a
	OR	A		;set flags accordingly
	RET			;and go back
;
APRCV4:	LD	A,'/'		;bad checksum, so
APRC4A	CALL	RSPUT		;ask for retransmission
	CALL	VDCHRK		;announce it
	JP	APRCV0
APRCV5:	JP	NC,ABORT	;abort if we missed a record
	LD	A,'.'		;unless it was a duplicate, then
	JR	APRC4A		;ok it, ignore it, and continue
;
MEMPT:	PUSH	DE
	LD	DE,$-$		;store high mem pointer here
MEMPT1	EQU	$-2		;when program initializes
	PUSH	HL		;just in case we missed...
	OR	A		;the etx for a block
	SBC	HL,DE		;we better check...
	POP	HL		;if loaded up to high$
	POP	DE		;before bumping pointer
	RET	Z		;since we don't know how
	INC	HL		;big a block will be
	RET
;
APSND:	XOR	A		;flag to mask control chars
APSND0:	LD	(APFLG),A	;set mask mode
	LD	A,(APNXT)	;get expected rec num
	INC	A		;and bump it
	CP	'9'+1
	JR	C,APSND1
	LD	A,'0'		;wrap back to 0
APSND1:	LD	(APNXT),A	;save it
APSN1A:	LD	A,(APNXT)
	CALL	VDCHRK		;display num
APSND2:	LD	E,0		;clear checksum
	LD	A,SOH
	CALL	SNDPUT		;start the record
	LD	A,(APNXT)	;get record number
	CALL	SNDPUT		;transmit it
	CALL	DOCKS		;and checksum it.
APSND3:	LD	A,(COUNT)	;number of bytes
	LD	B,A
APSN3B:	LD	HL,(POINT)	;point to start of record
APSN3C:	LD	A,(HL)		;get a char
	CP	CR		;is it cr?
	JR	NZ,APSN3D
	LD	A,(XFRTYP)	;then check if..
	CP	'A'		;<a>scii type transfer
	LD	A,CR		;restore cr
	JR	NZ,APSN3D	;if not ascii
	CALL	DOCKS		;else add cr to cksum
	CALL	SNDMSK		;and send
	LD	A,LF		;and then send lf
APSN3D:	CALL	CTXFR		;display or show  "+"
	CALL	DOCKS		;checksum the char
	CALL	SNDMSK		;send it
	INC	HL		;point to next
	DJNZ	APSN3C		;send entire record
;
	LD	A,ETX		;tell host rec is finished
	CALL	SNDPUT		;send etx unmasked
	XOR	A
	LD	(APFLG),A	;flag to use dle
	LD	A,E		;get checksum
	CALL	SNDMSK		;xmit the checksum
;
APSN5A:	LD	B,7		;wait for reply
APSN5B:	LD	DE,0
APSND6:	CALL	GETIMM
	JR	NZ,APSND7
	DEC	D
	JR	NZ,APSND6
	DEC	E
	JR	NZ,APSND6
	DJNZ	APSN5B
	LD	A,ETX
	CALL	SNDPUT		;send extra <etx> if slow
	JR	APSN5A
APSND7:	CP	KNAK		;host says abort?
	JP	Z,ABORT		;then quit
	CALL	VIOMRK		;dsply rcvd char
	CP	'/'
	JP	Z,APSN1A	;error, retry
	CP	'.'
	JR	NZ,APSND6	;wrong answer,wait 
	LD	(POINT),HL	;done with this record, save position
	RET
;
;
SNDMSK:	CP	20H		;chk for control char
	JR	NC,SNDPUT	;send if not
	CP	CR		;we will send a lot of these
	JR	Z,SNDPUT	;so make a special check
	CP	LF		;to save time since they
	JR	Z,SNDPUT	;will pass tymnet ok
	PUSH	AF		;save char
	LD	A,(APFLG)	;check if masking
	OR	A
	JR	Z,SNDLE		;zero if adding dle
	POP	AF		;if not wanted, go on
	JR	SNDPUT
SNDLE:	LD	A,DLE		;precede w/dle
	CALL	SNDPUT	
	POP	AF		;get char
	OR	40H		;add 40h to get char through tymnet etc.
;necessary to avoid confusion with the control characters
;that are always being transmitted by synchronous modems
;
SNDPUT:	PUSH	AF
	CALL	GETIMM		;check for host
	JR	Z,SNDPT5	;if no input
	CP	KNAK		;else
	JP	Z,ABORT		;abort if asked by <nak>
	CP	XOFF		;ctrl-s pause requested?
	JR	NZ,SNDPT5	;if not, who cares?
	PUSH	DE
	PUSH	BC
	LD	B,2

