; you may need a separate program like this to assemble:
; *GET MNET6/ASM
;      END ENTRY
;
	TITLE	<MNETA	*CL>
;**********  MNETA1/ASM ***********
;     This program uses parts of the:
; *** COMPUSERVE INFORMATION SERVICE EXECUTIVE
; Copyright (c) 1980, 1981 COMPUSERVE INCORPORATED
; by Russ Ranshaw and Harry Selfridge.
; This adaptation for TRS-80 MODEL I or III (now mod 4)
; by Les Mikesell, with thanks to Ray Pelzer for some of
; the 8080 to Z-80 translation.
; adapted for TRSDOS 6 on 04/25/84 by JJKD
;       corrected for close of upload file
;       16:00 05/22/84  JJKD
;       improved 1200 baud operation
; 12/27/85 LM:
;   HIGH/LOW memory self configure 
;   Note: receive buffer is very small when called from
;      COMM or BASIC - calling from Modem80 or standalone
;      leaves full buffer size
;   Adjust circle buffer a bit
;   Allow non-256 LRL file open for send
;   Use GTMOD to find $CL driver if no device name given
;   Pass screens with Modem80 pgm if called as DOS cmd
;   Expand tabs on screen instead of showing ^I
;   Pad .BIN type uploads to 128 byte multiples (was 32) to
;     see if it helps with Compuserve's problem with finding EOF
;     when a different protocol is used to download.
;   Fix bug in disk error handler (move error code to C)
;
; ***************  NOTE  ****************
;This program handshakes with the 'XA' on SIGS, 'ACCESS', and
;The file transfer utility 'XFTRAN'. 'XFTRAN' works just like
;'FILTRN', i.e. the files are uploaded or downloaded to the
;User's personal filespace.  On 'XA' and 'ACCESS', this
;Program allows use of the 'DOW' function.
;The SYSID string must be modified for use with SOFTEX.
;A later version may include this change.
;
; This version has none of the fancy cursor or printer 
; controls of vidtex included. It is just a dumb terminal
; with the error-free protocol for file transfers. It may be
; called as a dos command from COMM (or other smart
; terminal program), or used alone. If called from another
; terminal program, it must be loaded before typing the
; R XFTRAN or DOW filespec command so it will identify itself
; when the host checks.  Unlike the original, this program
; will display the data as it is being transmitted so that
; you can abort the transfer if the file is not one you
; wanted, especially useful for the things in access.
;******************************************
;
;       changes for TRSDOS 6.x
;
;*****************************************
;
;       The system keyboard driver and all other
;       drivers are used. This makes transfer abort
;       to be <shift><clear>, and local clear 
;       screen to be <clear><:>.
;
;       The COM/DVR wakeup vector is picked up upon entry
;       and restored upon exit. A 128 (64?) byte circular
;       buffer is used. This should provide for proper 
;       operation at up to 1200 baud.
;
;       <clear><-> toggles data display during download.
;       make sure you toggle this *before* starting the
;       download.
;
; pressing <break> at any time will exit from the program.
;
;******************************************************
;
; The load to ram protocol for downloading object files
; created by the cross-assemblers on compuserve is also
; implememted. (use the system program LODHEX for those
; files which are stored in intel hex format).
;
; special characters for data transmission protocol
SOH	EQU	01H		;Start of text
ETX	EQU	03H		;End of text
EOT	EQU	04H		;End of transmission
SI	EQU	0FH		;<si> = shift into protocol mode
SO	EQU	0EH		;<so> = shift out of protocol mode
; protocol mode implies that <esc> sequences
; are not sent to console but are used to control
; the up/down load protocol
XON	EQU	11H		;<dc1> control-q: resume transmission
XOFF	EQU	13H		;<dc3> control-s: stop transmission
KNAK	EQU	15H		;<nak>
DLE	EQU	10H		;<dle> (transparacy flag)
ESC	EQU	1BH		;Escape
CR	EQU	0DH		;<ret>
LF	EQU	0AH		;<lf>
;
TAB	EQU	09H		;Will expand to spaces
BKSP	EQU	08H
CARET	EQU	5EH
HOME	EQU	1CH		;Home cursor
CLR	EQU	1FH		;To end of screen
CURSON	EQU	0EH		;Turn cursor on 
CURSOFF	EQU	0FH	
;
;
*GET	SVCMAC
;
	ORG	2600H		;As low as possible
;
; video ctl stuff..
GETCUR:	PUSH	BC
	LD	B,4
VDCTL:	PUSH	DE
	LD	A,15
	RST	28H		;@@VDCTL
	POP	DE
	POP	BC
	RET
;
GETSC1:	PUSH	BC
	LD	B,6
	JR	VDCTL
DOCOFF:	LD	A,CURSOFF
	JR	DODSP
DOCON:	LD	A,CURSON
DODSP:	JP	DSP
GETSCR:	CALL	DOCOFF
	CALL	GETSC1
	JR	DOCON
;
VIDLIN	PUSH	DE
	@@DSPLY
	POP	DE
	RET
INPUT	EQU	$
	PUSH	DE
	PUSH	HL
	CALL	GETCIRC
	EI
	POP	HL
	POP	DE
	RET
OUTPUT	EQU	$
	PUSH	BC
	PUSH	DE
	LD	C,A
	LD	DE,CLDCB
	@@PUT
	POP	DE
	POP	BC
	RET
;
; video filter -  add caret before ctl chars
VDCHAR:	PUSH	AF	
	CALL	VDSHOW		;Fix up for display
	POP	AF
	RET	
;
VDSHOW:	AND	7FH		;No graphics or sp comp codes wanted
	RET	Z
	CP	20H		;Printable??
	JP	NC,DSP		;Print char if not control
	CP	0AH
	JP	Z,DSP		;Linefeeds
	CP	0DH
	JP	Z,DSP		;Carriage return
	CP	BKSP
	JP	Z,DSP
	CP	TAB
	JR	NZ,NOTAB
	PUSH	HL
	CALL	GETCUR
	LD	A,L
	POP	HL
	PUSH	BC
	LD	C,8
SUBLP:	SUB	C
	JR	NC,SUBLP
	NEG
	LD	B,A
TBLP:	LD	A,' '
	CALL	DSP
	DJNZ	TBLP
	POP	BC
	RET
NOTAB:	CP	CLR		;Clear ?
	JR	Z,CLRSCR	;Or..
	CP	0CH		;Formfeed?
	JR	NZ,CTLCHR
CLRSCR:	LD	A,HOME
	CALL	DSP		;Then clear screen
	LD	A,CLR
	JR	DSP
CTLCHR:	PUSH	AF		;Print caret, char
	LD	A,CARET
	CALL	DSP
	POP	AF
	OR	40H		;Chg to upper case char
DSP	EQU	$
	PUSH	BC
	PUSH	DE
	LD	C,A
	@@DSP
	POP	DE
	POP	BC
	RET
;
EXIT	EQU	$
	LD	IY,$-$
OLDWAKE	EQU	$-2		;Spot for old wakeup vector
	LD	DE,CLDCB
	LD	C,4
	@@CTL
EMPTY:	@@GET
	JR	Z,EMPTY		;Unload driver buffer
;Check if called by Modem80 pgm
	LD	A,(MDM80F)
	OR	A
	JR	Z,NOMDM		;Pass back screen if so
	LD	HL,8000H	;Where stored in Modem80
	CALL	GETSCR		;Restore it
	CALL	GETCUR		;Find cursor posn
	LD	(99BFH),HL	;Pass it back
NOMDM:	LD	HL,0
QUIT:	LD	SP,$-$
STKSV	EQU	$-2
	RET
;
; dumb terminal mode
DTERM:	EQU	$
	@@KBD
	JR	NZ,INCK		;Go on if no keypress
	CP	80H		;Is it <break>?
	JR	Z,EXIT
	CP	0BAH		;<clear><:>?
	JR	NZ,CONT2
	CALL	CLRSCR
	JR	DTERM
CONT2	CP	0ADH		;<clear><->?
	JR	NZ,OUTP
	CALL	DTGL
	JR	DTERM
;
OUTP:	CALL	OUTPUT		;Send out rs232
;
INCK:	CALL	INPUT		;Received character?
	JR	Z,DTERM		;If no input
CONT	AND	7FH		;Mask parity
	CP	DLE		;<dle> received
	JR	Z,ISDLE		;Process if so
SHOW:	CP	SI		;Start protocol?
	JR	Z,ISSI	
	CP	SO		;Non-protocol
	JR	Z,ISSO
	CP	ESC		;Is it <escape>?
	JR	Z,ISESC		;Yes, see what to do next
	PUSH	AF		;Save char
	CP	LF		;Linefeed?
	JR	NZ,NOTLF	;No
	LD	A,(CRFLG)	;Check last char
	CP	CR		;Was it cr?
	JR	Z,SKPCHR	;Then don't display lf
NOTLF:	LD	A,(CRFLG)	;Check last chr
	CP	ESC		;Was it escape?
	JR	Z,SKPCHR	;Skip if so (cursor conrtol etc)
	POP	AF		;Get flag set by cp esc
	PUSH	AF
	CALL	NZ,VDCHAR	;Display
SKPCHR:	POP	AF
NOTSIM:	LD	(CRFLG),A	;And save last char
	JR	DTERM		;Loop
;
ISDLE:	CALL	GETWAT		;If <dle>, then get next char
	AND	1FH		;Make control char
	JR	SHOW		;And print it
;
ISSO:	XOR	A		;<so> disables protocol mode
ISSI:	LD	(SIFLAG),A	;<si> enables protocol mode
	JR	DTERM		;Continue
;
ISESC:	LD	A,(SIFLAG)	;Is protocol enabled?
	OR	A
	LD	A,ESC		;Reload esc
	JR	Z,NOTSIM	;Not using protocol
;
ISESCN:	CALL	GETWAT		;Wait for next char
	AND	7FH		;Mask it
	CP	'I'		;If <esc> <i>
	JR	NZ,ESC0		;Else
	LD	HL,SYSID	;Then send id
SNDID:	LD	A,(HL)
	INC	HL
	OR	A		;End?
	JR	Z,DTERM		;Then back to terminal
	CALL	RSPUT		;Send char
	JR	SNDID		;Till done
;
ESC0:	CP	'L'		;If <esc><l>
	JR	NZ,ESC1		;Else
	LD	E,0		;Then system load function
	CALL	GETCKS		;Get byte count
	LD	B,A
	CALL	GETCKS		;Get low address byte
	LD	L,A
	CALL	GETCKS		;Get high address byte
	LD	H,A
;
ESCL0:	CALL	GETCKS		;Next data byte
	LD	(HL),A		;Save it
	INC	HL		;Point to next
	DEC	B		;Count down
	JR	NZ,ESCL0	;Load block
	LD	C,E		;Save checksum
	CALL	GETCKS		;Get checksum
	CP	C		;Match?
	LD	A,'.'		;Logical ack
	JR	Z,ESCL1		;If correct
	LD	A,'/'		;If no match, send "/"
ESCL1:	CALL	OUTPUT		;
	CALL	VDCHAR		;And display
	JP	DTERM		;And wait for next
;
ESC1:	CP	'A'		;<esc><a>?
	JR	NZ,NOTSIM	;If not
	LD	(STKPTR),SP	;Save stack pointer for emergencies
;
; initialiZe for data transmission
; using the compuserve a-protocol
; the protocol begins with the following sent from the host:
; <esc><a><soh><recnum><u | d><a | b><filespec><etx><cksum>
; where the <recnum> is a single digit ascii record
; number of "1","2", ... "9", or "0"
; where the <u> or first <d> imply upload or download
; a=ascii (remove <lf> after a <cr>), b=binary
; the <filespec> is a standard trsdos file specification.
; cksum=checksum for the record
;
ABEGIN:	XOR	A
	LD	(APFLG),A	;Clear flags
	LD	(EOFFLG),A
	LD	A,'0'		;Start record number digit
	LD	(APNXT),A	;Save it
	LD	(DMODE),A	;Don't display cmd line
	LD	HL,XCVBUF	;Point to start of buffer
	LD	(POINT),HL	;To put command
	PUSH	HL
	CALL	APRCMD		;Get command line fm host
	POP	HL		;Get buffer pointer
	LD	(POINT),HL	;And reset for transfer
	LD	HL,XCVBUF+2	;Rcv'd filename fm host
	LD	DE,DCB		;Move filespec to
	@@FSPEC
	LD	A,(XCVBUF+1)	;Get transfer type of
	LD	(XFRTYP),A	;<a>scii or <b>inary
	CP	'B'		;If binary
	JR	Z,NOTASC	;Leave block mode display
	LD	A,(DMODE1)
	LD	(DMODE),A	;Set display mode for data
NOTASC:	XOR	A
	LD	(CRFLG),A	;Clear flag to start
	LD	B,0		;Lrl = 256
	LD	DE,DCB		;Set up to open file
	LD	HL,DBUFF	;Point to disk buffer
	LD	A,(XCVBUF)	;Get direction of xfer
	CP	'D'		;Download??
	JR	NZ,CHECKU	;Nope, check upload
	@@INIT
	JP	NZ,DERROR	;Can't open file
	JR	C,INITOK	;Not an existing file
	LD	HL,DLBOMB	;Existing file
	CALL	VIDLIN		;Announce it
	LD	B,1		;Chars wanted
	LD	HL,KEYBUF	;Buffer to receive
	@@KEYIN
	LD	A,(KEYBUF)	;Get answer
	AND	5FH		;Make upper case
	CP	'Y'		;Check answer
	JP	NZ,ABORT	;Abort if good file
INITOK:	LD	HL,DNLOAD	;Else announce download
	CALL	VIDLIN
;
DOWNLD:	CALL	APRCV		;Receive a block 
	JR	NZ,DLLAST	;Eot rcv'd if not zero
	CALL	WRITE		;Check buffer, write if needed
	JR	DOWNLD		;And keep loading buffer
DLLAST:	DEC	HL		;Back up past the <eot> char
	CALL	WRITE1		;Write what we have now
	LD	DE,DCB
	@@CLOSE
	JP	NZ,DERROR	;Abort on closing error
	LD	A,'.'
	CALL	RSPUT		;Announce we got it.
	CALL	VIOMRK
	LD	SP,(STKPTR)
	JP	DTERM		;Return to mainline
;
CHECKU:	CP	'U'		;Upload??
	JP	NZ,ABORT	;Abort if not
	PUSH	HL
	LD	HL,(SFLAG)	;Set R/O & ignore LRL fault
	SET	0,(HL)
	POP	HL
	@@OPEN
	JP	NZ,DERROR	;Abort on open error
	LD	HL,UPLOAD	;Else announce upload
	CALL	VIDLIN
	LD	A,'.'		;Logical <ack>
	CALL	RSPUT		;Send to host
	CALL	VIOMRK
;
;Start the upload!
	CALL	GETWAT		;See if host is
	CP	'.'		;Ready to receive
	JP	NZ,ABORT	;Abort if not
	CALL	READ		;Read the disk 
UPL1:	CALL	GETBYT		;Reset (count), read more if needed
	JR	C,UPL2		;Carry set if we already finished
	CALL	APSND		;Now do the transmission
	JR	UPL1		;And do the next block
UPL2:	CALL	APSND0		;Transmit <eot> unmasked 
	LD	SP,(STKPTR)	;Ready to go home now.
	JP	DTERM		;Back to mainline
;
;*********  subroutines ***********
;
GETBYT:	LD	DE,(POINT)	;Get next byte address
	LD	HL,(LAST1)	;One past end byte
	OR	A
	SBC	HL,DE		;How many left in buffer
	JR	Z,GTMORE	;None - if "next" is past end
	LD	A,H
	OR	A		;More than 256?
	LD	A,0		;Then write 256
	JR	NZ,GETB2
	LD	A,L		;Else write remaining
GETB2:	LD	(COUNT),A	;Bytes to send in this block
	RET	
;
GTMORE:	LD	A,(EOFFLG)	;End of file read?
	OR	A	
	JR	Z,GTB3		;If not, read more
	LD	HL,XCVBUF
	LD	(POINT),HL	;Else send eot
	LD	(HL),EOT
	LD	A,1
	SCF			;Carry set means finished
	JR	GETB2		;Set count and return
;
GTB3:	CALL	READ		;Read in some more
	JR	GETBYT		;And then set pointers
;
;Disk read routine
;
READ:	LD	HL,XCVBUF
	LD	(POINT),HL	;Start at beginning
	LD	BC,(MAXLD)	;Quit when we get here
	LD	DE,DCB		;Point to file
READ0:	@@GET			;Load a byte
	JR	NZ,EOFCK	;Test for end, else error
	LD	(HL),A		;Store char
	PUSH	HL
	SBC	HL,BC		;Test for max sectors
	POP	HL
	INC	HL		;Bump ptr for nxt (doesn't affect flgs)
	JR	NZ,READ0	;Till buffer full or eof
;
READ1:	LD	(LAST1),HL	;Save pointer to end byte (1 past)
	RET	
;
EOFCK:	CP	1CH		;Is error code "eof"
	JP	NZ,DERROR	;Abort if something else
	LD	(EOFFLG),A	;Flag that file is done
	@@CLOSE
	LD	A,(XFRTYP)	;If ascii transfer
	CP	'A'
	JR	NZ,EOF2		;Go if <b>
	DEC	HL		;If <a>scii
	LD	A,CR		;Then check if..
	CP	(HL)		;Last char was cr...
	JR	Z,EOF1
	INC	HL		;If not, add one
	LD	(HL),A		;Just to be sure
EOF1:	INC	HL		;That file will be accepted
	JR	READ1	
;Compuserve seems a little brain-damaged about finding the
;End of file in .BIN format  - we will try padding to 128 
;Byte multiples
EOF2:	PUSH	HL		;If <b>inary file we must
	LD	DE,XCVBUF	;Send multiples of 32 bytes (now 128)
	OR	A		;For the .bin format
	SBC	HL,DE		;So...
	LD	A,L		;Get low byte of count in bfr(mod256)
	POP	HL		;Restore bfr pointer
	AND	128-1		;Mask out even multiples
	JR	Z,READ1		;Ok if even
	LD	B,A		;<32
	LD	A,128		;We want 32
	SUB	B		;How many more?
	LD	B,A		;Into b
EOF3:	LD	(HL),0		;Pad out with zero bytes
	INC	HL
	DJNZ	EOF3		;To multiple of 32
	JR	READ1		;And go back
;
; disk write routine
;
WRITE:	PUSH	HL		;Save posn in buffer
	LD	DE,(MAXLD)	;Full? 
	OR	A		;Clear carry
	SBC	HL,DE		;Test
	POP	HL		;Restore current position
	RET	C		;Not full yet, keep loading buffer
;
WRITE1:	LD	DE,XCVBUF	;Starting point
	OR	A		;Clear carry
	SBC	HL,DE		;Get count of bytes to write
	PUSH	HL
	POP	BC		;Into bc 
	EX	DE,HL		;Start to hl
	LD	(POINT),HL	;Fix pointer while we have it
;
	LD	DE,DCB		;Point to file
WRITE2:	LD	A,C
	OR	B		;Test for end
	RET	Z		;Quit if done
	DEC	BC		;Count down
	PUSH	BC
	LD	C,(HL)		;Get char
	INC	HL		;Point to next 
	@@PUT
	POP	BC
	JR	Z,WRITE2	;Do it all unless error
	JP	DERROR		;Then quit
;
; receive a record from host and save in buffer
;
APRCV:	LD	A,'.'		;Prompt host for data
	CALL	RSPUT		;Send it
	CALL	VIOMRK		;Init display
APRCMD:	LD	A,(APNXT)
	INC	A		;Bump the desired record number
	CP	'9'+1
	JR	C,APRCM1	;Past "9" yet??
	LD	A,'0'		;Start at "0" again
APRCM1:	LD	(APNXT),A
	CALL	DSP
APRCV0:	CALL	GETWAT		;Get a byte
	CP	SOH		;Start of record??
	JR	Z,APRCV1	;Then go!
	CP	ETX
	JR	NZ,APRCV0	;<etx> alone is questionable
	LD	A,'/'		;So we'd better ask
	CALL	RSPUT		;For a retransmission
	CALL	VDCHRK
	JR	APRCV0
;
APRCV1:	XOR	A
	LD	E,A		;For checksum
	LD	(APEOT),A	;Clear <eot> flag & checksum
	LD	HL,(POINT)	;Get current pointer
	CALL	GETCKS		;Get sender's record number
	LD	(APCUR),A	;And hold it
APRCV2:	CALL	GETCKS		;Get a byte and checksum
	JR	Z,APRCV3	;Jump if <etx> received
	CP	LF		;Was it a line feed?
	JR	NZ,APRC2A
	LD	A,(XFRTYP)	;If so, is this ascii transfer?
	CP	'A'
	JR	NZ,APRCLF	;Jump if not
	LD	A,(CRFLG)	;Does it follow a <cr>?
	CP	CR
	LD	A,0		;Reset crflg
	LD	(CRFLG),A	;So only one lf is skipped
	JR	Z,APRCV2	;Ignore <lf> if so.
APRCLF:	LD	A,LF		;Else restore the line feed
APRC2A:	LD	(HL),A		;Store the byte in buffer
	LD	(CRFLG),A	;And save to check for <cr,lf>.
	CALL	MEMPT		;Bump pointer (unless up to high$)
	CALL	CTXFR		;Give display some work.
	JR	APRCV2		;And loop for more
;
APRCV3:	LD	C,E		;Save our checksum
	CALL	GETCKS		;Get theirs
	CP	C		;Checksums verify??
	JR	NZ,APRCV4	;Nope
	LD	A,(APNXT)	;Yep, get our record number
	LD	C,A
	LD	A,(APCUR)	;Check with their rec #
	CP	C
	JR	NZ,APRCV5	;No match, check further
	LD	(POINT),HL	;All ok, store buffer position
	LD	A,(APEOT)	;Put <eot> flag in a
	OR	A		;Set flags accordingly
	RET			;And go back
;
APRCV4:	LD	A,'/'		;Bad checksum, so
APRC4A	CALL	RSPUT		;Ask for retransmission
	CALL	VDCHRK		;Announce it
	JR	APRCV0
APRCV5:	JP	NC,ABORT	;Abort if we missed a record
	LD	A,'.'		;Unless it was a duplicate, then
	JR	APRC4A		;Ok it, ignore it, and continue
;
MEMPT:	PUSH	DE
	LD	DE,$-$
MEMPT1	EQU	$-2		;When program initializes
	PUSH	HL		;Just in case we missed...
	OR	A		;The etx for a block
	SBC	HL,DE		;We better check...
	POP	HL		;If loaded up to high$
	POP	DE		;Before bumping pointer
	RET	Z		;Since we don't know how
	INC	HL		;Big a block will be
	RET
;
APSND:	XOR	A		;Flag to mask control chars
APSND0:	LD	(APFLG),A	;Set mask mode
	LD	A,(APNXT)	;Get expected rec num
	INC	A		;And bump it
	CP	'9'+1
	JR	C,APSND1
	LD	A,'0'		;Wrap back to 0
APSND1:	LD	(APNXT),A	;Save it
APSN1A:	LD	A,(APNXT)
	CALL	VDCHRK		;Display num
APSND2:	LD	E,0		;Clear checksum
	LD	A,SOH
	CALL	SNDPUT		;Start the record
	LD	A,(APNXT)	;Get record number
	CALL	SNDPUT		;Transmit it
	CALL	DOCKS		;And checksum it.
APSND3:	LD	A,(COUNT)	;Number of bytes
	LD	B,A
APSN3B:	LD	HL,(POINT)	;Point to start of record
APSN3C:	LD	A,(HL)		;Get a char
	CP	CR		;Is it cr?
	JR	NZ,APSN3D
	LD	A,(XFRTYP)	;Then check if..
	CP	'A'		;<a>scii type transfer
	LD	A,CR		;Restore cr
	JR	NZ,APSN3D	;If not ascii
	CALL	DOCKS		;Else add cr to cksum
	CALL	SNDMSK		;And send
	LD	A,LF		;And then send lf
APSN3D:	CALL	CTXFR		;Display or show  "+"
	CALL	DOCKS		;Checksum the char
	CALL	SNDMSK		;Send it
	INC	HL		;Point to next
	DJNZ	APSN3C		;Send entire record
;
	LD	A,ETX		;Tell host rec is finished
	CALL	SNDPUT		;Send etx unmasked
	XOR	A
	LD	(APFLG),A	;Flag to use dle
	LD	A,E		;Get checksum
	CALL	SNDMSK		;Xmit the checksum
;
APSN5A:	LD	B,7		;Wait for reply
APSN5B:	LD	DE,0
APSND6:	CALL	GETIMM
	JR	NZ,APSND7
	DEC	D
	JR	NZ,APSND6
	DEC	E
	JR	NZ,APSND6
	DJNZ	APSN5B
	LD	A,ETX
	CALL	SNDPUT		;Send extra <etx> if slow
	JR	APSN5A
APSND7:	CP	KNAK		;Host says abort?
	JR	Z,ABORT		;Then quit
	CALL	VIOMRK		;Dsply rcvd char
	CP	'/'
	JR	Z,APSN1A	;Error, retry
	CP	'.'
	JR	NZ,APSND6	;Wrong answer,wait 
	LD	(POINT),HL	;Done with this record, save position
	RET
;
;
SNDMSK:	CP	20H		;Chk for control char
	JR	NC,SNDPUT	;Send if not
	CP	CR		;We will send a lot of these
	JR	Z,SNDPUT	;So make a special check
	CP	LF		;To save time since they
	JR	Z,SNDPUT	;Will pass tymnet ok
	PUSH	AF		;Save char
	LD	A,(APFLG)	;Check if masking
	OR	A
	JR	Z,SNDLE		;Zero if adding dle
	POP	AF		;If not wanted, go on
	JR	SNDPUT
SNDLE:	LD	A,DLE		;Precede w/dle
	CALL	SNDPUT	
	POP	AF		;Get char
	OR	40H		;Add 40h to get char through tymnet etc.
;
;Necessary to avoid confusion with the control characters
;That are always being transmitted by synchronous modems
;
SNDPUT:	PUSH	AF
	CALL	GETIMM		;Check for host
	JR	Z,SNDPT5	;If no input
	CP	KNAK		;Else
	JR	Z,ABORT		;Abort if asked by <nak>
	CP	XOFF		;Ctrl-s pause requested?
	JR	NZ,SNDPT5	;If not, who cares?
	PUSH	DE
	PUSH	BC
	LD	B,2
;**********  mneta2/asm **********
SNDPT1:	LD	DE,8000H
SNDPT2:	CALL	GETIMM		;Wait for ctrl-q...
	JR	Z,SNDPT3
	CP	XON		;A ctrl-q???
	JR	Z,SNDPT4	;If so, let's go.
SNDPT3:	DEC	E
	JR	NZ,SNDPT2
	DEC	D
	JR	NZ,SNDPT2
	DJNZ	SNDPT1		;If it takes too long, go ahead anyhow.
SNDPT4:	POP	BC
	POP	DE
SNDPT5:	POP	AF
	CALL	RSPUT		;Xmit the data byte
	RET
;
; error messages
;
DERROR:	OR	0C0H		;Get short error msg
	LD	C,A
	@@ERROR
ABORT:	LD	A,(SIFLAG)
	OR	A		;In protocol mode?
	JR	Z,ABORT1	;No, just waiting for something
	LD	HL,ABLOAD	;General abort message
	CALL	VIDLIN
	LD	DE,DCB
	LD	A,(DE)
	BIT	7,A		;Was file open?
	JR	Z,CONTIN
	@@CLOSE
CONTIN	LD	A,KNAK
	CALL	RSPUT		;Send aborting <nak>
ABORT1:	LD	SP,(STKPTR)	;Reset stack pointer
	XOR	A
	LD	(SIFLAG),A	;Disable a protocol
	JP	DTERM		;Return to mainline
;
GETCKS:	CALL	GETWAT		;Get a char
	CP	ETX		;Check for <etx> not preceded by <dle>
	RET	Z		;Return if so - done with block
	PUSH	AF		;Else save flags
	CP	EOT		;Are we done??  end of transmission!
	JR	NZ,GETCK1
	LD	(APEOT),A	;Say "eot seen"
GETCK1:	CP	DLE
	JR	NZ,GETCK2	;If dle, then get next one
	CALL	GETWAT		;<dle> masks a control character
	AND	1FH		;So get another & unmask it.
GETCK2:	CALL	DOCKS		;Update cksum
	POP	AF		;Flag set by cp etx
	LD	A,D		;Restore byte
	RET	
;
DOCKS:	LD	D,A		;Save the byte
	LD	A,E		;Get old checksum
	RLCA			;Rotate thru carry
	ADD	A,D		;Add in the new byte
	ADC	A,0		;Include any carry bit
	LD	E,A		;Save new checksum
	LD	A,D		;Restore the byte
	RET
;
GETIMM:	EQU	$
	PUSH	DE
	@@KBD
	POP	DE
	CP	1FH
	JR	Z,ABORT
	CP	80H
	JP	Z,EXIT	
	CALL	INPUT		;Get a byte from rs-232
	RET	Z		;Don't wait if no input.
	AND	7FH		;Strip top bit away
	RET
;
GETWAT:	EQU	$
	PUSH	DE
	@@KBD
	POP	DE
	CP	1FH
	JR	Z,ABORT
	CP	80H
	JP	Z,EXIT	
	CALL	INPUT		;Get an unstripped byte
	JR	Z,GETWAT	;Wait if nothing there
	CP	KNAK		;Is it a <nak>??? (unmasked)
	JR	Z,ABORT		;Abort if so.
	RET
;
RSPUT:	PUSH	AF
	CALL	OUTPUT		;Send character out
	POP	AF
	RET
;
VDCHRK:	CALL	VIDCHK		;Header info and "/" or "." 
	JP	NZ,VDCHAR	;Only if <not> showing data..
	RET
;
VIDCHK:	PUSH	BC
	LD	C,A		;Save current char
	LD	A,(DMODE)	;Are we displaying data?
	OR	A		;Set flag
	LD	A,C		;Restore byte
	POP	BC
	RET			;Z=show it 
;
VIOMRK:	CALL	VIDCHK		;Displaying data?
	RET	Z		;Then don't show this part
	PUSH	AF		;Else...
	LD	A,CR		;Do funny things..
	CALL	VDCHAR		;On display during file transfer
	LD	A,32		;Using "their" method
	LD	(XFRCTR),A
	POP	AF
	CP	'.'
	CALL	Z,VDCHAR
	RET
;
CTXFR:	CALL	VIDCHK		;Display data as received?
	JP	Z,VDCHAR	;Yes, do it
	PUSH	AF		;Else..
	PUSH	HL		;Show "+" sometimes
	LD	HL,XFRCTR
	DEC	(HL)
	JR	NZ,CTXFR0
	LD	(HL),32
	LD	A,'+'
	CALL	VDCHAR
CTXFR0:	POP	HL
CTXFR2:	POP	AF
	RET
;
DTGL:	LD	HL,DMSG
	CALL	VIDLIN		;Start msg
	LD	A,(DMODE1)	;Reverse setting for 
	OR	A		;Data display during
	LD	HL,DSPOFF	;File transfer
	LD	A,0FFH
	JR	Z,DTGL2		;Was <on>,turn off
	LD	HL,DSPON	;Else
	XOR	A		;If off,turn on
DTGL2:	LD	(DMODE1),A	
	CALL	VIDLIN		;Announce it
	RET

GETCIRC	LD	HL,(OUTPTR)	;Point to byte to get
	PUSH	HL		;Check for empty buffer
	LD	DE,(INPTR)
	AND	A
	SBC	HL,DE
	POP	HL
	RET	Z		;Z if empty
	LD	A,(HL)		;Pick up byte
	PUSH	AF		;Save byte/nz flag
	CALL	ADDONE
	LD	(OUTPTR),HL
	POP	AF
	RET
;
; M4 com/dvr sometimes interrupts itself!
PUTCIRC	RET	NZ		;Skip if no character
	LD	HL,(INPTR)	;Point to position to put
	LD	(HL),C
	CALL	ADDONE
	LD	DE,(OUTPTR)
	PUSH	HL
	AND	A
	SBC	HL,DE
	POP	HL
	RET	Z		;Do not wrap if already full
	LD	(INPTR),HL
	RET
;
ADDONE	INC	HL
	PUSH	HL
	LD	DE,EBUFF
	AND	A
	SBC	HL,DE
	POP	HL
	RET	NZ
	LD	HL,SBUFF
	RET
;
OUTPTR	DW	SBUFF
INPTR	DW	SBUFF
;
DMODE:	DB	0		;Display data in protocol mode?
DMODE1:	DB	0		;Keep this one as set in term mode
CRFLG:	DB	0		;Prev char to check for cr,lf
APEOT:	DB	0		;<eot> received.
XFRCTR:	DB	0		;Counter for showing "+"
POINT:	DW	0		;Pointer to "next" posn in xcvbuf
LAST1:	DW	0		;Pointer to current end from file(+1)
COUNT:	DB	0		;Bytes to send in current block
APNXT:	DB	'0'		;Record number expected
APCUR:	DB	'0'		;Record number received
XFRTYP:	DB	0		;<a>scii or <b>inary xfer
APFLG:	DB	0		;Nonzero if eot to be sent unmasked
EOFFLG:	DB	0		;Flag if all of file read
STKPTR:	DW	0		;Save stack for abort return
SIFLAG	DB	0		;Non-zero if protocol enabled
KEYBUF	DC	2,0		;Keyin buffer!
DNLOAD:	DB	LF,LF,'CSEXEC - Start DOWNload',LF,CR
UPLOAD:	DB	LF,LF,'CSEXEC - Start UPload',LF,CR
ABLOAD:	DB	LF,LF,'CSABRT - Aborting xfer',LF,CR
DLBOMB:	DB	LF,LF,'File exists!'
	DB	LF,'Replace (Y/N) ? ',ETX
DMSG:	DB	LF,'Xfer display <O',ETX
DSPON:	DB	'N>',CR
DSPOFF:	DB	'FF>',CR
SFLAG:	DW	00		; pointer to SFLAG
MAXLD:	DW	00		; end of buffer
MDM80F:	DB	0		; flag if called from Modem80
;
SYSID:	DB	'#RS2LM,,,PL,PA,HC',0DH,00H
;
CLDCB	DB	07		;Type byte for get,put,ctl
DCB:	EQU	CLDCB+32	;For DCB or fake w/driver address
DBUFF	EQU	DCB+32		;Disk buffer
SBUFF	EQU	DBUFF+256
XCVBUF	EQU	SBUFF+128	;Xmit/rcv buffer
EBUFF	EQU	XCVBUF-1
;The equ's don't generate extra space here like ds would
;
; meaning of the data in sysid:
; #rs222,cc,cw,pl,pa,hc
; #means can use protocol
; #rs222 means radio shack mod 1 w/trsdos 2.2
;
; cc= cursor control  (not implemented)
; implies the following cursor control:
; <esc><a>        cursor up
; <esc><b>        cursor down
; <esc><c>        cursor right
; <esc><d>        cursor left
; <esc><h>        cursor home
; <esc><j>        erase to end of screen
; <esc><k>        erase to end of line
; <esc><j>        erase screen and home cursor (also <ff>)
; <esc><y><l+31><c+31> position cursor to line l and column c
; cw= width control    (not implemented)
; <esc><m>        go to double size characters (32 per line)
; <esc><l>        switch to normal (64 per line) characters
; hc= hard copy   (not implemented)
; implies the following:
; <dc2> (ctrl-r, 022 octal, 12 hex) enable printer
; <dc4> (ctrl-t, 024 octal, 14 hex) disable printer
; pa= a protocol
; implies file transfer capability using the compuserve a protocol
; pl= load protocol
; implies ability to load code segments under the compuserve l protocol
;
INIT	EQU	$		;Set things up, then we can overwrite
ENTRY:	LD	(STKSV),SP	;Save stack on entry
	PUSH	HL		;Save command line pointer
	CALL	CKMDM		;Restore term screen if modem80
	LD	HL,BANNER
	@@DSPLY
;
	@@FLAGS
	PUSH	IY
	POP	DE
	LD	HL,'S'-'A'
	ADD	HL,DE
	LD	(SFLAG),HL
	LD	B,0
	BIT	1,(IY+'C'-'A')	; in CMDR?
	JR	Z,GTHI
	INC	B		;Use LOW$ if so
GTHI:	LD	HL,0
	@@HIGH$
CALC:	LD	(MEMPT1),HL	;Save for later
	LD	BC,XCVBUF
	INC	B		; allow a little room
	OR	A
	SBC	HL,BC		; how much free mem
	JP	C,NOMEM		; already dead...
	LD	L,0		; make mult of 256
	LD	A,18		; max sectors/load
	CP	H		; use free amt or 18
	JR	NC,STHI		; whichever is less
	LD	H,A
STHI:	INC	H
	DEC	H
	JP	Z,NOMEM		; must have at least one
	DEC	B
	ADD	HL,BC
	LD	(MAXLD),HL	;Store address to stop loads
;
; this part looks for device name passed on cmd line
;
	POP	HL		;Cmd line
	DEC	HL
SC1:	INC	HL
	LD	A,(HL)
	CP	20H		;Skip any spaces
	JR	Z,SC1
	CP	CR
	JP	Z,NODEV1	;No device specified
	CP	'*'		;Devicespec starts with *
	JP	NZ,NODEV	;Else abort
;
OPENCL:	LD	DE,CLDCB	;Set up dcb
	@@FSPEC
	JR	NZ,NODEV	
	LD	DE,CLDCB	;If no error
	@@OPEN
	JR	Z,LOGON1	;And use it 
	OR	0C0H
	@@ERROR
	JR	NODEV
;
NOMEM:	LD	HL,MEMMESS
	JR	FATAL
NODEV:	LD	HL,DEVSPR	;Tell user
FATAL:	@@DSPLY
	LD	HL,-1
	JP	QUIT
; look for device memory header - this will succeed if using
; Modem80 even without COM/DVR loaded
NODEV1:	LD	DE,NAME		; no device name, so try @GTMOD
	@@GTMOD			; using $CL
	JR	NZ,NODEV	; no driver loaded..
	LD	(CLDCB+1),HL	; found it, build fake DCB
;Connect com/dvr wakeup to local buffer routine
LOGON1	LD	C,4		;Wakeup function
	LD	DE,CLDCB
	LD	IY,PUTCIRC
	DI
	@@CTL			;Install vector, old comes back in IY
	LD	(OLDWAKE),IY	;Setup for exit
	EI
;
	LD	C,CURSON
	@@DSP
;
	JP	DTERM		;Ready to go now
;
;Check to see if invoked as DOS cmd fm Modem80
CKMDM:	LD	DE,MDMCK
	@@GTMOD	
	RET	NZ		; not found, continue..
;If present, restore previous terminal screen
	LD	HL,8000H	;Where stored in Modem80
	CALL	PUTSCR		;Restore it
	LD	HL,(99BFH)	;Stored cursor posn
	CALL	PUTCUR		;Re-position
	LD	A,0FFH		;Flag need to pass back exit screen
	LD	(MDM80F),A
	RET
;
PUTCUR:	PUSH	BC		;Vidctl stuff only needed to
	LD	B,3		; grab modem80 screen
	JP	VDCTL
PUTSC1:	PUSH	BC
	LD	B,5
	JP	VDCTL
PUTSCR:	CALL	DOCOFF
	CALL	PUTSC1
	JP	DOCON
;
NAME:	DB	'$CL',0DH,00,00,00,00,00	;Chg to $CL0 for MAXDOS
MDMCK:	DB	'MDM',0DH	; memory header used by Modem80 pgm
;
MEMMESS	DB	'>> Not enough memory for file transfers! ',CR
DEVSPR:	DB	'>> Device spec required!',CR
BANNER:	DB	LF,'CIS A protocol  -  Version 01.01.04   12/27/85'
	DB	LF,CR
;
	END	ENTRY

