;MAKDISK4/ASM
;Copyright (c) 1993 Lance Wolstrup
;all rights reserved
;creates a real single-sided, single-density
;Model I disk from a PC-Model I emulator virtual file
;for convenience of speed - this program runs on Model 4
;
	ORG	3000H
START	LD	C,15		;cursor off
	LD	A,2		;@dsp
	RST	40
;
	LD	A,105		;@cls
	RST	40
;
	LD	HL,HELLO$	;point to header msg
	LD	A,10		;@dsply
	RST	40
;
ASKSRC	LD	HL,0905H	;print@(9,5)
	CALL	LOCATE		;position cursor
;
	LD	HL,SRCMSG	;point to source prompt
	LD	A,10		;@dsply
	RST	40
;
	LD	A,2		;set default
	LD	(SRC),A		;and store it
;
	LD	HL,BUFFER	;point to buffer
	LD	BC,0100H	;max input chr=1
	LD	A,9		;@keyin
	RST	40
;
	JP	C,EXIT		;exit if break
;
	LD	HL,BUFFER	;point to input
	LD	A,(HL)		;and get it
	CP	13		;is it just enter?
	JR	Z,ASKDST	;yes-default chosen-jump
;
	CP	30H		;is it 0?
	JR	C,ASKSRC	;jump if less
	CP	38H		;jump if
	JR	NC,ASKSRC	;larger than 7
	SUB	30H		;drv num legal - so strip ascii
	LD	(SRC),A		;and store in buffer
;
ASKDST	LD	HL,0B00H	;print@(11,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,DSTMSG	;point to destination prompt
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;set default
	LD	(DST),A		;and store it
;
	LD	HL,BUFFER	;point to common buffer
	LD	BC,0100H	;max chr input=1
	LD	A,9		;@keyin
	RST	40
;
	JR	C,ASKSRC	;to previous prompt if break
;
	LD	HL,BUFFER	;point to input
	LD	A,(HL)		;ad get it
;
	CP	13		;is it enter
	JR	Z,ASKNAM	;jump if default chosen
;
	CP	30H		;is it 0
	JR	C,ASKDST	;jump if less
	CP	38H		;is it 8 or more
	JR	NC,ASKDST	;jump if so
;
	SUB	30H		;strip ascii
	LD	B,A		;dst drv num to b
	LD	A,(SRC)		;get src drv num
	CP	B		;compare them
	JR	NZ,SETDST	;jump if different
;
DRVERR	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,SRCDST	;point to error msg
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;@key
	RST	40
;
	CP	13		;is it enter
	JR	NZ,DRVERR	;not enter - so prompt again
	JR	ASKDST		;go ask for dst drive num
;
SETDST	LD	A,B		;retrieve dst drive num
	LD	(DST),A		;and store it
;
ASKNAM	LD	HL,0D13H	;print@(13,19)
	CALL	LOCATE		;position cursor
;
	LD	HL,NAMMSG	;point to name message
	LD	A,10		;@dsply
	RST	40
;
	LD	HL,BUFFER	;point to input buffer
	LD	BC,1800H	;max input char=23+cr
	LD	A,9		;@keyin
	RST	40
;
	JR	C,ASKDST	;previous prompt if break
;
	LD	A,B		;get number of chars input
	OR	A		;any there?
	JR	Z,ASKNAM	;no - prompt again
;
PUTDN	INC	HL		;find end of filename
	LD	A,(HL)		;get chr
	CP	':'		;is drv num attached
	JR	Z,PUTDN1	;attached-so skip colon
	DJNZ	PUTDN
;
	LD	A,':'		;append colon
	LD	(HL),A		;to filename
PUTDN1	INC	HL		;next filename position
	LD	A,(SRC)		;get source drive number
	ADD	A,30H		;make it ascii
	LD	(HL),A		;append it to filename
	INC	HL		;next filename position
	LD	A,13		;append
	LD	(HL),A		;terminator to filename
;
ASKRDY	LD	HL,1000H	;print@(16,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,RDYMSG	;point to ready message
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;@key
	RST	40
;
	CP	80H		;is it break
	JR	Z,ASKNAM	;back to previous prompt if break
;
	CP	13		;is it enter
	JR	NZ,ASKRDY	;no - ask again
;
	LD	C,15		;cursor off
	LD	A,2		;@dsp
	RST	40
;
	LD	HL,BUFFER	;point to stored filename
	LD	DE,FCB		;point to fcb
	LD	A,78		;@fspec
	RST	40
;
	LD	HL,BUFFER	;point to i/o buffer
	LD	B,0		;256 bytes
	LD	A,59		;@open
	RST	40
;
	JR	Z,GETTRK	;jump if no error
;
FERR	LD	HL,1000H	;print@(16,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,FILERR	;point to error message
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;@key
	RST	40
;
	CP	80H		;is it break
	JR	Z,ASKNAM	;jump is so
;
	CP	13		;is it enter
	JR	Z,ASKNAM	;jump if so
	JR	FERR
;
GETTRK	LD	DE,FCB		;point to fcb
	LD	A,65		;@peof
	RST	40
;
	PUSH	DE
	POP	IX
	LD	A,(IX+10)	;lsb of last rec num
	LD	L,A
	LD	A,(IX+11)	;msb of last rec num
	LD	H,A		;xfer to hl
;
	LD	C,10		;divide by number of sectors
	LD	A,94		;@div16
	RST	40
;
	LD	B,L		;xfer lsb to b
;
	LD	A,68		;@rew
	RST	40
;
	LD	D,0		;begin with track 0
TLOOP	PUSH	BC		;save trk loop counter
	PUSH	DE		;save current track number
	LD	HL,1000H	;print@(16,0)
	CALL	LOCATE		;position cursor
	LD	L,D		;trk num to hl
	LD	H,0
	LD	DE,DECTRK	;convrt to decimal
	LD	A,97		;@hexdec
	RST	40
;
	LD	HL,RDMSG	;display message
	LD	A,10		;@dsply
	RST	40
;
	LD	HL,BUFFER	;point to i/oo buffer
	LD	B,10		;10 sectors
	LD	DE,FCB		;point to fcb
	PUSH	DE		;copy it
	POP	IX		;to ix
RLOOP	LD	(IX+3),L	;stuff address of current
	LD	(IX+4),H	;buffer segment in fcb
	LD	A,67		;@read
	RST	40
;
	PUSH	DE		;save fcb pointer
	LD	DE,256		;figure new address
	ADD	HL,DE
	POP	DE		;restore fcb pointer
	DJNZ	RLOOP
;
	LD	HL,1000H	;print@(16,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,WRTMSG	;point to write message
	LD	A,10		;@dsply
	RST	40
;
	LD	B,10		;write 10 sectors
	POP	DE		;restore track num
	PUSH	DE		;save it again
	LD	E,0		;start with sector 0
	LD	A,D		;copy track num to a
	CP	17		;is it dir trk
	JR	Z,SYSSEC	;yes-jump to syssec
	LD	A,53		;@wrsec
	JR	WRT
SYSSEC	LD	A,54		;@wrssc
WRT	LD	(WRTCMD),A	;store write type
	LD	HL,BUFFER	;point to i/o buffer
	LD	A,(DST)		;get destination drive num
	LD	C,A		;store in c
WLOOP	LD	A,(WRTCMD)		;get sector write type
	RST	40
;
	INC	E		;next sector
	PUSH	DE		;save sector num
	LD	DE,256		;figure new buffer address
	ADD	HL,DE
	POP	DE		;restore sector num
	DJNZ	WLOOP
;
	POP	DE		;restore tracks
	INC	D		;next track
	POP	BC		;restore counter
	DJNZ	TLOOP
;
	LD	DE,FCB		;point to fcb
	LD	A,60		;@close
	RST	40
;
ASKRPT	LD	HL,1000H	;print@(16,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,OKMSG	;point to message
	LD	A,10		;@dsply
	RST	40
;
	LD	A,1		;@kbd
	RST	40
;
	CP	80H		;is it break
	JR	Z,EXIT		;yes - jump to exit
	CP	13		;is it enter
	JP	Z,ASKSRC	;yes-back to 1st prompt
	JR	ASKRPT		;no-so prompt again
;
EXIT	LD	C,14		;cursor on
	LD	A,2		;@dsp
	RST	40
;
	RET			;return to dos
;
ERROR	POP	DE
	POP	BC
	OR	192		;set bits 6 & 7
	LD	C,A
	LD	HL,1300H	;print@(19,0)
	CALL	LOCATE		;position cursor
	LD	A,26		;@error
	RST	40
	JR	EXIT
;
LOCATE	PUSH	BC
	PUSH	DE
	LD	B,3		;position cursor
	LD	A,15		;@vdctl
	RST	40
	POP	DE
	POP	BC
	RET
;
HELLO$	DB	'MAKDISK4',10,10
	DB	'create a single-sided, single-density, '
	DB	'real Model I disk from an Emulator file',10
	DB	'Copyright ',21,239,21
	DB	' 1993 v.1.0 by Lance Wolstrup. '
	DB	'All rights reserved',10,10
	DB	13
;
SRCMSG	DB	15,31
	DB	'Enter source drive number (default = 2): ',14,3
;
DSTMSG	DB	15,31
	DB	'Enter destination drive number (default = 1): ',14,3
;
SRCDST	DB	15
	DB	'The source and destination drives cannot be the same '
	DB	'- press ENTER to continue ',14,3
;
NAMMSG	DB	15,31
	DB	'Enter name of source file: ',14,3
;
RDYMSG	DB	15,31
	DB	'Press ENTER when source and destination disks '
	DB	'are ready ',14,3
;
FILERR	DB	15,31
	DB	'Unable to open the source file - press ENTER ',14,3
;
WRTMSG	DB	'Writing',3
RDMSG	DB	31
	DB	'Reading track '
DECTRK	DS	5
	DB	13
;
OKMSG	DB	15,31
	DB	'Model I disk successfully restored - '
	DB	'press ENTER to continue ',14,3
;
SRC	DB	0
DST	DB	0
WRTCMD	DB	0
FCB	DS	32
BUFFER	DS	2560
;
	END	START
