;MAKDISK1/ASM - MAKDISK3/ASM
;Copyright (c) 1993 Lance Wolstrup
;all rights reserved
;creates a real single-sided, single-density
;Model I disk from a PC-Model I emulator virtual file
;this program runs on Model I & III
;
	ORG	7000H
;
START	CALL	1C9H		;cls
;
	LD	A,(293)		;get value from 293
	CP	73		;is it Mod III
	JR	Z,MOD3		;yes -jump
	XOR	A		;set up Model I
	LD	(COPYRG),A	;nop
	LD	A,31H		;no - set a to "1"
	JR	MOD13		;and jump
MOD3	LD	A,33H		;set a to "3"
MOD13	LD	(MODEL),A	;and stuff it into text
;
	LD	HL,HELLO$	;point to header msg
	CALL	4467H		;@dsply
;
ASKSRC	LD	HL,0605H	;print@(6,5)
	CALL	LOCATE		;position cursor
;
	LD	HL,SRCMSG	;point to source prompt
	CALL	4467H		;@dsply
;
	LD	A,2		;set default
	LD	(SRC),A		;and store it
;
	LD	HL,BUFFER	;point to buffer
	LD	BC,0100H	;max input chr=1
	CALL	40H		;@keyin
;
	JP	C,EXIT		;exit if break
;
	LD	HL,BUFFER	;point to input
	LD	A,(HL)		;and get it
	CP	13		;is it just enter?
	JR	Z,ASKDST	;yes-default chosen-jump
;
	CP	30H		;is it 0?
	JR	C,ASKSRC	;jump if less
	CP	38H		;jump if
	JR	NC,ASKSRC	;larger than 7
	SUB	30H		;drv num legal - so strip ascii
	LD	(SRC),A		;and store in buffer
;
ASKDST	LD	HL,0800H	;print@(8,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,DSTMSG	;point to destination prompt
	CALL	4467H		;@dsply
;
	LD	A,1		;set default
	LD	(DST),A		;and store it
;
	LD	HL,BUFFER	;point to common buffer
	LD	BC,0100H	;max chr input=1
	CALL	40H		;@keyin
;
	JR	C,ASKSRC	;to previous prompt if break
;
	LD	HL,BUFFER	;point to input
	LD	A,(HL)		;ad get it
;
	CP	13		;is it enter
	JR	Z,ASKNAM	;jump if default chosen
;
	CP	30H		;is it 0
	JR	C,ASKDST	;jump if less
	CP	38H		;is it 8 or more
	JR	NC,ASKDST	;jump if so
;
	SUB	30H		;strip ascii
	LD	B,A		;dst drv num to b
	LD	A,(SRC)		;get src drv num
	CP	B		;compare them
	JR	NZ,SETDST	;jump if different
;
DRVERR	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,SRCDST	;point to error msg
	CALL	4467H		;@dsply
;
	CALL	49H		;@key
;
	CP	13		;is it enter
	JR	NZ,DRVERR	;not enter - so prompt again
	JR	ASKDST		;go ask for dst drive num
;
SETDST	LD	A,B		;retrieve dst drive num
	LD	(DST),A		;and store it
;
ASKNAM	LD	HL,0A13H	;print@(10,19)
	CALL	LOCATE		;position cursor
;
	LD	HL,NAMMSG	;point to name message
	CALL	4467H		;@dsply
;
	LD	HL,BUFFER	;point to input buffer
	LD	BC,1800H	;max input char=23+cr
	CALL	40H		;@keyin
;
	JR	C,ASKDST	;previous prompt if break
;
	LD	A,B		;get number of chars input
	OR	A		;any there?
	JR	Z,ASKNAM	;no - prompt again
;
PUTDN	INC	HL		;find end of filename
	LD	A,(HL)		;get chr
	CP	':'		;is drv num attached
	JR	Z,PUTDN1	;attached-so skip colon
	DJNZ	PUTDN
;
	LD	A,':'		;append colon
	LD	(HL),A		;to filename
PUTDN1	INC	HL		;next filename position
	LD	A,(SRC)		;get source drive number
	ADD	A,30H		;make it ascii
	LD	(HL),A		;append it to filename
	INC	HL		;next filename position
	LD	A,13		;append
	LD	(HL),A		;terminator to filename
;
ASKRDY	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,RDYMSG	;point to ready message
	CALL	4467H		;@dsply
;
	CALL	49H		;@key
;
	CP	1		;is it break
	JR	Z,ASKNAM	;back to previous prompt if break
;
	CP	13		;is it enter
	JR	NZ,ASKRDY	;no - ask again
;
	LD	A,15		;cursor off
	CALL	33H		;@dsp
;
	LD	HL,BUFFER	;point to stored filename
	LD	DE,FCB		;point to fcb
	CALL	441CH		;@fspec
;
	LD	HL,BUFFER	;point to i/o buffer
	LD	B,0		;256 bytes
	CALL	4424H		;@open
;
	JR	Z,GETTRK	;jump if no error
;
FERR	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,FILERR	;point to error message
	CALL	4467H		;@dsply
;
	CALL	49H		;@key
;
	CP	1		;is it break
	JR	Z,ASKNAM	;jump is so
;
	CP	13		;is it enter
	JR	Z,ASKNAM	;jump if so
	JR	FERR
;
GETTRK	LD	DE,FCB		;point to fcb
	CALL	4448H		;@peof
;
	PUSH	DE
	POP	IX
	LD	A,(IX+10)	;lsb of last rec num
	LD	L,A
	LD	A,(IX+11)	;msb of last rec num
	LD	H,A		;xfer to hl
;
	LD	A,10		;divide by number of sectors
	CALL	4451H		;@div - mod iii
;	call	44c4h		;@div - mod i
;
	LD	B,L		;xfer lsb to b
;
	CALL	443FH		;@REW
;
	LD	D,0		;begin with track 0
TLOOP	PUSH	BC		;save trk loop counter
	PUSH	DE		;save current track number
	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
	LD	L,D		;trk num to hl
	LD	H,0
	LD	DE,DECTRK	;convrt to decimal
	CALL	HEXDEC		;convert to decimal
;
	LD	HL,RDMSG	;display message
	CALL	4467H		;@dsply
;
	LD	HL,BUFFER	;point to i/oo buffer
	LD	B,10		;10 sectors
	LD	DE,FCB		;point to fcb
	PUSH	DE		;copy it
	POP	IX		;to ix
RLOOP	LD	(IX+3),L	;stuff address of current
	LD	(IX+4),H	;buffer segment in fcb
	CALL	4436H		;@read
;
	PUSH	DE		;save fcb pointer
	LD	DE,256		;figure new address
	ADD	HL,DE
	POP	DE		;restore fcb pointer
	DJNZ	RLOOP
;
	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,WRTMSG	;point to write message
	CALL	4467H		;@dsply
;
	LD	B,10		;write 10 sectors
	POP	DE		;restore track num
	PUSH	DE		;save it again
	LD	HL,BUFFER	;point to i/o buffer
	LD	A,(DST)		;get destination drive num
	LD	C,A		;store in c
	LD	E,0		;start with sector 0
WLOOP	LD	A,D		;copy track to a
	CP	17		;is it dir trk
	JR	Z,SYSSEC	;yes-jump to syssec
	CALL	4763H		;@wrsect
	JR	WLOOP1
SYSSEC CALL	4768H		;@wrprot
WLOOP1	INC	E		;next sector
	PUSH	DE		;save sector num
	LD	DE,256		;figure new buffer address
	ADD	HL,DE
	POP	DE		;restore sector num
	DJNZ	WLOOP
;
	POP	DE		;restore tracks
	INC	D		;next track
	POP	BC		;restore counter
	DJNZ	TLOOP
;
	LD	DE,FCB		;point to fcb
	CALL	4428H		;@close
;
ASKRPT	LD	HL,0D00H	;print@(13,0)
	CALL	LOCATE		;position cursor
;
	LD	HL,OKMSG	;point to message
	CALL	4467H		;@dsply
;
	CALL	49H		;@key
;
	CP	1		;is it break
	JR	Z,EXIT		;yes - jump to exit
	CP	13		;is it enter
	JP	Z,ASKSRC	;yes-back to 1st prompt
	JR	ASKRPT		;no-so prompt again
;
EXIT	RET
;
ERROR	POP	DE
	POP	BC
	OR	192		;set bits 6 & 7
	LD	C,A
	LD	HL,0F00H	;print@(15,0)
	CALL	LOCATE		;position cursor
	CALL	4409H		;@error
	JR	EXIT
;
HEXDEC	LD	A,L		;get number
	LD	HL,TABLE	;point to table
	LD	B,2		;only need two digits
HEX0	PUSH	BC		;save loop counter
	PUSH	AF		;save number
	LD	B,0		;subtraction loop counter
	LD	A,(HL)		;get subtraction value
	LD	C,A		;store it in c
	POP	AF		;restore number
	PUSH	AF		;save it again for later
HEX1	SBC	A,C		;subtract table value
	JR	C,NEXT		;until below zero
	INC	B		;subtract good - inc counter
	JR	HEX1		;and do it again
NEXT	PUSH	BC		;save subtraction counter
	LD	A,B		;copy it to a
	OR	A		;is it zero
	JR	Z,NEXT1		;yes - so jump
	XOR	A		;a=0
HEX2	ADD	A,C		;get the digits value
	DJNZ	HEX2
NEXT1	POP	BC		;restore subtraction counter
	LD	C,A		;copy digits value to c
	LD	A,B		;copy number to a
	ADD	A,30H		;make it ascii
	LD	(DE),A		;store number in buffer
	POP	AF		;restore original number
	SUB	C		;subtract digit value
	INC	DE		;point to next buffer location
	INC	HL		;point to next table value
	POP	BC		;restore loop counter
	DJNZ	HEX0
	RET
;
LOCATE	PUSH	BC
	PUSH	DE
	LD	DE,15360	;start of screen
	LD	B,0
	LD	C,L		;store horiz value for later
	LD	A,H		;get vert value
	OR	A		;is it vert 0
	JR	Z,NOMULT	;yes - no need to multiply
	LD	L,H		;vert value in l
	LD	H,0		;vert value now in hl
	LD	B,6		;multiply hl by 64
MULT64	ADD	HL,HL
	DJNZ	MULT64
NOMULT	ADD	HL,BC		;add in the horiz value
	ADD	HL,DE		;add the memory offset
	LD	(4020H),HL	;cursor set
	POP	DE
	POP	BC
	RET
;
HELLO$	DB	'MAKDISK'
MODEL	DB	32
	DB	10,10
	DB	'create Model I disk from Emulator file',10
	DB	'Copyright ',21
COPYRG	DB	239
	DB	21
	DB	' 1993 v.1.0 by Lance Wolstrup. '
	DB	'All rights reserved',10,10
	DB	13
;
SRCMSG	DB	15,31
	DB	'Enter source drive number (default = 2): ',14,3
;
DSTMSG	DB	15,31
	DB	'Enter destination drive number (default = 1): ',14,3
;
SRCDST	DB	15
	DB	'The source and destination drives cannot be the same '
	DB	'- press ENTER to continue ',14,3
;
NAMMSG	DB	15,31
	DB	'Enter name of source file: ',14,3
;
RDYMSG	DB	15,31
	DB	'Press ENTER when source and destination disks '
	DB	'are ready ',14,3
;
FILERR	DB	15,31
	DB	'Unable to open the source file - press ENTER ',14,3
;
WRTMSG	DB	'Writing',3
RDMSG	DB	31
	DB	'Reading track '
DECTRK	DS	2
	DB	13
;
OKMSG	DB	15,31
	DB	'Model I disk successfully restored - '
	DB	'press ENTER to continue ',14,3
;
SRC	DB	0
DST	DB	0
FCB	DS	32
;
TABLE	DB	10
	DB	1
;
BUFFER	DS	2560
;
	END	START
