;SYS3/ASM - LS-DOS 6.2
	ADISP	'<SYS3 - LS-DOS 6.2>'
;
*LIST	OFF			;Get SYS0/EQU
*REF	'SYS0/EQU:1'
*LIST	ON
LF	EQU	10
CR	EQU	13
;
*GET	'COPYCOM:1'		;Copyright message
;
	ORG	1E00H
;
SYS3	AND	70H
	RET	Z		;Back on zero entry
	CP	10H
	JR	Z,CLOSE		;Jump if close
	CP	20H
	JP	Z,FNAME		;Jump if filespec recover
	RET
CLOSE	LD	A,(DE)		;Test for device
	BIT	7,A
	JP	Z,CLOSDEV	;Jump if closing device
	CALL	CKOPEN@		;Test for open file
	LD	C,(IX+6)	;P/u drive #
;
;	Special MINI check drive routine
;
	PUSH	IY		;Save IY
	CALL	@GTDCT		;Pick up DCT for drive
CKAGN	CALL	@RSLCT		;Wait until not busy
	JP	NZ,HOLDUP	;Go to error handler
	BIT	3,(IY+3)	;If hard drive, bypass
	JR	NZ,SAWBLK
	BIT	4,(IY+4)	;If "ALIEN" bypass
	JR	NZ,SAWBLK
	BIT	7,(IY+4)	;Ck if CKDRV inhibit
	JR	NZ,SAWBLK	;Go if so
;
;	Test for diskette in drive (no index)
;
	PUSH	DE
	LD	D,(IY+5)	;P/u current track
	LD	E,0		;Set sector to 0
	CALL	@SEEK		;Do a command
	POP	DE
	LD	B,30H		;Set up count (short)
BLACK	CALL	@RSLCT		;Check for index pulse
	BIT	1,A		;Test index
	JR	Z,SAWBLK	;Saw black, seems OK
	DJNZ	BLACK
	JP	HOLDUP		;Close fault handler
;
;	Diskette is there, let's continue
;
SAWBLK	POP	IY		;Restore IY
	LD	B,(IX+7)	;P/u DEC of FPDE
	CALL	@DIRRD		;Read the directory
	RET	NZ		;Quit if error there
	BIT	4,(HL)		;Ck for killed file
	RET	Z		;Quit if killed file
	PUSH	HL
	PUSH	BC
	CALL	RWRIT@		;Write last buffer?
	POP	BC
	POP	HL
	RET	NZ		;Ret on I/O error
	BIT	6,(IX+0)	;If user does not have
	JP	Z,RCVN0		;  close authority...
	INC	L		;  else reset possible
	RES	5,(HL)		;  file open bit in DIR+1
	INC	L		;Determine if the EOF
	INC	L		;  byte has been changed
	LD	A,(IX+8)	;P/u EOF byte offset
	PUSH	HL		;Save ptr to DIR+3
	CP	(HL)
	JR	NZ,CLOS1	;Go if moved
	LD	A,11H
	ADD	A,L
	LD	L,A
	LD	A,(IX+12)	;P/u low-order ERN
	CP	(HL)
	JR	NZ,CLOS1	;Go if moved
	INC	L
	LD	A,(IX+13)	;P/u high-order ERN
	CP	(HL)
	JR	NZ,CLOS1	;Go if moved
	POP	AF
	JR	CLOS2		;Didn't move
;
;	Routine to change a 3-byte EOF marker
;
CLOS1	POP	HL		;Pop DIR+3
	LD	A,(IX+8)	;Xfer the EOF offset
	LD	(HL),A
	LD	A,11H
	ADD	A,L
	LD	L,A
	LD	A,(IX+12)	;  and the ERN from the FB
	LD	(HL),A
	INC	L
	LD	A,(IX+13)	;  to the DIR entry
	LD	(HL),A
	BIT	2,(IX+0)	;If the file was updated
	JR	NZ,CLOS3	;  then update MOD date
	JR	CLOS5		;  else don't
;
;	Three-byte EOF marker did not change
;
CLOS2	BIT	2,(IX+0)	;If file was updated
	JR	NZ,CLOS3	;  then update MOD date
	BIT	6,(IX+0)	;If close authority then
	JR	NZ,CLOS5	;  write back the DIR
	JR	CLOS6		;  else continue
;
;	Routine to insert packed date into entry
;
CLOS3	PUSH	HL		;Save ptr to DIR+21
	LD	A,L		;Pt to start of dir rec
	AND	0E0H
	LD	L,A
	INC	L		;Pt to DIR+1
	SET	6,(HL)		;Set the MOD flag
	LD	DE,DATE$	;Point to the year
	LD	A,(DE)		;If year = 0, then date
	OR	A		;  is 00/00/00
	JR	Z,$+4
	SUB	80		;Offset from 1980
	PUSH	BC
	LD	B,A		;Year-80 -> regB
	INC	DE		;Point to day
	LD	A,(DE)		;Shift day into 3-7 &
	RLCA			;  merge the year into
	RLCA			;  the lo-order bits
	RLCA
	OR	B
	INC	L
	LD	(HL),A		;Store day/year
	DEC	L
	INC	DE		;Point to month
	LD	A,(DE)
	LD	B,A
	LD	A,(HL)		;P/u dir byte
	AND	0F0H		;Strip old month
	OR	B		;Merge month &
	LD	(HL),A		;  update the field
	POP	BC
CLOS4	POP	HL		;Rcvr DIR+21
CLOS5	PUSH	HL
	CALL	@DIRWR		;Write back DIR entry
	POP	HL
	RET	NZ
CLOS6	INC	L		;Pt to DIR+22 which is
	PUSH	HL		;  the 1st extent
	LD	A,L
	SUB	15H		;Back up to DIR+1
	LD	L,A
	BIT	7,(HL)		;Test if created
	POP	HL
	JP	NZ,RCVN0	;Bypass if created
	LD	DE,0		;Init gran counter
CLOS7	LD	A,(HL)		;P/u cyl indicator
	INC	L		;Pt to gran alloc
	CP	0FEH		;Extent in use?
	JR	NC,CLOS8	;Jump if spare or FXDE
	LD	A,(HL)		;P/u granule allocation
	INC	L		;Pt to next extent
	AND	1FH		;Strip off # of grans &
	INC	A		;  adjust for zero offset
	ADD	A,E		;Accumulate the number of
	LD	E,A		;  grans in this extent
	JR	NC,CLOS7	;Any previous quantity
	INC	D
	JR	CLOS7
CLOS8	JR	NZ,CLOS9	;Found all grans in this
	LD	B,(HL)		;  extent, ck for FXDE
	CALL	@DIRRD
	RET	NZ
	LD	A,L		;Point to extents in FXDE
	ADD	A,16H
	LD	L,A
	JR	CLOS7		;Go to continue count
;
;	Routine to determine need to deallocate
;
CLOS9	PUSH	HL		;Save ptr to last extent
	LD	L,(IX+12)	;P/u ending record #
	LD	H,(IX+13)
	LD	A,8		;Get # sectors/gran
	CALL	@DCTBYT
	AND	1FH		;Remove other data
	PUSH	AF		;Save the #
	ADD	A,L		;Round up to next
	LD	L,A		;  higher gran
	JR	NC,CLOS10
	INC	H
CLOS10	POP	AF		;Rcvr # sectors/gran
	INC	A		;Adjust for division
	CALL	@DIV16		;Calculate # grans in use
	XOR	A		;Subtract the # of grans
	EX	DE,HL		;  used from the # of
	SBC	HL,DE		;  grans allocated in the
	EX	DE,HL		;  directory, and move DE
	POP	HL		;Rcvr ptr to last extent
	JP	Z,RCVN0		;Jump if same quantity
	JP	C,RCVN0		;Jump if now more
;
;	Need to deallocate space
;
	CALL	@GATRD		;Read GAT
	RET	NZ
	JR	BAKUP		;B/u to last used extent
CLOS11	PUSH	DE		;Sv count of excess grans
	LD	A,(HL)		;P/u alloc info
	AND	0E0H		;Get starting relative
	RLCA			;  gran into reg-E
	RLCA
	RLCA
	LD	E,A
	LD	A,(HL)		;# of contiguous grans
	AND	1FH		;Remove unneeded data
	ADD	A,E		;Calculate ending
	LD	E,A		;  relative gran #
	LD	A,8		;P/u the # of grans
	CALL	@DCTBYT		;  per cylinder
	RLCA
	RLCA
	RLCA
	AND	7		;Move into bits 0-2
	INC	A		;Adjust for zero offset
	LD	D,A		;Save count
	LD	A,4
	CALL	@DCTBYT
	BIT	5,A		;2-sided disk?
	LD	A,D		;Rcvr count
	JR	Z,$+3		;Bypass if 1-sided
	RLCA			;Double count
	CALL	@DIV8		;A=quotient, E=remainder
	DEC	L		;Pt to starting cylinder
	ADD	A,(HL)		;Bump cyl pointer by how
	LD	D,A		;  many excessive cyls to
	PUSH	HL		;  start from the rear
	PUSH	BC
	LD	H,DIRBUF$>8	;Pt to that cyl's GAT
	LD	L,D
	LD	B,(HL)		;P/u the GAT allocation
	LD	A,E
	CALL	CALCBIT		;Deallocate a gran
	LD	(HL),B		;Replace GAT byte
	POP	BC
	POP	HL
	INC	L		;Repoint to alloc info
	DEC	(HL)		;Reduce by 1 gran
	LD	A,(HL)		;Get info on contig gran
	INC	A		;Adj for zero offset
	AND	1FH		;Mask off unneeded
	POP	DE		;Rcvr excess gran count
	DEC	DE		;  and count down
	JR	NZ,CLOS12	;Go if extent still used
BAKUP	LD	(HL),0FFH	;  else extent is spare
	DEC	L
	LD	(HL),0FFH
	DEC	L
	LD	A,L		;Check if backed all the
	AND	1FH		;  way thru this entry
	CP	15H
	JR	NZ,CLOS12	;Go if not
	XOR	L		;Deallocate this FXDE
	LD	L,A
	BIT	7,(HL)		;Was it the FPDE?
	JR	Z,CLOS12	;Bypass if FPDE
	LD	(HL),0		;Show dir is spare
	CALL	@DIRWR		;Write back
	RET	NZ
	LD	A,B		;P/u deallocated DEC
	AND	0E0H
	INC	A		;Pt to DIR+1
	LD	L,A
	LD	A,(HL)		;P/u previous DEC
	LD	(STUFDEC+1),A	;Save in opcode ahead
	CALL	@HITRD		;Read the HIT
	RET	NZ
	LD	L,B		;Point to deallocated HIT
	LD	(HL),0		;Deallocate space in HIT
	CALL	@HITWR		;Write back
	RET	NZ
STUFDEC	LD	B,0		;P/u previous DEC
	CALL	@DIRRD		;Read its dir entry
	RET	NZ
	LD	A,B
	OR	1FH		;Pt to end of entry
	LD	L,A
	LD	(HL),0FFH	;Erase pointer
	DEC	L		;  to deallocated FXDE
	LD	(HL),0FFH
	DEC	L		;Point to previous extent
	PUSH	HL		;Save pointer
	CALL	@DIRWR		;Write back
	POP	HL
	RET	NZ
CLOS12	LD	A,D		;Loop if still more to
	OR	E		;  deallocate
	JP	NZ,CLOS11
	CALL	@DIRWR
	JR	Z,CLOS13	;Go if no write error
	CP	15		;"write protected
	RET	NZ		;Bad if not
	JR	RCVN0
;
CLOS13	CALL	@GATWR		;Write back the altered GAT
	RET	NZ
;
;	Routine starts to recover file spec
;
RCVN0	LD	A,(IX+7)	;P/u DEC of FPDE
	LD	C,(IX+6)	;P/u drive
	XOR	B		;Check if its directory
	AND	1FH		;  record is resident
	LD	B,(IX+7)	;P/u DEC of FPDE
	CALL	NZ,@DIRRD	;Get FPDE dir if needed
	RET	NZ
	PUSH	IX		;Transfer FCB to DE
	POP	DE
RCVNAM	LD	A,C
	AND	7		;Convert drive to ASCII
	OR	'0'
	LD	(RCVN5+1),A
	LD	H,SBUFF$>8	;Pt to DIR+5 (name)
	LD	A,B
	AND	0E0H
	OR	5
	LD	L,A
	PUSH	HL		;Save name start posn
	LD	B,8		;Init 8 chars max
RCVN1	LD	A,(HL)		;Move filename from
	CP	' '		;  direc to FCB
	JR	Z,RCVN2
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	RCVN1		;Loop up to 8
RCVN2	POP	HL
	LD	A,L
	ADD	A,8		;Pt to extension
	LD	L,A
	LD	A,(HL)
	CP	' '
	JR	Z,RCVN4		;Jump if none
	LD	A,'/'
	LD	(DE),A		;Stuff separator into FCB
	INC	DE
	LD	B,3		;Init 3-char extension
RCVN3	LD	A,(HL)		;Stuff the ext
	CP	' '		;  into FCB
	JR	Z,RCVN4
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	RCVN3
RCVN4	LD	A,':'		;Stuff drive indicator
	LD	(DE),A
	INC	DE
RCVN5	LD	A,0		;P/u drive in ASCII
	LD	(DE),A		;  & stuff it
	INC	DE
	LD	A,03H		;Close FCB with ETX
	LD	(DE),A
	XOR	A		;Set Z for no error
	RET
;
;	Routine to recover the filespec
;
FNAME	PUSH	HL
	PUSH	DE
;
;	Calculate the number of directory sectors
;	= (#sectors x #heads) - 2 for GAT & HIT
;
	LD	A,7		;Get highest # sector
	CALL	@DCTBYT
	LD	D,A		;Store heads & sectors
	AND	1FH		;Mask for # sectors
	LD	E,A		;  & stuff into E
	INC	E		;Bump for 0 offset
	XOR	D		;Rcvr # heads, destroy # secs
	RLCA			;Rotate into bits 0-2
	RLCA
	RLCA
	INC	A		;Bump for 0 offset
	CALL	@MUL8		;Multiply sectors x heads
	LD	E,A		;Now check double bit
	LD	A,4
	CALL	@DCTBYT
 	BIT	5,A		;2-sided if set
	LD	A,E
	JR	Z,ONESID	;Go if not set
	ADD	A,A		;  else double value
ONESID	SUB	2		;Reduce for GAT & HIT
	LD	D,A
	LD	A,B
	AND	1FH		;Calc req sector #
	CP	D
	JR	C,FNAM1
	LD	A,16		;"Illegal logical file #
	OR	A
	JR	FNAM2
FNAM1	POP	DE		;Reget Cyl/Sec
	PUSH	DE
	CALL	@DIRRD
	CALL	Z,RCVNAM	;Rcvr the filespec
FNAM2	POP	DE
	POP	HL
	RET
;
;	Close a logical device
;
CLOSDEV	CP	10H		;If not open device,
	LD	A,38		;  return "file not open...
	RET	NZ
	CALL	LNKFCB@		;Link to FCB
	LD	C,(IX+6)	;Get device name
	LD	B,(IX+7)
	LD	(IX+0),'*'	;Stuff device indicator
	LD	(IX+1),C	;Stuff 1st char of name
	LD	(IX+2),B	;Stuff 2nd char of name
	LD	(IX+3),3	;Terminate with ETX
	XOR	A
	RET
;
;	Calculate GAT bit to deallocate
;
CALCBIT	AND	7		;Make binary bit # into
	RLCA			;  the proper RES
	RLCA			;  opcode
	RLCA
	OR	80H
	LD	(CALC1+1),A
CALC1	RES	0,B		;Reset bit in GAT
	RET
;
;	User removed disk with an open file
;
HOLDUP	PUSH	HL
	PUSH	DE
	LD	HL,HOLDUP$	;Pt to message
	CALL	@DSPLY		;Display to console
	CALL	@CKBRKC		;Clear out break bit
WAITING	CALL	@KBD		;Scan the keyboard
	JR	NZ,WAITING	;Keep looking
	CP	CR		;Check for <ENTER>
	JR	Z,TRYNOW
	CALL	@CKBRKC		;Check for a break
	JR	Z,WAITING
ABRT	POP	DE
	POP	HL
	POP	IY		;Restore from above
	LD	A,32		;Show illegal drive #
	OR	A		;Set NZ condition
	RET			;Go back now
TRYNOW	POP	DE
	POP	HL
	JP	CKAGN		;Try checking again
HOLDUP$	DEFB	LF,'** CLOSE FAULT **  Drive not ready, '
	DEFB	'<ENTER> to retry, <BREAK> to abort',CR
LAST	EQU	$
	IF	$.GT.DIRBUF$
	ADISP	'ERROR: Module too big'
	ENDIF
	ORG	MAXCOR$-2
	DW	LAST-SYS3	;Overlay length
;
	END	SYS3
