;VIDB/PCL    10/04/83
	IF	ADDS
;Call BLINKR every time through main loop
;Read screen into buffer - update according to attributes
BLINKR:	LD	A,(BLINKF)	;Has BLINK attribute been set?
	OR	A
	RET	Z		;Skip if not
	LD	A,(ATFLG)	; are ANY attributes current?
	LD	(BLINKF),A	;Reset BLINKF if not
	OR	A
	RET	Z
	LD	HL,BLINKC	;Get counter
	INC	(HL)
	LD	A,(HL)
	CP	180		;Patchable count
	RET	NZ		;Blink every 256 loops
	LD	(HL),0		;Reset for next
	LD	A,(BLINKD)	;ON/OFF
	CPL
	LD	(BLINKD),A	;Toggle
	OR	A
	JP	Z,UPSCRN	;Replace blinking chars if Z
;
;Otherwise remove blinking chars
	CALL	GETSCR		;Get screen into buffer
;Screen is in buffer, merge current attributes
	LD	DE,ALTSCR	;=>alt screen
	LD	HL,TRSCR	;=>real screen
	LD	BC,0		;No attribs to start
	EXX			;Set counter
	LD	E,0		;Set flag for blink attrib bytes
	LD	BC,80*24	;=>number of chars
	EXX
;Remove chars fm blinking fields/replace w/space or rev space
BLLOOP:	LD	A,(DE)		;Get possible attribute
	OR	A		;New setting?
	JP	M,ISNEW2	; change in attrib val
;This is not an attribute position
;B=0 if not reverse field/80H if reversed C=attrib byte
	BIT	BLINK,C		;Is this field blinking?
	JP	Z,BUMPA		;Skip if not
;Blinking fields should aready be stored in alt screen
;So just blank out on real screen
	LD	A,20H		;Replace w/blank
	OR	B		;Or reverse blank
	LD	(HL),A		;On screen
BUMPA:	INC	HL		;Move to next posn
	INC	DE		;On each screen
	EXX
	DEC	BC		;Count the positions
	LD	A,B
	OR	C
	EXX
	JP	NZ,BLLOOP	;Do all of screen
	EXX			;Were there any blinks?
	XOR	A
	BIT	BLINK,E
	EXX
	JP	NZ,PUTSCR	;Replace screen if changed
	LD	(BLINKF),A	;Nothing changed
	JP	CCUR		;Reset cursor
;
ISNEW2:	LD	C,A		;Save attribute
	EXX
	OR	E		;Merge all attrib bits into alt E
	LD	E,A		;To see if any fields blinked
	EXX			;When done
	LD	A,C
	RLCA			;Shift bit 6 to bit 7 (REV)
	AND	80H		;High bit (rev) only
	LD	B,A		;To B
	JP	BUMPA		;Move to next posn
	ENDIF
	IF	.NOT.ADDS
DUMPCH:
BLINKR:	RET			;
;
;*********************************************
; Video emulator for 6.X control codes & SVCs
; Pass all control codes directly
; ESC is sent as ESC ESC
; CTL-Q is sent as ESC 'Q'
; ESC X rc char means @vdctl fcn 2 (put char @ rc)
; ESC Y rc = cursor posn
; ESC V = start of screen dump @vdctl fcn 5
; ESC W = end of screen dump
;*=*=*
;
;List of FIRST (or only) chars for special functions
VTBL1:	DB	VENTRY1		;Number of entries in table
;Single or first char of control codes acted upon:
;Followed by address 
	DB	BELL		;  07H
	DW	DOBELL		;Noise?
	DB	TAB		;  09H     ;left to next stop
	DW	DOTAB		;Move to next tab setting
	DB	ESC		;  1BH     ;possible start of sequence
	DW	VESCAP		;Starting ESC sequence
;
;TRS video codes are passed on...
VENTRY1	EQU	$-VTBL1/3	;Number of entries
	DW	OUTA		;Jp if no match
;
VESCAP:	LD	HL,VESC2	;EP for next char
	JP	SVEC
VESC2:	LD	HL,CHAR1
	CALL	SVEC
	LD	HL,VTBL2
	JP	LOOKUP
;
VTBL2:	DB	VENTRY2
	DB	ESC
	DW	OUTA		;Was ESC ESC
	DB	'C'	
	DW	VESCC		;Set cursor char
	DB	'Q'
	DW	VESCQ		;Chg to ctl-Q (rev off)
	DB	'S'
	DW	VESCS		;Scroll protect
	DB	'V'
	DW	VESCV		;Start screen dump
	DB	'X'
	DW	VESCX
	DB	'Y'
	DW	ESCY		;Same as ADDS mode
VENTRY2	EQU	$-VTBL2/3
	DW	DUMPCH
;
VESCQ:	LD	A,'Q'-40H	;Unreverse video
	JP	OUTA		;Since ctl-q is dumped
;Change cursor character
VESCC:	LD	HL,VESCC2
	JP	SVEC
VESCC2:	LD	HL,CHAR1	
	CALL	SVEC
	LD	C,A
	JP	MAKCUR		;Pass to @VDCTL
;Scroll protect n lines
VESCS:	LD	HL,VESCS2
	JP	SVEC
VESCS2:	LD	HL,CHAR1
	CALL	SVEC
	SUB	20H		;Remove ASCII offset
	LD	C,A
	JP	SCRPRT		;Scroll protect n lines
;
; set up to receive screen image
VESCV:	LD	HL,VESCV2	;Send following chars via VDCTL 2
	CALL	SVEC
	LD	HL,0		;Starting posn
	LD	(VPNT),HL	;Store next char posn
	CALL	GETCUR		;Save cursor posn
	PUSH	HL
	CALL	CLS2		;Clear screen first
	POP	HL
	JP	SETCUR		;Restore cursor posn
; chars in screen image format
VESCV2:	LD	C,A		;Save char
	LD	HL,(VPNT)	;Get r/c pointer
	PUSH	HL		;Save posn
	CALL	PUTAHL		;Put char there
	POP	HL		;Restore posn
	INC	L		;Next posn
	LD	A,L		;Done?
	SUB	80
	JR	NZ,SPSN		;Set for next char
	LD	L,A
	INC	H		;Move to next row
	LD	A,H
	CP	24
	JR	NZ,SPSN
	LD	HL,CHAR1	;Back to normal mode
	JP	SVEC		;For next char
SPSN:	LD	(VPNT),HL	;Next char posn
	RET
;
VESCX:	LD	HL,ESCX2
	JP	SVEC
ESCX2:	LD	(CURROW),A	;Save this one
	LD	HL,ESCX3
	JP	SVEC
ESCX3:	LD	HL,ESCX4
	LD	(CURCOL),A	;Save col
	JP	SVEC
;
ESCX4:	LD	C,A
	LD	HL,CHAR1
	CALL	SVEC
	LD	A,(CURCOL)	;P/u col addres
	SUB	32		;Rmv ascii offset
	RET	C		;Quit if illegal
	CP	79+1
	RET	NC
	LD	L,A
	LD	A,(CURROW)	;Row address
	SUB	32
	RET	C
	CP	23+1
	RET	NC
	LD	H,A		;To H
	JP	PUTAHL		;Send to video
	ENDIF
;
