;VIDA - 09/21/83 - duplicate @VDCTL SVCs
; CALL INTVID to initialize correct mode
; CALL RESVID to restore original cursor & default mode
; CALL TKGET before keyboard to allow muli-key xlate
; CALL TKI with each KB char to test for XLATE
;
; enter with char in A at TEMEM
; JPs to VIDOUT to go to video only
; JPs to OUTB   with char for all but video
;RETURNS if no action to be taken yet
; May CALL OUTA,OUTB,VIDOUT with multple chars
; REPLYs to ESC ? with CALL SENDA to RS232 output (ADDS mode)
;*=*=*
; Switch between emulation modes by changing (KXPTR)
; for keyboard tables
; and (VXPTR) for video fcn jump table
; also (CTLPTR) for file or pr controlled by ctl-R/T
;
	IF	ADDS
KXPTR:	DW	KXTBL		;Ptr to ki xlates
;                                VKTBL for 6.x
VXPTR:	DW	TABLE1		;Ptr to video fcn xlates
;                               VTBL1 for 6.x
IFLG:	DB	0FFH		;Init video & cursor?
;                               ; 0 for 6.x
AFLG:	DB	0FFH		;Using ADDS emulator?
CTLPTR:	DW	PUTPR+1		;Or FRSW+1
	ELSE
VXPTR:	DW	VTBL1		;Ptr to video fcn xlates
IFLG:	DB	00		;Init video & cursor?
AFLG:	DB	00
CTLPTR:	DW	FRSW+1		;Or FRSW+1
	ENDIF
;
SCRFLG:	DB	0		;AUTO scroll ON?
TFLAG:	DB	0FFH		;Emulator ON?
VPNT:	DW	0		;Row/col psns
CURCOL:	DB	0	
CURROW:	DB	0
CURFLG:	DB	0FFH		;Cursor ON/OFF
OLDCUR:	DB	0
JPVEC:	DW	CHAR1		;Look for 1st char of seq
;
	IF	ADDS
;ADDS video attribute lookup
;
;ALTSCR  is 80X24 table of attribute bytes for screen
; plus characters including invis and blinking
; High bit is set on attribute bytes
;TRSCR is 2K buffer used for screen transfer
;ATFLG  is flag for no attribute bytes on screen
; if 0, skip alt screen update
;All characters go on screen via @VDCTL
;
;Bit settings for attribute bytes
ATT	EQU	7		;Bit 7 if attrib byte
ATT$	EQU	10000000B
REV	EQU	6		;Bit 6 if reverse field
REV$	EQU	01000000B
INV	EQU	5		;Bit 5 if invis field
INV$	EQU	00100000B
BLINK	EQU	4		;Bit 4 if blinking field
BLINK$	EQU	00010000B
;
BLINKC:	DB	0		;Counter for blinking
BLINKD:	DB	0		;Flag for ON/OFF
BLINKF:	DB	0		;Flag for blinking
ATFLG	DB	0		;Flag for attribs set
NEEDUP	DB	0		;Flag screen needs update
CHAR	DB	0		;Current output char
ATBYTE	DB	0		;Attribute for position if >0
CURSAV	DW	0		;System r/c address
ALTPOS	DW	0		;Posn in alternate screen
ALTSCR	DS	80*24		;Fill w/nulls at startup
TRSCR	DS	256*8		;2K buffer
;
; xlate cursor psn into alt screen posn
GETOFF:	CALL	GETCUR		;Get rc position
	LD	(CURSAV),HL	;Save system cursor posn
	LD	A,(ATFLG)	;Any atttribs
	OR	A
	JR	Z,SKPOF1	;Skip alt screen if not
;Find corresponding position in saved screen
;Multiply H by 80/ add L
GETOF1:	PUSH	HL		;R/c posn
	XOR	A		;Zero
	LD	E,H
	LD	D,A		;H to DE (row)
	LD	H,A
	PUSH	HL		;L on stack
	LD	L,E		;HL=DE
;
	ADD	HL,HL		;X2
	ADD	HL,HL		;X4
	ADD	HL,DE		;X5
	ADD	HL,HL		;X10
	ADD	HL,HL		;X20
	ADD	HL,HL		;X40
	ADD	HL,HL		;X80
	POP	DE		;Get L
	ADD	HL,DE		;Merge col
	LD	DE,ALTSCR
	ADD	HL,DE		;Add to start of alt screen
	LD	(ALTPOS),HL
	POP	HL		;R/c
SKPOF1:	LD	A,H		;Will this char force a scroll?
	CP	23	
	RET	NZ		;Not on last line
	LD	A,L
	CP	79		;Last char posn?
	RET			;Z=screen needs to scroll
;
;HL=>alt screen posn / get attrib for posn into A
GETATR:	LD	A,(ATFLG)	;Any attributes present?
	OR	A
	RET	Z		;NO attributes on screen
	LD	A,(ATBYTE)	;Do we have the setting stored?
	OR	A
	RET	M		;Saved one is valid use it
	CALL	ATLP		;Find attribute for this posn
	SET	7,A		;Make "no attrib" if 0
	LD	(ATBYTE),A	;For next time
	RET
;
ATLP:	LD	A,(HL)		;P/u char
	DEC	HL
	OR	A		;Is high bit set?
	RET	M		;Return attribute for position
	LD	A,H		;Go backwards to start of screen
	CP	ALTSCR-1<-8	;High byte of altscr start
	JP	NZ,ATLP
	LD	A,L
	SUB	ALTSCR-1&0FFH	;Low byte
	JP	NZ,ATLP		;Loop till done
;No attribute bytes before cursor posn, check after
	LD	HL,(ALTPOS)	;Where is it
ALP2:	LD	A,(HL)		;Check each char
	INC	HL
	OR	A
	JP	M,ISATT		;Go if found
	LD	A,H
	CP	80*24+ALTSCR+1<-8	;Check High byte
	JP	NZ,ALP2
	LD	A,L
	CP	80*24+ALTSCR+1&0FFH	;Low byte
	JP	NZ,ALP2
;No attribute bytes anywhere on screen/clear alt
;
CLSALT:	XOR	A
	LD	(ATFLG),A	;Flag no attributes set on screen
	LD	(ATBYTE),A	;And none for cursor posn
	LD	HL,ALTSCR
	PUSH	DE
	LD	DE,ALTSCR+1
	PUSH	BC
	LD	BC,80*24-1
	LD	(HL),0		;Zero alternate screen
	LDIR
	POP	BC
	POP	DE
ISATT:	XOR	A
	RET			;Z=none found before cursor
;
CLRATT:	XOR	A		;Flag atbyte
	LD	(ATBYTE),A	;Not valid
	JP	CLRAT1		;Overwrite attrib byte
;Change an attribute byte/new val in A
SETATT:	LD	(CHAR),A	;Save char
	LD	(ATBYTE),A	;Keep to check later
	AND	BLINK$		;Setting a blinking field?
	LD	A,0FFH		;Set..
	JP	Z,NBLNK		;Nope..
	LD	(BLINKF),A	;Flag it if so
NBLNK:	LD	(ATFLG),A	;Flag some attribute is set
	CALL	GETOFF		;Find posn
	JP	NZ,SETT1	;Go if no scroll
	CALL	SCROLR		;Scroll if needed
	LD	H,23
	LD	L,0
	CALL	SETCUR		;Position cursor
	JP	CLRAT1
SETT1:	CALL	CURS1		;Else advance cursor
CLRAT1:	LD	A,(CHAR)	;P/u char
; may be attribute byte or character overwriting one
	LD	HL,(ALTPOS)	;Get posn for attribute
	LD	(HL),A		;Stuff new setting
	LD	A,(NEEDUP)	;Did scroll happen
	OR	A
	JP	NZ,UPSCR1	;Then screen is already in buffer
;
;Read screen into buffer - update according to attributes
;INV=move from screen to altscreen unless space char already
;    put space on screen
;Get char fm altscreen if present/else fm real screen
;REV=set high bit on screen char
;NOR=reset high bit on screen
;BLINK = put on screen this round
;
UPSCRN:	CALL	GETSCR		;Get screen into buffer
;Screen is in buffer, merge current attributes
UPSCR1:	LD	DE,ALTSCR	;=>alt screen
	LD	HL,TRSCR	;=>real screen
	LD	BC,0		;No attribs to start
	EXX			;Set counter
	LD	BC,80*24	;=>number of chars
	EXX
;
UPLOOP:	LD	A,(DE)		;Get possible attribute
	OR	A		;New setting?
	JP	M,ISNEW		; change in attrib val
;This is not an attribute position
;B=0 if not reverse field/80H if reversed C=attrib byte
	BIT	INV,C		;Is this field invisible?
	JR	NZ,ISINV	;Go if so
;Is anything on alternate screen?
	OR	A
	JP	NZ,HVALT	;Update real screen fm alt
	LD	A,(HL)		;Alt screen was cleared
	AND	7FH		;Clear REVERSE
	LD	(DE),A		;Restore alt screen if null
HVALT:	OR	B		;Merge REVERSE bit
	LD	(HL),A		;Put on real screen
BUMP1:	INC	HL		;Move to next posn
	INC	DE		;On each screen
	EXX
	DEC	BC		;Count the positions
	LD	A,B
	OR	C
	EXX
	JP	NZ,UPLOOP	;Do all of screen
	LD	(NEEDUP),A	;Flag update is done
	JP	PUTSCR		;Replace screen
;
ISNEW:	LD	(HL),20H	;Show blank on screen
	LD	C,A		;Save attribute
	RLCA			;Shift bit 6 to bit 7 (REV)
	AND	80H		;High bit (rev) only
	LD	B,A		;To B
	JP	BUMP1		;Move to next posn
;
ISINV:	LD	A,(HL)		;Get char fm screen
	PUSH	AF		;Save it
	LD	A,20H		;Replace w/blank
	OR	B		;Or reverse blank
	LD	(HL),A		;On screen
	POP	AF		;Was non-blank there?
	AND	7FH	
	CP	20H
	JP	Z,BUMP1		;Yes, don't change alt
	LD	(DE),A		;Otherwise save removed character
	JP	BUMP1		;Go to next posn
;
ADDVID:	LD	(CHAR),A	;Save character to PUT
	LD	A,(DEVOUT+1)
	OR	A
	RET	Z		;Ignore if *DO is off
	CALL	GETOFF		;Find cursor/alt posn
	JP	Z,SCROLA	;Scroll screen if necessary
	CALL	CURS1		;Else advance cursor
NOWPUT:	LD	A,(ATFLG)	;Any ATTRIBUTEs set?
	OR	A
	JP	Z,ONLYSC	;No attribs, put on screen
	LD	HL,(ALTPOS)	;P/u alt screen posn
	LD	A,(HL)		;Is this an attribute setting?
	RLCA			;Test bit 7
	JP	C,CLRATT	;Go if overwriting attribute
	LD	A,(CHAR)	;Get char
	LD	C,A
	LD	(HL),A		;Put on saved screen
	CALL	GETATR		;Get attrib for char
	BIT	INV,A		;Is it invisible?
	JR	NZ,CKROL	;See if scroll happened
	AND	01000000B	;REV bit
	RLCA			;To bit 7
	OR	C		;Merge w/char
ONLYS1:	LD	C,A		;Char to C
	LD	A,(NEEDUP)	;Did screen move?
	OR	A
	JP	NZ,UPSCR1	;Then update whole screen
	LD	HL,(CURSAV)	;Else p/u char posn
	JP	PUTAHL		;And put on screen
;
CKROL:	LD	A,(NEEDUP)	;Added invis char
	OR	A		;Did screen move
	JP	NZ,UPSCR1	;Update if so
	RET			;Else done
;
ONLYSC:	LD	A,(CHAR)
	JR	ONLYS1
;
;Advance cursor one posn /cant be at end
CURS1:	LD	HL,(CURSAV)
	INC	L
	LD	A,L
	CP	80
	JP	NZ,SETCUR
	LD	L,0
	INC	H
	JP	SETCUR
;
;Printing last char scrolls screen...
SCROLA:	CALL	SCROLB		;Adjust first..
	JP	NOWPUT		;Then put character
;Adjust pointers/cursor/screen for next char
SCROLB:	LD	A,(SCRFLG)	;Is screen scroll OFF?
	OR	A
	JP	NZ,SISOFF
	CALL	SCROLR		;Adjust screen/pointers
	LD	H,23
	LD	L,0
	JP	SETCRA		;New system cursor posn
;
SISOFF:	LD	HL,0
	JP	SETCRA		;New position is 0 if no scroll
;
SCROLR:	LD	A,(ATFLG)	;Any attribs?
	OR	A
	JP	Z,SCRL1
; if altscr in use, scroll it also
	XOR	A
	LD	(ATBYTE),A	;May change attributes
	LD	HL,ALTSCR+80	;Move alt screen up a line
	LD	DE,ALTSCR	;
	LD	BC,80*23
	LDIR
	LD	B,80		; fill bottom line w/blanks
	LD	A,20H
BLNK2:	LD	(DE),A
	INC	DE
	DJNZ	BLNK2
	LD	DE,-80		;Now adjust posn for char
	LD	HL,(ALTPOS)	;On alt screen
	ADD	HL,DE
	LD	(ALTPOS),HL
;
	CALL	GETSCR		;Put screen in buffer
	LD	HL,TRSCR+80
	LD	DE,TRSCR
	LD	BC,80*23
	LDIR			;Scroll screen
	LD	B,80		;Line length
	LD	A,20H		;Load a blank
BLNK1:	LD	(DE),A		;Blank last line
	INC	DE
	DJNZ	BLNK1
;
	LD	A,22		;Adjust row posn of cursor
	LD	(CURSAV+1),A	;Store new
	LD	A,0FFH
	LD	(NEEDUP),A	;Flag that...
	RET			;Screen is not replaced yet
;
;If NO attributes set, scroll screen by printing ctl-z
SCRL1:	LD	A,VDN1
	CALL	VIDOUT		;Force screen scroll
	LD	A,22		;Reset row posn for
	LD	(CURSAV+1),A	;Char not added yet
	RET
;
;
;Keyboard translator for arrow keys:
TKEXPC:	DB	0
TKPTR:	DW	0
TKGET:	LD	A,(TKEXPC)	;Expanding key?
	OR	A
	RET	Z		;Z=none here
	DEC	A
	LD	(TKEXPC),A	;Count down
	LD	HL,(TKPTR)
	LD	A,(HL)
	INC	HL
	LD	(TKPTR),HL
	DEC	H		;Force NZ
	RET
;
TKI:	LD	HL,(KXPTR)
	LD	B,(HL)		;Get number
	INC	B
	DEC	B
	RET	Z
	LD	D,0
KIXLP:	INC	HL
	CP	(HL)
	INC	HL
	LD	E,(HL)		;Get length
	JR	Z,KMAT
	ADD	HL,DE		;Move to next -1
	DJNZ	KIXLP
	RET
;
KMAT:	LD	A,E		; get length
	INC	HL		;Char
	DEC	A		; count down
	LD	B,(HL)		;Get char
	JR	Z,JUST1		;Only one
	LD	(TKEXPC),A	;Else flag more
	INC	HL		;Point to next
	LD	(TKPTR),HL	;And save pointer
JUST1:	LD	A,B		;Char to return
	RET
;
VKTBL:	DB	0		;Disable function
KXTBL:	DB	8		;Number of entries
	DB	0BH,01,1AH	;Up arrow
	DB	09H,01,06H	;Right arrow
	DB	81H,01,01H	;F1 = HOME key
	DB	82H,01,02H	;F2 = ctl-B
; this is what the DT1 DOC says...
;       DB      139,03,01,48H,13 ; clr up arrow
;       DB      137,03,01,46H,13 ;clr rt arrow
;       DB      138,03,01,42H,13 ;clr dn arrow
;       DB      136,03,01,44H,13 ;clr lft arrow
;
; but this is what the keys actually do...
	DB	139,03,02,56,13	; clr up arrow
	DB	137,03,02,54,13	;Clr rt arrow
	DB	138,03,02,50,13	;Clr dn arrow
	DB	136,03,02,52,13	;Clr lft arrow
;
	ELSE
TKGET:	XOR	A
	RET			;No key expansion
TKI:	RET			;No key xlate
	ENDIF
HOOKS:
;
SENDA:	LD	C,A
	JP	CLOUT
;
	IF	ADDS
OUTA:
OUTADD:	LD	C,A		;Send to ADDS emulator & devices
	PUSH	BC
	CALL	ADDVID
	POP	BC
	LD	A,C
	JP	OUTB		;To other devices
	ELSE
OUTA:	LD	C,A
	PUSH	BC
	CALL	VIDOUT
	POP	BC
	LD	A,C
	JP	OUTB
	ENDIF
;
;PR ON/OFF is done by COMM code (instead of FR)
;DOPROF: RET
;DOPRON: RET
;*=*=*=*
;Note the following is TRS mod 4 specific...
;Interrupts have to be ON
;*=*=*=*
SNDPRT	EQU	90H		;Sound port
DOBELL:	LD	BC,4040H
	LD	DE,01FFH
BELLP:	LD	A,1		;Hold output high
	OUT	(SNDPRT),A
	DJNZ	$
	LD	A,2
	OUT	(SNDPRT),A
	LD	B,C
	DJNZ	$
	DEC	E
	JR	NZ,BELLP
	DEC	D
	JR	NZ,BELLP
	RET
;Patch space
	DB	'                                '
;End of hardware specific code.
;
;Entry to terminal emulator - test if ON first
TERMEM:	LD	C,A
	LD	A,(TFLAG)	;Is terminal emulator ON
	LD	B,A		;And...
	LD	A,(DEVOUT+1)	;Is video ON
	AND	B
	LD	A,C
	JP	Z,OUTA		;Go if OFF
; minimize overhead on non-ctl codes..
; Note: this is NOT re-entrant code!
	LD	HL,(JPVEC)	; Now what?
	JP	(HL)		; go do something
;
CHAR1:	CP	' '		;First look for control codes only
	JP	NC,OUTA		;Otherwise no changes
	;OUTA for 6.0
;*=*=* point to list of spc chars for mode *=*=*
	LD	HL,(VXPTR)	;Pt to list of spc chars
LOOKUP:	LD	B,(HL)		;How many entries
LKLP:	INC	HL		;=>entry
	CP	(HL)		;Something special?
	INC	HL		;Move to address field
	JR	Z,AMATCH	;Go if this one
	INC	HL
	DJNZ	LKLP
	INC	HL
; list terminated w/default address.
AMATCH:	LD	E,(HL)		;Get low byte
	INC	HL		;Move to ..
	LD	D,(HL)		;High byte
	EX	DE,HL		;Address to HL
	JP	(HL)		;Go to it!
;
BELL	EQU	07H
TAB	EQU	09H		;Left to next stop
ESC	EQU	1BH		;Possible start of sequence
	IF	ADDS
;********************************************************
; Video emulator for ADDS25
; Translate to corresponding control codes where possible
; otherwise do in memory and use VIDCTL
;*=*=*
; enter with char in A at TEMEM
; JPs to VIDOUT to go to video only
; JPs to OUTB   with char for all but video
;RETURNS if no action to be taken yet
; May CALL OUTA,OUTB,VIDOUT with multple chars
; REPLY to ESC ? with CALL SENDA to RS232 output
;*=*=*
; CALL INTVID to initialize correct mode
; CALL RESVID to restore original cursor & default mode
;Single or first char of control codes
;********************************************
;These are the control values observed:
HOME	EQU	01H		;Bottom right
CURRT	EQU	06H		;Cursor right
BKSP	EQU	08H		;Non-destructive
CURSDN	EQU	0AH		;Down one line
FFEED	EQU	0CH		;Home & clear
CR	EQU	0DH		;Return to left of line
PRON	EQU	12H		;Enable printer
PROFF	EQU	14H		;Disable printer
CURSLF	EQU	15H		;Ctl U also BKSP
CURSUP	EQU	1AH		;Up one line
NWLINE	EQU	1FH		;Start of next line
;
;ESCAPE sequences:
; 1BH and following character are always discarded
;
;ESC 1  - Set tab stop
;ESC 2  - Clear tab stop
;ESC I  - Back tab
;ESC K  - erase to end of line
;ESC k  - erase to end of page
;ESC *  - clear screen
;
;ESC G 0 - normal video
;ESC G 1 - invisible video
;ESC G 4 - reverse video
;ESC G 5 - rev (shld be inv reverse)
;ESC G 6 - reverse also (shld blink)
;ESC G 7 - rev (shld be rev inv blink)
;ESC G < - rev (shld be rev underline)
;ESC G = - rev (shld be inv rev underline)
;ESC G > - rev (rev blink underline)
;ESC G ? - rev (inv rev blnk underline)
;
;ESC .  - cursor on/off toggle
;
;ESC Y rc - direct cursor addressing
;ESC ?  - read cursor row/column
;
;ESC 5  - disable keyboard
;ESC 6  - enable keyboard
;TRS video codes to trap
SO	EQU	0EH		;Cursor ON
SI	EQU	0FH		;Cursor OFF
DLE	EQU	10H		;Rev vid
DC1	EQU	11H		;Disable hi bit routine
SYN	EQU	16H		;Swap spcl chars
ETB	EQU	17H		;40 cpl
CAN	EQU	18H		;Cursr
EM	EQU	19H		;Curs rt
FS	EQU	1CH		;Cursor home/80 cpl/hi bit routine off
;
	ENDIF
;OPERATORS actually sent to TRS video
LF	EQU	0AH
VCURON	EQU	0EH		;Cursor ON
VCUROF	EQU	0FH		;Cursor OFF
VRVID	EQU	10H		;Reverse video ON & set hi bits
VURVID	EQU	11H		;Un-reverse (don't set hi bit)
VLF1	EQU	18H		;Left 1
VRT1	EQU	19H		;Right 1
VDN1	EQU	1AH		;Down 1
VUP1	EQU	1BH		;Up 1
VHOME	EQU	1CH		;Cursor to upper left/80 cpl/hi bit off
VBOL	EQU	1DH		;Cursor to start of line
VCEOL	EQU	1EH		;Erase to end of line
VCEOF	EQU	1FH		;Erase to end of frame
;
;Looking for second char of esc sequence
	IF	ADDS
ESCAPE:	LD	HL,ESC2
	ENDIF
SVEC:	LD	(JPVEC),HL	;Trap next pass
	RET
;
	IF	ADDS
ESC2:	LD	HL,CHAR1
	LD	(JPVEC),HL	;Most values are just two chars
;Second char of ESC sequence lands here:
	LD	HL,TABLE2
	JR	LOOKUP
;
CTLK:	LD	HL,CTLK2	;Set to receive ROW posn
	JR	SVEC
CTLK2:	LD	HL,CHAR1
	CALL	SVEC
	SUB	32		;Remove ascii offset
	RET	C
	CP	23+1
	RET	NC
	PUSH	AF
	CALL	GETCUR
	POP	AF
	LD	H,A
	JP	SETCRA		;Set new cursor posn
;
CTLP:	CALL	GETCUR		;Next char will be COL posn
	LD	A,32
	ADD	A,H		;Keep ROW posn
	JR	ESCY2		;Reset on next char
	ENDIF
;
ESCY:	LD	HL,ESCY2
	JR	SVEC
ESCY2:	LD	(CURROW),A	;Save this one
	LD	HL,ESCY3
	JR	SVEC
ESCY3:	LD	HL,CHAR1
	CALL	SVEC
	SUB	32		;Rmv ascii offset
	RET	C		;Quit if illegal
	CP	79+1
	RET	NC
	LD	L,A
	LD	A,(CURROW)
	SUB	32
	RET	C
	CP	23+1
	RET	NC
	LD	H,A
	JP	SETCRA		;Set new value
;
	IF	ADDS
ESCG:	LD	HL,ESCGN
	JR	SVEC
ESCGN:	LD	HL,CHAR1
	CALL	SVEC
	LD	HL,TABLE3
	JR	LOOKUP
;
ESCG0:	LD	A,ATT$		;End attributes
	JP	SETATT		;Set normal video
ESCG1:	LD	A,ATT$!INV$	;Invisible field
	JP	SETATT
ESCG2:	LD	A,ATT$!BLINK$	;Blinking
	JP	SETATT
ESCG3:	LD	A,ATT$!INV$!BLINK$	;Inv blink
	JP	SETATT
ESCG4:	LD	A,ATT$!REV$	;Turn on reverse video...
	JP	SETATT
ESCG5:	LD	A,ATT$!REV$!INV$	;Invisible reverse
	JP	SETATT
ESCG6:	LD	A,ATT$!REV$!BLINK$
	JP	SETATT
ESCG7:	LD	A,ATT$!REV$!BLINK$!INV$
	JP	SETATT
;Hi/lo intensity becomes attribute byte same as previous
SETLO:	CALL	GETOFF		;Find posn
	LD	HL,(ALTPOS)	;Put in HL
	CALL	GETATR		;Get attribute for posn
	OR	ATT$		;Make attribute even if none
	JP	SETATT		;Store it for posn
;
TABLE3:	DB	ENTRY3
	DB	'0'		;Normal video
	DW	ESCG0		;Normal video
	DB	'1'		;Invisible field
	DW	ESCG1
	DB	'2'		;Blink
	DW	ESCG2
	DB	'3'		;Inv blink
	DW	ESCG3
	DB	'4'		;Reverse video
	DW	ESCG4		;Reverse video
	DB	'5'		;Inv rev
	DW	ESCG5
	DB	'6'		;Reverse blink
	DW	ESCG6
	DB	'7'		;Rev inv blink
	DW	ESCG7
	DB	'8'		;Underline
	DW	ESCG0		;Cant do..
	DB	'9'		;Inv underline
	DW	ESCG1
	DB	':'		;Blink underline
	DW	ESCG2
	DB	';'		;Inv blink underline
	DW	ESCG3
	DB	'<'		;Rev underline
	DW	ESCG4
	DB	'='		;Inv rev underline
	DW	ESCG5
	DB	'>'		;Rev blink underline
	DW	ESCG6
	DB	'?'		;Inv rev blink underline
	DW	ESCG7
ENTRY3	EQU	$-TABLE3/3
	DW	DUMPCH		;Default action
;
TABLE2:	DB	ENTRY2		;Length of table
	DB	'1'		;Set tab stop
	DW	ESC1		;Set tab stop
	DB	'2'		;Clear tab stop
	DW	ESC2A		;Clear tab stop
	DB	'5'		;Disable keyboard
	DW	ESC5
	DB	'6'		;Enable keyboard
	DW	ESC6
	DB	'H'		;Auto-scroll toggle
	DW	ESCH
	DB	'I'		;Back a tab stop
	DW	ESCI		;Back a tab stop
	DB	'K'		;Erase to end of line
	DW	ESCK		;Erase to end of line
	DB	'k'		;Erase to end of page
	DW	ESCSMK		;Erase to end of page
	DB	'*'		;Clear screen
	DW	DOFF		;Clear screen/home cursor
	DB	'G'		;More following
	DW	ESCG		;Get next char
	DB	'.'		;Toggle cursor on/off
	DW	ESCPER		;Toggle cursor on/off
	DB	'Y'		;More following
	DW	ESCY		;Get next
	DB	'?'		;Send cursor posn
	DW	ESC?		;Send row/col
	DB	')'		;Half intensity
	DW	SETLO		;Fake it
	DB	'('		;Full intensity
	DW	SETLO		;Print a space
ENTRY2	EQU	$-TABLE2/3
	DW	DUMPCH		;Vector for no match
;
;List of FIRST (or only) chars for special functions
TABLE1:	DB	ENTRY1		;Number of entries in table
;Single or first char of control codes acted upon:
;Followed by address 
	DB	HOME		;  01H top or bottom left
	DW	DOHOME
	DB	CURRT		;  06H   cursor right
	DW	GORT1		;Cursor right
	DB	BELL		;  07H
	DW	DOBELL		;Noise?
	DB	BKSP		;  08H   non-destructive
	DW	DOBKSP		;Non-destructive
	DB	TAB		;  09H     ;left to next stop
	DW	DOTAB		;Move to next tab setting
	DB	CURSDN		;  0AH     ;down one line
	DW	GODWN1		;Cursor down one
	DB	FFEED		;  0CH     ;home & clear
	DW	DOFF		;Home,clear
	DB	CR		;  0DH     ;return to left of line
	DW	DOCR		;Do CR
	DB	10H		;Ctl-P
	DW	CTLP		;Cursor col follows
	DB	0BH		;Dtl-K
	DW	CTLK		;Cursor row follows
;* these have already been checked at this point
;       DB    PRON    ;  12H     ;enable printer
;       DW      DOPRON
;       DB    PROFF   ;  14H     ;disable printer
;       DW      DOPROF
;*
	DB	CURSLF		;  15H     ;ctl U also BKSP
	DW	DOBKSP		;Cursor left one
	DB	CURSUP		;  1AH     ;up one line
	DW	GOUP1		;Move cursor up
	DB	ESC		;  1BH     ;possible start of sequence
	DW	ESCAPE		;Starting ESC sequence
	DB	NWLINE		;  1FH     ;start of next line
	DW	DOCRLF		;Do CR/LF
;
;TRS video codes to trap also...
	DB	SO
	DW	DUMPCH		;Discard character
	DB	SI
	DW	DUMPCH		;Discard character
	DB	DLE
	DW	DUMPCH		;Discard character
	DB	DC1
	DW	DUMPCH		;Discard character
	DB	SYN
	DW	DUMPCH		;Discard character
	DB	ETB
	DW	DUMPCH		;Discard character
	DB	CAN
	DW	DUMPCH		;Discard character
	DB	EM
	DW	DUMPCH		;Discard character
	DB	FS
	DW	DUMPCH		;Discard character
ENTRY1	EQU	$-TABLE1/3	;Number of entries
	DW	OUTA		;Jp if no match
;
;
ESC5:	XOR	A		;Disable
	JR	SKB
ESC6:	LD	A,0FFH		;Enable
SKB:	LD	(KISW+1),A
;
DUMPCH:	RET			;No action
;
ESCPER:	LD	HL,CURFLG	;P/u current setting
	CALL	TOGGLE		;Reverse it
	LD	A,VCURON	;XOR setting Z means..
	JR	NZ,SENCH	;Cursor was ON
	LD	A,VCUROF	;So turn it OFF instead
SENCH:	JP	VIDOUT
;
;Clear to end of line
ESCK:	LD	A,(ATFLG)	;Using alt screen?
	OR	A
	LD	A,VCEOL
	JP	Z,VIDOUT	;No, use ctl char
	CALL	GETOFF		;Find current posn
	LD	HL,(CURSAV)	;Col posn
	LD	A,80		;How far to end of line?
	SUB	L
	LD	B,A		;Count to B
	LD	HL,(ALTPOS)	;Where on alt screen
	LD	A,20H
SPCL1:	LD	(HL),A		;Blank out
	INC	HL
	DJNZ	SPCL1		;On alt screen
UPSC:	XOR	A		;May have hit attribute
	LD	(ATBYTE),A
	JP	UPSCRN		;Update fm alt screen
;
;Clear to end of frame
ESCSMK:	LD	A,(ATFLG)	;If no attributes
	OR	A
	LD	A,VCEOF		;Use ctl char
	JP	Z,VIDOUT
	CALL	GETOFF		;Get current posn
	LD	HL,(CURSAV)
	PUSH	HL
	LD	A,80
	SUB	L		;How many bytes?
	LD	B,A
	LD	HL,(ALTPOS)	;Alt screen posn
	LD	A,20H
SPCL2:	LD	(HL),A
	INC	HL
	DJNZ	SPCL2		;Blank 1st line
	POP	DE		;Get row posn
	INC	D		;Count line done
ROWLP:	LD	A,D
	CP	24
	JP	Z,UPSC		;Last line
	LD	B,80		;Chars/line
	LD	A,20H
SPCLP3:	LD	(HL),A
	INC	HL
	DJNZ	SPCLP3
	INC	D
	JP	ROWLP		;Do all lines to bottom
;
ESC?:	CALL	GETCUR
	PUSH	HL
	LD	A,H
	CALL	SENPN
	POP	HL
	LD	A,L
SENPN:	ADD	A,32		;Add ascii offset
	JP	SENDA		;Send it
;
ESCH:	LD	HL,SCRFLG	;=>flag byte
TOGGLE:	LD	A,(HL)		;Reverse
	XOR	0FFH
	LD	(HL),A
	RET
;
DOFF:	LD	A,FFEED
	CALL	OUTB		;Send form feed to other devices
	ENDIF
CLS2:
	IF	ADDS
	CALL	CLSALT		;Clear any attributes
	ENDIF
	LD	HL,0
	CALL	SETCUR		;Home cursor
	LD	A,VCEOF		;Clear it
	JP	VIDOUT
;
	IF	ADDS
GORT1:	XOR	A
	LD	(ATBYTE),A	;Moving cursor
	CALL	GETCUR		;Check if last char
	LD	D,23
	LD	E,79
	OR	A
	SBC	HL,DE
	JP	NZ,USDSP	;Advance cursor if not last
	LD	A,(SCRFLG)	;Is auto-scroll OFF
	OR	A
	JP	NZ,SETCUR	;Then posn to 0,0
	CALL	SCROLR		;Else scroll screen(s)
	LD	H,23
	LD	L,0
	CALL	SETCUR		;Position cursor
	LD	A,(NEEDUP)	;Is alt screen in use?
	OR	A
	JP	NZ,UPSCR1	;Then update
	RET			;Else finished..
USDSP:	LD	A,VRT1		;Otherwise use @DSP
	JP	VIDOUT
;Go to top left (0,0) if scroll is OFF
;Go to bottom left (23,0) if scroll ON
DOHOME:	LD	A,(SCRFLG)	;Is auto-scroll OFF
	OR	A		;NZ=off
	LD	L,0		;Left col
	LD	H,L		;Top if not scrolling
	JP	NZ,SETCRA
	LD	H,23		;Else top
	JP	SETCRA
;
DOCRLF:	CALL	DOCR
	LD	A,LF
	JP	GODWN1
;
DOCR:	LD	A,CR
	CALL	OUTB		;To everything else
	XOR	A
	LD	(ATBYTE),A	;Moving cursor
	LD	A,VBOL		;Go to beginning of line
	JP	VIDOUT		;To video
;
GODWN1:	CALL	OUTB		;Send to pr/files (if acc lf ON)
	CALL	GETCUR		;Find cursor posn
	LD	A,H
	INC	H		; down one unless..
	CP	23		; on last line?
	JP	NZ,SETCRA	;Move cursor if not
	LD	A,(SCRFLG)	;Scrolling turned off?
	OR	A
	LD	H,0
	JP	NZ,SETCRA	;Wrap screen if off
	CALL	SCROLR		;Adjust alt screen if needed
	LD	A,(NEEDUP)	;Did screen move?
	OR	A
	RET	Z		;No, done..
	JP	UPSCR1		; else correct screen
;
GOUP1:	CALL	GETCUR		;Top wraps to bottom
	XOR	A
	LD	(ATBYTE),A
	LD	A,H
	OR	A
	LD	H,23
	JP	Z,SETCUR
	LD	A,VUP1		;Otherwise use @DSP
	JP	VIDOUT
;
DOBKSP:	LD	A,BKSP		;Bksp
	CALL	OUTB		;Send BKSP to file/pr/echo
	CALL	GETCUR		;Beginning wraps to end
	XOR	A
	LD	(ATBYTE),A
	LD	A,H
	OR	L
	LD	H,23
	LD	L,79
	JP	Z,SETCUR
	LD	A,VLF1		;Non-destructive to video
	JP	VIDOUT		;
;
	ENDIF
;*=*=*
;Tab handling routines - may change to bit mapping later
; if it would save overall space
;*=*=*
;
DOTAB:	CALL	TABA		;Output to other devices
; HL=tab ptr posn / DE = current cursor posn
FTLP:	LD	A,E
	CP	79		;Reached end?
	RET	Z		;No further action
	INC	HL		;Look at next possible tab
	INC	E		;Moving possible cursor setting
	LD	A,(HL)
	OR	A
	JR	Z,FTLP		;Keep going if not set
NEWPSN:	EX	DE,HL
	JP	SETCRA		;Set new posn if stop found
;
TABA:	CALL	OUTB		;Send TAB to other devices
TABB:	CALL	GETCUR		;Find cursor posn
	PUSH	HL		;Save
	LD	D,0
	LD	E,L
	LD	HL,TABS		;Pt to tab stops
	ADD	HL,DE		;Mv to current posn
	POP	DE		; restore posn
	RET
;
;Back-tab goes to 0 if no setting before
ESCI:	CALL	TABB		;HL=>this col posn /DE=cursor posn
BTLP:	DEC	HL
	DEC	E
	JR	Z,NEWPSN
	LD	A,(HL)
	OR	A
	JR	Z,BTLP
	JR	NEWPSN
;
ESC1:	CALL	TABB
	LD	(HL),0FFH	;Set a tab stop here
	RET
ESC2A:	CALL	TABB
	LD	(HL),0		;Clear tab stop
	RET
;
;Array of tab settings (80 possible)
	IF	ADDS		;1st posn is col 9
TABS:	DB	00,00,00,00,00,00,00,00H
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	DB	0FFH,00,00,00,00,00,00,00
	ELSE			;Start at col 8
TABS:	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	DB	00,00,00,00,00,00,00,0FFH
	ENDIF
;
	IF	ADDS
PUTSCR:	LD	HL,TRSCR	;Put contents of buffer
	LD	B,5		;Onto video
	CALL	VDCTL1
CCUR:	LD	A,(CURFLG)	;Check if cursor should
	OR	A		;Be on
	RET	Z
	LD	A,VCURON	;Restore if needed
	JP	VIDOUT
;
GETSCR:	LD	A,VCUROF
	CALL	VIDOUT		;Be sure cursor is off first
	LD	HL,TRSCR	;Buffer to receive
	LD	B,6		;Video contents
	JR	VDCTL
SETCRA:	XOR	A
	LD	(ATBYTE),A	;May be invalid now
	ENDIF
	IF	.NOT.ADDS
SETCRA:
	ENDIF
SETCUR:	LD	B,3		;Set cursor posn
VDCTL1:	LD	A,(DEVOUT+1)	;Is *DO on?
	OR	A
	RET	Z		;Don't set if OFF
	JR	VDCTL
GETCUR:	LD	B,4		;Get cursor posn
VDCTL:	LD	A,15
	RST	28H
	RET
MAKCUR:	LD	B,8		;Set cursor char
	JR	VDCTL
PUTAHL:	LD	B,2		; put C at HL
	JR	VDCTL1
SCRPRT:	LD	B,7		;Scroll protect
	JR	VDCTL
;
SETCU2:	LD	B,3
	JR	VDCTL		;Do even if *DO is off
;
INTVD1:
	IF	ADDS
	CALL	CLSALT		;1st time only
	ENDIF
INTVID:	LD	A,(IFLG)	;Init video mode?
	OR	A
	RET	Z
	LD	C,'_'		;My cursor character
	CALL	MAKCUR		;Set it
	LD	HL,OLDCUR	;Save old
	INC	(HL)		;If not already set
	DEC	(HL)
	JR	NZ,ISDUN
	LD	(HL),A
ISDUN:	LD	A,(CURFLG)	;Turn cursor on
	OR	A		; if needed
	LD	C,VCURON
	JR	NZ,INITC
	LD	C,VCUROF	; or off..
INITC:	@@DSP
	LD	C,VRVID		;Enable reverse "mode"
	@@DSP
	LD	C,VURVID	;But don't display reversed
	@@DSP
	XOR	A
	LD	(RESVID),A
	RET
;
RESVID:	RET			; <= stuff NOP to allow
	CALL	GETCUR
	PUSH	HL
	LD	C,VHOME		;Clear "modes"
	@@DSP
	POP	HL
	CALL	SETCU2		;Without changing cursor posn
	LD	HL,OLDCUR
	LD	C,(HL)
	CALL	MAKCUR		;Restore old cursor char
	LD	C,VCURON
	@@DSP			;And turn cursor on
	LD	A,0C9H
	LD	(RESVID),A
	RET
;
