;VCOMM2/PCL - 09/21/83
;****
;       routine to set up the task processor
;*****
SETUPT:	DI
	IF	.NOT.BUFFRD
	LD	DE,TCB8		;CL task process
	LD	C,8
	@@ADTSK
	LD	DE,TCB9		;Printer output task
	LD	C,9		;Only if RS232 does
	@@ADTSK			;Not interrupt
	ENDIF
;
	IF	BUFFRD
	LD	DE,CLDCB	;Turn on wakeup feature
	LD	IY,TASK8A
	LD	C,4
	@@CTL
	LD	(OLDVEC),IY	;Keep for restore
	ENDIF
	EI
	RET
;
DOSCMD
	IF	ADDS
	CALL	GETSCR		;Save current terminal screen
	CALL	GETCUR		;And cursor posn
	LD	(CURSAV),HL
	LD	C,VCURON
	@@DSP			;Put cursor back on
	ENDIF
	LD	HL,BASE-1
	LD	B,1		;Set LOW$
	@@HIGH$
	LD	HL,CMDPMT	;Issue prompt
	@@DSPLY
	LD	BC,80<8		;Max characters
	LD	HL,DUMMY	;=>input buffer
	@@KEYIN
	JR	C,EPMT		;BREAK pressed
	INC	B
	DEC	B
	JR	Z,EPMT		;CR only..
	PUSH	HL		;Save cmd
	CALL	RESVID
	CALL	RESTSK		;Turn off interrupt tasks
	LD	HL,$-$		;Cflag$
CFLAG	EQU	$-2		;Stuff address
	BIT	0,(HL)
	SET	0,(HL)		;Freeze memory
	EX	(SP),HL		;Save CFLAG add/get cmd
	PUSH	AF		;Save previous setting
	@@CMNDR			;Do it
	CALL	INTVID		;Reset term video
	CALL	SETUPT		;Relink interrupts
	POP	AF
	POP	HL		;=>cflag$
	JR	NZ,EPMT		;Was set before
	RES	0,(HL)		;Unfreeze
EPMT:	LD	HL,CMPLTD	;Show cmd finished
	@@DSPLY			;Prompt
	IF	ADDS
	@@KEY			;Wait for keypress
	CP	CR
	JP	NZ,CLSALT	;Continue w/o screen restore
	LD	HL,(CURSAV)	;Restore previous cursor
	CALL	SETCUR
	JP	PUTSCR		;And screen contents
	ELSE
	RET
	ENDIF
CMDPMT	DB	LF,LF,'Enter command:',CR
	IF	ADDS
CMPLTD	DB	LF,'Press <ENTER> to restore terminal screen'
	DB	' - any other key to continue.',VCURON,CR
	ELSE
CMPLTD	DB	LF,'Command completed',CR
	ENDIF
;*****
;       Messages
;*****
BRAKET	DB	'{  }',3	;Brackets around hex byte
FILEPMT	DB	29,10,'File name: ',3
OPENMSG	DB	29,10,'File already open',CR
MNUMSG	DB	LF
STAT1	DB	'                                    '
	DB	'                                   ',LF
	DB	'DUPLX ECHO  ECOLF ACCLF REWND PEOF  '
	DB	' DCC   CLS   8-B   CMD  HNDSH  EXIT',LF
;
	IF	@MOD4
	DB	'==1== ==2== ==3== ==4== ==5== ==6== '
	DB	'==7== ==8== ==9== ==0== ==:== ==-==',LF
	ENDIF
	IF	@MOD2
	DB	'==1== ==2== ==3== ==4== ==5== ==6== '
	DB	'==7== ==8== ==9== ==0== ==-== =====',LF
	ENDIF
;
	DB	' *KI   *DO   *PR   *CL   *FS   *FR  '
	DB	' DTD   ???   ID    RES   ON    OFF',LF
STAT2	DB	'                                     '
	DB	'  ',CR
STATAB	DW	KISW+1,STAT2+2,DEVOUT+1,STAT2+8
	DW	PUTPR+1,STAT2+14,TASK8B+1,STAT2+19
	DW	CLRFLG,STAT2+21,FSSW+1,STAT2+26
	DW	FRSW+1,STAT2+32,FRIOSW+1,STAT2+38
	DW	DPLXSW+1,STAT1+2,ECHOSW+1,STAT1+8
	DW	ECOLF,STAT1+14,ACCLFSW+1,STAT1+20
	DW	DSPCTRL+1,STAT1+38,EIGHT+1,STAT1+50
	DW	SHAKE+1,STAT1+61
FSNAME$	DB	'FS-Spec: ',3
FRNAME$	DB	'  FR-Spec: ',3
PAGSPR$	DB	'  Memory:   K',CR
CMDERR$	DB	'Unacceptable command sequence!',CR
LILPG$	DB	'Warning! Less than 2K of buffer left!'
	DB	' X-OFF transmitted',CR
;*=*=*
;       File control blocks
;*=*=*
CLDCB	DB	'*CL',3
	DS	28
FS_FCB	DS	32
FR_FCB	DS	32
DUMMY	DS	81		;Used for dos cmd buffer also
;*=*=*
;       Put/Get index pointers
;  put (2),get(2),pages(1)
;*=*=*
KIVCTR	DW	0,0		;KI input
	DB	0
PRVCTR	DW	0,0		;PR output
	DB	0
CLREC	DW	0,0		;CL input
CLPG	DB	0
CLSEND	DW	0,0		;CL output
	DB	0
FSVCTR	DW	0,0		;File input (send)
	DB	0
FRVCTR	DW	0,0		;File output
	DB	0
FREEPG	DB	0		;Remaining pages
;
SYNC	NOP			;<=stuff RET to disable
	LD	A,$-$
XFLG	EQU	$-1
	OR	A		;Has XOFF been sent?
	JR	NZ,NDXOF	
	LD	A,(CLPG)	; no, do we need one?
	CP	2
	RET	C		;Not yet..
	LD	A,(XOFFP1)	;Get character
	CALL	PUTNOW		;And send
	RET	NZ		;Unless previous not sent
	LD	A,0FFH
	LD	(XFLG),A	;Flag xoff sent
	RET
NDXOF	LD	A,(CLPG)	;Should XON be sent?
	CP	2
	RET	NC		;Not if >1 page
	LD	A,(CLREC+2)	;Low byte of GETptr
	LD	B,A
	LD	A,(CLREC)	;PUT ptr
	SUB	B		; PUT-GET = chars
	CP	10
	RET	NC		;Down to 10 chars?
	LD	A,(XONP1)
	CALL	PUTNOW
	RET	NZ
	XOR	A
	LD	(XFLG),A
	RET
PUTNOW	LD	HL,FRCPUT+1	
	LD	B,(HL)
	INC	B
	DEC	B
	RET	NZ
	LD	(HL),A
	RET
;
;*=*=*
;       patches to buffer I/O in pgm loop
; Keep interrupts off while updating table
;*=*=*
OUTPGM	DI
	CALL	OUTPUT
	EI
	RET
PGMGET	DI
	CALL	BUFGET
	EI
	RET
;
;*****
;       common routine to stuff dynamic buffer
;*****
OUTPUT	LD	L,(IX)		;P/u pointer to
	LD	H,(IX+1)	;Buffer PUT
	LD	(HL),A		;Write char into buffer
	INC	(IX)		;Bump buffer pointer
	RET	NZ		;Go if still in same page
	CALL	NEXTAP		;Find next avail page
	JR	Z,DUMPCHR	;Go if no pages available
	LD	(IX+1),A	;Set index to new page
	LD	HL,FREEPG	;Reduce the amount of
	DEC	(HL)		; free pages
	INC	(IX+4)		;Show allocated to device
	LD	A,7		;Less than 2K available?
	CP	(HL)
	RET	C		;  & return with NZ
	LD	(WRNFLG),A	;Set flag for warning
	OR	A		;Ensure NZ return
	RET
;*=*=*
;       No more pages available - keep last page
;*=*=*
DUMPCHR	DEC	(IX)		;Dump character and
	XOR	A		;Bypass this - won'T ***
	RET			; work at 1200 baud  ***
	DB	0
	PUSH	IX		;  requesting the output
	POP	HL
	XOR	A		;The difference will be
	SBC	HL,DE		;  the offset into the
	LD	DE,DEVICE$	;  name table
	ADD	HL,DE
	LD	BC,4
	LD	DE,OVRRUN$+3
	LDIR
	LD	HL,OVRRUN$	;Display the buffer
	@@DSPLY			;  overrun error
	XOR	A		;  reuse current page
	RET
;*****
;       Check for character available in dynamic buffer
;*****
BUFGET	LD	L,(IX+2)	;P/u pointer to next
	LD	H,(IX+3)	;  buffer GET
	LD	A,L		;Check on in=out lo-order
	CP	(IX)
	JR	NZ,INNEOUT	;Go if in not equal out
	LD	A,H		;Check on in=out hi-order
	CP	(IX+1)
	RET	Z		;Ret if none to i/o
;*=*=*
;       Buffer is not empty - Get next character
;*=*=*
INNEOUT	LD	A,(HL)		;Get a char from buffer
	INC	(IX+2)		;Advance lo-order pointer
	RET	NZ		;Ret if still same page
	PUSH	AF		;Save the character
	CALL	FNPIU		;Find next page in use
	LD	(IX+3),A	;Stuff new page index
	POP	AF		;Recover the character
	DEC	H		;Set NZ return for rcvd
	RET
;*****
;       Routine to find next available page buffer
;*****
NEXTAP	LD	L,H		;Point to page buffer
	LD	H,LINKS<-8	;  index
	LD	A,(LINKS)	;Get next empty link
	PUSH	HL		;Save this index pointer
	LD	L,A		;Point to new link
	LD	A,(HL)		;Get what it links to
	OR	A		;Test if none left
	JR	NZ,GOTNAP	;Go if still more
	POP	HL		;Restore reg & return
	RET			;  with Z-flag for error
;*=*=*
;       Found the next available page - set the links
;*=*=*
GOTNAP	LD	(LINKS),A	;Update new next avail
	LD	A,L		;Xfer index of new page
	POP	HL		;Rcvr pointer to index
	LD	(HL),A		;  of old & link to new
	LD	L,A		;Repoint to new page's
	LD	(HL),0		;  index & show it is
	RET			;  the last one
;*****
;       Find next page in use
;*****
FNPIU	LD	A,(FREEPG)	;Show one additional
	INC	A		;  page is free
	LD	(FREEPG),A	;Maintain total free space
	DEC	(IX+4)		;Update pg count for device
	LD	A,(HIPAGE)	;P/u last page avail
	LD	L,A		;Set HL to its index 
	LD	A,H		;Save emptied pg address
	LD	H,LINKS<-8	;Show that page links to
	LD	(HL),A		; the one we just emptied
	LD	(HIPAGE),A	;Now update the new end
	LD	L,A		;Set HL to the emptied
	LD	A,(HL)		;Page, p/u what it
	LD	(HL),0		;  linked to, & show old
	RET			;  is end_ Ret A=link
;
;*=*=*
;       Page buffer Link table
; Table is maintained as a linked list
; (LINKS) is a pointer to the next available page (table pos)
; (HIPAGE) points to end of free page list (table pos)
; the low byte of the table position corresponds to the
; high byte of a memory page - the contents of the table
; position is a pointer to the next table entry in the same
; list (0 marks end)
;*=*=*
	ORG	$<-8+1<+8
LINKS	DS	1		;Link to next available
HIPAGE	DS	1		;Link to last available
	DS	1		;Init to 1st avail
	DS	1		;Init to last avail
	DS	252		;Space for linkage tables
;*=*=*
;       Transmit and Receive File buffers
;*=*=*
XMTBUF	DS	256
RCVBUF	DS	256
;
