;TAPE100B - Disk I/O & other routines - 10/24/83
;
;
;********************************************************
;***						      ***
;*** DISPSTR - Display String			      ***
;***						      ***
;********************************************************
;
DISPSTR	PUSH	DE		;Save DE
	LD	DE,(CURPOS)	;p/u cursor position
DSLP	LD	A,(HL)		;p/u source char
	CP	ETX		;done ?
	JR	Z,EXIT1		;yes - exit
	CP	CR		;done ?
	JR	Z,EXIT2		;yes - exit
	CP	LF		;line feed ?
	JR	NZ,STUFCHR	;no - stuff character
	CALL	NEXTLIN		;get next line
	JR	BUMPIT		;
STUFCHR	LD	(DE),A		;output to video
	INC	DE		;
BUMPIT	INC	HL		;no - bump count
	JR	DSLP		;
EXIT2	CALL	NEXTLIN		;next one down
EXIT1	LD	(CURPOS),DE	;Save cursor position
	POP	DE		;restore DE
	RET			;and RETurn
;
;
;********************************************************
;***						      ***
;*** NEXTLIN - Position to next line on video	      ***
;***						      ***
;*** DE => RAM location				      ***
;***						      ***
;********************************************************
;
NEXTLIN	PUSH	HL		;Save regs
	EX	DE,HL		;xfer # to HL
	CALL	GETCRS		;calculate X,Y
	INC	H		;bump row #
	LD	L,0		;and start @ beginning
	CALL	GETPOS2		;convert to RAM location
	EX	DE,HL		;stuff into DE
	POP	HL		;
	RET			;
;
;********************************************************
;***						      ***
;*** CONV_UC - Convert A to upper case		      ***
;***						      ***
;********************************************************
;
CONV_UC	CP	'a'		;lower case ?
	RET	C		;no
	CP	'z'+1		;lower case ?
	RET	NC		;no
	RES	5,A		;convert to Upper Case
	RET			;
;
;
;********************************************************
;***						      ***
;*** CURSOFF - Turn off Cursor			      ***
;***						      ***
;********************************************************
;
CURSOFF	PUSH	AF		;Save regs
	PUSH	DE		;
	PUSH	BC		;
	LD	C,CUROFF	;Cursor off Character
	@@DSP			;
	JP	NZ,IOERR	;
	POP	BC		;restore regs
	POP	DE		;
	POP	AF		;
	RET			;and RETurn
;
;
;********************************************************
;***						      ***
;*** INIT - Init a file				      ***
;***						      ***
;********************************************************
;
INIT	LD	A,@INIT		;SVC #
	JR	DOSVC		;INIT file
;
;
;********************************************************
;***						      ***
;*** OPEN - Open Source File			      ***
;***						      ***
;********************************************************
;
OPEN	SET	0,(IY+SFLAG$)	;Inhibit file-open bit
	LD	A,@OPEN		;OPEN SVC #
;
DOSVC	PUSH	AF
	PUSH	DE		;
	LD	HL,DFBUF	;HL => Disk filename buf
TLP	LD	A,(DE)		;p/u byte from FCB
	LD	(HL),A		;xfer to TEMBUF
	INC	HL
	INC	DE
	CP	CR+1		;Done ?
	JR	C,DUN
	CP	':'
	JR	Z,DUN
	CP	'.'
	JR	NZ,TLP
;
;*=*=* Found valid terminator - Is this a device ? *=*=*
;
DUN	DEC	HL		;back up to term
	POP	DE		;DE => FCB+0
	LD	A,(DE)		;Device ?
	CP	'*'
	JR	Z,DUN2		;yes - done
	LD	(HL),':'	;no - overwrite with ":"
	INC	HL		;bump
	LD	(DSPEC+1),HL	;save drivespec location
	INC	HL		;bump
DUN2	LD	(HL),ETX	;end with X'03'
	POP	AF		;A = SVC #
	LD	(SVCNUM+1),A	;Save SVC #
	LD	HL,IOBUFF	;HL => I/O Buffer
	LD	B,0		;LRL = 256
	RST	28H		;OPEN or INIT file
CHECK	JR	Z,CHKPROT	;check PROTection status
;
;*=*=* Ignore Error #42 - "LRL Open Fault" *=*=*
;
	CP	42		;Ignore this error
	RET	NZ		;NZ - Abort
;
;*=*=* Stuff Drive # into Buffer *=*=*
;
CHKPROT	PUSH	DE		;p/u drivespec
	POP	IX		;from FCB+6
	LD	A,(IX+6)
	ADD	A,'0'		;convert to ASCII
DSPEC	LD	($-$),A		;
;
;*=*=* Check if File has proper Access *=*=*
;
	BIT	7,(IX)		;Is this a filespec ?
	JR	Z,ILLFILE	;no - Illegal Filename
	LD	A,(IX+1)	;p/u protection byte
	AND	7
	LD	B,A		;xfer to B
;
SVCNUM	LD	A,$-$		;p/u SVC #
	CP	@INIT		;@INIT ?
	LD	A,B		;p/u protection level
	JR	Z,INIT1		;Z - Must be < 5
	CP	6		;Read Access ?
	JR	C,OKYDOKY	;yes - set Z & RETurn
;
;*=*=* Illegal Access to protected file *=*=*
;
ILLACC	@@CLOSE			;Close File
	LD	A,25		;File Access Denied
	JP	IOERR		;Error - Regardless
;
INIT1	CP	5		;Update Access ?
	JR	NC,ILLACC	;no - Illegal Access
OKYDOKY	XOR	A		;RETurn Z
	RET			;
;
ILLFILE	LD	A,19		;Illegal Filename
	OR	A		;set NZ
	RET			;
;
;
;********************************************************
;***						      ***
;*** CLOSE - Close the Destination File		      ***
;***						      ***
;********************************************************
;
CLOSE	LD	DE,FCB2		;DE => FCB
	@@CLOSE			;Close File
	RET	Z		;good - RETurn
	JP	IOERR		;bad - Retry ?
;
;
;********************************************************
;***						      ***
;*** WRITESC - Write a Sector to Destination file     ***
;***						      ***
;********************************************************
;
WRITESC	LD	DE,FCB2		;DE => FCB
	@@WRITE			;Write Sector
	JP	NZ,IOERR	;bad - retry ?
	RET			;good - RETurn
;
;
;********************************************************
;***						      ***
;*** WRTDEST - Write Destination File		      ***
;***						      ***
;********************************************************
;
WRTDEST	LD	DE,FCB2		;DE => Destination FCB
WRTDES	LD	HL,FCB2+4	;HL => msb of I/O buffer
	INC	(HL)		;bump
	CALL	WRITESC		;Write Sector
EOTF2	LD	A,$-$		;p/u # of sectors
	CP	(HL)		;Finished ?
	JR	NZ,WRTDES	;no - back to loop
;
;*=*=* Finished Writing - Set EOF offset byte *=*=*
;
OFFSET	LD	A,$-$		;p/u offset byte
	LD	(FCB2+8),A	;& stuff into FCB
	CALL	CLOSE		;Close the File
	RET			;and RETurn
;
;
;********************************************************
;***						      ***
;*** READSRC - Read in chunk of Source Disk file      ***
;***						      ***
;********************************************************
;
READSRC	LD	HL,FCB1+4	;HL => Hi byte of I/O buf
	LD	(HL),MEM<-8-1	;init FCB I/O buffer
;
;*=*=* Read in Source file *=*=*
;
READSR2	LD	DE,FCB1		;pt DE to FCB
	INC	(HL)		;bump I/O buffer
	@@READ			;read a sector
	JR	Z,READSR2	;
;
;*=*=* Fill remainder of sector w/ X'1A's *=*=*
;
	PUSH	AF		;Save Error code
NOMORE	LD	A,(FCB1+8)	;p/u EOF offset byte
	NEG			;
	LD	B,A		;xfer to B for DJNZ
	LD	H,(HL)		;p/u I/O buffer msb
	LD	L,0FFH		;end of sector
	JR	Z,NULBUF	;Z - keep HL here
	DEC	H		;Sector boundary
NULBUF	LD	(HL),1AH	;fill remainder of buffer
	DEC	HL		;with zeroes
	DJNZ	NULBUF		;
;
;*=*=* Add an extra set of 256 X'1A's just in case *=*=*
;
	INC	H		;pt to next sector
	LD	L,0		;
XTR1AS	LD	(HL),01AH	;Just in case
	INC	HL		;bump
	DJNZ	XTR1AS		;	
DONTFIL	POP	AF		;recover error code
;
;*=*=* I/O Error - Better be EOF error *=*=*
;
	CP	1CH		;EOF ?
	RET	Z		;yes - RETurn
	CP	1DH		;
	RET	Z		;yes - RETurn
	JP	IOERR		;no - Disk Error
;
;
;********************************************************
;***						      ***
;*** ENDOKI - Enable Video & Keyboard		      ***
;***						      ***
;********************************************************
;
ENDOKI	PUSH	AF
	PUSH	HL
	LD	A,(OPREG$)	;P/u port mask
	LD	(SVOPREG+1),A	;and save it for DISDOKI
	RES	0,A		;Reset bit 0
	SET	1,A		;Set bit 1
	JR	DOOPREG		;Set new assignment
;
;
;********************************************************
;***						      ***
;*** DISDOKI - Disable Video & Keyboard		      ***
;***						      ***
;********************************************************
;
DISDOKI	PUSH	AF
	PUSH	HL
;
SVOPREG	LD	A,$-$		;Restore original mask
DOOPREG	LD	(OPREG$),A	;
	OUT	(@OPREG),A	;and disable video
;
	POP	HL		;Restore regs & RETurn
	POP	AF
	RET
;
;
;********************************************************
;***						      ***
;*** SWAP38 - Swap 38H - 3AH with save area	      ***
;***						      ***
;********************************************************
;
SWAP38	LD	B,3		;3 bytes to exchange
	LD	HL,SWAREA	;HL => Swap Area
	LD	DE,38H		;DE => Restart Xfer addr
SWAPLP	LD	C,(HL)		;p/u source
	LD	A,(DE)		;
	EX	DE,HL		;swap ptrs
	LD	(HL),C		;stuff in dest
	LD	(DE),A		;
	INC	HL		;bump ptrs
	INC	DE		;
	DJNZ	SWAPLP		;3 bytes to swap
	RET			;return
;
SWAREA	JP	RST38V		;JP vector
;
;
;********************************************************
;***						      ***
;*** GETPOS - Get current cursor position in video    ***
;***						      ***
;********************************************************
;
GETPOS	LD	B,4		;p/u current cursor pos
	@@VDCTL			;
GETPOS2	LD	C,L		;save column #
	LD	L,H		;
	LD	H,0		;HL => Row #
	LD	D,H		;Set DE = HL
	LD	E,L		;
	ADD	HL,HL		;x 2
	ADD	HL,HL		;x 4
	ADD	HL,DE		;x 5
	ADD	HL,HL		;x 10
	ADD	HL,HL		;x 20
	ADD	HL,HL		;x 40
	ADD	HL,HL		;x 80
	LD	B,VIDEO<-8	;D = high byte of video
	ADD	HL,BC		;HL => Cursor location
	LD	(CURPOS),HL	;save cursor position
	RET			;done
;
;
;********************************************************
;***						      ***
;*** GETCRS - Calculate row x column cursor pos	      ***
;***						      ***
;*** HL => Cursor position in RAM		      ***
;*** HL <= Cursor position in Row (H) Column (L)      ***
;***						      ***
;********************************************************
;
GETCRS	LD	DE,VIDEO	;get offset
	OR	A		;
	SBC	HL,DE		;
	LD	C,80		;calculate row #
	@@DIV16			;
	LD	H,L		;Set H = Row
	LD	L,A		;Set L = Column
	RET			;
