;TAPE100A - Tape I/O routines - 04/26/83
;
;********************************************************
;***						      ***
;*** CASSON - Turn Cassette Motor On		      ***
;***						      ***
;********************************************************
;
CASSON	DI			;Disable interrupts
	CALL	SWAP38		;grap RST 38H vector
	IN	A,(PORTE0)	;clear any latches
	IN	A,(MODOUT)	;Clear any latches
	LD	A,2		;motor on, slow speed
	OUT	(MODOUT),A	;Turn on motor
	LD	A,3		;Disable other interrupts
	OUT	(PORTE0),A	;
	RET			;and RETurn
;
;
;********************************************************
;***						      ***
;*** CASSOFF - Turn off Cassette Motor		      ***
;***						      ***
;********************************************************
;
CASSOFF	LD	A,(IY+WRMASK)	;p/u original
	OUT	(PORTE0),A	;set up R/F interrupt
	IN	A,(PORTFF)	;Clear 1500 bd interrupts
	LD	A,(IY+MODMASK)	;turn off motor
	OUT	(MODOUT),A	;
	CALL	SWAP38		;restore RST 38H vector
	RET			;and RETurn
;
;
;********************************************************
;***						      ***
;*** PRTAPE - Prompt for "Tape Ready" & turn motor on ***
;***						      ***
;********************************************************
;
PRTAPE	LD	HL,TREADY	;Read cassette & <ENTER>
	CALL	DSPLY		;
NOTENT	LD	B,1		;just 1 char
	CALL	INPUT		; <BREAK> or <ENTER>
	JP	CURSOFF		;Turn off Cursor & RETurn
;
;
;********************************************************
;***						      ***
;*** RDDAT - Read in A tape file		      ***
;***						      ***
;********************************************************
;
RDDAT	LD	HL,MEM-100H	;HL => Start of file
RDDAT2	INC	H		;bump hi-byte
	CALL	RDDATA		;Read a block
	RET	Z		;eof ?
EOTF	LD	A,$-$		;at top of memory ?
	CP	H		;
	JR	NZ,RDDAT2	;no
	OR	A		;top of mem - 
	RET			;RETurn NZ
;
;
;********************************************************
;***						      ***
;*** RDDATA - Read in a block of Data		      ***
;***						      ***
;*** HL => Destination of Block			      ***
;***						      ***
;********************************************************
;
RDDATA	CALL	RDSYNC		;Read sync field
	CALL	RDBYTE		;Read a byte
	CP	8DH		;legal ?
	JP	NZ,ILLEGAL	;no - bad news
	LD	DE,0		;D=EOF flag, E = checksum
;
RDLP1	CALL	RDBYTE		;read a byte
	LD	(HL),A		;stuff into buffer
;
;*=*=* Check for End of File byte X'1A' *=*=*
;
	CP	1AH		;Eof ?
	JR	NZ,AFTER	;no
	CP	D		;been here before ?
	JR	Z,AFTER		;first time ?
	LD	D,A		;Set D = 1AH
	LD	B,L		;yes - set B = pos
;
;*=*=* Add byte to checksum *=*=*
;
AFTER	ADD	A,E		;add checksum
	LD	E,A		;xfer back to E
	INC	L		;bump
	JR	NZ,RDLP1	;
	NEG			;negate checksum
	LD	E,A		;stuff back in E
;
;*=*=* Verify Checksum byte *=*=*
;
	CALL	RDBYTE		;Read in byte
	CP	E		;checksums match ?
	CALL	NZ,CHKERR	;no - checksum error!
;
;*=*=* Stuff EOF offset byte into WRTDEST routine *=*=*
;
	LD	A,H		;p/u eom
	LD	(EOTF2+1),A	;stuff into WRTDEST
	LD	A,B		;p/u byte
	INC	A		;bump
	LD	(OFFSET+1),A	;
;
;*=*=* Read past 20 dummy zeroes *=*=*
;
	LD	B,20		;
RDLP2	CALL	RDBYTE		;
	DJNZ	RDLP2		;
;
;*=*=* Set Z flag if at EOF *=*=*
;
	LD	A,D		;Eof ?
	CP	1AH		;
	RET			;done
;
;
;********************************************************
;***						      ***
;*** RDBIT - Read a Bit from Cassette		      ***
;***						      ***
;********************************************************
;
RDBIT	LD	C,0		;init count = 0
	EI			;Back on
RBLP	INC	C		;bump count
	LD	A,(BREAKLC)	; <BREAK> hit ?
	AND	4		;
	JR	Z,RBLP		;no - wait for interrupt
;
;*=*=* <BREAK> key hit - Abort *=*=*
;
	DI			;Cancel next interrupt
	CALL	DISDOKI		;put *DO & *KI back
	CALL	CASSOFF		;turn off cassette
	LD	C,CR		;end line
	CALL	DSP		;
	JP	ABORT		;go to abort routine
;
;*=*=* Interrupt Handler - Comes from RST 38 *=*=*
;
RST38V	JP	$+3		;Wait
	PUSH	AF		;save status
	IN	A,(PORTE0)	;Read port
	RRA			;Bit 0 low ?
	JP	NC,BIT0LOW	;
	RRA			;Bit 1 low ?
	JP	NC,BIT1LOW	;
	POP	AF		;recover status
	EI			;back on
	RET			;RETurn
;
;*=*=* Set E = bit image - bit 0 or 1 *=*=*
;
BIT0LOW	LD	E,1		;High
	JR	BIT1LOW+2	;add interrupt offset
BIT1LOW	LD	E,0		;Low
	LD	A,ROUTOFF	;Add interrupt routine
	ADD	A,C		;offset to C
	LD	C,A		;
;
;*=*=* Is the Head on a valid pulse ? *=*=*
;
	IN	A,(PORTFF)	;Read cassette level
	AND	1		;mask off all but bit 0
	CP	E		;same as given level ?
	JR	NZ,WAITINT	;no - wait for next inter
;
;*=*=* Valid pulse - Get out of interrupt routine *=*=*
;
	POP	AF		;remove RST 38 RET addr
	POP	AF		;
	RET			;Return
;
;*=*=* Not the right interrupt - wait for next *=*=*
;
WAITINT	POP	AF		;Recover status
	EI			;And wait for next
	RET			;interrupt
;
;
;********************************************************
;***						      ***
;*** RDHEAD - Read a TAPE100 header		      ***
;***						      ***
;********************************************************
;
RDHEAD	LD	HL,(CURPOS)	;p/u cursor position
	LD	DE,BUFFER	;buffer
	CALL	RDSYNC		;Read in SYNC
;
;*=*=* Read in Header Type byte *=*=*
;
	CALL	RDBYTE		;read type byte
	CP	9CH		;Text type ?
	JR	NZ,RDHEAD	;no - try again
;
	LD	BC,600H		;B=6 bytes, Checksum = 0
;
RFNLP	CALL	RDBYTEC		;read byte
	LD	(HL),A		;save byte
	LD	(DE),A		;stuff in buffer
	INC	HL		;bump cursor pos
	INC	DE		;bump buffer ptr
	DJNZ	RFNLP		;
;
;*=*=* Next ten bytes are bogus *=*=*
;
	LD	B,10		;
BOGUSLP	CALL	RDBYTEC		;read byte & checksum
	DJNZ	BOGUSLP		;
;
;*=*=* Negate checksum *=*=*
;
	LD	A,C		;p/u checksum
	NEG			;negate it
	LD	C,A		;
	CALL	RDBYTE		;Read in Checksum byte
	CP	C		;match ?
	CALL	NZ,CHKERR	;no - checksum error !!
;
;*=*=* Read in twenty bogus zeroes *=*=*
;
	LD	B,20		;
DUMBYT	CALL	RDBYTE		;
	DJNZ	DUMBYT
;
;*=*=* Check if this is the correct filename *=*=*
;
CORRECT	NOP			;X'C9' if first filename
	LD	DE,BUFFER	;Is this the one ?
	LD	HL,FILENM	;
	LD	B,6		;6 chars in filename
;
;*=*=* Loop to compare (HL) to (DE) *=*=*
;
CKFILE	LD	A,(DE)		;p/u header byte
	CALL	CONV_UC		;convert to U/C
	CP	(HL)		;match ?
	INC	HL		;
	INC	DE		;
	JP	NZ,RDHEAD	;no - try again Jack
	DJNZ	CKFILE		;
	RET			;yes - RETurn
;
;*=*=* Checksum error - Either ignore it or "C" *=*=*
;
CHKERR	NOP			;RETurn or NOP
	DI			;Disable interrupts
	LD	A,'C'		;<C>hecksum error
CHKERR2	LD	(VIDEO+79),A	;
	CALL	DISDOKI		;bring back RAM
	CALL	CASSOFF		;Turn off motor
	LD	HL,READERR	;"Tape Read Error!"
	CALL	DSPLY		;
	JP	ABORT		;good bye
;
;
;********************************************************
;***						      ***
;*** RDSYNC - Read Cassette SYNC byte field	      ***
;***						      ***
;********************************************************
;
;*=*=* Save Registers *=*=*
;
RDSYNC	PUSH	HL		;Save regs
	PUSH	DE		;
	PUSH	BC		;
	LD	A,1		;Set interrupt vector
	OUT	(PORTE0),A	;
;
;*=*=* Read in 128 bits (16 bytes) initially *=*=*
;
RDSYNC2	LD	B,80H		;Read 128 bits (16 bytes)
RBTLP	CALL	RDBIT		;Read bit
	LD	A,C		;p/u count value
	CP	TOOSHRT		;Is this a bit ?
	JR	C,RDSYNC2	;no - didn't find a bit
	CP	TOOLONG		;Is this a bit ?
	JR	NC,RDSYNC2	;no - wait for bit
	DJNZ	RBTLP		;legal bit - dec count
;
;*=*=* Now check parity of next 128 bits *=*=*
;
RESCNT	LD	HL,0		;H = 0's count, L = 1's
	LD	B,40H		;
;
;*=*=* Read in 3 bits *=*=*
;
LOOP	CALL	RDBIT		;Read bit
	CALL	RDBIT		;Read bit
	LD	D,C		;save count
	CALL	RDBIT		;Read bit
;
;*=*=* Calculate Difference between last 2 bits *=*=*
;
	LD	A,D		;p/u last bit
	SUB	C		;subtract current bit
	JR	NC,ABSVAL	;
	NEG			;change to ABS value
;
;*=*=* If Value < DIFFER then Bit = 1, else Bit = 0 *=*=*
;
ABSVAL	CP	DIFFER		;Bit = 1 ?
	JR	C,BIT1		;yes - bump Bit 1 count
	INC	H		;no - bump Bit 0 count
	JR	DODJ		;back to loop
BIT1	INC	L		;bump Bit 1 count
DODJ	DJNZ	LOOP		;dec count - go to loop
;
;*=*=* Check if H (0's count) & L (1's count) = 40 *=*=*
;
	LD	A,40H		;Is H = 64 ?
	CP	H		;
	JR	Z,CHKMARK	;yes - check for marker
	CP	L		;Is L = 64 ?
	JR	NZ,RESCNT	;no - Reset count
;
;*=*=* Set interrupt Vector & discard 1 bit *=*=*
;
	LD	A,2		;Set interrupt vector
	OUT	(PORTE0),A	;
	CALL	RDBIT		;Read bit
;
;*=*=* Rotate each bit read in D & check if = X'7F' *=*=*
;
CHKMARK	LD	D,0		;Set byte = 0
GETBIT	CALL	RDBIT		;Read next bit
	CALL	ROTBYTE		;rotate into Byte (D)
	LD	A,D		;p/u byte
	CP	7FH		;Marker byte ?
	JR	NZ,GETBIT	;no - get another bit
;
;*=*=* Found marker byte - Restore Regs & RETurn *=*=*
;
	POP	BC		;Restore Registers
	POP	DE		;
	POP	HL		;
	RET			;done
;
;
;********************************************************
;***						      ***
;*** ROTBYTE - Rotate bit through D & check if error  ***
;***						      ***
;********************************************************
;
ROTBYTE	LD	A,C		;p/u count
	CP	WHICH1		;Bit = 0 or 1 ?
	RL	D		;Set bit if Carry set
	CP	TOOSHRT		;too quick ?
	JP	C,CIOERR	;yes - I/O Error
	CP	TOOLONG		;too long (like my ...)
	RET	C		;no - RETurn
;
;*=*=* Cassette I/O Error - Display Error *=*=*
;
CIOERR	DI			;interrupts off
	LD	A,'D'		;Data Error
	JP	CHKERR2		;
;
;
;********************************************************
;***						      ***
;*** RDBYTEC - Read byte & Add byte to Check Sum      ***
;***						      ***
;********************************************************
;
RDBYTEC	CALL	RDBYTE		;Read byte
	ADD	A,C		;add to checksum
	RET			;done
;
;
;********************************************************
;***						      ***
;*** RDBYTE - Read a byte			      ***
;***						      ***
;*** A <= Byte					      ***
;***						      ***
;********************************************************
;
RDBYTE:	PUSH	DE		;Save regs
	PUSH	BC		;
	CALL	RDBIT		;get bogus bit
	LD	D,0		;init byte = 0
	LD	B,8		;8 bits to read
;
RDBLP	CALL	RDBIT		;Read a bit
	CALL	ROTBYTE		;rotate into D
	DJNZ	RDBLP		;
;
;*=*=* Add to Byte count *=*=*
;
	LD	A,(COUNT)	;p/u count
	INC	A		;
	AND	3FH		;
	LD	(COUNT),A	;
	JR	NZ,NOTBLNK	;
;
	LD	A,(VIDEO+79)	;Blinky
	XOR	0AH		;
	LD	(VIDEO+79),A	;
;
NOTBLNK	LD	A,D		;xfer byte to A
	JR	NEXTINS		;
;
NEXTINS	POP	BC		;restore BC
	POP	DE		;& DE
	RET			;done
;
;
;********************************************************
;***						      ***
;*** WRBIT - Write a bit to Cassette		      ***
;***						      ***
;********************************************************
;
;*=*=* Set DE = Delay Count for bit *=*=*
;
WRBIT	RLC	C		;Get bit
	JR	NC,NOPULS	;NC - zero
BT1	LD	DE,DELAY1	;NC - Bit=0
	JR	DEL_LP		;go to delay
NOPULS	LD	DE,DELAY0	;Delay for bit=0
;
;*=*=* Delay 18 counts for 1, 43 counts for 0 *=*=*
;
DEL_LP	DEC	D		;Dec count
	JR	NZ,DEL_LP	;
	LD	A,2		;0 Volts to tape
	OUT	(PORTFF),A	;
DEL_LP2	DEC	E		;secondary delay
	JR	NZ,DEL_LP2	;
	LD	A,1		;0.85 volts to tape
	OUT	(PORTFF),A	;
	RET			;done
;
;
;********************************************************
;***						      ***
;*** WRHEAD - Write a cassette header		      ***
;***						      ***
;********************************************************
;
WRHEAD	CALL	WRSYNC		;Write SYNC pattern
;
;*=*=* Write Text header type byte X'9C' *=*=*
;
	LD	D,0		;init checksum = 0
	LD	C,9CH		;Text header type byte
	CALL	WRBYTE		;write type byte
;
;*=*=* Write Filename in header block *=*=*
;
	LD	B,6		;B = 6 chars
	LD	HL,FILENM	;HL => Filename
FILELP	LD	C,(HL)		;p/u filename character
	CALL	WRBYTEC		;and write it
	INC	HL		;bump count
	DJNZ	FILELP		;
;
;*=*=* Write 10 bogus bytes *=*=*
;
	LD	B,10		;just for the fun of it
BOGUS	CALL	WRBYTEC		;
	DJNZ	BOGUS		;
;
;*=*=* Write checksum byte & 20 dummy X'00' bytes *=*=*
;
	LD	A,D		;p/u checksum
	NEG			;be tricky
	LD	C,A		;& xfer to C
	CALL	WRBYTE		;Write Checksum byte
	LD	BC,1400H	;B = 20 bytes, C = 0
DUMMY	CALL	WRBYTE		;write byte
	DJNZ	DUMMY		;
	RET			;Get back quick
;
;
;********************************************************
;***						      ***
;*** WRDAT - Write a chunk of data to cassette	      ***
;***						      ***
;********************************************************
;
WRDAT	LD	HL,MEM		;HL => Mem start
WRDAT2	CALL	WRDATA		;Write Block
	INC	H		;
	LD	A,(FCB1+4)	;Finished ?
	CP	H		;
	JR	NZ,WRDAT2	;no - write another
	RET			;yes - RETurn
;
;
;
;********************************************************
;***						      ***
;*** WRDATA - Write a data Block		      ***
;***						      ***
;*** HL => 256 byte block of data (page boundary)     ***
;***						      ***
;********************************************************
;
WRDATA	CALL	WRSYNC		;Write sync pattern
	LD	C,8DH		;Write X'8D' type byte
	CALL	WRBYTE		;
;
;*=*=* Write 256 byte block of data *=*=*
;
	XOR	A		;Set checksum = 0
WBLP	LD	C,(HL)		;p/u byte
	ADD	A,C		;add checksum
	PUSH	AF		;save A
	CALL	WRBYTE		;write byte
	POP	AF		;recover checksum
	INC	L		;bump count
	JR	NZ,WBLP		;
;
;*=*=* Write checksum byte *=*=*
;
	NEG			;negate checksum
	LD	C,A		;Write checksum byte
	CALL	WRBYTE		;
;
;*=*=* Write 20 dummy bytes - X'00' *=*=*
;
	LD	B,20		;write 20 dummy zeroes
WDLP	LD	C,0		;
	CALL	WRBYTE		;
	DJNZ	WDLP		;
	RET			;done
;
;
;********************************************************
;***						      ***
;*** WRBYTEC - Write a byte & add checksum	      ***
;***						      ***
;********************************************************
;
WRBYTEC	CALL	WRBYTE		;write byte
	LD	A,C		;p/u byte
	ADD	A,D		;add checksum
	LD	D,A		;new checksum
	RET			;and RETurn
;
;
;********************************************************
;***						      ***
;*** WRBYTE - Write a byte to Cassette		      ***
;***						      ***
;*** C => Byte to Output			      ***
;***						      ***
;********************************************************
;
WRBYTE:	PUSH	BC		;Save regs
	PUSH	DE		;Save HL
	CALL	NOPULS		;write dummy pulse
	LD	B,8		;8 bits to write
WRBTLP	CALL	WRBIT		;write bit
	DJNZ	WRBTLP		;
	POP	DE		;restore regs
	POP	BC		;
	RET			;and RETurn
;
;
;********************************************************
;***						      ***
;*** WRSYNC - Write a SYNC pattern to Cassette	      ***
;***						      ***
;********************************************************
;
WRSYNC	DI			;Disable interrupts
	PUSH	BC		;Save BC
	LD	B,80H		;delay
	@@PAUSE			;
	LD	BC,0055H	;B = 256, C = X'55'
;
;*=*=* Write 512 SYNC bytes - X'55' *=*=*
;
WR55LP	CALL	WRBYTE8		;write 2 X'55' bytes
	DJNZ	WR55LP		;256 x 2 bytes
;
;*=*=* Write Marker byte - X'7F' *=*=*
;
	LD	C,7FH		;Write marker byte X'7F'
	CALL	WRBYTE8		;
	POP	BC		;Recover BC
	RET			;done
;
;
WRBYTE8	PUSH	BC		;Save B
	LD	B,8		;8 bits Doug
WB8LP	CALL	WRBIT		;Write bit
	DJNZ	WB8LP		;
	POP	BC		;
	RET			;
