;SYS3/ASM - LDOS 6.2 - 10/11/83
	TITLE	<SYS3 - LDOS 6.2>
;*=*=*
;
;	change log
; 03/18/83 - Changed "AND 80H" to "BIT 7,A"
;*=*=*
*LIST	OFF
*GET	SYS0/EQU:2
*LIST	ON
LF	EQU	10
CR	EQU	13
 COM	'<Copyright (C) 1982 by Logical Systems, Inc.>'
	ORG	1E00H
SYS3	AND	70H
	RET	Z		;Back on zero entry
	CP	10H
	JR	Z,CLOSE		;jump if close
	CP	20H
	JP	Z,FNAME		;jump if filespec recover
	RET
CLOSE	LD	A,(DE)		;test for device
	BIT	7,A		;	03/18/83	*
	JP	Z,CLOSDEV	;jump if closing device
	CALL	CKOPEN@		;test for open file
	LD	C,(IX+6)	;p/u drive #
;*=*=*=*
;	Special MINI check drive routine
;*=*=*=*
	PUSH	IY		;Save IY
	CALL	@GTDCT		;Pick up DCT for drive
CKAGN	CALL	@RSLCT		;wait until not busy
	JP	NZ,HOLDUP	;go to error handler
	BIT	3,(IY+3)	;If hard drive, bypass
	JR	NZ,SAWBLK
	BIT	4,(IY+4)	;If "ALIEN" by pass
	JR	NZ,SAWBLK
	BIT	7,(IY+4)	;Ck if CKDRV inhibit
	JR	NZ,SAWBLK	; go if so
;*****
;	test for diskette in drive (no index)
;*****
	PUSH	DE
	LD	D,(IY+5)	;P/u current track
	LD	E,0		;set to sector 0
	CALL	@SEEK		;do a command
	POP	DE
	LD	B,30H		;set up count (short)
BLACK	CALL	@RSLCT		;Check for index pulse
	BIT	1,A		;test index
	JR	Z,SAWBLK	;Saw black, seems OK
	DJNZ	BLACK
	JP	HOLDUP		;Close fault handler
;*****
;	diskette is there, lets continue
;*****
SAWBLK	POP	IY		;Restore IY
	LD	B,(IX+7)	;p/u DEC of fpde
	CALL	@DIRRD		;read the directory
	RET	NZ		;Quit if error there
	BIT	4,(HL)		;ck for killed file
	RET	Z		;Quit if killed file
	PUSH	HL
	PUSH	BC
	CALL	RWRIT@		;write last buffer?
	POP	BC
	POP	HL
	RET	NZ		;ret on i/o error
	BIT	6,(IX+0)	;If user does not have
	JP	Z,RCVN0		;  close authority...
	INC	L		;  else reset possible
	RES	5,(HL)		;  file-open bit in DIR+1
	INC	L		;determine if the EOF
	INC	L		;  byte has changed
	LD	A,(IX+8)	;p/u EOF byte offset
	PUSH	HL		;Save ptr to DIR+3
	CP	(HL)
	JR	NZ,CLOS1	;go if moved
	LD	A,11H
	ADD	A,L
	LD	L,A
	LD	A,(IX+12)	;p/u lo-order ERN
	CP	(HL)
	JR	NZ,CLOS1	;go if moved
	INC	L
	LD	A,(IX+13)	;p/u hi-order ERN
	CP	(HL)
	JR	NZ,CLOS1	;Go if moved
	POP	AF
	JR	CLOS2		;Didn't move
;*****
;	routine to change the 3-byte EOF marker
;*****
CLOS1	POP	HL		;Pop DIR+3
	LD	A,(IX+8)
	LD	(HL),A
	LD	A,11H
	ADD	A,L
	LD	L,A
	LD	A,(IX+12)
	LD	(HL),A
	INC	L
	LD	A,(IX+13)
	LD	(HL),A
	BIT	2,(IX+0)	;If file was updated
	JR	NZ,CLOS3	;  then update mod date
	JR	CLOS5		;  else don't
;*=*=*
;	Three-byte EOF marker did not change
;*=*=*
CLOS2	BIT	2,(IX+0)	;If file was updated
	JR	NZ,CLOS3	;  then update mod date
	BIT	6,(IX+0)	;If close authority then
	JR	NZ,CLOS5	;  write back the DIR
	JR	CLOS6		;  else continue
;*****
;	routine to insert packed date into directory
;*****
CLOS3	PUSH	HL		;save ptr to DIR+21
	LD	A,L		;pt to start of dir rec
	AND	0E0H
	LD	L,A
	INC	L		;pt to DIR+1
	SET	6,(HL)		;set the MOD flag
	LD	DE,DATE$	;point to year
	LD	A,(DE)		;if year = 0, then date
	OR	A		;  is 00/00/00
	JR	Z,$+4
	SUB	80		;offset from 1980
	PUSH	BC
	LD	B,A		;year-80 -> regB
	INC	DE		;point to day
	LD	A,(DE)		;shift day into 3-7 &
	RLCA			;  merge the year into
	RLCA			;  the lo-order bits
	RLCA
	OR	B
	INC	L
	LD	(HL),A		;store day/year
	DEC	L
	INC	DE		;point to month
	LD	A,(DE)
	LD	B,A
	LD	A,(HL)		;p/u dir byte
	AND	0F0H		;Strip old month
	OR	B		;Merge month &
	LD	(HL),A		;  update the field
	POP	BC
CLOS4	POP	HL		;rcvr DIR+21
CLOS5	PUSH	HL
	CALL	@DIRWR		;Write back DIR entry
	POP	HL
	RET	NZ
CLOS6	INC	L		;pt to DIR+22 which is
	PUSH	HL		;  the 1st extent
	LD	A,L
	SUB	15H		;Backup to DIR+1
	LD	L,A
	BIT	7,(HL)		;test if nonreleasable
	POP	HL
	JP	NZ,RCVN0	;bypass if nonreleasable
	LD	DE,0		;init gran counter
CLOS7	LD	A,(HL)		;p/u cyl indicator
	INC	L		;pt to gran alloc
	CP	0FEH		;extent in use?
	JR	NC,CLOS8	;jump if spare or FXDE
	LD	A,(HL)		;p/u granule allocation
	INC	L		;pt to next extent
	AND	1FH		;strip off # of grans &
	INC	A		;  adjust for zero offset
	ADD	A,E		;accumulate the number of
	LD	E,A		;  grans in this extent
	JR	NC,CLOS7	;any previous quantity
	INC	D
	JR	CLOS7
CLOS8	JR	NZ,CLOS9	;found all grans in this
	LD	B,(HL)		;  extent, ck for FXDE
	CALL	@DIRRD
	RET	NZ
	LD	A,L		;Point to extents in FXDE
	ADD	A,16H
	LD	L,A
	JR	CLOS7		;Go to continue count
;*****
;	routine to determine need to deallocate
;*****
CLOS9	PUSH	HL		;Save ptr to last extent
	LD	L,(IX+12)	;p/u ending record #
	LD	H,(IX+13)
	LD	A,8		;get # sectors/gran
	CALL	@DCTBYT
	AND	1FH		;remove other data
	PUSH	AF		;save the #
	ADD	A,L		;round up to next
	LD	L,A		;  higher gran
	JR	NC,CLOS10
	INC	H
CLOS10	POP	AF		;rcvr # sectors/gran
	INC	A		;adjust for division
	CALL	@DIV16		;calculate # grans in use
	XOR	A		;subtract the # of grans
	EX	DE,HL		;  used from the # of
	SBC	HL,DE		;  grans allocated in the
	EX	DE,HL		;  directory, and move DE
	POP	HL		;Rcvr ptr to last extent
	JP	Z,RCVN0		;jump if same quantity
	JP	C,RCVN0		;jump if now more
;*****
;	need to deallocate space
;*****
	CALL	@GATRD		;read GAT
	RET	NZ
	JR	BAKUP		;B/u to last used extent
CLOS11	PUSH	DE		;sv count of excess grans
	LD	A,(HL)		;p/u alloc info
	AND	0E0H		;get starting relative
	RLCA			;  gran into reg-E
	RLCA
	RLCA
	LD	E,A
	LD	A,(HL)		;# of contiguous grans
	AND	1FH		;remove unneeded data
	ADD	A,E		;calculate ending
	LD	E,A		;  relative gran #
	LD	A,8		;p/u the # of grans
	CALL	@DCTBYT		;  per cylinder
	RLCA
	RLCA
	RLCA
	AND	7		;move into bits 0-2
	INC	A		;adjust for zero offset
	LD	D,A		;save count
	LD	A,4
	CALL	@DCTBYT
	BIT	5,A		;2-sided disk?
	LD	A,D		;rcvr count
	JR	Z,$+3		;bypass if 1-sided
	RLCA			;double count
	CALL	@DIV8		;A=quotient, E=remainder
	DEC	L		;pt to starting cylinder
	ADD	A,(HL)		;bump cyl pointer by how
	LD	D,A		;  many excessive cyls to
	PUSH	HL		;  start from the rear
	PUSH	BC
	LD	H,DIRBUF$<-8	;pt to that cyl's GAT
	LD	L,D
	LD	B,(HL)		;p/u the GAT allocation
	LD	A,E
	CALL	CALCBIT		;deallocate a gran
	LD	(HL),B		;repl GAT byte
	POP	BC
	POP	HL
	INC	L		;repoint to alloc info
	DEC	(HL)		;reduce by 1 gran
	LD	A,(HL)		;get info on contig gran
	INC	A		;adj for zero offset
	AND	1FH		;strip unneeded
	POP	DE		;rcvr excess gran count
	DEC	DE		;And count down
	JR	NZ,CLOS12	;go if extent still used
BAKUP	LD	(HL),0FFH	;  else extent is spare
	DEC	L
	LD	(HL),0FFH
	DEC	L
	LD	A,L		;Chack if backed all the
	AND	1FH		;  way thru this entry
	CP	15H
	JR	NZ,CLOS12	;Go if not
	XOR	L		;Deallocate this FXDE
	LD	L,A
	BIT	7,(HL)		;Was it the FPDE?
	JR	Z,CLOS12	;bypass if FPDE
	LD	(HL),0		;show dir is spare
	CALL	@DIRWR		;Write back
	RET	NZ
	LD	A,B		;p/u deallocated DEC
	AND	0E0H
	INC	A		;pt to DIR+1
	LD	L,A
	LD	A,(HL)		;P/u previous DEC
	LD	(STUFDEC+1),A	;save in instruction
	CALL	@HITRD		;read the HIT
	RET	NZ
	LD	L,B		;Point to deallocated HIT
	LD	(HL),0		;Deallocate space in HIT
	CALL	@HITWR		;Write back
	RET	NZ
STUFDEC	LD	B,0		;p/u previous DEC
	CALL	@DIRRD		;read its dir entry
	RET	NZ
	LD	A,B
	OR	1FH		;pt to end of entry
	LD	L,A
	LD	(HL),0FFH	;Erase pointer
	DEC	L		;  to deallocated FXDE
	LD	(HL),0FFH
	DEC	L		;Point to previous extent
	PUSH	HL		;Save pointer
	CALL	@DIRWR		;write back
	POP	HL
	RET	NZ
CLOS12	LD	A,D		;loop if still more to
	OR	E		;  deallocate
	JP	NZ,CLOS11
	CALL	@DIRWR
	JR	Z,CLOS13
	CP	15
	RET	NZ
	JR	RCVN0
CLOS13	CALL	@GATWR
	RET	NZ
;*****
;	routine starts to recover file spec
;*****
RCVN0	LD	A,(IX+7)	;p/u DEC of FPDE
	LD	C,(IX+6)	;p/u drive
	XOR	B		;Check if its directory
	AND	1FH		;  record is resident
	LD	B,(IX+7)	;p/u DEC of FPDE
	CALL	NZ,@DIRRD	;get FPDE dir if needed
	RET	NZ
	PUSH	IX		;Transfer FCB to DE
	POP	DE
RCVNAM	LD	A,C
	AND	7		;convert drive to ascii
	OR	'0'
	LD	(RCVN5+1),A
	LD	H,SBUFF$<-8	;pt to DIR+5 (name)
	LD	A,B
	AND	0E0H
	OR	5
	LD	L,A
	PUSH	HL
	LD	B,8		;stuff filename back
RCVN1	LD	A,(HL)		;  into fcb
	CP	' '
	JR	Z,RCVN2
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	RCVN1
RCVN2	POP	HL
	LD	A,L
	ADD	A,8		;pt to extension
	LD	L,A
	LD	A,(HL)
	CP	' '
	JR	Z,RCVN4		;jump if none
	LD	A,'/'
	LD	(DE),A		;stuff separator
	INC	DE
	LD	B,3		;init 3-char extension
RCVN3	LD	A,(HL)		;stuff the ext
	CP	' '
	JR	Z,RCVN4
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	RCVN3
RCVN4	LD	A,':'		;stuff drive indicator
	LD	(DE),A
	INC	DE
RCVN5	LD	A,0		;p/u drive in ascii
	LD	(DE),A		;& stuff it
	INC	DE
	LD	A,3		;close FCB with ETX
	LD	(DE),A
	XOR	A
	RET
;*****
;	routine to recover the filespec
;*****
FNAME	PUSH	HL
	PUSH	DE
;*****
;	calculate the number of directory sectors
;	= (#sectors x #sides) - 2 for GAT & HIT
;*****
	LD	A,7		;get highest # sector
	CALL	@DCTBYT
	LD	D,A		;store sides&sectors
	AND	1FH		;rake off # sectors
	LD	E,A		;  & stuff into E
	INC	E		;bump for 0 offset
	XOR	D		;recover # sides
	RLCA			;  into bits 0-2
	RLCA
	RLCA
	INC	A		;bump for 0 offset
	CALL	@MUL8		;multiply sectors x sides
	LD	E,A		;Now check double bit
	LD	A,4
	CALL	@DCTBYT
	BIT	5,A
	LD	A,E
	JR	Z,ONESID	;Go if not set else
	ADD	A,A		;  double value if set
ONESID	SUB	2		;reduce for GAT & HIT
	LD	D,A
	LD	A,B
	AND	1FH		;Calc req sector #
	CP	D
	JR	C,FNAM1
	LD	A,16		;"Illegal logical file #
	OR	A
	JR	FNAM2
FNAM1	POP	DE
	PUSH	DE
	CALL	@DIRRD
	CALL	Z,RCVNAM	;rcvr the filespec
FNAM2	POP	DE
	POP	HL
	RET
;*****
;	close a logical device
;*****
CLOSDEV	CP 	10H
	LD	A,38
	RET	NZ
	CALL	LNKFCB@		;link to FCB
	LD	C,(IX+6)	;get device name
	LD	B,(IX+7)
	LD	(IX+0),'*'	;stuff device indicator
	LD	(IX+1),C	;stuff 1st char of name
	LD	(IX+2),B	;stuff 2nd char of name
	LD	(IX+3),3	;terminate with ETX
	XOR	A
	RET
;*****
;	calculate GAT bit to deallocate
;*****
CALCBIT	AND	7
	RLCA
	RLCA
	RLCA
	OR	80H
	LD	(CALC1+1),A
CALC1	RES	0,B
	RET
HOLDUP	PUSH	HL
	PUSH	DE
	LD	HL,HOLDUP$
	CALL	@DSPLY		;Display to console
	CALL	@CKBRKC		;clear out break bit
WAITING	CALL	@KBD		;scan the keyboard
	JR	NZ,WAITING	;keep looking
	CP	CR		;check for <ENTER>
	JR	Z,TRYNOW
	CALL	@CKBRKC		;Check for a break
	JR	Z,WAITING
ABRT	POP	DE
	POP	HL
	POP	IY		;Restore from above
	LD	A,32		;Show illegal drive #
	OR	A		;set NZ condition
	RET			;go back now
TRYNOW	POP	DE
	POP	HL
	JP	CKAGN		; Try checking again
HOLDUP$	DB	LF,'** CLOSE FAULT **  Drive not ready, '
	DB	'<ENTER> to retry, <BREAK> to abort',CR
LAST	EQU	$
	IFGT	$,DIRBUF$
	ERR	'Module too big'
	ENDIF
	ORG	MAXCOR$-2
	DW	LAST-SYS3
	END	SYS3
