;SYS2/ASM - LDOS 6.2 - 11/15/83
	TITLE	<SYS2 - LDOS 6.2>
;*****
;	This SYS module performs the following functions:
;	. OPENs an existing File or Device
;	. INITs a new File
;	. Checks availability of a specific drive
;	. Hashes an 11-byte field (file name & ext)
;	. Hashes an 8-byte field (password)
;	. Renames a filespec/devspec
;	. Gets the address of a device control block
;*=*=*
;	Change Log
;
; 09/30/83 - Complete new check drive concept installed
; 10/03/83 - Add "CKDRV INHIBIT" convention by looking
;	     at bit 7 of DCT+4 (reserved before now)
;
;*=*=*
CR	EQU	13
*LIST	OFF
*GET	SYS0/EQU:2
*LIST	ON
 COM	'<Copyright (C) 1982 by Logical Systems, Inc.>'
	ORG	1E00H
SYS2	AND	70H		;strip all but entry
	RET	Z		;Back on zero entry
	CP	10H		;check for OPEN
	JP	Z,OPEN
	CP	20H		;check for INIT
	JP	Z,INIT
	CP	70H		;check for rename
	JP	Z,RENAME
	CP	30H		;Get a DCB?
	JR	Z,GTDCB
	CP	40H		;drive availability?
	JR	Z,CKDRV
	CP	60H		;check password hash
	JR	Z,HASHPSWD
;*****
;	routine to hash a file name
;*****
HASHNAME
	LD	B,11		;Init for 11 chars
	XOR	A		;Clear for start
HNAME1	XOR	(HL)		;Modulo 2 addition
	INC	HL		;Bump to next character
	RLCA			;Rotate bit structure
	DJNZ	HNAME1		;  & loop for field len
	OR	A		;Do not permit a zero
	JR	NZ,HNAME2	;  hash code
	INC	A
HNAME2	LD	(FILEHASH),A	;Stuff code for later
	RET
;*****
;	hash a password
;*****
HASHPSWD
	LD	HL,7		;Hashing will be from
	ADD	HL,DE		;  right to left so
	EX	DE,HL		;  point to lo-order
	LD	HL,-1		;Init shift reg to 1's
	LD	B,8		;Init for 8-char string
HPSWD1	LD	A,(DE)		;P/u the next byte
	PUSH	DE		;  & save the pointer
	LD	D,A
	LD	E,H
	LD	A,L		;Modulo 2 add bits 0-2
	AND	7		;  to bits 4-6 of the
	RRCA			;  16-bit shift register
	RRCA
	RRCA
	XOR	L
	LD	L,A		;Shift shift-register
	LD	H,0		;  left by 4-bits to
	ADD	HL,HL		;  isolate bits 4-7
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	XOR	H		;Mod 2 add SR bits 4-7
	XOR	D		;Mod 2 add new byte
	LD	D,A		;Save tempy for hi-order
	LD	A,L
	ADD	HL,HL
	XOR	H
	XOR	E
	LD	E,A
	EX	DE,HL		;SR result to HL
	POP	DE		;P/u pointer to string
	DEC	DE		;  & point to next byte
	DJNZ	HPSWD1		;Loop for field length
	XOR	A
	RET
;*=*=*
;	Routine to locate a Device Control Block
;*=*=*
GETDCB	LD	E,(IX+1)	;p/u the 2-character
	LD	D,(IX+2)	;  device name
GTDCB	LD	HL,KIDCB$	;point to 1st DCB
DEV1	PUSH	HL
	LD	A,L		;point to device
	ADD	A,6		;name field
	LD	L,A
	LD	A,(HL)		;p/u 1st char of name
	INC	L		;point to 2nd char
	CP	E		;compare 1st for match
	JR	NZ,DEV2		;no match? then loop
	LD	A,(HL)		;1st matches, does 2nd?
	CP	D
	JR	NZ,DEV2		;loop if no match
	POP	HL		;get start of DCB
	RET
DEV2	POP	AF		;pop last DCB start
	INC	L		;inc to start of next DCB
	JR	NZ,DEV1		;bypass if not at end
;*****
;	device not found in tables
;*****
	LD	A,8		;"device not available"
	OR	A
	RET
;*****
;check a drive for availability: NOTE also in SYS12
;*****
CKDRV	PUSH	IY		;we use IY in disk I/O
	CALL	@GTDCT		;get driver routine addr
	LD	A,(IY+0)	;p/u drive vector
	CP	0C3H		;ck for enabled
	JP	NZ,CKDR5	;bypass if disabled
	PUSH	HL
	PUSH	DE
	BIT	3,(IY+3)	;test for HARD drive
	JR	NZ,CKDRV1A	;if so bypass range check
	LD	A,(IY+6)	;Make sure the current
	CP	(IY+5)		;  cylinder is in range
	JR	NC,CKDRV1	;go if in range
	CALL	@RSTOR		;restore drive
	JP	NZ,CKDR7A	;go if error!
;
CKDRV1	LD	D,(IY+5)	;p/u current track
	LD	E,0		;set for sector 0
	CALL	@SEEK		;set track info to FDC
	JR	NZ,CKDR7A	;go if error
CKDRV1A	CALL	@RSLCT		;wait until not busy
	JR	NZ,CKDR7A	;Not there - ret NZ
	BIT	3,(IY+3)	;If hard drive, bypass
	JR	NZ,CKDR3A	;  GAT data update
	BIT	4,(IY+4)	;If "ALIEN" by pass
	JR	NZ,CKDR2B	;  test of index pulses
	IF	@MOD4
	LD	A,(FDDINT$)	;Check 'SMOOTH' state
	OR	A
	LD	A,09		;Set MSB of count down
	JR	Z,INTRON	;Go if not SMOOTH
	SRL	A		;divide the count by two
	DI
	ENDIF
	IF	@MOD2
	LD	A,20
	ENDIF
INTRON	LD	(CDCNT+1),A	;store in 'LD H' instruction
	LD	HL,0020H	;set up count (short)
;*****
;	test for diskette in drive & rotating
;*****
CKDR1	CALL	INDEX		;test index pulse
	JR	NZ,CKDR1	;jump on index
	BIT	7,(IY+4)	;Check CKDRV inhibit bit
	JR	NZ,CKDR2B	; if on skip index test
CDCNT	LD	H,00H		;CKDRV counter (long)
				;count set from above
CKDR2	CALL	INDEX		;test index pulse
	JR	Z,CKDR2		;jump on no index
	IF	@MOD4
	EI			;OK for INTs now
	ENDIF
	LD	HL,0020H	;Index off wait (short)
CKDR2A	CALL	INDEX
	JR	NZ,CKDR2A	;jump on index
;*****
;	diskette is rotating
;*****
CKDR2B	PUSH	AF		;save FDC status
	CALL	@DIRCYL		;get directory track in D
	LD	HL,SBUFF$	;point to HIT buffer
	LD	E,L		;sector 0 for GAT
	CALL	@RDSSC		;read the GAT
	JR	NZ,CKDR7	;jump on error
	LD	HL,(SBUFF$+0CCH) ;p/u excess tracks
	LD	A,22H		;add offset
	ADD	A,L
	LD	(IY+6),A	;max track # to DCT
	RES	5,(IY+4)	;set to side 0
	BIT	5,H		;test double sided
	JR	Z,CKDR3		;jump if only single
	SET	5,(IY+4)	;set for side 2
CKDR3	POP	AF		;recover FDC status
CKDR3A	RLCA			;shift write prot to 7
	OR	(IY+3)		;merge Soft WP bit
	AND	80H		;strip all but 7
	LD	(OPNCB9+1),A	;Save WP status for OPNCB
	ADD	A,A		;write prot to carry flg
;
CKDR4	EQU	$
	EI
	POP	DE
	POP	HL
CKDR5	POP	IY
	RET
INDEX	LD	A,H
	OR	L
	JR	Z,CKDR7
	DEC	HL
	CALL	@RSLCT		;Check for index pulse
	BIT	1,A		;test index
	RET
CKDR7	POP	AF
;
CKDR7A	OR	A		;set NZ ret
	JR	CKDR4		; EXIT NOW
;*****
;	OPEN a device
;	Device Control Blocks are from X'0208' - X'02FF'
;*****
DEVOPEN	CALL	GETDCB		;Find the DCB named
	RET	NZ		;  in the IX pointer
;*****
;	Found the needed Device Control Block
;*****
DEV4	LD	B,H		;xfer dcb vector to BC
	LD	C,L
	PUSH	IX
	POP	HL
	LD	(HL),10H	;show routed
	INC	HL
	LD	(HL),C		;stuff dcb vector
	INC	HL
	LD	(HL),B
	INC	HL
	XOR	A		;zero next 3 bytes
	LD	(HL),A
	INC	HL
	LD	(HL),A
	INC	HL
	LD	(HL),A
	INC	HL
	LD	(HL),E		;stuff dcb name
	INC	HL
	LD	(HL),D
	RET
;
;*****
;	OPEN a file
;	. HL <= the address of a 256-byte buffer
;	. DE <= the address of a 32-byte FCB
;	.  B <= the logical record length (LREC)
;*****
OPEN	CALL	LNKFCB@		;set up link to dcb
OPEN1	LD	A,(SFLAG$)	;stuff current sysflag
	LD	(OPEN14+1),A	;to check later then
	AND	0F8H		;remove bits 0, 1 & 2
	LD	(SFLAG$),A
	LD	A,(IX+0)
	CP	'*'		;if name starts with '*',
	JR	Z,DEVOPEN	;  it is a device spec
	LD	A,B		;p/u LREC
	LD	(LREC$),A
	LD	(OPNCB4+1),HL	;stuff disk I/O buffer
	PUSH	IX		;transfer the filespec
	POP	HL		;  into the system
	CALL	XFRSPEC		;  buffer area
	RET	NZ		;return if bad name
	LD	HL,NAME$EXT	;point to name/ext field
	CALL	HASHNAME	;  & hash it (11 chars)
	LD	DE,PSWDBUF	;point to the password
	CALL	HASHPSWD	;  & hash it
	LD	(PW$HASH1),HL	;stuff owner pswd
	LD	(PW$HASH2),HL	;stuff user pswd
OPEN2	LD	A,0		;p/u drive <FF-07>
	LD	C,A
	INC	A		;jump if :d entered
	JR	NZ,OPEN3
	LD	C,A
OPEN3	CALL	CKDRV		;drive available?
	JR	NZ,OPEN6	;jump if not
	CALL	@HITRD		;get hash index table
	RET	NZ		;return if read error
;*****
;	compare hashed filename/ext with each entry
;	in the HIT to see if file is on this drive
;*****
OPEN4	LD	A,(HL)		;bypass HIT entry if
	OR	A		;  unused
	JR	Z,OPEN5
	PUSH	HL		;not vacant
	LD	HL,FILEHASH	;point to DEC
	CP	(HL)		;compare with HIT entry
	POP	HL
	JR	Z,OPEN9		;jump if a match else
OPEN5	INC	L		;  bump to next entry
	JR	NZ,OPEN4	;loop until 256 bytes
;*****
;	file not on this drive
;*****
OPEN6	CALL	TESTDRV		;bump drive if we can
	JR	C,OPEN3		;loop if another to test
OPEN7	LD	A,24		;file not found error
	OR	A
	RET
TESTDRV	LD	A,(OPEN2+1)	;if drive still X'FF',
	INC	A		;  then advance to next
	OR	A		;reset Carry for ret w/o
	RET	NZ		;  affecting Z/NZ result
	INC	C		;bump drive counter
	LD	A,C
	CP	8		;loop end, 8 max
	RET
;*****
;	although the HIT entry matched, the filename/ext
;	did not (due to a collision). Continue to scan
;	the rest of the hash index table.
;*****
OPEN8	POP	BC
	POP	HL
	POP	BC
	CALL	@HITRD
	POP	HL
	RET	NZ
	JR	OPEN5
;*****
;	the hashed name matches, read the directory
;*****
OPEN9	PUSH	HL
	PUSH	BC
	LD	B,L		;set up the DEC
	CALL	@DIRRD
	JR	Z,OPEN10	;jump if no error
	POP	BC		;else pop returns
	POP	HL
	RET			;& exit
;*****
;	verify that directory entry is this file
;*****
OPEN10	PUSH	HL
	PUSH	BC		;save drive (reg C)
;*****
;	if bit 7 is set, it denotes an extended
;	directory entry which does not include
;	the filename. Go to next HIT entry if set
;*****
	BIT	7,(HL)		;test for FXDE
	JR	NZ,OPEN8	;jump if extended
	BIT	4,(HL)		;If DIR record spare,
	JR	Z,OPEN8		;  continue to search
	LD	A,5		;point to filename/ext
	ADD	A,L		;  field in directory
	LD	L,A
	LD	DE,NAME$EXT	;point to entered name
	LD	B,11		;init to check 11 chars
OPEN11	LD	A,(DE)		;verify a match
	CP	(HL)		;  or no match
	JR	NZ,OPEN8	;go to next HIT entry
	INC	HL		;  if no match; else bump
	INC	DE		;  pointers & loop
	DJNZ	OPEN11
	POP	BC		;matches! get drive #
	LD	A,C		;  & stuff it
	LD	(OPEN2+1),A
	POP	HL
	POP	AF
	POP	AF
	PUSH	BC		;Save DEC and drive
	PUSH	HL		;Save ptr to dir record
	LD	A,(HL)		;p/u 1st byte of dir rec
	LD	(DIR$INIT),A	;stuff it
	AND	7		;strip all but protection
	LD	C,A
	LD	B,0
	LD	A,16		;point to update password
	ADD	A,L
	LD	L,A
	LD	DE,(PW$HASH2)	;p/u password hash
	LD	A,(HL)		;p/u owner pswd lo order
	INC	HL
	PUSH	HL
	LD	H,(HL)		;p/u owner pswd hi order
	LD	L,A
	LD	A,(NFLAG$)	;P/u NFLAG$
	BIT	7,A		;Check for PW override
	JR	Z,USEPWD	; if not set use password
	LD	D,H		;Force good password
	LD	E,L
USEPWD	XOR	A		;compare password entry
	SBC	HL,DE		;  with owner password
	POP	HL
SETJR	JR	Z,OPEN16	;grant access if match
	LD	A,C		;recover protection
	CP	7		;abort if "no access"
	JR	Z,OPEN12
	INC	HL		;else point to user
	LD	B,C		;  password & xfer prot
	LD	A,(HL)		;p/u user pswd lo order
	INC	HL
	LD	H,(HL)		;p/u user pswd hi order
	LD	L,A
	XOR	A		;check for a match
	SBC	HL,DE
	JR	Z,OPEN13	;jump if match
;*****
;	file is password protected - abort
;*****
OPEN12	POP	HL
	POP	BC
	LD	A,25		;"file access denied"
	OR	A
	RET
;*****
;	check if prot is exec only
;*****
OPEN13	LD	A,C
	CP	6		;check for EXEC ONLY
	JR	NZ,OPEN16	;jump if not
OPEN14	LD	B,0		;p/u SFLAG$ entry state
	BIT	2,B		;did RUN request open?
	JR	Z,OPEN15	;bypass if NOT from RUN
	LD	HL,SFLAG$
	SET	1,(HL)		;show RUN & EXEC file
	LD	A,5		;set read access for now
OPEN15	LD	HL,SET@EXEC	;set RST vector to turn
	LD	(HL),0C9H	;  off DEBUG
OPEN16	LD	(OPNCB1+1),A	;stuff access level
	POP	HL		;Ptr to direc record
	POP	BC		;P/u DEC and drive
;*****
;	routine to open up the fcb from the directory
;	HL => directory record in SBUFF$
;	BC => DEC and drive used for directory read/write
;	IX => pointer to File Control Block
;*****
OPNCB	PUSH	IY		;Save IY
	PUSH	HL		;Transfer direc record
	POP	IY		;  ptr to IY
	PUSH	BC		;Save DEC and drive
	CALL	OPNCB0		;Create the opened FCB
	POP	BC
	LD	HL,OPEN14+1	;If from LOAD, don't do
	BIT	0,(HL)		;  any further checks
	JR	Z,OPNEX1
	XOR	A
OPNEX	POP	IY
	RET
OPNEX1	BIT	5,(IY+1)	;If file already open
	JR	Z,OPNCB8	;  then set read-only
	POP	IY		;  & return "file open...
OPNEX2	LD	A,(IX+1)	;P/u current attributes
	AND	0F8H		;Mask off current prot
	OR	5		;  & replace with READ
	LD	(IX+1),A	;Reset access to READ
	LD	A,41		;Set "file already open"
	RET
;*=*=*
;	If access level is > read, set file open flag in
;	the directory & note close authority in the FCB.
;*=*=*
OPNCB8	LD	A,(IX+1)	;P/u FCB access level
	AND	7		;Mask off other junk
	CP	5		;Ck READ, EXEC, NONE
	JR	NC,OPNCB10	;Go if one of the above
OPNCB9	LD	A,0		;P/u CKDRV status
	RLCA			;Was drive write prot?
	JR	C,FRCREAD
	SET	5,(IY+1)	;Set file open in direc
	LD	A,(NFLAG$)	;P/u Nflag
	BIT	0,A		;Check for function ON
	CALL	NZ,@DIRWR	;Write the directory
	JR	NZ,OPNEX
	SET	6,(IX+0)	;Set close authority
;*=*=*
;	Ck if passed LRL matches directory
;*=*=*
OPNCB10	LD	A,(IX+9)	;P/u LRL from FCB &
	CP	(IY+4)		;  compare with directory
	LD	A,42		;Init "LRL open fault
	JR	OPNEX
;*=*=*
;	Disk write protected - Change access to READ
;*=*=*
FRCREAD	CALL	OPNEX2		;Change access to READ
	JR	OPNCB10
;*=*=*
;	This routine creates the open file control block
;*=*=*
OPNCB0	EX	DE,HL
	PUSH	IX		;transfer fcb pointer
	POP	HL
	LD	A,(DE)		;Get DIR+0
	AND	20H		;Keep "PDS" bit & show
	OR	80H		;  FCB as open
	LD	(HL),A		;Shove into FCB+0
	INC	HL
	LD	A,(LREC$)	;p/u lrec
	OR	A		;test for 0 (256)
OPNCB1	LD	A,0		;now start byte 2 with
	JR	Z,OPNCB2	;  that set by "OPEN16"
	OR	80H		;show sector or byte I/O
OPNCB2	OR	20H		;show buffer is empty
;*****
;	set bit 3 if filespec ended in an
;	exclamation point. This causes the
;	directory to be updated on every
;	file write where the EOF is extended
;*****
OPNCB3	OR	0
	LD	(HL),A		;init FCB+1
	INC	HL
	XOR	A
	LD	(HL),A		;init FCB+2 with 0
	INC	HL
	PUSH	DE		;put address of disk I/O
OPNCB4	LD	DE,0		;  buf into FCB+3 & FCB+4
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	POP	DE		;FCB+5 with 0 for
	LD	(HL),A		;  lo order next
	INC	HL
	LD	(HL),C		;FCB+6 with drive
	INC	HL
	LD	(HL),B		;FCB+7 with DEC
	INC	HL
	INC	DE		;point to DIR EOF byte
	INC	DE
	INC	DE
	LD	A,(DE)		;p/u DIR lo order EOF
	LD	(HL),A		;  & stuff into FCB+8
	INC	HL
	INC	DE
	LD	A,(LREC$)	;p/u lrec & stuff
	LD	(HL),A		;  into FCB+9
	INC	HL
	XOR	A
	LD	(HL),A		;init FCB+10 & FCB+11
	INC	HL		;  with zero for NRN
	LD	(HL),A
	INC	HL
	SET	4,E		;point to file EOF
	LD	BC,2		;move ERN
	EX	DE,HL
	LDIR			;And zero BC reg
	EX	DE,HL
	LD	A,5		;Max 5 extents
	PUSH	AF
OPNCB5	LD	A,(DE)		;Move starting track
	LD	(HL),A
	INC	HL
	INC	DE
	LD	A,(DE)		;Move grans & offset
	LD	(HL),A
	INC	HL
	AND	1FH		;strip out grans
	INC	A		;bump for zero offset
;*****
;	add reg A to reg pair BC
;*****
	ADD	A,C		;add previous count
	LD	C,A		;update C
	JR	NC,$+3		;Go if no carry to B
	INC	B
	POP	AF		;recover counter
	DEC	A		;decrement loop
	RET	Z		;done if moved in 5
	PUSH	AF
	INC	DE
	LD	A,(DE)		;test for end of extents
	CP	0FEH		;extent in use?
	JR	NC,OPNCB6	;jump if not
	LD	(HL),C		;stuff # of cumulative
	INC	HL		;  grans to this
	LD	(HL),B		;  allocation into FCB
	INC	HL
	JR	OPNCB5		;loop for next
;*****
;	unused extents - put X'FFFF' in remaining fields
;*****
OPNCB6	POP	AF
	RLCA
	RLCA
	LD	B,A
OPNCB7	LD	(HL),0FFH
	INC	HL
	DJNZ	OPNCB7
	RET
;*****
;	INIT a file
;	. HL <= the address of a 256-byte buffer
;	. DE <= the address of a 32-byte FCB
;	.  B <= the logical record length (LREC)
;*****
INIT	CALL	LNKFCB@		;link to FCB
	LD	(OPNCB1+1),A	;start FCB+1 with 0
	PUSH	HL
	LD	HL,SFLAG$
	RES	2,(HL)
	POP	HL
	CALL	OPEN1		;can we "OPEN" the file?
	RET	Z		;return if file existing
	CP	24		;return if error not
	RET	NZ		;  "file not found"
	LD	A,10H		;set dir rec to show
	LD	(DIR$INIT),A	;  assigned
	LD	A,(OPEN2+1)	;p/u the drive entry
	LD	C,A
	INC	A		;jump if a drive entry
	PUSH	AF
	JR	NZ,INIT1	;  was made
	LD	C,A
INIT1	POP	AF		;Stack integrity
	CALL	CKDRV		;is this drive available?
	JR	NZ,INIT2	;jump if not
	JR	C,INIT2
	CALL	@HITRD		;read hash index table
	RET	NZ		;return if read error
	CALL	SPRHIT		;locate spare entry
	JR	Z,INIT4		;jump if space
	XOR	A		;Set status of CKDRV=Z
INIT2	PUSH	AF		;Save last CKDRV status
	CALL	TESTDRV
	JR	C,INIT1		;loop if not at end
	LD	A,(OPEN2+1)	;If drivespec not entered
	INC	A		;  then "directory full
	JR	NZ,INIT2A
	POP	AF		;Stack integrity
	JR	ERR26
INIT2A	POP	AF		;  else if no drive then
	JR	NZ,ERR32	;  "illegal drive...
	JR	C,ERR15		;  else if write protect
ERR26	LD	A,26		;"directory space full"
	DB	1
ERR15	LD	A,15		;"write protect...
	DB	1
ERR32	LD	A,32		;"Illegal drive...
	OR	A
	RET
;*****
;	found a spare HIT entry position
;*****
INIT4	LD	B,L		;save DEC
	LD	A,(FILEHASH)	;p/u filespec hash
	LD	(HL),A		;  & store in HIT
	CALL	@HITWR		;write updated HIT
	CALL	Z,@DIRRD	;read that dir record
	RET	NZ		;return if read error
	PUSH	HL
	PUSH	BC
	EX	DE,HL
	LD	BC,5		;move 1st 5 bytes into
	LD	HL,DIR$INIT	;  directory record
	LDIR
	LD	C,17		;move filename & password
	LD	HL,NAME$EXT	;  info into directory
	LDIR
	EX	DE,HL
	LD	B,10		;put X'FFFF' into 5 ext's
INIT5	CALL	OPNCB7		;4 for the ext's & 1 for
	POP	BC		;  staarting info
	CALL	@DIRWR		;write updated directory
	POP	HL
	RET	NZ		;return if write error
	CALL	OPNCB		;  else open the fcb
	SCF			;  indicate new file
	RET
;*****
;	xfer the file spec to system buffer area
;*****
XFRSPEC	LD	B,19
	LD	DE,PSWDBUF
	LD	A,20H		;blank out the filename
XSPEC1	LD	(DE),A		;  field in system buffer
	INC	DE
	DJNZ	XSPEC1
	LD	A,0FFH		;set drive to X'FF' for
	LD	(OPEN2+1),A	;  checking user entry
	LD	E,NAME$EXT&0FFH	;xfer file name
	CALL	XSPEC8
	LD	C,A
	LD	A,B
	SUB	8		;Any valid chars found?
	JR	NZ,XSPEC3	;jump if valid name
;*****
;	filename was invalid format
;*****
	OR	19		;"illegal file name"
	RET
;*****
;	continue to check file spec
;*****
XSPEC3	LD	A,C
	CP	'/'		;ext entered?
	LD	E,FILE$EXT&0FFH
	LD	B,3
	CALL	Z,XSPEC8A	;xfer the ext
	CP	'.'		;password entered?
	LD	E,PSWDBUF&0FFH
	CALL	Z,XSPEC8	;xfer the password
	CP	':'		;drive entered?
	JR	NZ,XSPEC6
	LD	A,(HL)		;p/u drive #
	SUB	'0'		;convert to binary
	LD	(OPEN2+1),A	;stuff drive #
	AND	0F8H		;must be <0-7>
	LD	A,32		;"illegal drive #"
	RET	NZ		;return error if out
	INC	HL		;  of range
	LD	A,(HL)		;does filespec end in
XSPEC6	SUB	21H		;  exclamation point?
	LD	A,8		;init to set bit 3 of
	JR	Z,XSPEC7	;  FCB+1 & jump if "!"
	XOR	A		;  else reset if not
XSPEC7	LD	(OPNCB3+1),A
	RET
;*****
;
;*****
XSPEC8	LD	B,8
XSPEC8A	LD	A,(HL)		;p/u a filespec character
	INC	HL		;  & 1st test for A-Z
	JR	XSPEC10
XSPEC9	LD	A,(HL)		;p/u a filespec character
	INC	HL		;advance to next one
	CP	'0'		;check for 0-9
	RET	C
	CP	'9'+1
	JR	C,XSPEC11
XSPEC10	CP	'A'		;check for A-Z
	RET	C
	CP	'Z'+1
	RET	NC
XSPEC11	LD	(DE),A		;character is valid
	INC	DE		;advance to next one
	DJNZ	XSPEC9		;  & loop
	LD	A,(HL)		;p/u following character
	INC	HL
	RET			;go home
;*****
;	routine to find a spare HIT entry
;*****
SPRHIT
;*****
;	calculate the number of directory sectors
;	= (#sectors x #sides) - 2 for GAT & HIT
;*****
	LD	A,7		;get highest # sector
	CALL	@DCTBYT
	PUSH	DE
	LD	D,A		;store sides&sectors
	AND	1FH		;rake off # sectors
	LD	E,A		;  & stuff into E
	INC	E		;bump for 0 offset
	XOR	D		;recover # sides
	RLCA			;  into bits 0-2
	RLCA
	RLCA
	INC	A		;bump for 0 offset
	CALL	@MUL8		;multiply sectors x sides
	LD	E,A		;Now check double bit
	LD	A,4
	CALL	@DCTBYT
	BIT	5,A
	LD	A,E
	JR	Z,ONESID	;Go if not set else
	ADD	A,A		;  double value if set
ONESID	POP	DE
	SUB	2		;reduce for GAT & HIT
	LD	(GSH3+1),A	;stuff for compare
;*=*=*
;	Here we search across rows instead of down
;	columns. This increases randomness if random
;	start byte happened to fall on an unused table
;	portion. ALLOC still should search down columns.
;*=*=*
	LD	L,27H		;Try first to use a HIT
	CALL	GSHLOOP		; past the SYS slots
	RET	Z		;great is so RETURN
;			else
	LD	L,1		;Start again after DIR
GSHLOOP	INC	L		;Step to next
	JR	NZ,GSHTRY	;Go if not done yet
	OR	H		;Set NZ flag
	RET			;Return failure
GSHTRY	LD	A,L		;Skip unused parts
	AND	1FH
GSH3	CP	0		;Cp with # of dir sectors
	LD	A,L
	JR	C,GSHOK		;Go if NOT unused
	OR	1FH		;Force to end of row
	LD	L,A
	JR	GSHLOOP		;Loop back & ck for end
GSHOK	LD	A,(HL)		;P/u HIT byte
	OR	A		;Free?
	RET	Z		;Done if so
	JR	GSHLOOP		;Try next
;*=*=*
;	Routine to rename a filespec/devspec
;*=*=*
REN0	LD	A,18H
	LD	(SETJR),A
	OR	A		;Denote "file not in dir
	RET
RENAME	CALL	LNKFCB@		;Save regs & link to IX
	LD	A,(IX+0)	;If a device, use the
	SUB	'*'		;  "device" routine
	JR	Z,RENDEV
	CP	'R'!80H-'*'	;Magic open condition?
	JR	Z,REN0
	PUSH	HL		;Save new pointer
	LD	HL,SFLAG$	;Set don't test flags
	SET	0,(HL)
	CALL	OPEN1		;Open the "old" spec
	POP	HL
	RET	NZ
	LD	A,(IX+1)	;Make sure user has
	AND	7		;  permission to rename
	CP	3
	JR	C,REN1
	LD	A,25H		;"Illegal access...
	OR	A
	RET
;*=*=*
;	User has access to rename - locate drivespec
;*=*=*
REN1	PUSH	HL		;Save start
REN2	LD	A,(HL)		;P/u char of new spec
	INC	HL
	CP	CR
	JR	Z,REN3		;Go on ENTER
	CP	3
	JR	Z,REN3		;Go on ETX
	CP	':'
	JR	NZ,REN2		;Loop on colon
REN3	DEC	HL		;Backup to where the
	LD	(HL),':'	;  colon should go
	INC	HL		;  & force the drivespec
	LD	A,(IX+6)	;  to the same as "old"
	LD	C,A		;Keep drive spec in C
	AND	7
	ADD	A,'0'		;Make it an ASCII digit
	LD	(HL),A
	INC	HL
	LD	(HL),CR
	LD	B,(IX+7)	;Get DEC
	POP	IX		;Put "new" FCB into IX
	PUSH	BC		;  & save DEC & drive
	LD	HL,SFLAG$	;Set don't test flags
	SET	0,(HL)
	CALL	OPEN1		;Open the "new" spec
	POP	BC
	JR	NZ,REN4
REN3A	LD	A,19		;"Illegal file name...
	OR	A		;  if "new" is existing
	RET			;  & we opened it
REN4	CP	24		;If not "file not found"
	RET	NZ		;  then is error!
	CALL	@DIRRD		;Read "old's" directory
	RET	NZ
	PUSH	BC		;Save drive spec
	LD	D,H		;Xfer buffer hi
	LD	A,L
	ADD	A,5		;pt to filename field
	LD	E,A		;Set buffer lo
	LD	HL,NAME$EXT	;Point to where the
	LD	BC,11		;  new name is stored
	LDIR			;move in new name
	POP	BC
	CALL	@DIRWR		;Rewrite the directory
	CALL	Z,@HITRD	;Read the HIT
	RET	NZ
	LD	D,H		;Set the buffer hi
	LD	E,B		;Set the exact HIT lo
	LD	HL,NAME$EXT	;This doesn't change C
	CALL	HASHNAME	;Hash the new name
	LD	(DE),A		;Stuff code into HIT
	JP	@HITWR		;Rewrite & exit
;*=*=*
;	Routine to rename a device
;*=*=*
RENDEV	PUSH	HL		;Save new pointer
	CALL	GETDCB		;Locate in tables
	POP	IX		;Recover pointer to "new"
	RET	NZ		;Back if not in tables
	LD	A,L
	CP	DCBKL$		;Ck if protected device
	LD	A,40		;"Protected system device
	RET	C
	LD	A,(IX+0)	;"new" must be a device
	CP	'*'
	JR	NZ,REN3A	;"illegal file name...
	PUSH	HL		;Save address of "old"
	CALL	GETDCB		;Ck if "new" is unused
	POP	HL		;Rcvr address of "old"
	JR	Z,REN3A
	LD	BC,6		;Point to name field
	ADD	HL,BC		;  of "old" device
	LD	(HL),E		;Stuff new name into
	INC	HL		;  device control block
	LD	(HL),D
	XOR	A		;Set Z-flag
	RET
;*****
;	Parameter storage area
;*****
FILEHASH	DS	1
PSWDBUF		DS	8
NAME$EXT	DS	8
FILE$EXT	DS	3
PW$HASH1	DS	2
PW$HASH2	DS	2
		DW	0	;ERN init
DIR$INIT	DB	0,0,0,0
LREC$		DS	1
LAST	EQU	$
	IFGT	$,DIRBUF$
	ERR	'Module too big'
	ENDIF
	ORG	MAXCOR$-2
	DW	LAST-SYS2
	END	SYS2
