;SYS12/ASM - LDOS 6.2 - 11/01/83
	TITLE	<SYS12 - LDOS 6.2>
;*=*=*
;	Change Log
;
; 04/28/83 - Updated CKDRV routine to match SYS2 updates
; 10/25/83 - Changed @GTMOD to only accept modules
;	   - allocated in the driver zone as resident.
;	   - This change also prevents problem of
;	   - stopping search if the module ends on
;	   - address X'12FF'. DK
;*=*=*
*LIST	OFF
CR	EQU	13
*GET	SYS0/EQU:2
*LIST	ON
 COM	'<Copyright (C) 1982 by Logical Systems, Inc.>'
	ORG	1E00H
SYS12	AND	70H		;strip bit 7
	RET	Z		;Back on zero entry
	CP	30H		;Locate module address?
	JP	Z,GTMOD
	CP	20H		;mini dir?
	JP	Z,MDIR
	CP	10H		;Tandy's RAMDIR?
	RET	NZ		;ret if any other entry
;*=*=*
;	RAMDIR interfacing
;	HL = user buffer area
;	 B = drive #
;	 C = 0 for entire directory
;	 C = 1-254 for selected DEC-1 (02-FF)
;	 C = 255 for Tandy's disk space; in use/free
;*=*=*
RAMDIR	LD	A,7		;Ck on valid drive #
	CP	B
	LD	A,32		;Init "illegal drive
	RET	C
	CALL	LNKFCB@		;Save regs
	LD	A,B		;Get drive where needed
	LD	B,C		;Xfer DEC to B
	LD	C,A		;  & drive to C
	OR	'0'		;Make it ASCII
	LD	(DSTDRV+1),A	;Stuff for STUFBUF
	CALL	CKDRV
	RET	NZ
	INC	B		;Test 0, 1-254, 255
	JR	NZ,DIRINFO	;Go if directory req
;*=*=*
;	Get FREE SPACE info
;*=*=*
	PUSH	HL		;Save buffer pointer
	CALL	SPACE		;Get our info
	LD	B,(HL)		;P/u free space in K
	DEC	HL		;  into BC
	LD	C,(HL)
	DEC	HL
	LD	A,(HL)		;Get total space in K
	DEC	HL		;  into HL
	LD	L,(HL)
	LD	H,A
	SBC	HL,DE		;Calc "in use" (CF=0)
	EX	DE,HL		;Xfer to DE
	POP	HL		;Rcvr user buf ptr
	LD	(HL),E		;Stuff "in use"
	INC	HL
	LD	(HL),D
	INC	HL
	LD	(HL),C		;Stuff "free to use"
	INC	HL
	LD	(HL),B
	XOR	A		;Show no error
	RET
;*=*=*
;	Do RAMDIR directory info
;*=*=*
DIRINFO	DEC	B		;If DEC=0, do it all
	JR	Z,DOALL		;Go if all of it!
	INC	B		;1=>2, 2=>3, ..., FE=>FF
;*****
;	calculate the number of directory sectors
;	= (#sectors x #sides) - 2 for GAT & HIT
;*****
	LD	A,7		;get highest # sector
	CALL	@DCTBYT
	LD	D,A		;store sides&sectors
	AND	1FH		;rake off # sectors
	LD	E,A		;  & stuff into E
	INC	E		;bump for 0 offset
	XOR	D		;recover # sides
	RLCA			;  into bits 0-2
	RLCA
	RLCA
	INC	A		;bump for 0 offset
	CALL	@MUL8		;multiply sectors x sides
	LD	E,A		;Now check double bit
	LD	A,4
	CALL	@DCTBYT
	BIT	5,A
	LD	A,E
	JR	Z,ONESID	;Go if not set else
	ADD	A,A		;  double value if set
ONESID	SUB	2		;reduce for GAT & HIT
	LD	D,A
	LD	A,B
	AND	1FH
	CP	D
	JR	C,DIRINF1
	LD	A,16		;"Illegal logical file #
	OR	A
	RET
DIRINF1	PUSH	HL		;Save buffer ptr
	CALL	@DIRRD		;Get its directory record
	POP	DE		;Rcvr buf ptr
	RET	NZ		;Back on an error
	LD	A,(HL)		;Get attributes
	AND	0D8H		;Only if in use & VIS
	XOR	10H		;Flip state so NZ=no
	LD	A,25		;Init file access denied
	RET	NZ
GETSTUF	PUSH	HL		;Save DIR ptr
	CALL	STUFBUF		;Stuff the filespec
	POP	HL
	LD	A,(HL)
	AND	7		;Keep the access level
	LD	(DE),A
	INC	DE
	INC	L		;Go up to EOF offset
	INC	L
	INC	L
	LDI			;Move in the offset & LRL
	LDI
	LD	A,L		;Bump to ERN
	ADD	A,15
	LD	L,A
	LD	A,(HL)		;P/u ERN
	LD	(DE),A		;  and xfer it
	INC	L
	INC	DE
	LD	H,(HL)
	LD	L,A		;# sectors to HL
	EX	DE,HL		;  hence to DE
	LD	(HL),D		;Stuff ERN High-order
	INC	HL		;Bump buf ptr
	INC	DE		;Adjust for rounding
	INC	DE
	INC	DE
	SRL	D		;Divide by 4 to calc K
	RR	E
	SRL	D
	RR	E
	LD	(HL),E
	INC	HL
	LD	(HL),D
	INC	HL
	LD	(HL),'+'	;Stuff buffer terminator
	EX	DE,HL
	XOR	A
	RET
;*=*=*
;	Tandy's RAMDIR - Do all of the directory
;*=*=*
DOALL	EX	DE,HL		;Buffer pointer to DE
	CALL	HITRD1
	RET	NZ		;exit if read error
	JR	DOALL3
DOALL1	POP	BC		;recover HIT pointer lo
	LD	H,DIRBUF$<-8
	LD	L,B		;Advance to next dir
DOALL2	LD	A,L		;  record of this sector
	ADD	A,32
	LD	L,A
	JR	NC,DOALL3	;Bypass if still same
	INC	L		;Else point to next one
	BIT	5,L		;Finished with
	JR	Z,DOALL3	;  this drive?
	XOR	A
	RET
DOALL3	LD	A,(HL)		;P/u HIT entry
	OR	A
	JR	Z,DOALL2	;Jump if spare
	LD	B,L		;Save DEC in regB
	PUSH	BC		;  & to stack
	LD	A,L		;Pt to dir record for
	AND	0E0H		;  this DEC
	LD	L,A		;Get the dir sector for
	XOR	B		;  this DEC
DOALL4	CP	0FFH		;Same as one in core?
	JR	Z,DOALL5	;Jump if so else
	LD	(DOALL4+1),A	;  update one we have and
	CALL	@DIRRD		;  read it into buffer
	JP	NZ,MDIR12	;Jump on read error
DOALL5	LD	H,SBUFF$<-8	;Sysbuf hi order
	LD	A,(HL)		;P/u attributes
	AND	0D8H		;Test FXDE & in-use
	XOR	10H		;If not used or FXDE
	JR	NZ,DOALL1	;  then back to DOALL1
	PUSH	HL
	CALL	GETSTUF		;Get the dir info
	POP	HL
	JR	DOALL1
;*****
;	routine to display a mini directory
;	 C => drive number in binary (0-7)
;	 B => option, 0 = display, 1 = buffer stuff
;		2 = display /EXT, 3 = buffer /EXT
;		4 = space into buffer
;	HL => address of buffer to stuff dir info & EXT
;	 Z <= set on valid conclusion
;	NZ <= set on any error
;*****
MDIR	LD	A,7		;test for bad drive #
	CP	C
	LD	A,32		;init illegal drive...
	RET	C
	CALL	CKDRV
	RET	NZ
	CALL	LNKFCB@		;Save the regs
	LD	A,B		;stuff the option
	LD	(TSTOPT+1),A
	CP	4
	JP	Z,SPACE0
	LD	A,43		;init "SVC parm error
	RET	NC
	PUSH	HL		;save possible buffer
	PUSH	BC
	LD	DE,LILBUF	;save possible /EXT
	LD	BC,3
	LDIR
	POP	BC
	LD	A,C
	OR	'0'
	LD	(DSTDRV+1),A
	LD	A,5		;init to 5 files/line
	LD	(MDIR11+1),A
	LD	A,23		;  & 23 lines/page
	LD	(CKPAGE+1),A
	CALL	HITRD1
	POP	DE		;rcvr possible buffer
	RET	NZ		;exit if read error
	JR	MDIR3
MDIR1	POP	BC		;recover HIT pointer lo
	LD	H,DIRBUF$<-8
	LD	L,B		;advance to next dir
MDIR2	LD	A,L		;record of this sector
	ADD	A,32
	LD	L,A
	JR	NC,MDIR3	;bypass if still same
	INC	L		;else point to next one
	BIT	5,L		;finished with
	JR	Z,MDIR3		;  this drive?
	LD	A,(TSTOPT+1)
	AND	1
	JR	NZ,CLSBUF
	LD	A,CR
	CALL	@DSP
	XOR	A
	RET
CLSBUF	LD	A,0FFH
	LD	(DE),A
	XOR	A
	RET
MDIR3	LD	A,(HL)		;p/u HIT entry
	OR	A
	JR	Z,MDIR2		;jump if spare
	LD	B,L		;save DEC in regB
	PUSH	BC		;  & to stack
	LD	A,L		;pt to dir record for
	AND	0E0H		;  this DEC
	LD	L,A		;get the dir sector for
	XOR	B		;  this DEC
MDIR4	CP	0FFH		;same as one in core?
	JR	Z,MDIR5		;jump if so
	LD	(MDIR4+1),A	;else update one we have
	CALL	@DIRRD		;  and read it into buf
	JR	NZ,MDIR12	;jump on read error
MDIR5	LD	H,SBUFF$<-8	;sysbuf hi order
	LD	BC,MDIR1	;Set up the return addr
	PUSH	BC
TSTOPT	LD	A,0
	PUSH	HL
	PUSH	DE
	CALL	TSTSAM
	POP	DE
	POP	HL
	RET	NZ		;Back to MDIR1
	LD	A,(TSTOPT+1)
	RRCA
	LD	A,(HL)
	JR	NC,DSPLYIT
	AND	90H		;test FXDE & in-use
	XOR	10H		;if not used, FXDE
	RET	NZ		;Back to MDIR1
	LD	BC,16
	LDIR			;user's buffer
	INC	L
	INC	L
	INC	L
	INC	L
	LD	C,2
	LDIR
	RET			;Back to MDIR1
DSPLYIT	AND	0D8H		;test if we want this
	XOR	10H		;only if in-use & VIS
	RET	NZ		;Back to MDIR1
	LD	DE,LILBUF+3
	PUSH	DE
	CALL	STUFBUF
	POP	HL		;Rcvr LILBUF ptr
	CALL	@DSPLY
MDIR11	LD	A,0		;count down 5-across
	DEC	A
	LD	(MDIR11+1),A	;update count
	RET	NZ		;loop if more to go
	LD	A,5		;  else re-init
	LD	(MDIR11+1),A
	LD	A,CR
	CALL	@DSP		;new line
CKPAGE	LD	A,0		;P/u display count
	DEC	A
	LD	(CKPAGE+1),A
	RET	NZ
	LD	A,23
	LD	(CKPAGE+1),A	;Reset for max
	CALL	@KEY		;Wait for keyboard input
	JP	@CLS
MDIR12	POP	BC
	RET
TSTSAM	BIT	1,A		;ck if /EXT option
	RET	Z		;ret with Z if
	LD	BC,13		; option <> /EXT
	ADD	HL,BC		;Else point to /EXT
	LD	B,3		; field of dir record
	LD	DE,LILBUF	; & check for match
TSTS1	LD	A,(DE)
	CP	'$'		;'$' matches with all
	JR	Z,TSTS2
	CP	'A'		;If numeric, don't cvrt
	JR	C,$+4		;  to upper case
	RES	5,A		;cvrt to UC if lc
	CP	(HL)
	RET	NZ		;ret on no match
TSTS2	INC	HL
	INC	DE
	DJNZ	TSTS1		;Loop for 3 chars
	RET
;*=*=*
;	Routine to construct the filespec field
;*=*=*
STUFBUF	LD	A,L
	ADD	A,5		;pt to start of filename
	LD	L,A
	LD	C,13		;init for 15 (-2) chars
	LD	B,8		;filename
STUFB1	LD	A,(HL)
	INC	HL
	CP	' '		;exit on 1st space
	JR	Z,STUFB2
	LD	(DE),A		;Stuff the char
	INC	DE
	DEC	C		;string count down
	DJNZ	STUFB1		;field loop
	JR	STUFB3		;bypass ext calculation
STUFB2	LD	A,L		;calculate start of
	ADD	A,B		;EXT field in dir record
	DEC	A
	LD	L,A
STUFB3	LD	A,(HL)		;display EXT if present
	CP	' '
	JR	Z,STUFB5	;exit if no EXT
	LD	A,'/'		;display slash
	LD	(DE),A		;Stuff the char
	INC	DE
	DEC	C		;dsplay char countdown
	LD	B,3		;3 chars max for EXT
STUFB4	LD	A,(HL)
	INC	HL
	CP	' '
	JR	Z,STUFB5	;exit on 1st blank
	LD	(DE),A		;  else stuff the char
	INC	DE
	DEC	C
	DJNZ	STUFB4		;loop 3 chars
STUFB5	LD	A,':'		;Stuff a drive sep
	LD	(DE),A		;Reg C already accounted
	INC	DE		;  for in the init
DSTDRV	LD	A,0		;P/u drive #
	LD	(DE),A
	INC	DE
STUFB6	LD	A,' '		;Stuff a space
	LD	(DE),A
	INC	DE
	DEC	C		;count down
	JR	NZ,STUFB6	;display trailing spaces
	LD	A,3		;Stuff the ETX
	LD	(DE),A
	RET
;*=*=*
;	Routine to get the free space info
;*=*=*
SPACE0	PUSH	HL		;Save buf start
	LD	DE,16		;Index for space
	PUSH	DE
	ADD	HL,DE
	CALL	SPACE		;Get the space data
	POP	BC		; name & date
	POP	DE		;Now shift in the
	LD	HL,DIRBUF$+0D0H	;move disk pack
	LDIR
	XOR	A
	RET
SPACE	CALL	@GATRD		;read GAT
	RET	NZ		;Ret on GAT read error
	PUSH	IY
	CALL	@GTDCT		;get DCT vector
	EX	DE,HL		;User buf ptr to DE
	LD	H,0		;p/u highest # cylinder
	LD	L,(IY+6)	;  & adjust for 0 offset
	INC	HL
	LD	A,(IY+8)	;p/u # of sectors/granule
	AND	1FH
	INC	A		;adjust for zero offset
	PUSH	AF		;save # of sectors/gran
	PUSH	DE		;save user buf ptr
	LD	E,A
	LD	A,(IY+8)	;p/u # of granules/cyl
	AND	0E0H
	RLCA			;& shift to bits 0-2
	RLCA
	RLCA
	INC	A		;adjust for zero offset
	CALL	@MUL8		;calc # of sectors/cyl
	BIT	5,(IY+4)	;double sided?
	JR	Z,$+3		;bypass  if one-sided
	ADD	A,A		;else double the count
	POP	BC		;rcvr user buf ptr
	CALL	DOMUL16		;calculate total sectors
	INC	HL		;bump to next buf pos
	PUSH	HL		; & save pointer
	LD	HL,DIRBUF$	;pt to start of GAT
	LD	DE,0		;init gran counter
	LD	A,(DIRBUF$+0CCH) ;p/u cyl excess
	ADD	A,35		;add base
	LD	B,A		;set loop counter
PUGAT	LD	A,(HL)		;p/u GAT byte
KEEP7	SCF			;keep bit 7 set
	RRA			;slide gran bit to carry
	JR	C,BYTEND?	;ignore if in use
	INC	DE		;free, bump gran counter
BYTEND?	CP	0FFH		;end of byte?
	JR	NZ,KEEP7	;loop if not
	INC	L		;bump GAT byte pointer
	DJNZ	PUGAT		;loop for # cyls
	EX	DE,HL		;# free grans -> HL
	POP	BC		;Pop user buf ptr
	POP	AF		;rcvr # of sectors/gran
	POP	IY
DOMUL16	CALL	@MUL16		;calc # of free sectors
	LD	H,B		;cvrt # of free sectors
	LD	D,L
	LD	L,C		;to free space in K by
	LD	E,A
	INC	DE		;dividing the # by 4
	INC	DE		;Round up adjustment
	SRL	D		;Divide 16-bit reg by 2
	RR	E
	SRL	D		;& divide again
	RR	E
	LD	(HL),E		;stuff the value
	INC	HL
	LD	(HL),D
	RET
;*****
;	read the hash index table
;*****
HITRD1	LD	HL,DIRBUF$	;pt to buffer
	PUSH	BC
	PUSH	DE
	CALL	@DIRCYL		;dir cyl to regD
	LD	E,1		;sector one
	CALL	@RDSSC
	POP	DE
	POP	BC
	LD	A,22		;"HIT read error"
	RET
;*=*=*
;	Routine to locate the address of a module
;	DE => pointer to module name
;	HL <= address of module start if found
;	DE <= address of end-of-module name + 1 if found
;	Z  <= if found, else NZ & A = 8
;*=*=*
GTMOD	PUSH	BC		;Save this reg pair
	LD	C,0FFH		;Init length counter
	PUSH	DE		;Save name start
GTM1	INC	C		;Bump counter
	LD	A,(DE)		;Search for end-of-name
	INC	DE
	CP	' '+1
	JR	NC,GTM1
	POP	DE
;*=*=*
;	Start search at system core
;*=*=*
	LD	HL,@$SYS	;Pointer to driver start
;*=*=*
;	Loop through core searching names
;*=*=*
GTM2	LD	A,H		;Are we currently
	CP	@BYTEIO<-8	; the driver zone ?
	JR	NC,GTM2A	;no - check himem
;*=*=*
;	In the Driver zone - is it allocated ?
;*=*=*
	PUSH	BC		;Save BC
	LD	BC,(DVRHI$)	;p/u next available
	OR	A		; addr in Driver zone.
	PUSH	HL		;Is this module
	SBC	HL,BC		; accounted for in
	POP	HL		; the driver zone ?
	POP	BC		;
	JR	NC,GTM8		;no - get out of d/z
;*=*=*
;	Does this module have a legal header ?
;*=*=*
GTM2A	LD	A,(HL)		;Ck for "JR xx"
	CP	18H
	JR	NZ,GTM7		;Exit on non-JR
	PUSH	HL		;Save pointer to start
	INC	HL		;Advance to length/name
	INC	HL
	INC	HL
	INC	HL
	LD	A,(HL)		;P/u length field
	AND	0FH		;Strip flags
	CP	C		;Lengths match?
	JR	NZ,GTM5
	INC	HL		;Point to start of name
	LD	B,A		;Set loop counter
	PUSH	DE		;Save user's name pointer
GTM3	LD	A,(DE)		;Compare the name strings
	CP	(HL)
	JR	NZ,GTM4
	INC	HL
	INC	DE
	DJNZ	GTM3
	EX	DE,HL		;Name+1 to DE
;*=*=*
;	Found a match - exit with info
;*=*=*
	POP	HL		;Keep DE to nameend+1
	POP	HL		;Module start address
	POP	BC		;Reg restoral
	XOR	A		;Set Z-flag for return
	RET
;*=*=*
;	No match - loop to next module
;*=*=*
GTM4	POP	DE
GTM5	POP	HL
	INC	HL		;Point to last byte used
	INC	HL
	LD	A,(HL)		;P/u low-order
	INC	HL
	LD	H,(HL)		;P/u high-order
	LD	L,A
GTM5A	INC	HL		;Bump to next address
	LD	A,H		;Ck for wrap to zero
	OR	L
	JR	NZ,GTM2		;Loop if not through
GTM6	POP	BC		;Restore reg
	LD	A,8		;Set "device not avail...
	OR	A
	RET
;*=*=*
;	Found non-JR - Advance to high memory?
;*=*=*
GTM7	LD	A,H		;Past driver core?
	CP	@BYTEIO<-8
	JR	NC,GTM6		;Exit with "not found"
GTM8	LD	HL,(HIGH$)	;  else p/u himem pointer
	JR	GTM5A		;  & hop to it if in use
;*****
;check a drive for availability: NOTE also in SYS12
;*****
CKDRV	PUSH	IY		;we use IY in disk I/O
	CALL	@GTDCT		;get driver routine addr
	LD	A,(IY+0)	;p/u drive vector
	CP	0C3H		;ck for enabled
	JP	NZ,CKDR5	;bypass if disabled
	PUSH	HL
	PUSH	DE
	LD	A,(IY+6)	;Make sure that the current
	CP	(IY+5)		;  cylinder count is in range
	JP	NC,CKDRV1	;go if in range
	CALL	@RSTOR		;restore drive
	JP	NZ,CKDR7A	;go if error!
;
CKDRV1	LD	D,(IY+5)	;p/u current track
	LD	E,0		;set for sector 0
	CALL	@SEEK		;set track info to FDC
	JR	NZ,CKDR7A	;go if error
	CALL	@RSLCT		;wait until not busy
	JR	NZ,CKDR7A	;Not there - ret NZ
	BIT	3,(IY+3)	;If hard drive, bypass
	JR	NZ,CKDR3A	;  GAT data update
	BIT	4,(IY+4)	;If "ALIEN" by pass
	JR	NZ,CKDR2B	;  test of index pulses
	IF	@MOD4
	LD	A,(FDDINT$)	;Check 'SMOOTH' state
	OR	A
	LD	A,09		;Set MSB of count down
	JR	Z,INTRON	;Go if not SMOOTH
	SRL	A		;divide the count by two
	DI
	ENDIF
	IF	@MOD2
	LD	A,20
	ENDIF
INTRON	LD	(CDCNT+1),A	;store in 'LD H' instruction
	LD	HL,0020H	;set up count (short)
;*****
;	test for diskette in drive & rotating
;*****
CKDR1	CALL	INDEX		;test index pulse
	JR	NZ,CKDR1	;jump on index
	BIT	7,(IY+4)	;Check CKDRV inhibit bit
	JR	NZ,CKDR2B	; if on skip index test
CDCNT	LD	H,00H		;CKDRV counter (long)
				;count set from above
CKDR2	CALL	INDEX		;test index pulse
	JR	Z,CKDR2		;jump on no index
	IF	@MOD4
	EI			;OK for INTs now
	ENDIF
	LD	HL,0020H	;Index off wait (short)
CKDR2A	CALL	INDEX
	JR	NZ,CKDR2A	;jump on index
;*****
;	diskette is rotating
;*****
CKDR2B	PUSH	AF		;save FDC status
	CALL	@DIRCYL		;get directory track in D
	LD	HL,SBUFF$	;point to HIT buffer
	LD	E,L		;sector 0 for GAT
	CALL	@RDSSC		;read the GAT
	JR	NZ,CKDR7	;jump on error
	LD	HL,(SBUFF$+0CCH) ;p/u excess tracks
	LD	A,22H		;add offset
	ADD	A,L
	LD	(IY+6),A	;max track # to DCT
	RES	5,(IY+4)	;set to side 0
	BIT	5,H		;test double sided
	JR	Z,CKDR3		;jump if only single
	SET	5,(IY+4)	;set for side 2
CKDR3	POP	AF		;recover FDC status
CKDR3A	RLCA			;shift write prot to 7
	OR	(IY+3)		;merge Soft WP bit
	AND	80H		;strip all but 7
	ADD	A,A		;write prot to carry flg
;
CKDR4	EQU	$
	EI
	POP	DE
	POP	HL
CKDR5	POP	IY
	RET
INDEX	LD	A,H
	OR	L
	JR	Z,CKDR7
	DEC	HL
	CALL	@RSLCT		;Check for index pulse
	BIT	1,A		;test index
	RET
CKDR7	POP	AF
CKDR7A	LD	A,8		;Set Device not avail
	OR	A		;set NZ ret
	JR	CKDR4		; EXIT NOW
LILBUF	DS	18
LAST	EQU	$
	IFGT	$,DIRBUF$
	ERR	'Module too big'
	ENDIF
	ORG	MAXCOR$-2
	DW	LAST-SYS12
	END	SYS12
