;SYS11/ASM - LDOS 6.2 - 11/02/83
*MOD
	TITLE	<SYS11 - LDOS 6.2>
;*=*=**
; Change Log
;*=*=**
LF	EQU	10
CR	EQU	13
*LIST	OFF
*GET	SYS0/EQU:2
*LIST	ON
 COM	'<Copyright (C) 1982 by Logical Systems, Inc.>'
	ORG	1E00H
SYS11	AND	70H
	RET	Z		;Back on zero entry
	PUSH	HL
	LD	HL,KFLAG$	;Reset the <ENTER>
	RES	2,(HL)		;  bit every time
	POP	HL
	CP	20H		;new @EXIT?
	JR	Z,NEWEXIT
	CP	40H		;new keyboard request
	JP	Z,KEYREQ	;  after input of a line?
	CP	50H		;//INPUT followup
	JP	Z,GETKEY
	CP	10H		;initial entry to DO?
	RET	NZ
;*=*=*
;	<DO> initialization of sysres hooks
;*=*=*
	DI			;clock off for now
	LD	HL,KFLAG$	;Reset break bit only on
	RES	0,(HL)		;  initial entry
	LD	HL,SFLAG$
	BIT	5,(HL)		;if DO already in effect
	SET	5,(HL)		;  don't rehook
	JR	NZ,IPLDO1
	LD	A,0ADH		;New @EXIT SVC
	LD	(@EXIT+1),A
IPLDO1	LD	SP,STACK$
	EI			;clock back on
	LD	DE,JFCB$	;at end of SYSTEM/JCL?
	CALL	@CKEOF
	JP	NZ,@ERROR
	LD	DE,IPLDO2	;Init JCLCB$
	LD	(JCLCB$+1),DE
	CALL	GETLINE		;get a line from the file
	LD	DE,@DOKEY	;change vector to SYS11,
	LD	(JCLCB$+1),DE	;  entry 4!
	JR	$?1		;go interpret it
IPLDO2	LD	DE,JFCB$	;JCLCB$ input routine
	JP	@GET
;*=*=*
;	new @EXIT processing
;*=*=*
NEWEXIT	LD	SP,STACK$	;Reset the stack
	EI
	LD	A,H		;Ck for error return
	OR	L
	JR	NZ,ABORT
	LD	HL,SFLAG$	;
	BIT	4,(HL)		;BREAK key disabled?
	JR	NZ,NEWEX1
	CALL	@CKBRKC		;Check on <BREAK>
	JR	NZ,ABORT
NEWEX1	LD	DE,JFCB$	;exit if end of JCL
	CALL	@CKEOF
	JR	NZ,EXIT
	CALL	GETLINE		;grab a JCL line
$?1	JP	@CMNDI
GETLINE	LD	HL,INBUF$	;pt to line buffer
	LD	BC,79<8		;max 79 chars
	JP	@KEYIN
;*=*=*
;	new ABORT processor
;*=*=*
ABORT	LD	HL,ABORT$	;"Job abort...
	LD	DE,@ABORT
	JR	EXIT1
;*=*=*
;	Scan for ENTER or BREAK
;*=*=*
KSCN	LD	A,(SFLAG$)	;Only test BREAK if
	BIT	4,A		;  BREAK key enabled
	LD	A,(KFLAG$)
	JR	NZ,KSCN1
	BIT	0,A		;BREAK detected?
	JR	NZ,ABORT
KSCN1	BIT	2,A		;Test <ENTER>
	RET	Z		;Back if not
KSCN2	CALL	@KBD		;Clear the type ahead
	JR	Z,KSCN2
	LD	HL,KFLAG$	;Reset the ENTER bit
	RES	2,(HL)
	PUSH	BC
	LD	B,3000<-8
	CALL	@PAUSE
	POP	BC
	LD	A,(HL)		;Don't return until clear
	AND	4
	XOR	4
	JR	Z,KSCN2
	RET
;*=*=*
;	continuation of EXIT processing
;*=*=*
EXIT	LD	HL,JOBDUN$
	LD	DE,@EXIT
EXIT1	PUSH	DE
	CALL	@LOGOT		;Log & fall thru
;*=*=*
;	turn off the DO processor
;*=*=*
DOOFF	EQU	$
	DI
	LD	HL,SFLAG$	;reset <DO> flag
	RES	5,(HL)
	XOR	A
	LD	(JFCB$),A	;show fcb is closed
	LD	H,A		;Set = 0 for @EXIT
	LD	L,A
	LD	DE,KIDCB$	;Clear any type ahead
	LD	A,3
	CALL	@CTL		;  buffer (no streaming)
	LD	A,93H		;Restore @EXIT SVC
	LD	(@EXIT+1),A
	RET
;*=*=*
;	keyboard request processor
;*=*=*
KEYREQ	LD	HL,10		;back stack up 5 words
	ADD	HL,SP		;SYS0,RET,DE,HL,IX,BC
	LD	C,(HL)		;get contents of BC
	INC	HL		;  prior to keyboard
	LD	B,(HL)		;  request & DRIVER save
;*=*=*
;	@KEYIN is requesting an entire line
;*=*=*
KEYLINE	LD	DE,JFCB$	;ck on end of JCL file
	PUSH	BC
	CALL	@CKEOF
	POP	BC
	JR	NZ,EXIT
	LD	A,B		;do we need to re-read
	CP	C		;  the JCL sector?
	JP	NZ,@GET
	CALL	@RREAD		;get the sector back
	JP	NZ,@ERROR
	CALL	@GET
	OR	A
	JR	Z,EXIT
	CP	'/'		;is this line execution
	JR	Z,GOTSLSH	;  JCL code to parse?
	CP	A		;Set Z-flag
	RET
;*=*=*
;	found an execution code line
;*=*=*
GOTSLSH	PUSH	BC
	PUSH	DE
	LD	B,79		;only 79 char line
	LD	HL,INBUF$	;get rest of line
	PUSH	HL		;  into JCL buffer
GOTSL1	LD	(HL),A
	INC	HL
	CP	CR
	JR	Z,GOTSL2
	CALL	@GET
	DJNZ	GOTSL1
	JR	BADJCL		;line too long!
GOTSL2	POP	HL		;rcvr pointer to buf
	PUSH	HL
	INC	HL		;pt to 2nd char
	LD	A,(HL)
	CP	'/'		;found a //?
	JR	NZ,REKEY2
	INC	HL		;ck on ///
	SUB	(HL)
	JP	Z,KEYIN6	;jump if ///
	SUB	0F6H
	JP	NC,KEYIN5	;jump if 3rd char is 0-9
	EX	(SP),HL		;p/u start of command
	CALL	@LOGER		;  line & log it
	EX	(SP),HL
GOTSL3	LD	A,(HL)		;was char ENTER?
	CP	CR
	JR	Z,REKEY2
	CP	' '		;ignore leading spaces
	INC	HL
	JR	Z,GOTSL3
	DEC	HL
	LD	DE,LILBUF	;put possible parm -> buf
	LD	B,5		;max length of parm
	CALL	PARSER		;parse parm
	JR	NZ,REKEY2
	LD	DE,LILBUF
	LD	BC,PARMTBL	;is the parm a macro?
	CALL	FNDPARM
	JR	NZ,REKEY2	;bypass if not in tbl
	PUSH	DE		;stack routine's entry
	RET			;  & go to it
REKEY1	POP	BC
REKEY2	POP	HL
	POP	DE
	POP	BC
	JR	KEYLINE
BADJCL	LD	HL,BADJCL$	;"invalid JCL...
	JP	ABORT+3
;*=*=*
;	process //STOP
;*=*=*
STOP	CALL	DOOFF		;turn off DO proc
	POP	HL
	POP	DE
	POP	BC
	EI
	JP	@KEY		;Go back to keyboard
;*=*=*
;	process //DELAY
;*=*=*
DELAY	EX	(SP),HL
	CALL	@DSPLY
	EX	(SP),HL
	CALL	@DECHEX		;cvrt entry to binary
	LD	B,C		;set count
DELAY1	CALL	SILEN1
	DJNZ	DELAY1
	JR	REKEY2
;*=*=*
;	process //PAUSE
;*=*=*
PAUSE	POP	HL		;display "pause..
	PUSH	HL
	CALL	@DSPLY
PAUSE1	CALL	KSCN		;loop for BREAK or ENTER
	JR	Z,PAUSE1
	JR	REKEY2
;*=*=*
;	process //KEYIN
;*=*=*
KEYIN	POP	HL		;rcvr pointer to "KEYIN
	PUSH	HL
KEYIN1	LD	A,(HL)		;display JCL command line
	INC	HL
	CP	CR
	JR	Z,KEYIN2
	CALL	@DSP
	JR	KEYIN1
KEYIN2	CALL	@KEY		;get & display the char
	CALL	@DSP
	LD	(KEYIN5+1),A	;stuff for compare
	LD	A,CR
	CALL	@DSP		;write new line
KEYIN3	POP	HL
	PUSH	HL
	LD	DE,JFCB$	;ck for end of JCL
	CALL	@CKEOF
	JP	NZ,EXIT
KEYIN4	CALL	@GET		;xfer a line of JCL
	LD	(HL),A		;  to buffer
	INC	HL
	CP	CR
	JR	NZ,KEYIN4
	POP	HL
	PUSH	HL
	LD	A,(HL)		;look for // to find
	CP	'/'		;start of procedure block
	JR	NZ,KEYIN3
	INC	HL
	CP	(HL)		;//?
	JR	NZ,KEYIN3
	INC	HL		;point to proc label
	SUB	(HL)		;is label a '/' noting
	JR	Z,KEYIN6	;  exec phase cond's end?
	LD	A,(HL)		;nope, get proc label
KEYIN5	CP	0		;same as key entry?
	JR	NZ,KEYIN3	;no match? check next one
KEYIN6	LD	(KEYIN5+1),A	;stuff 0 if ///
	POP	HL
	PUSH	HL
	CALL	@LOGER		;log the command
	JR	REKEY2
;*=*=*
;	process //ALERT
;*=*=*
ALERT	XOR	A
	LD	(ALERT4+1),A	;start with clean flag
ALERT1	LD	A,(HL)		;ignore spaces
	INC	HL
	CP	' '
	JR	Z,ALERT1
	CP	','		;comma separator?
	JR	Z,ALERT1
	CP	CR		;end of line?
	JP	Z,REKEY2
	CP	')'		;closing paren?
	JR	Z,ALERT2
	CP	'('		;start of parms?
	JR	NZ,ALERT3	;if none of the above...
	LD	(ALERT2+1),HL	;save ptr to parm start
	JR	ALERT1
;*=*=*
;	check here when closing parm received
;*=*=*
ALERT2	LD	HL,0		;p/u ptr to '(' if there
	LD	A,H		;if the //ALERT1 started
	OR	L		;  with a '(', then
	JR	NZ,ALERT1	;  repeat the parm
	JP	BADJCL		;  parsing else exit
;*=*=*
;	assumed integer parm found
;*=*=*
ALERT3	DEC	HL		;backup pointer
	CALL	@DECHEX		;cvrt value to binary
	LD	B,C		;keep value as counter
ALERT4	LD	A,0		;flip flag: entries 1, 3,
	XOR	0FFH		;  5, ... are noise, 2,
	LD	(ALERT4+1),A	;   4, 6, ... are silence
	LD	C,A
	BIT	0,C		;test noise or silence
	CALL	NZ,@SOUND	;call for Phillip Morris
	BIT	0,C		;  then test again
	CALL	Z,SILENCE	;silence is golden
	CALL	KSCN		;ck BREAK or ENTER
	JP	NZ,REKEY2	;Go on enter
	JR	ALERT1		;Loop if not
;*=*=*
;	silence routine
;*=*=*
SILENCE	OR	B		;A was zero
	RET	Z
	CALL	SILEN1		;delay a bit
	DJNZ	SILENCE		;  for duration
	RET
SILEN1	PUSH	BC		;delay for 0.1 sec
	LD	BC,6555
	CALL	@PAUSE
	POP	BC
	RET
;*=*=*
;	process //FLASH
;*=*=*
FLASH	CALL	@DECHEX
	LD	B,C		;p/u the flash count
	POP	HL
	PUSH	HL
FLASH1	PUSH	BC
	CALL	@DSPLY		;display the prompt
	LD	BC,4000H	;countdown to flash msg
FLASH2	CALL	KSCN		;Keep testing <ENTER>
	JP	NZ,REKEY1	; key during countdown
	DEC	BC		;BREAK would abort
	LD	A,B
	OR	C
	JR	NZ,FLASH2	;loop until count=0
	LD	A,27		;erase the message line
	CALL	@DSP
	LD	A,30
	CALL	@DSP
	CALL	SILEN1		;delay while blanked
	POP	BC
	DJNZ	FLASH1
FLASH3	JP	REKEY2
;*=*=*
;	process //SLEEP and //WAIT
;*=*=*
SLEEP	DB	3EH		;Make it LD A,0AFH
WAIT	XOR	A
	LD	(SLPWT+1),A	;Save entry state
	EX	(SP),HL		;display the JCL line
	CALL	@DSPLY
	EX	(SP),HL
	LD	DE,TIMFLD	;Pt to time field
	LD	B,3		;Set up loop counter
	JR	PAKTIM1
PAKTIM	CP	':'-30H		;Test valid separator
	JP	NZ,BADJCL
PAKTIM1	PUSH	BC
	CALL	@DECHEX		;Cvrt the hours
	LD	(HL),C		;Store time parm
	LDI			;Shift & bump HL & DE
	POP	BC		;Rcvr the loop counter
	DJNZ	PAKTIM		;Loop for 3 values
SLPWT	LD	A,0		;P/u sleep/wait flag
	OR	A
	JR	Z,TSTIME	;Go if //WAIT
	LD	HL,TIMFLD+2	;Point to seconds
	LD	DE,TIME$
	LD	B,2
SLP1	LD	A,(DE)		;Add secs/mins
	ADD	A,(HL)
	LD	(HL),A		;Store
	SUB	60		;Ck overflow to mins/hrs
	JR	C,SLP2		;Go if none
	LD	(HL),A		;Update value mod 60
	DEC	HL		;  & bump next field
	INC	(HL)
	INC	HL		;Adj for dec
SLP2	INC	DE		;Bump time$
	DEC	HL		;Bump user field
	DJNZ	SLP1
	LD	A,(DE)		;Add hours
	ADD	A,(HL)
	LD	(HL),A
	SUB	24		;Wrap past midnight?
	JR	C,TSTIME	;Go if not else
	LD	(HL),A		;  adjust mod 24
;*=*=*
;	Wait until the system clock advances to request
;*=*=*
TSTIME	CALL	KSCN		;Scan for BREAK
	LD	HL,TIMFLD
	LD	DE,TIME$+2
	LD	B,3		;Set loop counter
CKTIME	LD	A,(DE)		;P/u a time value
	CP	(HL)		;Match user input?
	JR	NZ,TSTIME	;Go if no match
	INC	HL		;Inc the user req ptr
	DEC	DE		;Dec the time string ptr
	DJNZ	CKTIME		;Loop for 3 values
	JR	FLASH3		;all match, exit!
;*=*=*
;	process //INPUT request
;*=*=*
INPUT	POP	HL		;recover JCL line &
	CALL	@DSPLY		;  pump it to screen
	LD	A,0DDH		;change sysres hook
	LD	(@DOKEY+1),A
	POP	DE		;stack integrity
	POP	BC		;get @KEYIN values
;*=*=*
;	this next routine will satisfy the request
;*=*=*
GETKEY	CALL	@KEY		;Fetch from keyboard
	PUSH	AF		;don't disturb flag
	DEC	A
	JR	Z,UNHOOK	;change back on BREAK
	CP	CR-1		;  or ENTER
	JR	Z,UNHOOK
	POP	AF
	RET
UNHOOK	LD	A,0CDH		;restore sysres hook
	LD	(@DOKEY+1),A
	POP	AF		;get saved character
	RET
;*=*=*
;	parameter list & scanners
;*=*=*
;	parse a field
;	(HL) => command line
;	(DE) => FCB area
;	Z    <= found valid field
;	NZ   <= found invalid field
;*=*=*
PARSER	LD	B,8		;set length
PAR1	LD	A,B
	LD	(PAR6+1),A
	INC	B
PAR2	LD	A,(HL)
	CP	3		;ETX?
	JR	Z,PAR5
	CP	CR		;<ENTER>?
	JR	Z,PAR5
	CP	'('		;begin of parm?
	JR	Z,PAR5
	INC	HL		;Bump pointer to next
	CALL	TST09AZ		;Test if 0-9,A-Z
	JR	NC,PAR3		;Go if one of the above
	CP	'a'		;Check on lower case
	JR	C,PAR5		;jump on non-alpha
	CP	'z'+1		;Is it a-z?
	JR	NC,PAR5		;jump on non-alpha
	RES	5,A		;convert lower to upper
PAR3	DEC	B		;count down
	JR	Z,PAR4
	LD	(DE),A		;xfer the char
	XOR	A		;show at least 1 valid
	LD	(PAR6+1),A	;char was detected
	INC	DE		;bump FCB pointer
	JR	PAR2		;loop
PAR4	INC	B		;here on max chars ck'd
	JR	PAR2
PAR5	LD	C,A		;save separator
	LD	A,3		;stuff ETX
	LD	(DE),A
PAR6	LD	A,0		;set Z-flag if at least
	OR	A		;1 valid char detected
	LD	A,C		;recover separator char
	RET
TST09AZ	CP	'0'		;Special character?
	RET	C		;Go if not in range
	CP	'9'+1		;jump on digit 0-9
	JR	C,EXITC		;Go if 0-9 & make NC
	CP	'A'		;jump on spec char
	RET	C		;Go with C-flag if 3B-40
	CP	'Z'+1		;jump on A-Z
EXITC	CCF			;Switch flag of result
	RET
;*=*=*
;	find parameter in table
;	(HL) => pointer to line
;	(DE) => pointer to buffer area
;	(BC) => pointer to parameter table
;	  C  <= entry # of parm in table
;	(DE) <= parm vector address
;	  Z <= set if found
;	 NZ <= if not found in table
;	routine similar as FIND.PARM in SYS1 - dif width
;*=*=*
FNDPARM	PUSH	HL
	LD	H,B		;xfer the table address
	LD	L,C
FND1	LD	A,(DE)		;p/u input byte
	CP	(HL)		;match 1st char of table?
	JR	Z,FND3		;jump if 1st matches
FND2	PUSH	BC		;else bypass that entry
	LD	BC,7		;width of table
	ADD	HL,BC
	POP	BC
	LD	A,(HL)		;test for table end
	OR	A
	JR	NZ,FND1		;loop if not at end
	POP	HL
	INC	A		;else set NZ return
	RET
;*=*=*
;	1st matches, does the rest?
;*=*=*
FND3	LD	B,4		;# chars remaining
	PUSH	HL
	PUSH	DE
FND4	INC	DE
	INC	HL
	LD	A,(DE)		;p/u input char
	CP	3		;ETX?
	JR	Z,FND7
	CP	CR		;end of line?
	JR	Z,FND7
	CP	(HL)		;match with table?
	JR	NZ,FND6		;exit & test the char
	DJNZ	FND4		;loop for limit
FND5	POP	DE		;must be a match
	POP	BC
	LD	HL,5		;point to vector
	ADD	HL,BC
	LD	E,(HL)		;xfer vector to DE
	INC	HL
	LD	D,(HL)
	POP	HL
	XOR	A		;& show it found
	RET
;*=*=*
;	no match if alphanumeric unless a space
;*=*=*
FND6	CALL	TST09AZ		;Ck for 0-9, A-Z
	JR	NC,FND8		;Go if one of the above
FND7	LD	A,(HL)		;Loop if table has
	CP	' '		; trailing spaces
	JR	Z,FND5
FND8	POP	DE
	POP	HL
	JR	FND2
LILBUF	DS	6
TIMFLD	EQU	LILBUF
BADJCL$	DB	'Bad JCL, '
ABORT$	DB	'Job aborted',CR
JOBDUN$	DB	'Job done',CR
PARMTBL	DB	'ABORT'
	DW	ABORT
	DB	'ALERT'
	DW	ALERT
	DB	'DELAY'
	DW	DELAY
	DB	'EXIT '
	DW	EXIT
	DB	'FLASH'
	DW	FLASH
	DB	'KEYIN'
	DW	KEYIN
	DB	'PAUSE'
	DW	PAUSE
	DB	'SLEEP'
	DW	SLEEP
	DB	'STOP '
	DW	STOP
	DB	'WAIT '
	DW	WAIT
	DB	'INPUT'
	DW	INPUT
	NOP
LAST	EQU	$
	IFGT	$,DIRBUF$
	ERR	'Module too big'
	ENDIF
	ORG	MAXCOR$-2
	DW	LAST-SYS11
	END	SYS11
