;SYS10/ASM - LDOS 6.2 - 02/11/83
	TITLE	<SYS10 - LDOS 6.2>
;*=*=*
;	Change Log
;
;*=*=*
*LIST	OFF
CR	EQU	13
*GET	SYS0/EQU:2
*LIST	ON
 COM	'<Copyright (C) 1982 by Logical Systems, Inc.>'
	ORG	1E00H
SYS10	AND	70H		;strip bit 7
	RET	Z		;Back on zero entry
	CP	10H		;Remove all for now
	RET	NZ		;ret if any other entry
	LD	A,(DE)		;test device/file
	BIT	7,A		;File open or device?
	JR	Z,CLOSDCB	;jump if device
	CALL	CKOPEN@		;test for open file
	LD	A,(IX+1)	;  & link the FCB to IX
	AND	7		;Test for remove access
	CP	2
	JR	C,REMOV1	;jump if access granted
	LD	A,25H		;  else init errcod
	OR	A
	RET
REMOV1	LD	C,(IX+6)	;p/u drive #
	LD	B,(IX+7)	;p/u DEC
	CALL	@GATRD		;read GAT => DIRBUF$
REMOV2	CALL	Z,@DIRRD	;read dir for this DEC
	RET	NZ		;ret if read error
	LD	A,22		;point to 1st extent
	ADD	A,L
	LD	L,A
REMOV3	LD	E,(HL)		;p/u relative cylinder
	INC	L
	LD	D,(HL)		;p/u granule allocation
	LD	(EXTINFO+1),DE	;modify later instruction
	LD	A,E		;ck if extent in use
	CP	0FEH
	JR	NC,FIXDIR	;jump if not used
	INC	L
	CALL	RMVEXT		;deallocate ext from GAT
	JR	REMOV3		;loop to next extent
;*=*=*
;	deallocated last extent; clean up directory
;*=*=*
FIXDIR	LD	A,L		;point to 1st byte
	AND	0E0H		;  of DIR entry
	LD	L,A
	RES	4,(HL)		;show dir entry spare
	CALL	@DIRWR		;write the dir record
	CALL	Z,@HITRD	;grab HIT => SBUFF$
	LD	H,SBUFF$<-8	;Point to HIT entry
	LD	L,B		;  & zero out DEC pos
	LD	(HL),0
	CALL	Z,@HITWR	;write HIT back to disk
	RET	NZ		;ret if read/write error
EXTINFO	LD	DE,0		;p/u last extent info
;*=*=*
;	if extended directory record in use,
;	D -> DEC of FXDE record
;	E -> FE if FXDE, FF if extent unused
;*=*=*
	LD	B,D		;ck for FXDE in use
	LD	A,E
	CP	0FEH		;X'FE' => FXDE in use
	JR	Z,REMOV2	;jump if FXDE in use
	CALL	@GATWR		;  else write the GAT
	RET	NZ		;ret if write error
	PUSH	IX		;transfer FCB address
	POP	HL		;  to HL & zero out FCB
	LD	B,32		;init for 32 byte field
	XOR	A		;zero the accumulator
ZERLP1	LD	(HL),A		;go for it!
	INC	HL
	DJNZ	ZERLP1
	RET
;*=*=*
;	REMOVE will only close a logical device
;*=*=*
CLOSDCB	CP	10H		;Is this an open DCB?
	LD	A,38		;Init "file not open
	RET	NZ
	CALL	LNKFCB@		;link to DCB (DE->IX)
	LD	C,(IX+6)	;get device name
	LD	B,(IX+7)
	LD	(IX+0),'*'	;stuff device indicator
	LD	(IX+1),C	;stuff 1st char of name
	LD	(IX+2),B	;stuff 2nd char of name
	LD	(IX+3),3	;terminate with ETX
	XOR	A
	RET
;*=*=*
;	deallocate an extent
;*=*=*
RMVEXT	PUSH	HL
	PUSH	BC
	LD	A,8		;p/u the # of grans per
	CALL	@DCTBYT		;  cylinder into regA
	RLCA			;shift into bits 0-2
	RLCA
	RLCA
	AND	7		;remove all else
	INC	A		;adjust for zero offset
;*=*=*
;	ck for 2-sided operation
;*=*=*
	LD	L,A		;save current grans/cyl
	LD	A,4
	CALL	@DCTBYT		;get 2-sided flag
	BIT	5,A		;test 2-sided
	LD	A,L		;xfer value back
	JR	Z,$+3		;bypass if 1-sided
	ADD	A,A		;  else multiply by 2
	LD	(GRNSCYL+1),A	;modify later instruction
	LD	L,E		;relative cylinder -> L
	LD	H,DIRBUF$<-8	;point to GAT byte
	LD	A,D		;rel gran & # of grans
	AND	1FH		;get # of grans
	LD	C,A		;  into regC & adjust
	INC	C		;  for zero offset
	XOR	D		;get rel gran & shift
	RLCA			;  into bits 0-2
	RLCA
	RLCA
RMVEX1	PUSH	AF		;save rel starting gran
	LD	B,(HL)		;p/u allocation byte
	CALL	RMVGRN		;turn off bit for a gran
	LD	(HL),B		;update GAT byte
	POP	AF		;recover starting gran
	INC	A		;bump up
GRNSCYL	CP	0		;ck with grans per cyl
	JR	NZ,DECGRNS	;Go if still on this cyl
	XOR	A		;else zero gran counter
	INC	L		;bump to next cyl in GAT
DECGRNS	DEC	C		;decrement # of grans
	JR	NZ,RMVEX1	;Go if more to deallocate
	POP	BC		;else recover regs
	POP	HL		;  & go home
	RET
;*=*=*
;	remove a bit to deallocate & free up a gran
;*=*=*
RMVGRN	AND	7		;max 8-grans per cyl
	RLCA			;shift to create RES
	RLCA
	RLCA
	OR	80H		;merge rest of RES code
	LD	(RMVGRN1+1),A	;stuff into the inst
RMVGRN1	RES	0,B		;reset proper bit
	RET
LAST	EQU	$
	IFGT	$,DIRBUF$
	ERR	'Module too big'
	ENDIF
	ORG	MAXCOR$-2
	DW	LAST-SYS10
	END	SYS10
