;SYS1/ASM - LDOS 6.2 - 11/10/83
	TITLE	<SYS1 - LDOS 6.2>
;*****
;	Change Log
;
; 02/23/82 - Install bank-0 on @CMD, @CMNDI, @CMNDR
; 08/30/83 - Put pointer to LIBTBL in front end of SYS
; 09/23/83 - Install ability for outside CMD processor
;            Add TOF and CLS commands, '*' to SYS13
; 10/13/83 - Fixed @PARAM to set the flag response bit
;	     instead of the numeric bit if a parameter
;	     with no value is given (P=,). DK
;*=*=*
LD___A	EQU	3AH		;LD A,(nnnn)
;*=*=*
LIBA	EQU	8000H
LIBB	EQU	0A000H		;Set bit 5
LIBC	EQU	0C000H		;Set bit 6
LF	EQU	10
CR	EQU	13
*LIST	OFF
*GET	SYS0/EQU:2
*LIST	ON
 COM	'<Copyright (C) 1982 by Logical Systems, Inc.>'
	ORG	1E00H
SYS1	JR	SYS1BGN		;Hop around pointer
	DW	LIBTBL$		; LIBTBL pointer
SYS1BGN	AND	70H		;Strip all but ept
	RET	Z		;Back on zero entry
	CP	10H		;Ck for @EXIT
	JR	Z,CMD
	CP	40H		;Ck for FSPEC
	JP	Z,FSPEC
	CP	50H		;Ck for FEXT
	JP	Z,FEXT
	CP	60H		;Ck for PARAM
	JP	Z,PARAM
	CP	70H		;Ck for vacant entry
	RET	Z
;*=*=*
;	Entry code for CMNDI (30) and CMNDR (20)
;*=*=*
	LD	DE,INBUF$	;Move 79 characters
	PUSH	DE		;  from (HL) to buffer
	LD	BC,79
	LDIR
	EX	DE,HL		;Terminate with ETX
	LD	(HL),3
	POP	HL
	CP	30H		;Ck entry for CMNDI
	JR	Z,CMD30		;Go on CMNDI
	LD	A,(CFLAG$)
	OR	2		;Set CMNDR bit
	LD	(CFLAG$),A	;Put it back
	JP	CMD20		;  & go on CMNDR
;*=*=*
;	Entry for @EXIT & @CMNDI
;*=*=*
CMD30	CALL	CLEANUP
	JP	NZ,@ABORT
	JR	CMD3A
;
CMD	CALL	CLEANUP
	JR	CMDCONT
;
CLEANUP
	DI			;stop for a moment
	LD	HL,0		;Reset vectored BREAK
	CALL	@BREAK		; to system
	POP	HL		;P/u local RETurn
	LD	SP,STACK$	;Reset stack pointer
	LD	BC,@EXIT	;Establish ret address
	PUSH	BC
	PUSH	HL		;Put back local return
	LD	A,(SFLAG$)	;DEBUG to be on or off?
	RLCA
	LD	A,0C9H		;Bit 7, 1=on, 0=off
	JR	NC,DBGOFF	;Go if OFF
	XOR	A		;Else reset to on
DBGOFF	LD	(@DBGHK),A
	LD	HL,KFLAG$	;point to KFLAG$
	LD	A,11111001B	;set mask to clear
	AND	(HL)		;Merge together
	LD	(HL),A
	LD	HL,SFLAG$	;Point to SFLAG
	LD	A,11111000B	;Mask for SFLAG$
	AND 	(HL)		; clean it up
	LD	(HL),A		;Put KFLAG back
	LD	HL,2FFFH	;Reset LOW$
	LD	(LOW$),HL
;*=*=*  Reset video ram handler pointer
	LD	HL,OPREG_SV_AREA
	LD	(OPREG_SV_PTR),HL
	LD	A,(CFLAG$)	;p/u CFLAG
	AND	20H		;Leave only bit 5
	LD	(CFLAG$),A	;put it back
	LD	HL,INBUF$	;point to command line
	PUSH	HL		; and BC
	POP	BC
	EI			;INTERRUPTS ON NOW!
	CALL	@CKBRKC		;Check and clear BREAK
	RET			;Local cleanup done
;
CMDCONT	LD	A,(EFLAG$)	;P/u External flag
	OR	A		; check if set
	JR	Z,CMD1A		;go if normal
	OR	10001111B	;Set for SYS13
				; P/u user entry code
	RST	40		;DO IT!
CMD1A	LD	HL,RDYMSG$	;Display ready message
	CALL	@DSPLY
CMD2	LD	HL,CFLAG$	;Let the world know we
	SET	2,(HL)		;  are in the command
	PUSH	HL		;  interpreter
	LD	HL,INBUF$	;Get 79 chars max!
	LD	BC,79<8		;No fill char for now
	CALL	@KEYIN
	EX	(SP),HL		;Turn off the interpreter
	RES	2,(HL)		;  bit & reget the buffer
	POP	HL
	JR	C,CMD		;Jump on <BREAK>
;*=*=*
;	Entry from @EXIT & @CMNDI
;
CMD3A
	LD	A,(HL)		;check for comment
	CP	'.'		; if so go before CR
	JR	Z,CMD20		; is displayed
;
	LD	A,CR		;do a line feed on
	CALL 	@DSP		; CMNDI and @EXIT
;
;	Entry from @CMNDR plus the above
;*=*=*
;
;*=*=*
;	Always bring in bank 0
;*=*=*
CMD20	XOR	A		;Prepare for bank-0
	LD	B,A
	LD	C,A
	CALL	@BANK		;Invoke bank-0
;*=*=*
;	Process the command entry
;*=*=*
	CALL	@LOGER		;Log the entry
	LD	DE,CFCB$	;point to command FCB
	LD	A,(HL)		;Jump on comment
	CP	'.'
	JR	Z,COMMENT
	CP	'*'		;Check if alternate CMD
	JR	NZ,CKNOEXC	; processor needed
	PUSH	HL
	POP	BC		;get Buffer in BC
	INC	HL		;Move HL past '*'
	LD	A,0FFH		;Set up for SYS13 entry
	RST	40		; # 7, and DO IT!
CKNOEXC	SUB	'!'		;Test for program force
	JR	NZ,NOEXC
	INC	HL
NOEXC	LD	(TSTEXC+1),A
	CALL	FSPEC		;Fetch command spec
	JR	NZ,WHAT		;Jump on error
	PUSH	HL		;Save terminator pointer
TSTEXC	LD	A,0		;Test if prog force
	OR	A
	JR	Z,NOTLIB	;Jump if starting "!"
	LD	BC,LIBTBL$
	CALL	@FNDPRM		;Is command in LIB?
	JR	Z,CMD4		;Jump if it is
NOTLIB	LD	HL,DFTEXT
	CALL	FEXT		;Default 'EXT' to CMD
	POP	HL		;Rcvr terminator pointer
	LD	A,(CFLAG$)	;Ck LIB only execution
	AND	10H		;  CFLAG$ bit-4
	JP	Z,@RUN		;The program else WHAT?
;*=*=*
;	Process non-entry
;*=*=*
WHAT	LD	HL,-1		;Set to show abort
	RET
;*=*=*
;	Process "dot" comment
COMMENT	LD	A,(SFLAG$)	;Ret if <DO> in effect
	BIT	5,A		;  else get another
	JP	Z,CMD2		;  input line
	LD	HL,0		;Set for no error
	RET
;*=*=*
;	Process LIB command
;*=*=*
CMD4	POP	HL		;Rcvr terminator pointer
	LD	A,0C9H		;Turn off DEBUG
	LD	(@DBGHK),A
	LD	A,D		;Test bit 7 of high
	RLCA			;  order LIB address
	PUSH	DE		;Ret to address of
	RET	NC		;  vector if bit 7 = 0
	POP	DE
	LD	B,E		;Else put overlay # in
	RLCA			;Calculate needed library
	RLCA			;  by rotating 7-5 into
	ADD	A,84H		;  2-0 & adding RST base
	RST	28H
;*=*=*
;	BOOT code brings back the ROM
;*=*=*
BOOTIT	XOR	A		;SVC-0 => @IPL
	RST	40
;
LIBTBL$	DB	'APPEND'
	DW	LIBA!31H
	DB	'ATTRIB'
	DW	LIBB!51H
	DB	'AUTO  '
	DW	LIBB!11H
	DB	'BOOT  '
	DW	BOOTIT
	DB	'BUILD '
	DW	LIBB!33H
	DB	'CAT   '
	DW	LIBA!20H
	DB	'CLS   '
	DW	LIBA!24H
	DB	'COPY  '
	DW	LIBA!32H
	DB	'CREATE'
	DW	LIBB!13H
	DB	'DATE  '
	DW	LIBB!15H
	DB	'DEBUG '
	DW	LIBB!14H
	DB	'DEVICE'
	DW	LIBA!61H
	DB	'DIR   '
	DW	LIBA!21H
	DB	'DO    '
	DW	LIBA!91H
	DB	'DUMP  '
	DW	LIBB!71H
	DB	'FILTER'
	DW	LIBA!66H
	DB	'FORMS '
	DW	LIBC!0B1H
	DB	'FREE  '
	DW	LIBB!22H
	DB	'LIB   '
	DW	LIBA!19H
	DB	'LINK  '
	DW	LIBA!62H
	DB	'LIST  '
	DW	LIBA!41H
	DB	'LOAD  '
	DW	LIBA!81H
	DB	'MEMORY'
	DW	LIBA!1EH
	DB	'PURGE '
	DW	LIBB!72H
	DB	'REMOVE'
	DW	LIBA!18H
	DB	'RENAME'
	DW	LIBA!53H
	DB	'RESET '
	DW	LIBA!63H
	DB	'ROUTE '
	DW	LIBA!64H
	DB	'RUN   '
	DW	LIBA!82H
	DB	'SET   '
	DW	LIBA!65H
	DB	'SETCOM'
	DW	LIBC!0B2H
	DB	'SETKI '
	DW	LIBC!0B3H
	DB	'SPOOL '
	DW	LIBC!0A2H
	DB	'SYSGEN'
	DW	LIBC!1CH
	DB	'SYSTEM'
	DW	LIBC!0A1H
	DB	'TIME  '
	DW	LIBB!16H
	DB	'TOF   '
	DW	LIBA!25H
	DB	'VERIFY'
	DW	LIBB!1BH
	NOP			;Patch 'K' here for KILL
	DB	'ILL  '
	DW	LIBA!18H
	NOP
;*****
;	routine to fetch a filespec/devicespec
;*****
FSPEC	PUSH	DE		;Save pointer to DCB
	CALL	@PARSER		;Parse expected command
	JR	NZ,FSP5		;Jump on invalid field
	CP	'/'		;EXT separator?
	JR	NZ,FSP1
	LD	(DE),A		;File extent coming,
	INC	DE		;  get it!
	LD	B,3		;EXT is 3-chars max
	CALL	@PAR1
FSP1	CP	'.'		;Password entered?
	JR	NZ,FSP2
	LD	(DE),A		;Password coming,
	INC	DE		;Get it also
	CALL	@PARSER
	JR	NZ,FSP6
FSP2	CP	':'		;Drive entered?
	JR	NZ,FSP3
	LD	(DE),A		;A one-byte drive
	INC	DE		; has been had
	LD	B,1
	CALL	@PAR1
	JR	NZ,FSP6
FSP3	CP	'!'		;update EOF always?
	JR	NZ,FSP4
	LD	(DE),A		;yes, slow but accurate
	INC	DE
	INC	HL
	LD	A,(HL)
FSP4	LD	C,A		;save separator char
	LD	A,3
	LD	(DE),A		;stuff an ETX
	XOR	A
	LD	A,C		;p/u separator
	POP	DE		;p/u start of DCB
	PUSH	DE
	LD	BC,PREPTBL	;ck on prepositions
	CALL	@FNDPRM
	POP	DE		;can use TO, ON,
	JR	Z,FSPEC		;  OVER, USING
	XOR	A
	RET
FSP5	CP	'*'		;ck on device spec
	JR	NZ,FSP6		;jump if not device
	LD	(DE),A		;else stuff the '*'
	INC	DE
	LD	B,2		;xfer two char device
	CALL	@PAR1
	JR	Z,FSP4
FSP6	POP	DE
	RET
;*****
;	preposition table
;*****
PREPTBL	DB	'TO    '
	DW	SBUFF$
	DB	'ON    '
	DW	SBUFF$
	DB	'OVER  '
	DW	SBUFF$
	DB	'USING '
	DW	SBUFF$
	NOP
;*****
;	fetch default file extension
;*****
FEXT	PUSH	DE		;save FCB pointer
	PUSH	HL		;save EXT default pointer
	EX	DE,HL		;exchange pointers
	INC	HL
	LD	B,9		;init for 9-char test
FEX1	LD	A,(HL)		;jump if found entered
	CP	'/'		;EXT indicator
	JR	Z,FEX3
	JR	C,FEX4		;jump on other separator
	CP	':'		;jump on digit 0-9
	JR	C,FEX2
	CP	'A'		;jump on special char
	JR	C,FEX4
FEX2	INC	HL		;advance past A-Z,0-9
	DJNZ	FEX1
FEX3	POP	HL		;user entered file ext
	POP	DE
	RET
;*****
;	use default extension
;*****
FEX4	LD	BC,15		;point to position past
	ADD	HL,BC		;the filespec
	LD	D,H
	LD	E,L
	INC	DE		;make room for '/EXT'
	INC	DE		;which is 4 chars
	INC	DE
	INC	DE
	INC	BC		;now move 16 bytes
	LDDR
	POP	HL		;recover pointer to EXT
	INC	HL		;point to 3rd char
	INC	HL
	LD	C,3		;move in 3 chars
	LDDR
	LD	A,'/'		;put in the slash
	LD	(DE),A
	POP	DE
	RET
*GET	PARAM:3
DFTEXT	DB	'CMD'
RDYMSG$	DB	LF,14,'TRSDOS Ready',CR
LAST	EQU	$
	IFGT	$,DIRBUF$
	ERR	'Module too big'
	ENDIF
	ORG	MAXCOR$-2
	DW	LAST-SYS1
	END	SYS1
