;SOUND/ASM : Includes - Sound, Puase, Dechex - 09/16/83
*MOD
SNDPORT	EQU	90H
	ORG	STACK$
	DW	00		;Stack gaurd
;*=*=*
;	Pause routine
;*=*=*
@PAUSE	PUSH	BC		;Save the count
;	SRL	B		;Adjust for WAIT STATES
;	RR	C
	LD	A,(SFLAG$)	;If system (FAST)
	BIT	3,A		; then double it
	CALL	NZ,CDLOOP		;Call if fast
	POP	BC		;Restore the count
CDLOOP	DEC	BC		;Count down routine
	LD	A,B
	OR	C
	JR	NZ,CDLOOP
	RET
;*=*=*
;	@SOUND SVC-104 - Operates sound generator
;	B => sound function
;	bits 0-2 <0-7> = note # (0 highest)
;	bits 3-7 <0-31> = relative sound duration
;	All regs except A left unchanged
;	Z-flag set on exit
;	Note that interrupts disabled during duration
;*=*=*
@SOUND	PUSH	BC		;Save registers
	PUSH	HL
	LD	A,B		;p/u sound data
	AND	7		;  & strip off duration
	RLCA			;Adj for 2-byte fields
	LD	HL,SNDTAB
	LD	C,A
	LD	A,B		;Pick up duration data
	LD	B,0		;Index into tone table
	ADD	HL,BC		;  to get note-on/off
	LD	C,(HL)		;P/u note-on/off data
	INC	HL
	LD	L,(HL)		;P/u note duration
	RRCA			;Rotate sound duration
	RRCA			;  into bits 0-4
	RRCA
	AND	1FH		;Strip off sound #
	INC	A		;Adjust for offset
	LD	H,A		;Set sound counter
	LD	A,(SFLAG$)	;If fast, double values
	AND	8H
	JR	Z,$?1
	SLA	H
	SLA	L
	SLA	C
$?1	DI			;Can't interrupt timing
$?2	PUSH	HL		;Save note duration
$?3	LD	B,C		;play tone
	LD	A,1		;hold output high
	OUT	(SNDPORT),A	;  for count of (B)
	DJNZ	$
	LD	B,C		;hold output low for
	INC	A		;  for count of (B)
	OUT	(SNDPORT),A
	DJNZ	$
	DEC	L		;dec the duration
	JR	NZ,$?3
	POP	HL		;Get sound/note durations
	DEC	H		;Count down the sound
	JR	NZ,$?2		;  duration counter
	EI			;Restore interrupts
	POP	HL
	POP	BC
	RET
;*=*=*
;	note table
;*=*=*
SNDOFF	EQU	180		;Sound duration offset
TONER	EQU	28
SNDTAB	DB	108-TONER	;Note 0 (highest)
	DB	0-SNDOFF
	DB	114-TONER
	DB	252-SNDOFF
	DB	120-TONER
	DB	248-SNDOFF
	DB	126-TONER
	DB	244-SNDOFF
	DB	135-TONER
	DB	240-SNDOFF
	DB	142-TONER
	DB	236-SNDOFF
	DB	149-TONER
	DB	232-SNDOFF
	DB	156-TONER	;Note 7 (lowest)
	DB	228-SNDOFF
SNDLEN	EQU	$-@SOUND
;*****
;	process decimal assignment
;*****
@DECHEX	LD	BC,0		;init value to zero
DEC1	LD	A,(HL)		;p/u a char
	SUB	30H		;cvrt to binary
	RET	C		;return if < "0"
	CP	10		;ck for bad decimal
	RET	NC		;ret if not 0-9
	PUSH	BC		;exchange BC & HL
	EX	(SP),HL		;& save HL on stack
	ADD	HL,HL		;multiply by 10
	ADD	HL,HL
	ADD	HL,BC
	ADD	HL,HL
	LD	B,0		;merge in new digit
	LD	C,A		;new digit to C
	ADD	HL,BC		;& add it in
	LD	B,H		;current value to BC
	LD	C,L
	POP	HL		;recover HL pointer
	INC	HL
	JR	DEC1		;loop
;*=*=*=*
; 	Special Boot code to be moved to 4300h by IPL
;*=*=*=*
BOOTCOD	DI			;Boot stub for @IPL to
	XOR	A		; to move to 4300h
	OUT	(@OPREG),A
	RST	0
BOOTLEN	EQU	$-BOOTCOD
;******
; 	End of special low modules
;******
