;REPAIR/ASM - For VERSION 6.2 - 11/16/83
;
	TITLE	<REPAIR - LDOS 6.2.0>
 COM '<Copyright 1982/3 by Logical Systems Inc.>
;*=*=*
;       REPAIR - LDOS Diskette Repair Utility
; 02/08/83 - Cleaned up a bit - RS
; 02/25/83 - Restricted drive 0
; 04/20/83 - Added MPW parm for hard drives
;*=*=*
LF	EQU	10
CR	EQU	13
BLNKMPW	EQU	4296H
FLAG	EQU	01000000B
ABB	EQU	00010000B
*GET	SVCMAC:3
;
	ORG	2600H
BEGIN
	@@CKBRKC		;Check for break
	JR	Z,BEGINA	; if not continue
	LD	HL,-1		; else abort
	RET
;
BEGINA
	LD	(STACK),SP
	PUSH	HL		;Save ptr to CMD buffer
	LD	HL,HELLO$
	CALL	$DSPLY
	POP	HL
	CALL	PGRM		;Normal exit is via RET
;
; set exit condition..
;
$EXIT	LD	HL,0
QUIT$	LD	SP,$-$
STACK	EQU	$-2
	@@CKBRKC
	RET
;
PGRM	LD	A,(HL)		;Ck for drive entered
	CP	':'		;Colon indicator?
	JP	NZ,PRMERR	;Bypass if not
	INC	HL		;Point to drive #
	LD	A,(HL)		;P/u drive
	SUB	'0'		;Cvrt to binary
	CP	8
	JP	NC,ILLEG	;Bigger than 7
;
	OR	A		;Can't be drive 0
	JP	Z,NOT0
	LD	(DRIVE),A	;Stuff for later
	INC	HL		;Bump past the drive
	LD	C,A
	@@GTDCT			;What's its DCT$
;*=*=*
;	Get any parameter
;*=*=*
	LD	DE,PRMTBL$
	@@PARAM
	JP	NZ,PRMERR
	LD	A,(MRSP)	;MPW parameter entered?
	OR	A
	JP	NZ,MPARM
	BIT	3,(IY+3)	;Can't "repair" a hard drive
	JP	NZ,NIXHARD
	BIT	4,(IY+4)	;If not alien controller
	CALL	Z,CKDRV		;  make sure disk present
	LD	DE,0		;Read BOOT to get dir cyl
	CALL	RDSEC
	XOR	A
	LD	(BUF1),A	;Set 1st byte to zero
	LD	A,(BUF1+2)	;P/u the dir cyl
	AND	7FH		;Strip bit 7
	LD	(BUF1+2),A	;Put it back
	PUSH	AF		;Save dir cyl
	CALL	WRSEC		;Rewrite the BOOT
	INC	E
	CALL	RDSEC		;Get sect 1 also
	POP	AF
	LD	(BUF1+2),A	;Update dir cyl
	PUSH	AF
	CALL	WRSEC		;Write back
	POP	AF		;Dir cyl again
;
	LD	D,A
	LD	E,0
	LD	(IY+9),A	;Set as dir cyl
	CALL	RDSEC		;Read the GAT
;
	RES	5,(IY+4)	;Show single sided
	LD	L,0CBH		;Pt to version # byte
	LD	A,(HL)		;Pick it up
	CP	40H		;Earlier than a 4.0?
	JR	C,LC		;Quit if so
	CP	70H		;"Later" than 6.F?
	JR	NC,LC		;Quit if so
	LD	L,0CDH		;Point to CONFIG byte
	BIT	5,(HL)		;Check 2-sided
	JR	Z,LC		;Quit if not
	SET	5,(IY+4)	;Show double sided
;
LC	LD	L,0BFH		;Pt to end of lockout
	LD	B,96		;Max cylinder count
ALIEN1	LD	A,(HL)		;P/u a lockout byte
	INC	A		;Locked out?
	JR	NZ,ALIEN2	;Exit when in use
	DEC	L		;Backup by 1
	DJNZ	ALIEN1
ALIEN2	LD	A,-35		;What's in use?
	ADD	A,B		;Convert to excess
	LD	L,0CCH
	LD	(HL),A		;Stuff into GAT
;*=*=*
;       construct config byte
;*=*=*
	LD	A,(IY+4)	;P/u sec size & # sides
	AND	80H!20H
	LD	B,A		;Save tempy
	LD	A,(IY+3)	;P/u density
	AND	40H
	OR	B		;Merge with previous
	LD	B,A
	LD	A,(IY+8)	;P/u # grans/track
	RLCA
	RLCA
	RLCA
	AND	7
	OR	B		;Merge with previous
	INC	L		;Pt to config
	LD	B,A		;save for a moment
	LD	A,(HL)		;P/u present config byte
	AND	80H		;keep only bit 7
	OR	B		;pick up the rest
	LD	(HL),A		;& stuff
	LD	L,0
	CALL	WRSYS		;Write the GAT
;*=*=*
;       operate on the HIT
;*=*=*
	INC	E		;Bump sector ptr to 1
	CALL	RDSEC		;Read the HIT
	INC	L		;Pt to DIR/SYS dec
	LD	(HL),0C4H	;"correct" DEC code
	DEC	L
	CALL	WRSYS		;Write out the HIT
	LD	B,8		;Init for 8 sectors
ALIEN3	INC	E		;Bump to next sector
	CALL	RDSEC		;Get the sector
	CALL	UNOPEN		;Be sure these bits are off
	LD	A,E		;If DIR/SYS sector,
	CP	3		;Then update count & it
	JR	NZ,ALIEN4
	PUSH	HL
	LD	HL,BLNKMPW	;Set DIR/SYS password
	LD	(BUF1+12H),HL	;To blanks
	LD	A,(BUF1+20)	;P/u ERN of DIR/SYS
	SUB	3		;Account for 1st 3 done
	LD	B,A		;Update loop counter
	POP	HL
ALIEN4	CALL	WRSYS		;Write back the sector
	DJNZ	ALIEN3
;
	@@LOGOT	ALCAO$		;Advise complete - now readable
	RET			;Done
;*=*=*
;	MPW parameter to change disk password on hard drive
;*=*=*
MPARM	LD	DE,0		;P/u MPW string address
	BIT	5,A		;If not string, then error
	JP	Z,PRMERR
	BIT	3,(IY+3)	;Can't do if not hard
	JP	Z,PRMERR
	CALL	GETMPW		;Get and hash the entry
	JP	NZ,IOERR
	LD	C,0		;Init to drive requested
DRIVE	EQU	$-1
	CALL	GATRD		;Read GAT into BUF1
	JP	NZ,IOERR	;Back on error
	LD	(BUF1+0CEH),HL	;Stuff PW
	CALL	GATWR		;Write sector 0 from buf
	JP	NZ,IOERR	;Jump on write error
	RET
;*=*=*
;	enter SYS2 & hash the password
;*=*=*
GETMPW	CALL	GMPW1		;Get MPW into buffer
	RET	NZ
	LD	A,0E4H		;Hash password (DE) to HL
	RST	28H		;Ret to what called
;*=*=*
;	Place entered password into buffer
;*=*=*
GMPW1	LD	HL,PSWDBUF	;Point to buffer
	PUSH	HL
	LD	B,8		;Init for 8 chars
GMPW2	LD	A,(DE)		;P/u a char
	CP	CR		;End of line?
	JR	Z,GMPW4
	CP	','		;Comma separator?
	JR	Z,GMPW4
	CP	'"'		;Closing quote?
	JR	Z,GMPW4
	INC	DE		;Bump input pointer
	LD	(HL),A		;Transfer character
	INC	HL		;Bump output pointer
	DJNZ	GMPW2		;Loop until done
	JR	CKMPW
GMPW4	LD	(HL),' '	;Buffer with
	INC	HL		;  trailing spaces
	DJNZ	GMPW4
;*=*=*
;	Convert (SP) through (SP)+7 to upper case
;*=*=*
CKMPW	POP	HL
	PUSH	HL
	LD	B,8
	LD	A,(HL)		;P/u 1st char
	JR	CKMPW2		;  & check <A-Z>
CKMPW1	INC	HL
	LD	A,(HL)
	CP	' '		;Got to a space?
	JR	Z,CKMPW7
	CP	'0'		;Less than '0' is error
	JR	C,INVMPW
	CP	'9'+1		;<0-9> is okay for 2-n
	JR	C,CKMPW3
CKMPW2	CP	'A'		;Less than "A" is error
	JR	C,INVMPW
	CP	'Z'+1		;<A-Z> is okay
	JR	C,CKMPW3
	CP	'a'
	JR	C,INVMPW
	CP	'z'+1
	JR	NC,INVMPW
	RES	5,(HL)
CKMPW3	DJNZ	CKMPW1
CKMPW4	POP	DE		;Point to buffer start
	XOR	A
	RET
CKMPW5	INC	HL
	CP	(HL)		;No imbedded spaces
	JR	NZ,INVMPW
CKMPW7	DJNZ	CKMPW5
	JR	CKMPW4
INVMPW	LD	HL,BADMPW$
	LD	A,63
	OR	A
	POP	DE
	RET
;*=*=*
UNOPEN	PUSH	HL
	PUSH	BC
	LD	B,8		;8 entries
	INC	L		;=>first
ZAP	RES	5,(HL)		;Clear bit
	LD	A,32
	ADD	A,L
	LD	L,A		;Move to next
	DJNZ	ZAP
	POP	BC
	POP	HL
	RET
;*=*=*
$DSPLY	@@DSPLY
	RET	Z
	JR	IOERR
;*=*=*
WRSYS	@@WRSSC			;Write the sector
	JR	NZ,IOERR
	@@VRSEC			;Verify it
	CP	6		;Must be SYSTEM sector
	RET	Z
	JR	IOERR
;*=*=*
WRSEC	@@WRSEC			;Write normal sector
	RET	Z
	JR	IOERR
;*=*=*
;       sector read routine
;*=*=*
RDSEC	LD	HL,BUF1		;Read sector
	@@RDSEC	
	RET	Z
	CP	6
	RET	Z		;Fall thru to error?
;*****
;       error exits
;*****
IOERR	CP	63		;Extended error?
	JR	Z,EXTERR
	LD	H,0
	LD	L,A		;Save error
	PUSH	HL
	OR	0C0H
	LD	C,A
	@@ERROR
;
	LD	HL,ABTJOB$
;
	@@LOGOT
	POP	HL
	JR	QUIT$$
;
NIXHARD	LD	HL,NIXHARD$
	DB	0DDH
NOT0	LD	HL,NOT0$
	DB	0DDH
PRMERR	LD	HL,PRMERR$
	DB	0DDH
EXTERR	@@LOGOT
	LD	HL,-1
QUIT$$	JP	QUIT$
;
;*=*=*
;	read the granule allocation table
;*=*=*
GATRD	DB	0F6H		;Set NZ for test
GATWR	XOR	A		;Set Z for test
	PUSH	HL
	PUSH	AF
	LD	D,(IY+9)
	LD	HL,BUF1
	LD	E,L		;Set to sector 0
	POP	AF
	JR	Z,GATRW1
	@@RDSSC
	LD	A,14H
	JR	GATRW3
GATRW1	@@WRSSC
	JR	NZ,GATRW2	;Skip verify if error
	@@VRSEC			;Verify the write
GATRW2	CP	6
	LD	A,15H
GATRW3	POP	HL
	RET
;*=*=*
;	Routine to check on floppy present
;*=*=*
CKDRV	LD	A,40		;@DCSTAT
	RST	28H
	JR	NZ,ILLEG
	LD	A,44		;@RSTORE
	RST	28H
	LD	HL,BUF1
	PUSH	BC
	@@TIME
	POP	BC
	EX	DE,HL		;HL=>TIMER$
	DEC	HL		;=>25 ms
	LD	A,47		;@RSLCT
	RST	28H		;Wait till ready
	LD	A,(HL)		;Get 25 ms count
	ADD	A,20
	LD	D,A
CK1	CALL	INDEX
	JR	NZ,CK1		;Get no pulse
CK2	CALL	INDEX
	JR	Z,CK2		;Get pulse
CK3	CALL	INDEX
	JR	NZ,CK3		;Get no pulse
	RET
;
INDEX	LD	A,(HL)		;Get time
	CP	D		;Interval expired?
	JR	Z,ILLG1
	LD	A,47		;@RSCT
	RST	28H
	BIT	1,A		;Test for index pulse
	RET
;
ILLG1	POP	HL		;Fix stack
ILLEG	LD	A,32		;'illegal drv #'
	JP	IOERR
;
;*=*=*
;	Messages
;*=*=*
HELLO$	DB	'REPAIR'
*GET	CLIENT:3
;
ALCAO$	DB	'Repair function complete',CR
ABTJOB$	DB	'REPAIR aborted',CR
NOT0$	DB	'Can''t REPAIR drive 0',CR
PRMERR$	DB	'Parameter error',CR
BADMPW$	DB	'Invalid master password',CR
NIXHARD$ DB	'Can''t repair a hard drive',CR
PRMTBL$	DB	80H
STR	EQU	20H
	DB	STR!3,'MPW'
MRSP	DB	0
	DW	MPARM+1
	NOP
PSWDBUF	DS	8		;Password buffer
HASHBUF	DS	4		;Owner & user hashes
FCB	DS	32
	ORG	$<-8+1<+8
BUF1	DS	256
	END	BEGIN
