;PATCHA/ASM - for LDOS 6.2 - 10/29/83
	TITLE	'<PATCH	- VERSION 6.2>'
ETX	EQU	3
LF	EQU	10
CR	EQU	13
FLAG	EQU	01000000B
ABB	EQU	00010000B
*GET	SVCMAC:3
	COM	'<Copyright (C) 1982 by Logical Systems, Inc.>'
;Change log
;04/28/83  LM
; added line count for installed patches
; added CLOSE if error but file not modified
; skip over comments between D & F lines 05/23/83
;
	ORG	2600H
BEGIN
	@@CKBRKC
	JR	Z,BEGINA	;Continue if no break
	LD	HL,-1		; else abort
	RET
;
BEGINA
	LD	(STACK),SP
	PUSH	HL		;Save ptr to CMD buffer
	@@FLAGS			;Set up IY
	LD	HL,HELLO$
	CALL	$DSPLY
;Get /CMD file
	POP	HL		;P/u cmd line ptr
	LD	DE,PGMDCB	;Set up for OPEN
	@@FSPEC			;Fetch program filespec
	JP	NZ,PGMREQ	;Bad name
	LD	A,(DE)
	CP	'*'		;Test for device spec
	JP	Z,PGMREQ	;Abort if not a filespec
	PUSH	HL
	LD	HL,CMDEXT
	@@FEXT			;Default ext to CMD
	PUSH	DE
	EX	DE,HL
	LD	DE,FNM$
	@@FSPEC			;Save name for error msg
	POP	DE
	LD	HL,PGMBUF	;Establish buffer
	LD	B,0		;Set lrec=256
	CALL	$OPEN		;Open the file to fix
;Get /FIX file (if any)
	POP	HL		;Pt to second filename
	LD	DE,FIXDCB
	@@FSPEC			;Fetch fix filespec
	JP	NZ,CKLIN
	PUSH	HL
	LD	HL,FIXEXT
	@@FEXT			;Use default ext=FIX
	LD	HL,FIXDCB
	LD	DE,NAMFIX$
	LD	B,0
;Save patch file name for X header
FXNAM	LD	A,(HL)		;Find the fix file name
	INC	HL
	CP	'/'
	JR	Z,FXNAM2
	CP	':'		;Colon yet?
	JR	C,FXNAM1
	CP	'A'		;A-Z?
	JR	C,FXNAM2
	CP	'Z'+1
	JR	NC,FXNAM2
FXNAM1	LD	(DE),A
	INC	DE
	INC	B
	JR	FXNAM
FXNAM2	LD	A,B
	LD	(NAMLEN$),A
	POP	HL
CKLIN	LD	A,(HL)		;Test command line
	CP	CR		;For end
	JR	Z,RDFIX
	INC	HL
	CP	20H
	JR	Z,CKLIN		;Ignore spaces
	CP	'('		;Beginning of parm?
	JP	NZ,PRMERR
;Test for REMOVE or LOC parm
	LD	DE,PTBL$	;=>list
	PUSH	HL		;Save pointer
	DEC	HL		;Back up to '('
	@@PARAM
	POP	HL		;Restore cmd line ptr
	LD	BC,$-$
RPARM1	EQU	$-2
	LD	A,C
	LD	(RPARM),A	;Set Remove parm
	LD	BC,-1
OPARM1	EQU	$-2
	LD	A,C
	LD	(OPARM),A	;Find=on/off
	JP	Z,RDFIX		;If @PARAM was good
;Allow cmd line patch
	LD	BC,FIXDATA	;If @parm says no
CKLIN1	LD	A,(HL)		;Must be /FIX data
	CP	CR
	JP	Z,CKLIN3	;Permit closing CR
	CP	')'
	JR	Z,CKLIN3	;Fill FIX buffer with
	INC	HL		;Parm list converting
	CP	':'		;Colon separators to CR
	JR	NZ,CKLIN2	;Can't use comma to allow
	LD	A,CR		; for "D" verb in cmdline
CKLIN2	LD	(BC),A
	INC	BC
	JR	CKLIN1
CKLIN3	LD	A,CR
	LD	(BC),A
	INC	BC
	LD	A,ETX		;End buffer with ETX
	LD	(BC),A
	JR	DOFIX
; p/u the fix info from the FIX file
RDFIX	LD	A,(NAMLEN$)
	OR	A
	JP	Z,PGMREQ
	SET	0,(IY+'S'-'A')	;Set inhibit bit
	LD	DE,FIXDCB
	LD	HL,FIXBUF
	LD	B,0
	CALL	$OPEN		;Open the fix file
	LD	HL,PGMDATA
	DEC	HL		;Adj for test
	LD	BC,FIXDATA
RDFIX1	CALL	$GET1
	JR	NZ,RDFIX2
	AND	7FH		;Strip bit 7
	JR	Z,RDFIX3
	LD	(BC),A
	INC	BC
	PUSH	HL
	SBC	HL,BC		;Room in fixdata buffer?
	POP	HL
	JP	C,TOOBIG
	JR	RDFIX1
RDFIX2	CP	1CH		;End of file?
	JP	NZ,IOERR
RDFIX3	LD	A,ETX
	LD	(BC),A
DOFIX	LD	HL,FIXDATA
DOFIX1	PUSH	HL
	LD	HL,RDGINP$	;"reading input...
	CALL	$DSPLY
	POP	HL
	LD	(SETMSG+1),HL	;Set LOGOT msg addr
	LD	A,$-$
PASS2	EQU	$-1		;Zero if checking F lines
	OR	A
	LD	A,(HL)
	JP	Z,PASS1
	LD	A,(HL)
	CP	ETX		;End of patch?
	JR	Z,PCHDUN
	CP	'.'		;Comment?
	JP	Z,COMMENT
	RES	5,A		;In case lc
	CP	'F'		;FIND line?
	JP	Z,COMMENT	;Skip on 2nd pass or if O=N
	CP	'D'		;Disk record?
	JP	Z,DVERB
	CP	'Y'		;Yank previous patch?
	JP	Z,YANK
	CP	'L'		;Library overlay?
	JP	Z,LVERB
	CP	'R'
	JP	Z,REMOVE	;Yanking D patch
	CP	'O'	
	JP	Z,OVERB		;Allow O=N etc on cmd line
	CP	'X'		;Patch address?
	JP	NZ,PCHERR
; verb = 'X' -> patch by heX load address
	LD	DE,PGMDCB	;Rewind the program to 0
	LD	BC,0		;Use POSN so EOF
	CALL	$POSN		; is not changed
	CALL	POSFIL		;Position the load file
	PUSH	AF
	PUSH	HL
	PUSH	DE
	LD	HL,INSPCH$	;"installing patch...
	CALL	$DSPLY
	POP	DE
	POP	HL
	POP	AF
	CP	2
	JP	NZ,FILERR	;Load file format error
	LD	A,1		;Tempy set LRL to 1
	LD	(PGMDCB+9),A	;& backspace the file
	CALL	$BKSP
	XOR	A		;Reset LRL to 256
	LD	(PGMDCB+9),A
	CALL	STUFNM		;Generate the patch
	LD	A,(HL)
	CP	ETX
	JP	NZ,PCHERR	;Patch input format error
; patch/operation complete - close the file
PCHDUN	LD	A,CR
	CALL	$DSP
	LD	DE,PGMDCB
	@@CLOSE
	JP	NZ,IOERR
	LD	HL,YANKMSG
	LD	A,(YNKFLG)
	OR	A
	JR	NZ,EXLOG	;Yes, log out
	LD	HL,SUCCES$	;"function completed.."
	@@LOGOT
	LD	HL,(LINCNT)	;P/u # of d & x lines
	LD	A,H
	OR	L		;Any?
	JR	Z,NOCHG		;No D or X verbs
	PUSH	HL
	LD	DE,1		;Exactly 1?
	SBC	HL,DE
	POP	HL
	JR	NZ,NTONE
	LD	A,' '		;Then remove 's' from msg
	LD	(PLURAL),A
NTONE	LD	DE,LINMSG$
	@@HEXDEC
NOCHG	LD	HL,LINMSG$
EXLOG	@@LOGOT
	LD	HL,0		;=>no error
$QUIT	PUSH	HL
	LD	HL,PGMDCB
	BIT	7,(HL)		;Was file left open?
	EX	DE,HL		;DE=>DCB possible close
	CALL	NZ,FLOPN	;Warn user
	LD	A,14		;Cursor on
	CALL	$DSP
	POP	HL
	LD	SP,$-$
STACK	EQU	$-2
	@@CKBRKC		;clear break
	RET
; verb = '.' => comment line
COMMENT	LD	A,(HL)		;Read & ignore comment
	CP	ETX
	JP	Z,DOFIX1	;Set PASS2?
	INC	HL
	CP	';'		;Logical EOL
	JR	Z,EOL1
	CP	CR
	JR	NZ,COMMENT
EOL1	JP	DOFIX1
; verb = 'D' -> disk record patch
DVERB	CALL	CNTLIN		;Bump line counter
	CALL	DPOSN		;For pass 2
	CALL	DLINE
	JP	DOFIX1
;*=*=*
DPOSN	INC	HL
	CALL	PRSFIX		;Get char or hex pair
	LD	B,0		;Get disk record #
	LD	C,A
	LD	A,(HL)		;If no comma, then
	CP	','		; get 3rd & 4th digits
	JR	Z,DVERB1
	CALL	PRSFIX
	LD	C,A
DVERB1	LD	DE,PGMDCB	;Position file to record
	CALL	$POSN
	LD	A,(HL)		;Separate POSN from
	CP	','		;Byte offset
	JP	NZ,PCHERR
	INC	HL
	CALL	$READ		;Read the sector
	CALL	PRSFIX		;Get relative byte #
	LD	(PGMDCB+5),A	;Set byte offset in FCB
	RET
DLINE	LD	A,(HL)		;Follow byte with '='
	CP	'='
	JP	NZ,PCHERR
DVERB2	INC	HL
DVERB3	CALL	PRSFX1		;Get patch byte
	CALL	PUTORCHK
	LD	A,(HL)		;P/u next char
	CP	CR		;Exit if ENTER
	JR	Z,DVERB4+1	;Bump HL on CR
	CP	';'		;End of line?
	JR	Z,DVERB4
	CP	'"'		;Closing dbl-quote?
	JR	Z,DVERB4
	LD	A,(STRFLG+1)	;If in quote string,
	OR	A		;Do not bump HL past
	JR	Z,DVERB2	;The non-existant space
	JR	DVERB3
DVERB4	LD	A,(HL)		;Ignore rest of line
	INC	HL
	CP	CR
	JR	NZ,DVERB4
	LD	A,(PASS2)	;Reading or checking?
	OR	A
	CALL	NZ,$RWRIT	;Re-write the sector
	RET			;Done w/line
;Verb = 'R' -> set flag to yank D patch
REMOVE	LD	A,-1
	LD	(RPARM),A
	JP	COMMENT		;Read rest of patch
; verb = 'Y' -> yanks patch with same name
YANK	LD	A,(HL)		;Ignore rest of the line
	INC	HL
	CP	CR
	JR	NZ,YANK
	PUSH	HL
	LD	HL,YNKPCH$	;"yanking patch...
	CALL	$DSPLY
	LD	BC,0		;Rewind the file
	LD	DE,PGMDCB
	CALL	$POSN
YANK1	CALL	$GET1		;Get a "type" byte
	JP	NZ,YANK9
	CP	7		;Found a patch?
	JR	Z,YANK4		;Jump on type=7
	LD	(TYPCOD+1),A	;Stuff type for testing
	CALL	$GET		;Get a block length
	LD	B,A		;Set loop counter
TYPCOD	LD	A,0		;Test type
	DEC	A		;If type 1 (code block),
	JR	NZ,YANK2	;Adj block len
	CALL	$GET		;Read through the load
;Address & adj length
	DEC	B		;In case the block was
	CALL	$GET		;  255+2 or 256+2
	DEC	B
YANK2	CALL	$GET		;Read rest of block
YANK3	DJNZ	YANK2
	JR	YANK1
; found patch code area, is this the one?
YANK4	CALL	$GET		;Get a header length
	LD	B,A		;Set loop counter
	LD	A,(NAMLEN$)	;P/u fix file name length
	CP	B		;Ignore & ck next fix
	JR	NZ,YANK2	;If name lengths differ
	LD	HL,NAMFIX$	;Pt to yank file name
YANK5	CALL	$GET1		;Ck for match of yank
	JP	NZ,YANK2	; file name with prog
	CP	(HL)		; patch name
	INC	HL
	JR	NZ,YANK3	;Find the next fix
	DJNZ	YANK5
; found this fix patch - let's yank er!
YANK6	CALL	$GET		;Get type code
	CP	1		;Ignore block if
	JP	NZ,YANK8	; type <> 1
	LD	A,1		;Set LRL=1 & backspace
	LD	(PGMDCB+9),A
	CALL	$BKSP
	XOR	A		;Set LRL back to 256
	LD	(PGMDCB+9),A
	LD	A,10H		;Change type=1 to =16
	CALL	$PUT
	CALL	$RWRIT		;force re-write
	CALL	$GET		;Get length byte
	LD	B,A		;Set counter - it better
YANK7	CALL	$GET		;Be less than 256!
	DJNZ	YANK7
	JR	YANK6		;Loop through patch types
YANK8	POP	HL		;Twaren't type 1, advance
	LD	A,0FFH		;Flag for exit msg
	LD	(YNKFLG),A	;That fcn was YANK
	JP	PCHDUN
YANK9	CP	1CH		;Got $GET error
	JP	NZ,IOERR	;End of file?
	LD	HL,NOYANK$	;"can't yank, not in file
	JP	ERREXIT
; verb = 'O' -> turn FIND on/off
OVERB	INC	HL		;Move past O
	LD	A,(HL)
	CP	'='
	JR	NZ,WHATIS	;Look for =
	INC	HL		;Added 12/29/82 RS
	LD	A,(HL)
	CP	CR
	JR	Z,OISOFF	;O=<enter> is OFF
	RES	5,A
	CP	'N'
	JR	Z,OISOFF	;O=N,NO etc.
	CP	'Y'
	JR	Z,OISON
	CP	'O'
	JR	NZ,WHATIS	;Not Y/N/ON/OFF!
	CALL	GETNXT
	CP	'F'
	JR	Z,OISOFF	;OFF
	CP	'N'
WHATIS	JP	NZ,PCHERR	; not on/off/y/n
OISON	DB	3EH		;LD A,0AFH
OISOFF	XOR	A
	LD	(OPARM),A
	DEC	HL
	JP	COMMENT		;Ignore line
; verb = 'L' -> indicate patch to library file
LVERB	INC	HL		;Bypass the 'L'
	CALL	PRSFIX		;Get a hex digit pair
	LD	C,A		;Stuff for later
	LD	(OVRLY+1),A
	LD	A,(HL)		;Ck for end of line
	INC	HL
	CP	CR
	JP	NZ,PCHERR	;Error if not
	CALL	FISAM		;Get isam overlay ptrs
	PUSH	AF		;Save byte offset
	LD	A,(PGMDCB+1)
	RES	7,A		;Sector operations only!
	LD	(PGMDCB+1),A
	LD	DE,PGMDCB	;Position the file to
	CALL	$POSN		;Overlay requested
	CALL	$READ		;Read in the sector
	POP	AF
	LD	(PGMDCB+5),A	;Stuff byte offset -> FCB
	CALL	POSFIL		;Adv "positioning...
	CP	4		;End of ISAM overlay?
	JP	NZ,FILERR	;If not, "load format er.
	LD	A,1		;Set LRL=1
	LD	(PGMDCB+9),A
	CALL	$BKSP		;Backspace over the 4
	XOR	A		;Now set LRL back to 256
	LD	(PGMDCB+9),A
	CALL	STUFNM		;Do the patch
	PUSH	HL
	LD	HL,BLDMAP$	;"rebuilding library map.
	CALL	$DSPLY
	CALL	RPRMAP		;Rebuild the map
	POP	HL
	JP	DOFIX1		;Loop
; routine to position to file's end
POSFIL	PUSH	HL
	PUSH	DE
	LD	HL,POSLD$	;"positioning ...
	CALL	$DSPLY
	POP	DE
	POP	HL
POSFIL1	CALL	$GET		;Get a type byte
	CP	20H		;X'20' & up are comments
	JP	NC,FILERR
	CP	2		;Transfer address?
	RET	Z
	CP	3		;Not really used in
	RET	Z		; a file, yet...
	CP	4		;End of ISAM member?
	RET	Z
	CP	0AH		;End of ISAM directory?
	RET	Z
	LD	C,A		;Save type byte
	CALL	$GET		;Get block length
	LD	B,A		;Save it for countdown
	DEC	C		;Was type = 1 ?
	JR	NZ,POSFIL2	;Jump if not
	CALL	$GET		;Read off the load addr
	DEC	B		;Adjust length for each
	CALL	$GET
	DEC	B
POSFIL2	CALL	$GET		;Read the block
	DJNZ	POSFIL2
	JR	POSFIL1		;Loop to next type code
; routine to stuff the fix file name as label
STUFNM	PUSH	HL
	LD	HL,GENPCH$	;"generating patch...
	CALL	$DSPLY
	LD	DE,PGMDATA
	LD	HL,NAMLEN$	;Pt to fix name field
	LD	A,(HL)
	OR	A
	JR	Z,STUFNM2
	LD	A,7		;Set fix patch type
	LD	(DE),A
	INC	DE
	LD	B,(HL)		;Set header length
	INC	B		;Bump to write length
STUFNM1	LD	A,(HL)		;P/u header byte
	INC	HL
	LD	(DE),A		;Put in output buffer
	INC	DE
	DJNZ	STUFNM1
STUFNM2	POP	HL		;Stuff fix file name
STUFNM3	LD	(SETMSG+1),HL	;Address for joblog
	LD	A,(HL)
	CP	ETX		;End of text?
	JP	Z,RIPPLE
	INC	HL
	CP	'.'		;Comment?
	JR	Z,STUFNM4
	RES	5,A		;In case lower case
	CP	'X'		;Patch address?
	JR	Z,DOXVB
	JP	PCHERR		;"patch input format err
STUFNM4	LD	A,(HL)		;Ignore comments
	INC	HL
	CP	ETX
	JP	Z,PCHERR
	CP	CR
	JR	NZ,STUFNM4
	JR	STUFNM3
; do the 'X' verb patch
DOXVB	CALL	CNTLIN		;Count installed lines
	LD	A,1		;Show type 1
	LD	(DE),A
	INC	DE
	PUSH	DE		;Save ptr to length
	INC	DE
	LD	A,(HL)		;Should be "'"
	INC	HL
	CP	27H
	JP	NZ,PCHERR	;Error if not
	CALL	PRSFIX		;P/u hex digit pair
	LD	B,A		;Save hi-order address
	CALL	PRSFIX		;P/u hex digit pair
	LD	(DE),A		;Stuff lo-order address
	INC	DE
	LD	A,B
	LD	(DE),A		;Stuff hi-order address
	INC	DE
	LD	A,(HL)		;Syntax requires '=' next
	CP	'='
	JR	Z,DOXVB1
	CP	27H		;Bypass optional clsng '
	JP	NZ,PCHERR
	INC	HL
DOXVB1	INC	HL		;Bypass the '='
	LD	B,2		;Init len to 2 for
DOXVB2	LD	A,(HL)		;Load address len
	CP	'"'		;Ascii string?
	JR	Z,DOXVB5	;Bypass if so
DOXVB3	LD	A,(HL)		;P/u line byte
	INC	HL
	CP	';'		;Logical end?
	JR	Z,DOXVB4	;Ignore trailing
	CP	CR		;End of line?
	JR	Z,DOXVB6
	CP	20H
	JR	Z,DOXVB2	;Ignore spaces
	DEC	HL		;Back up, its a byte
	CALL	PRSFX1		;Get the hex digit pair
	LD	(DE),A		;Stuff into code buffer
	INC	DE
	INC	B		;Bump block length
	JR	DOXVB3
; fix format has double quote
DOXVB4	LD	A,(HL)		;P/u the character
	INC	HL
	CP	CR		;End of line?
	JR	NZ,DOXVB4
	JR	DOXVB6
; fix has double quote string
DOXVB5	INC	HL
	LD	A,(HL)		;Get next char
	CP	ETX		;End meof text?
	JP	Z,PCHERR	;Can't end w/o '"'
	INC	HL
	CP	CR		;End of line?
	JP	Z,DOXVB6	;Valid end
	CP	'"'		;Closing quote?
	JR	Z,DOXVB3	;Go for more
	DEC	HL
	LD	(DE),A		;Stuff the char
	INC	DE
	INC	B		;Bump counter
	JR	DOXVB5		;Loop until end or "
; found valid end - update length
DOXVB6	EX	(SP),HL		;Grab length pointer
	LD	(HL),B		;Stuff the length
	POP	HL
	JP	STUFNM3
; got to the end of the fix input
RIPPLE	PUSH	HL
	EX	DE,HL		;Last patch byte to HL
	LD	DE,PGMDATA	;Pt to patch code buffer
	XOR	A
	SBC	HL,DE		;Calc length of fixup
	LD	(RPRMAP9+1),HL	;Stuff for later
	LD	HL,INSPCH$	;"installing patch
	CALL	$DSPLY
	LD	HL,PGMDCB	;Move prog into fix
	LD	DE,FIXDCB	;File control block
	LD	BC,32		;For output use
	LDIR
	LD	HL,LIBBUF	;Set the i/o buffer
	LD	(FIXDCB+3),HL
	LD	DE,FIXDCB	;Reread the last program
	@@RREAD			;Sector
	JP	NZ,IOERR
; now ripple the file down while stuffing bytes
	LD	HL,PGMDATA	;Beginning of fix code
RIPPL1	LD	DE,FIXDCB	;Get prog byte
	CALL	$GET1
	JP	NZ,RIPPL2
	PUSH	HL		;Save buffer ptr & byte
	PUSH	AF
	LD	DE,PGMDCB	;Use the output fcb
	LD	A,(HL)		;P/u byte from fixbuf
	CALL	$PUT		;Put to disk
	LD	BC,(RPRMAP9+1)	;Pt to patch length
	ADD	HL,BC		;Pt past patch code
	POP	AF		;Recover prog byte
	LD	(HL),A		;& stuff after fix code
	POP	HL		;Rcvr buf ptr
	INC	HL		;Bump & loop
	JR	RIPPL1
RIPPL2	CP	1CH		;Got to end of file?
	JP	NZ,FILERR
	LD	DE,PGMDCB
	LD	BC,(RPRMAP9+1)	;Get length of patch
RIPPL3	LD	A,(HL)		;Put rest of program
	INC	HL		;(ie the bytes = to
	CALL	$PUT		; length of patch code
	DEC	BC
	LD	A,B
	OR	C
	JR	NZ,RIPPL3
	POP	HL
	RET
; routine to read & convert fix code values
PRSFIX	XOR	A		;Entry to clear
	LD	(STRFLG+1),A	; STRING check
PRSFX1	LD	A,(HL)		;P/u patch char
	CP	ETX		;End of text?
	JP	Z,PCHERR
	CP	'"'		;String?
	JR	NZ,STRFLG
	LD	(STRFLG+1),A	;Stuff string indicator
	INC	HL
	LD	A,(HL)		;P/u char
	CP	ETX		;End again?
	JP	Z,PCHERR
STRFLG	LD	A,0		;Test string flag
	OR	A
	LD	A,(HL)		;P/u char again
	INC	HL		;Bump pointer
	RET	NZ		;Ret if '"' was prev char
	CALL	CVTBIN		;Convert hex digit to bin
	LD	C,A		;Save value
	LD	A,(HL)		;P/u next digit
	INC	HL
	CP	ETX		;Backup pointer and ret
	JP	Z,PCHERR	;If next char is not hex
	CP	'0'		;Else pack it into regC
	JR	C,PRSFX3	;& place in reg A
	CP	'9'+1
	JR	C,PRSFX2
	CP	'A'
	JR	C,PRSFX3
PRSFX2	RLC	C		;Assume digit, move
	RLC	C		;Over a nybble
	RLC	C
	RLC	C
	CALL	CVTBIN		;Get hex digit
	OR	C		;Merge hi-order nybble
	RET
PRSFX3	LD	A,C		;Non-hex char,
	DEC	HL		; rcvr & exit
	RET
; routine to convert hex digit to binary
CVTBIN	SUB	30H		;1st adjustment to binary
	JP	C,NONHEX
	CP	10		;0-9 range?
	RET	C
	RES	5,A		;In case lower case
	SUB	7
	CP	16
	RET	C
	JP	NONHEX
; routine to find ISAM member pointer in map table
FISAM	LD	DE,PGMDCB
FISAM1	CALL	$GET1		;Get a type byte
	JR	Z,FISAM1A	;Go on no error
	CP	1CH		;EOF?
	JP	Z,LIBERR	;Invalid library format
	JP	IOERR		;  else I/O error
FISAM1A	CP	8		;Start of map table?
	JR	Z,FISAM3
	CP	0AH		;End of map table?
	JP	Z,NOVRLY
	PUSH	BC
	LD	C,A		;Save TYPE
	CALL	$GET		;Get block length
	LD	B,A		;Set counter & read
	DEC	C
	JR	NZ,FISAM1B	;Go if not load record
	CALL	$GET		;  else read 1st two
	DEC	B		;  bytes & then fall thru
	CALL	$GET		;  in case len=01 or 02
	DEC	B
FISAM1B	LD	A,B
	POP	BC
	LD	B,A
FISAM2	CALL	$GET		;Through the block
	DJNZ	FISAM2
	JR	FISAM1		;Go back for more
; found a map field
FISAM3	CALL	$GET		;Get field length
	LD	B,A		;Set counter
	CALL	$GET		;Get overlay #
	DEC	B		;Reduce count
	CP	C		;Is this the one?
	JR	NZ,FISAM2	;Loop to next field
	CALL	$GET		;Get lo-order traadr
	CALL	$GET		;Get hi-order transfer
	CALL	$GET		;Get lo-order NRN
	LD	C,A		;Save in C
	CALL	$GET		;Get hi-order NRN
	LD	B,A		;Save in B
	CALL	$GET		;Get byte offset
	RET
; routine to repair the library map
RPRMAP	LD	DE,PGMDCB	;Rewind the file
	LD	BC,0
	CALL	$POSN
	LD	HL,PGMDATA	;Pt to buffer area
RPRMAP1	CALL	$GET		;Read the map into buf
	CP	0AH		;End of table?
	JR	Z,RPRMAP3
	LD	(HL),A		;Save type code
	CALL	$GET		;Get length
	LD	B,A		;Set counter
	LD	A,(HL)		;Reget the TYPE
	INC	HL		;Bump where to stuf len
	DEC	A		;Is this a load record?
	LD	(HL),B		;Put length in too
	INC	HL
	JR	NZ,RPRMAP2	;Go if other type
	CALL	$GET		;  else get two extra
	DEC	B		;  & adjust length in
	LD	(HL),A		;  case len = 01 or 02
	INC	HL
	CALL	$GET
	DEC	B
	INC	HL
	LD	(HL),A
RPRMAP2	CALL	$GET		;Save member # & rest of
	LD	(HL),A		;  data entries
	INC	HL
	DJNZ	RPRMAP2
	JR	RPRMAP1
; found end of table
RPRMAP3	LD	(HL),A		;Show map end
	LD	HL,PGMDATA	;Pt to beginning
RPRMAP4	LD	A,(HL)		;P/u type code
	INC	HL
	LD	B,(HL)		;P/u length
	INC	HL
	CP	8		;Map is type 8
	JR	Z,RPRMAP6
	CP	0AH		;End of map?
	JP	Z,NOVRLY	;Should not have gotten
	DEC	A
	JR	NZ,RPRMAP5
	INC	HL		;You should know what
	DEC	B		;  this is for by now
	INC	HL
	DEC	B
RPRMAP5	INC	HL		;Bypass this field
	DJNZ	RPRMAP5
	JR	RPRMAP4
; found a type 8, check if ISAM # matches
RPRMAP6	LD	A,(HL)		;P/u member #
	INC	HL
	DEC	B		;Count down
OVRLY	CP	0		;Compare to patched one
	JR	NZ,RPRMAP5	;Keep reading until found
	INC	HL		;Bypass transfer address
	INC	HL
	LD	E,(HL)		;P/u the position lo
	INC	HL
	LD	D,(HL)		;& the pos hi
	INC	HL
	LD	C,(HL)		;& the byte offset
	LD	A,B		;Calc ptr to next field
	SUB	4
	LD	B,A
	INC	HL
	DJNZ	$-1		;Loop to next field
RPRMAP7	LD	A,(HL)		;End of table?
	CP	0AH		;If end, write the
	JR	Z,RWRMAP	;Map back to disk
	INC	HL		;Pt to field length
	LD	B,(HL)
	INC	HL		;Pt to member #
	INC	HL		;Transfer Low
	INC	HL		;Transfer High
	INC	HL		;NRN Low
	LD	A,B		;Adjust count for
	SUB	4		;  4 INC HLs
	LD	B,A
	LD	A,(HL)		;If position is the same
	INC	HL		;As that of patched
	CP	E		;One, its posn has not
	JR	NZ,RPRMAP8	;Changed, so don't
	LD	A,(HL)		;Change it
	INC	HL
	DEC	B
	CP	D
	JR	NZ,RPRMAP9
	LD	A,(HL)
	CP	C
	JR	NZ,RPRMAP9
LPFLD	INC	HL
	DJNZ	$-1		;Loop to end of field
	JR	RPRMAP7
; add the patch length to each position vector
RPRMAP8	INC	HL		;Bump to offset byte
	DEC	B
RPRMAP9	LD	DE,0		;P/u patch length
	LD	A,(HL)		;P/u offset & add
	ADD	A,E		;Lo-order patch length
	LD	(HL),A
	DEC	HL		;Pt to NRN
	DEC	HL
	LD	A,(HL)		;P/u NRN lo-order
	ADC	A,D		;Add to it
	LD	(HL),A
	INC	HL		;Pt to pos hi order
	LD	A,(HL)		;P/u the hi
	ADC	A,0		;Add in any carry
	LD	(HL),A
	INC	HL		;Pt to next map field
	LD	DE,0
	JR	LPFLD		;Loop
; routine to re-write the library map table
RWRMAP	LD	DE,PGMDCB	;Rewind the program file
	LD	BC,0
	CALL	$POSN
	LD	HL,PGMDATA	;Pt to mapbuf start
RWRMAP1	LD	A,(HL)		;Ret when we get to
	CP	0AH		;The map end type
	RET	Z
	LD	C,A		;Save the type
	INC	HL
	CALL	$PUT		;Put the type
	LD	A,(HL)		;P/u length
	INC	HL
	LD	B,A		;Save as counter
	CALL	$PUT		;Put out the length
	DEC	C		;Again, by now...
	JR	NZ,RWRMAP2
	LD	A,(HL)
	INC	HL
	CALL	$PUT
	DEC	B
	LD	A,(HL)
	INC	HL
	CALL	$PUT
	DEC	B
RWRMAP2	LD	A,(HL)		;Put block of code
	INC	HL
	CALL	$PUT
	DJNZ	RWRMAP2
	JR	RWRMAP1		;Loop for more
;*=*
SPASS2	LD	(PASS2),A	;Flag pass 2
	JP	DOFIX		;Start over
PASS1	CP	'.'
	JR	Z,OK	
	CP	ETX
	JR	Z,SPASS2	;End of pass1
	RES	5,A
	CP	'D'
	JR	Z,FCHK
	CP	'R'
	JP	Z,REMOVE
	CP	'O'
	JP	Z,OVERB
	CP	'F'
	JR	Z,OK
	CP	'Y'
	JR	Z,OK
	CP	'L'
	JR	Z,OK
	CP	'X'
	JP	NZ,PCHERR
OK	JP	COMMENT
;*=*=*
FCHK	LD	A,0FFH
OPARM	EQU	$-1		;SET  Z IF O=OFF
	OR	A
	JP	Z,COMMENT	;Skip check if 0=OFF
	LD	A,$-$		;YANKING?
RPARM	EQU	$-1
	OR	A		;(can't if O=off)
	JP	NZ,YANKD	;Reverse D & F lines
	LD	(DL),HL		;Save D pointer
	CALL	SKPLN		;Move to F line
	CALL	DOCHK		;Cp f line bytes w/file
	JP	DOFIX1
;
DOCHK	LD	(SETMSG+1),HL	;Set line error msg
	PUSH	HL		;Save posn
	LD	DE,(DL)		;Get D line
	LD	B,3
CP3	INC	HL
	INC	DE
	LD	A,(DE)
	CP	(HL)
	JP	NZ,FERROR	;'FIND' error
	DJNZ	CP3		;Ck d & f positioning
	LD	B,3
	LD	A,','		;Comma?
	CP	(HL)
	JR	Z,CP5		;Then two digit rec num
	LD	B,5		;Allow 4 digit rec num
CP5	INC	HL
	INC	DE
	LD	A,(DE)
	CP	(HL)
	JP	NZ,FERROR	;'FIND' error
	DJNZ	CP5		;Ck d & f positioning
	EX	(SP),HL		;=>f line/save pointer to '='
	CALL	DPOSN		;Posn file
	POP	HL
	CALL	DLINE		;Check against f line
	RET
;*=*=*
YANKD	PUSH	HL		;Save D line pointer
	CALL	SKPLN		;Move to F line
	LD	(DL),HL		;Save pointer
	POP	HL		;=>D line
	PUSH	HL		;Save D line again
	CALL	DOCHK		;Test D line
	POP	HL		;=>'D' 
	LD	(HL),'.'	;Make comment for pass2
	LD	HL,(DL)	
	LD	(HL),'D'	;Make 'F' line into D line
	CALL	SKPLN		;=>next line
	JP	DOFIX1
;*=*=*
SKPLN	CALL	SKPLN1		;move past D line
	LD	A,(HL)		;check char
	CP	'.'		;is it comment?
	JR	Z,SKPLN		;then skip it
	RET
SKPLN1	LD	A,(HL)
	INC	HL		;Move to next line
	CP	CR
	RET	Z
	CP	';'
	RET	Z
	JR	SKPLN
GETNXT	LD	A,(HL)
	INC	HL
	RES	5,A
	RET
PUTORCHK	LD	C,A
	LD	A,(PASS2)
	OR	A
	LD	A,C
	JP	NZ,$PUT		;Writing patch..
	CALL	$GET
	CP	C		;Match w/patch?
	RET	Z		;OK if match
FERROR	LD	HL,LOCERR$
	JP	ERRDSP		;If mismatch
;
CNTLIN	PUSH	HL
	LD	HL,(LINCNT)
	INC	HL
	LD	(LINCNT),HL
	POP	HL
	RET
FLOPN	LD	A,(WRFLAG)	;Did we modify file?
	OR	A
	JR	NZ,MESS		;Yes, don't close it
	@@CLOSE			;No changes
	JP	NZ,IOERR
	RET
MESS	LD	HL,WARN1$	;File is modified but
	CALL	$DSPLY		;PATCH did not complete
	LD	HL,WARN2$	; "oops...
	JP	$DSPLY		;Then return to caller
$OPEN	@@OPEN
	JR	NZ,IOERR
	RET
$POSN	@@POSN
	JR	NZ,IOERR
	RET
$BKSP	@@BKSP
	JR	NZ,IOERR
	RET
$RWRIT	@@RWRIT
	JR	NZ,IOERR
	RET
$GET1	@@GET			;Use this one if prog might get EOF
	RET
$GET	@@GET			;This one if EOF is also error
	JR	NZ,IOERR
	RET
$PUT	PUSH	BC
	LD	C,A
	LD	A,0FFH		;Flag..
	LD	(WRFLAG),A	;That file is modified
	@@PUT
	POP	BC
	JR	NZ,IOERR
	RET
$DSPLY	@@DSPLY
	JR	NZ,IOERR
	RET
$READ	@@READ
	JR	NZ,IOERR
	RET
$DSP	PUSH	BC
	LD	C,A
	@@DSP
	POP	BC
	RET	Z		;If OK else fall error
; error handling
IOERR	LD	L,A
	LD	H,0
	OR	0C0H
	LD	C,A
	@@ERROR
	JR	QUIT1
NOVRLY	LD	HL,NOVRLY$
	DB	0DDH
LIBERR	LD	HL,LIBERR$
	DB	0DDH
FILERR	LD	HL,FILERR$
	DB	0DDH
PRMERR	LD	HL,PRMERR$
	DB	0DDH
TOOBIG	LD	HL,TOOBIG$
	DB	0DDH
PGMREQ	LD	HL,PGMREQ$
ERREXIT	@@LOGOT
	LD	HL,-1
QUIT1	JP	$QUIT
NONHEX	LD	HL,NONHEX$
	DB	0DDH
PCHERR	LD	HL,PCHERR$
ERRDSP	PUSH	HL
	LD	A,CR
	CALL	$DSP
SETMSG	LD	HL,0
	@@LOGOT
	POP	HL
	JR	ERREXIT
YNKFLG	DB	0		;Was function YANK?
LINCNT	DW	0		;Count lines installed
WRFLAG	DB	0		;Did pgm write to file?
DL	DW	0		;Save pointer to line
CMDEXT	DB	'CMD'
FIXEXT	DB	'FIX'
PGMDCB	DB	0
	DS	32
FIXDCB	DS	32
HELLO$	DB	'PATCH'
*GET	CLIENT:3
PGMREQ$	DB	'PROGRAM file name required',CR
PRMERR$	DB	'Parameter error',CR
POSLD$	DB	29,'Positioning load file',30,32,3
RDGINP$	DB	29,'Reading input',30,32,3
GENPCH$	DB	29,'Generating patch',30,32,3
INSPCH$	DB	29,'Installing patch',30,32,3
BLDMAP$	DB	29,'Re-building library map',30,32,3
YNKPCH$	DB	29,'Yanking patch from file',30,32,3
NOYANK$	DB	LF,'Can''t yank, '
	DB	'patch not in load file',CR
NOVRLY$	DB	'Library overlay not found',CR
LIBERR$	DB	'Invalid library format',CR
PCHERR$	DB	'Patch input format error',CR
FILERR$	DB	'Load file format error',CR
NONHEX$	DB	'Non-hex digit encountered',CR
SUCCES$	DB	LF,'Patch function completed.',CR
LINMSG$	DB	'   No patch line'
PLURAL	DB	's installed.',CR
TOOBIG$	DB	'Fix file too big - partition it',CR
YANKMSG	DB	'Patch successfully yanked',CR
NAMLEN$	DB	3		;Length of fix file name
NAMFIX$	DB	'CLP     '	;Fix file name
LOCERR$	DB	'FIND line mismatch',CR
WARN1$	DB	'WARNING - File '
FNM$	DB	'                        '
WARN2$	DB	' Not Closed',CR
PTBL$	DB	80H
	DB	FLAG!ABB!6
	DB	'REMOVE',0
	DW	RPARM1
	DB	FLAG!1
	DB	'O',0
	DW	OPARM1
	NOP
	ORG	$<-8+1<+8
FIXBUF	DS	256		;I/O buffer for /FIX
LIBBUF	DS	256		;I/O buffer for ISAM
PGMBUF	DS	256		;I/O buffer for PGM
FIXDATA	DS	1400H		;5k alloted for fix data
PGMDATA	EQU	$		;Takes the rest of core
	END	BEGIN
