;PARAM/ASM - Part of LDOS 6.2 - 10/21/83
;*****
;	parse a field
;	(HL) => command line
;	(DE) => FCB area
;	(HL) <= 1st byte past non-<A-Z, a-z, 0-9>
;		except 13, 3, "("
;	Z    <= found valid field
;	NZ   <= found invalid field
;*****
@PARSER	LD	B,8		;set length
@PAR1	LD	A,B
	LD	(PAR6+1),A	;Stuff length for test
	INC	B
PAR2	LD	A,(HL)
	CP	3		;ETX?
	JR	Z,PAR5
	CP	CR		;<ENTER>?
	JR	Z,PAR5
	CP	'('		;begin of parm?
	JR	Z,PAR5
	INC	HL		;Bump pointer to next
	CALL	TST09AZ		;Test if 0-9,A-Z
	JR	NC,PAR3		;Go if one of the above
	CP	'a'		;Check on lower case
	JR	C,PAR5		;jump on non-alpha
	CP	'z'+1		;Is it a-z?
	JR	NC,PAR5		;jump on non-alpha
	RES	5,A		;convert lower to upper
PAR3	DEC	B		;count down
	JR	Z,PAR4
	LD	(DE),A		;xfer the char
	XOR	A		;show at least 1 valid
	LD	(PAR6+1),A	;char was detected
	INC	DE		;bump FCB pointer
	JR	PAR2		;loop
PAR4	INC	B		;here on max chars ck'd
	JR	PAR2
PAR5	LD	C,A		;save separator
	LD	A,3		;stuff ETX
	LD	(DE),A
;*=*=*
;	Skip over spaces
;*=*=*
	LD	A,C		;Was separator a space?
	CP	' '
	JR	NZ,PAR6		;Don't skip if not
PAR5A	CP	(HL)		;Next char a space?
	INC	HL
	JR	Z,PAR5A		;Loop until not
	DEC	HL		;Backup to last non-space
;*=*=*
;	Return status of field validity
;*=*=*
PAR6	LD	A,0		;set Z-flag if at least
	OR	A		;1 valid char detected
	LD	A,C		;recover separator char
	RET
;*=*=*
;	Test if 0-9 or A-Z
;*=*=*
TST09AZ	CP	'0'		;Special character?
	RET	C		;Go if not in range
	CP	'9'+1		;jump on digit 0-9
	JR	C,EXITC		;Go if 0-9 & make NC
	CP	'A'		;jump on spec char
	RET	C		;Go with C-flag if 3B-40
	CP	'Z'+1		;jump on A-Z
EXITC	CCF			;Switch flag of result
	RET
;*****
;	find parameter in table
;	(HL) => pointer to line
;	(DE) => pointer to buffer area
;	(BC) => pointer to parameter table
;	(BC) <= pointer to possible response byte
;	(DE) <= parm vector address
;	  Z <= set if found
;	 NZ <= if not found in table
;*****
@FNDPRM	PUSH	HL
	LD	H,B		;xfer table addr
	LD	L,C
	LD	A,(HL)		;P/u 1st byte of table
	RLCA			;  & test for enhanced
	PUSH	AF		;  table format
	JR	NC,FND1
	INC	HL		;Bump past indicator
FND1	POP	AF		;Old or enhanced format?
	PUSH	AF
	LD	A,5		;Init for old lengths
	LD	BC,1<8!2
	JR	NC,FND1A	;Branch if old format
	LD	A,(HL)		;  else get parm length
	AND	0FH		;Strip flags
	DEC	A		;Adjust for length-1
	INC	B		;Update offset to address
	INC	HL		;Bump past TYPE byte
FND1A	LD	(FND3A+1),A	;Stuff the lengths
	ADD	A,B
	LD	(FND5A+1),A
	ADD	A,C
	LD	(FND2+1),A
	LD	A,(DE)		;p/u command line byte
	CP	(HL)		;match 1st char of table?
	JR	Z,FND3		;jump if 1st char matches
FND2	LD	BC,8		;  else bypass that entry
	ADD	HL,BC
	LD	A,(HL)		;test for table end
	OR	A
	JR	NZ,FND1		;loop if more
	POP	HL		;Clean flag from stack
	POP	HL		;Rcvr saved reg &
	INC	A		;  set NZ for not found
	RET
FND3	POP	AF		;Ck old or new table
	PUSH	AF
	JR	NC,FND3A	;Go if old format table
	DEC	HL		;Ck if type byte permits
	BIT	4,(HL)		;  single-char abbrev
	INC	HL
	JR	Z,FND3A		;Go on no abbrev
	INC	DE		;Make sure the next char
	LD	A,(DE)		;  is not in the range
	DEC	DE		;  <0-9,A-Z> before
	CALL	TST09AZ		;  assuming abbrev
	JR	C,FND5A		;Go on 1-char abbrevs
FND3A	LD	B,5		;5 more chars to match
	PUSH	HL
	PUSH	DE
	LD	A,B		;Don't if trailing length
	OR	A		;  is zero
	JR	Z,FND5
FND4	INC	DE
	INC	HL
	LD	A,(DE)
	CP	3		;ETX?
	JR	Z,FND7
	CP	CR		;jump on <ENTER>
	JR	Z,FND7
	CP	(HL)		;match?
	JR	NZ,FND6		;jump if not
	DJNZ	FND4		;else loop
FND5	POP	DE		;parm matched
	POP	HL		;recover begin of parm
FND5A	LD	BC,6		;point to address field
	ADD	HL,BC
	LD	C,L		;Save the response-byte
	LD	B,H		;  pointer in BC
	DEC	BC
	LD	E,(HL)		;p/u parm table address
	INC	HL
	LD	D,(HL)
	POP	AF		;If not enhanced, change
	JR	C,$+4		;  pointer to bucket
	LD	B,SBUFF$<-8	;  so we don't alter user
	POP	HL		;recover line position
	XOR	A		;show found
	RET
FND6	CALL	TST09AZ		;Ck if 0-9, A-Z
	JR	NC,FND8		;Go if in range of above
FND7	LD	A,(HL)		;Loop if table has
	CP	' '		; trailing spaces
	JR	Z,FND5
FND8	POP	DE
	POP	HL
	JR	FND2
;*****
;	PARAM routine
;	 (HL) => param line
;	 (DE) => parm table
;	 (DE) <= table address value
;	    C <= # of parm
;	    Z = OK
;	   NZ = parm error
;*****
PARAM0	INC	HL
PARAM	LD	A,(HL)
	CP	CR
	RET	Z		;return on enter
	CP	' '
	JR	Z,PARAM0	;loop on space
	CP	'('
	JR	NZ,PARAM5	;jump if not left paren
	LD	A,(DE)		;Check if enhanced table
	RLCA
	JR	NC,PARAM1
	PUSH	DE		;Save pointer to start
	INC	DE		;Point to 1st TYPE byte
	PUSH	HL		;Save this reg
$?1	LD	A,(DE)		;P/u TYPE byte
	AND	0FH
	JR	Z,$?2		;Exit on end of table
	LD	L,A		;Point to response byte
	LD	H,0
	INC	L
	ADD	HL,DE
	LD	(HL),0		;Zero the response
	INC	HL		;Bump to the next TYPE
	INC	HL
	INC	HL
	EX	DE,HL		;Table pointer back to DE
	JR	$?1
$?2	POP	HL		;Rcvr reg
	POP	DE		;  & start of parm table
PARAM1	PUSH	DE
	LD	B,15		;max 15-char field
	LD	DE,SBUFF$	;point to buffer region
	INC	HL		;bypass the '('
	CALL	@PAR1		;get the field
	DEC	HL		;backup to separator
	POP	DE
	JR	NZ,ERROUT	;return if bad field
	CP	CR		;If separator was a CR,
	JR	NZ,$+3		; we need to counteract
	INC	HL		; the DEC HL above
	PUSH	DE
	LD	B,D
	LD	C,E
	LD	DE,SBUFF$	;parm in table?
	CALL	@FNDPRM
	PUSH	BC		;Save response pointer
	JR	Z,PARAM3	;jump if found in table
;*=*=*
;	Parameter not in table - NZ condition
;*=*=*
PARAM2	POP	DE		;Pop response pointer
	POP	DE		;Pop parm table pointer
ERROUT	LD	A,44		;Set up PARM ERROR
	RET
;*=*=*
;	Parameter found in table - parse the value
;*=*=*
PARAM3	LD	A,(HL)		;test for assignment
	CP	'='
	JR	Z,ASSIGN	;jump if parm=value
	LD	BC,-1		;else set symbol TRUE
PARMSW	EX	(SP),HL		;Get response byte
	SET	6,(HL)		;Turn on FLAG-SWITCH
;*=*=*
;	Valid parm argument parsed into reg BC
;*=*=*
PARAM4	EX	DE,HL		;Address pointer to HL
	LD	(HL),C		;Stuff lo-order value
	INC	HL
	LD	(HL),B		;Stuff hi-order value
	POP	HL		;Rcvr parm line pointer
	POP	DE		;Rcvr parm table pointer
	LD	A,(HL)
	CP	','		;comma separator?
	JR	Z,PARAM1
	CP	CR
	JR	Z,PARAM5
	CP	')'		;closing paren?
	JR	NZ,ERROUT	;leave with ERROR
	INC	HL		;bump line pointer
PARAM5	XOR	A		;show all OK
	RET
;*****
;	parameter assignment statement
;*****
ASSIGN	INC	HL		;advance token past '='
	LD	A,(HL)
	CP	'"'		;double quote string?
	JR	Z,STRING
	CP	'A'		;ck on digit or
	JR	C,ASS3		;special character
	RES	5,A		;strip l/c if present
	CP	'X'		;hexadecimal?
	JR	Z,ASS1
	CALL	ONOFF		;ck on Y, N, ON, OFF
	JR	Z,PARMSW	;Set FLAG-SWITCH if OK
	JR	PARAM2		;  else error exit
ASS1	INC	HL
	CALL	HEXVAL		;ck on hex format
	JR	NZ,PARAM2	;Error if bad format
	JR	ASS3A		;  else bypass & set resp
;****
;	Is the parameter numeric or flag ?
;****
ASS3	CP	'0'		;parameter=number ?
	PUSH	AF		;CF = 0 if number
	CALL	@DECHEX		;cvt # @ HL to bin in DE
	POP	AF		;
ASS3A	EX	(SP),HL		;Get response pointer
	JR	NC,ASS4		;Show numeric if CF=0
	SET	6,(HL)		;otherwise show switch
	DB	LD___A		;skip next instruction
ASS4	SET	7,(HL)		;Set Numeric response bit
	JR	PARAM4
;*****
;	parameter string entry
;*****
STRING	INC	HL		;bypass '"'
	LD	B,H		;save starting address
	LD	C,L
STR1	LD	A,(HL)		;p/u a char
	CP	20H
	JR	C,PARAM2	;exit on control char
	INC	HL		;bump pointer
	CP	'"'		;closing double quote
	JR	NZ,STR1
	PUSH	HL		;Save current pointer
	SBC	HL,BC		;Calc length of string
	LD	A,L
	DEC	A		;Adjust for INC HL
	CP	32		;If len > 31, set to 0
	JR	C,$+3
	XOR	A
	POP	HL		;Rcvr pointer
	EX	(SP),HL		;Get response byte
	OR	20H		;Set FLAG-STRING
	LD	(HL),A
	JR	PARAM4
;*****
;	check for Yes, No, On, Off
;*****
ONOFF	LD	BC,0		;init to FALSE
	SUB	'Y'		;Is it Yes?
	JR	Z,ONO1		;jump on yes
	ADD	A,'Y'-'N'	;Is it No?
	JR	Z,ONO2		;jump on no
	DEC	A		;Is it 'O'n or 'O'ff?
	RET	NZ		;return if not on/off
	INC	HL		;Bump pointer to next
	LD	A,(HL)		; character & P/U
	RES	5,A		;Set lower to upper
	CP	'F'
	JR	Z,ONO2		;jump on off
	CP	'N'
	RET	NZ		;return if not on
ONO1	LD	BC,-1		;init to true
ONO2	INC	HL		;ignore trailing part
	LD	A,(HL)		;  of word until closing
	CP	')'		;  ")" or comma separator
	RET	Z
	CP	CR
	RET	Z
	CP	','
	RET	Z
	JR	ONO2		;loop
;*****
;	process hexadecimal assignment
;*****
HEXVAL	LD	BC,0		;init value to zero
	LD	A,(HL)		;p/u a char
	CP	27H		;must be single quote
	RET	NZ		;ret if not
HEX1	INC	HL		;bump past it
	LD	A,(HL)		;p/u possible hex digit
	SUB	30H		;begin conversion
	JR	C,HEX2		;jump if < "0"
	CP	10		;ck for 0-9
	JR	C,HEX3		;jump if digit is 0-9
	RES	5,A		;strip l/c if present
	SUB	7		;else ck A-F
	CP	16
	JR	C,HEX3		;jump if A-F
HEX2	LD	A,(HL)		;test for closing quote
	CP	27H
	INC	HL		;bump pointer
	RET	Z		;ret if closing quote
	DEC	HL		;else backup, set OK,
	XOR	A		;then return
	RET
HEX3	PUSH	BC		;exchange BC & HL
	EX	(SP),HL		;and save HL
	ADD	HL,HL		;multiply by 16
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	B,H		;merge new digit
	ADD	A,L
	LD	C,A
	POP	HL		;recover pointer
	JR	HEX1		;loop
